/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import jpos.StringField;

public class FormattedStringField
extends StringField {
    private FieldFormat format = FieldFormat.PROPER;
    private boolean enforceFormatting;

    public FormattedStringField(FieldFormat format) {
        this.format = format;
        this.init();
    }

    public FormattedStringField(int length, FieldFormat format) {
        super(length);
        this.format = format;
        this.init();
    }

    private void init() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FormattedStringField.this.formatIfRequired();
            }
        });
    }

    private String toProperCase(String s) {
        StringBuffer sb = new StringBuffer(s.toLowerCase().trim());
        boolean bUpper = true;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) >= 'A' && sb.charAt(i) <= 'Z' || sb.charAt(i) >= 'a' && sb.charAt(i) <= 'z') {
                if (bUpper) {
                    sb.replace(i, i + 1, String.valueOf(sb.charAt(i)).toUpperCase());
                }
                bUpper = false;
                continue;
            }
            bUpper = true;
        }
        return sb.toString();
    }

    private String surnameExceptions(String s) {
        if ((s = this.toProperCase(s)).length() > 2 && s.startsWith("Mc")) {
            s = s.substring(0, 2) + s.substring(2, 3).toUpperCase() + s.substring(3, s.length());
        }
        if (s.startsWith("Van Der ")) {
            s = "Van d" + s.substring(5, s.length());
        }
        return s;
    }

    public void setEnforceFormatting(boolean enforceFormatting) {
        this.enforceFormatting = enforceFormatting;
    }

    public void formatIfRequired() {
        if (this.enforceFormatting) {
            switch (this.format) {
                case PROPER: {
                    this.setText(this.toProperCase(this.getText()));
                    break;
                }
                case UPPER: {
                    this.setText(this.getText().toUpperCase());
                    break;
                }
                case LOWER: {
                    this.setText(this.getText().toLowerCase());
                    break;
                }
                case SURNAME: {
                    this.setText(this.surnameExceptions(this.getText()));
                    break;
                }
                case FIRSTNAME: {
                    this.setText(this.toProperCase(this.getText()));
                    break;
                }
            }
        }
    }

    public static enum FieldFormat {
        PROPER,
        UPPER,
        LOWER,
        SURNAME,
        FIRSTNAME;

    }
}

