/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.SocketTimeoutException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jpos.AutoSuggestCombo;
import jpos.DlgHistoryFilter;
import jpos.DlgMessage;
import jpos.HistoryOptions;
import jpos.HistoryOptionsBuilder;
import jpos.LoyaltyCard;
import jpos.PaSales;
import jpos.PosCheckBox;
import jpos.PosComboBox;
import jpos.PosDateField;
import jpos.PosDateFormatter;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.Security;
import jpos.Settings;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringField;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.UareU.UareUFingerprintProvider;
import jpos.XMLLocal;
import jpos.XMLUtils;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.utils.Utils;
import jpos.crypt.PersonCrypt;
import jpos.kleber.KleberApiException;
import jpos.kleber.KleberModels;
import jpos.kleber.KleberUtils;
import jpos.omneo.DlgOmneoPerson;
import jpos.person.Country;
import jpos.person.CountryComboBox;
import jpos.person.CustSummaryItem;
import jpos.person.DlgPersonSearchResult;
import jpos.person.EmailStatus;
import jpos.person.FormattedStringField;
import jpos.person.Gender;
import jpos.person.LegacyDlgEditLoyalty;
import jpos.person.LegacyFrCustHistSummary;
import jpos.person.LegacyFrCustomerHistory;
import jpos.person.Location;
import jpos.person.PersonInterfaceUtils;
import jpos.person.PersonRefGrp;
import jpos.person.PersonRefGrps;
import jpos.person.PersonUtils;
import jpos.person.PhoneNumberField;
import jpos.person.TranDetail;
import jpos.person.TranHist;
import jpos.rewards.RewardsAccount;
import jpos.rewards.RewardsUtils;
import jpos.searchfields.SearchButton;
import jpos.searchfields.SearchPanel;
import jpos.taxlookup.TaxExemptReason;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.FormButton;
import jpos.ui.LabelHeading;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.StatusButton;
import jpos.ui.TouchPanel;
import jpos.ui.TouchPasswordField;
import jpos.ui.ValidationIconPanel;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class LegacyPersonDlg
extends PosDialog {
    private Rectangle screenSize;
    private boolean acceptPressed = false;
    private boolean suppressOmneoPersonMaint = false;
    private Object[] colNames = new Object[]{StoreParams.res.getString("Program"), StoreParams.res.getString("Card_Number"), StoreParams.res.getString("Expiry_Date"), StoreParams.res.getString("Balance"), StoreParams.res.getString("Credit_Status_Balance")};
    private ArrayList<FormattedStringField> formattedStringFields = new ArrayList();
    private PersonRefGrps refGrps;
    private boolean systemEditing = false;
    private boolean taxExemptionSecurityGranted = false;
    private TaxExemptReason currentTaxExemptReason = null;
    private FormattedStringField tfPersonTitle = new FormattedStringField(10, FormattedStringField.FieldFormat.PROPER);
    private FormattedStringField tfFirstName = new FormattedStringField(20, FormattedStringField.FieldFormat.PROPER);
    private FormattedStringField tfLastName = new FormattedStringField(20, FormattedStringField.FieldFormat.SURNAME);
    private FormattedStringField tfJobTitle = new FormattedStringField(20, FormattedStringField.FieldFormat.PROPER);
    private FormattedStringField tfAddr1 = new FormattedStringField(50, FormattedStringField.FieldFormat.PROPER);
    private LabelNormal lPersonTitle = new LabelNormal();
    private String sAccountCode = "";
    private LabelNormal lFirstName = new LabelNormal();
    private LabelNormal lLastName = new LabelNormal();
    private LabelNormal lJobTitle = new LabelNormal();
    private LabelNormal lAddr1 = new LabelNormal();
    private FormattedStringField tfAddr2 = new FormattedStringField(50, FormattedStringField.FieldFormat.PROPER);
    private FormattedStringField tfState = new FormattedStringField(50, FormattedStringField.FieldFormat.UPPER);
    private FormattedStringField tfPostCode = new FormattedStringField(10, FormattedStringField.FieldFormat.UPPER);
    private LabelNormal lAddr2 = new LabelNormal();
    private LabelNormal lCity = new LabelNormal();
    private LabelNormal lState = new LabelNormal();
    private LabelNormal lPostCode = new LabelNormal();
    private LabelHeading lScreenHeading = new LabelHeading();
    private List<Gender> genders = Arrays.asList(new Gender("", ""), new Gender("M", SP.getRS("Male")), new Gender("F", SP.getRS("Female")), new Gender("NS", SP.getRS("Non-specific")));
    private PosComboBox<Gender> cmbGender = new PosComboBox();
    private BJTextField tfGenderOffline = new BJTextField();
    private LabelNormal lGender = new LabelNormal();
    private PosDateField tfBirthday = new PosDateField(this, 100, 0);
    private LabelNormal lBirthday = new LabelNormal();
    private FormButton bSearch = new FormButton("");
    private FormButton bAccept = new FormButton("");
    private FormButton bCancel = new FormButton("");
    private FormButton bHistory = new FormButton("");
    private FormButton bScan = new FormButton("");
    private FormButton bDeletePerson = new FormButton("");
    private StatusButton bSendEmail = new StatusButton("");
    private BJTextField tfSearch = new BJTextField();
    private boolean enforcePhoneValidation = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_PHONE_NUM_VALIDATION);
    private boolean extendedLoyaltyProgram = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.EXTENDED_LOYALTY_PROGRAM);
    private long emailMandatory = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.MANDATORY_PERSON_EMAIL);
    private PhoneNumberField tfPhone = new PhoneNumberField(new Country("", ""), 250, this.enforcePhoneValidation){

        @Override
        public void validationPassed() {
            if (LegacyPersonDlg.this.paPhone != null) {
                LegacyPersonDlg.this.paPhone.clear();
            }
        }

        @Override
        public void validationFailed(String message) {
            if (LegacyPersonDlg.this.paPhone != null) {
                LegacyPersonDlg.this.paPhone.showError(message);
            }
        }
    };
    private StringField tfWork = new StringField(250);
    private StringField tfOther = new StringField(250);
    private StringField tfEmail = new StringField(250);
    private LabelNormal lPhone = new LabelNormal();
    private LabelNormal lWork = new LabelNormal();
    private LabelNormal lOther = new LabelNormal();
    private LabelNormal lEmail = new LabelNormal();
    private LabelNormal lCountry = new LabelNormal();
    private LabelNormal lFormatting = new LabelNormal();
    private String currentCountry = "";
    private static final String NZ_COUNTRY_CODE = "NZ";
    private PosCheckBox chkSRep = new PosCheckBox();
    private FormattedStringField tfSalesRepCode = new FormattedStringField(10, FormattedStringField.FieldFormat.UPPER);
    private LabelNormal lSalesRepCode = new LabelNormal();
    private LabelNormal lPassword = new LabelNormal();
    private LabelNormal lPasswordConfirm = new LabelNormal();
    private TouchPasswordField pfPassword = new TouchPasswordField();
    private TouchPasswordField pfPasswordConfirm = new TouchPasswordField();
    private LabelNormal lTaxExemptReason = new LabelNormal();
    private LabelNormal lTaxExemptCertificate = new LabelNormal();
    private StringField tfTaxExemptCertificate = new StringField(250){

        @Override
        public boolean allowEdit() {
            if (!LegacyPersonDlg.this.systemEditing && !LegacyPersonDlg.this.taxExemptionSecurityGranted) {
                if (Security.hasSecurity(LegacyPersonDlg.this.frParent, 11166L, LegacyPersonDlg.this.frParent.getUser().getMemidx(), 0, true)) {
                    LegacyPersonDlg.this.taxExemptionSecurityGranted = true;
                    return true;
                }
                return false;
            }
            return true;
        }
    };
    private Vector<TaxExemptReason> taxExemptReasons = TaxExemptReason.getAllReasons();
    private PosComboBox<TaxExemptReason> cmbTaxExemptReason = new PosComboBox<TaxExemptReason>(this.taxExemptReasons);
    private PosScrollPane loyaltyScrollPane;
    private PosScrollPane mainScrollPane;
    private PosTable tblLoyalty;
    private PosCheckBox chkPrivacy = new PosCheckBox();
    private LabelSubHeading lLoyalty = new LabelSubHeading();
    private FormButton bVoid = new FormButton("");
    private JPanel paFoot = new JPanel();
    private JPanel paLoyalty = new JPanel();
    private CountryComboBox cmbCountries = new CountryComboBox(Country.getCountryList());
    private BJTextField tfCountriesOffline = new BJTextField();
    private ValidationIconPanel paEmail = new ValidationIconPanel(this.tfEmail);
    private ValidationIconPanel paPhone = new ValidationIconPanel(this.tfPhone);
    private ValidationIconPanel paCountry = new ValidationIconPanel(this.cmbCountries);
    private JPanel paReferences = new JPanel();
    private boolean saveError;
    private String title;
    private Element person;
    private DialogButton bAddLoyalty = new DialogButton("");
    private DialogButton bEditLoyalty = new DialogButton("");
    private boolean showHistory;
    private boolean[] loyalSec;
    private boolean[] salesRepSec;
    private long accountCustidx;
    private boolean[] fingerprintSec;
    private boolean enforceFormatting = false;
    private AutoSuggestCombo<Location> cmbCities = new AutoSuggestCombo<Location>(Location.getLocationList(Settings.getCountry().getName()));
    private BJTextField tfCitiesOffline = new BJTextField();
    private boolean bActive = true;
    private LegacyFrCustomerHistory custHistory = new LegacyFrCustomerHistory(this);
    private LegacyFrCustHistSummary historySummary = new LegacyFrCustHistSummary(this);
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel panelHistory = new JPanel();
    private LabelSubHeading lCustHist = new LabelSubHeading();
    private KleberUtils kleberUtils = KleberUtils.getInstance(this.sParams);
    private static final String OFFLINE_HINT = SP.getRS("Offline");
    private boolean isNewPerson;

    public boolean isNewPerson() {
        return this.isNewPerson;
    }

    public void setNewPerson(boolean isNewPerson) {
        this.isNewPerson = isNewPerson;
        if (this.isNewPerson) {
            this.voidPerson();
            this.setPersonDefaultReferences();
            this.setPermissions(this.sParams.checkIConn());
        }
    }

    public LegacyPersonDlg(PosFrame frame, String title, Element pPerson, boolean[] pLoyalSec, boolean[] pSalesRepSec, long accountCustidx) {
        super(frame, title, true);
        try {
            this.title = title;
            this.loyalSec = pLoyalSec;
            this.salesRepSec = pSalesRepSec;
            this.person = pPerson;
            this.showHistory = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.DISPLAY_POS_PERSON_SPENDING);
            this.refGrps = new PersonRefGrps();
            this.accountCustidx = accountCustidx;
            this.jbInit();
            this.setNewPerson(XMLUtils.getValue(this.person, "peridx").isEmpty());
            this.setPermissions(this.sParams.checkIConn());
            this.pack();
            PosUtils.centreWindow(this);
            if (this.person.getAttribute("peridx") == null) {
                this.setPersonDefaultReferences();
            }
            this.setFocus();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setResizable(false);
        this.screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.mainScrollPane = new PosScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = new Dimension();
                d.width = 590;
                d.height = ((LegacyPersonDlg)LegacyPersonDlg.this).screenSize.height - 190;
                if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.EDIT_LOALTY_AT_STORE) && LegacyPersonDlg.this.loyalSec[0]) {
                    d.height -= 155;
                }
                if (d.height > 682) {
                    d.height = 682;
                }
                return d;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                d.height = 350;
                return d;
            }
        };
        TouchPanel panelMain = new TouchPanel(new GridBagLayout());
        this.formattedStringFields.add(this.tfPersonTitle);
        this.formattedStringFields.add(this.tfFirstName);
        this.formattedStringFields.add(this.tfLastName);
        this.formattedStringFields.add(this.tfJobTitle);
        this.formattedStringFields.add(this.tfAddr1);
        this.formattedStringFields.add(this.tfAddr2);
        this.formattedStringFields.add(this.tfState);
        this.formattedStringFields.add(this.tfPostCode);
        this.formattedStringFields.add(this.tfSalesRepCode);
        if (!Security.hasSecurity(this.frParent, 11160L, this.frParent.getUser().getMemidx(), 2, false)) {
            this.setEnforceFormatting(false);
        } else {
            this.setEnforceFormatting(this.sParams.bEnforceFormatting);
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.tfLastName.setFieldWidth(150);
        this.tfLastName.setFieldWidth(150);
        this.lPersonTitle.setText(StoreParams.res.getString("Title") + " ");
        this.lFirstName.setText(StoreParams.res.getString("First_Name") + " * ");
        this.lFirstName.setForeground(Colours.BLACK);
        this.lLastName.setText(StoreParams.res.getString("Surname") + " * ");
        this.lLastName.setForeground(Colours.BLACK);
        this.lBirthday.setText(StoreParams.res.getString("Birthday") + " ");
        this.lJobTitle.setText(StoreParams.res.getString("Job_Title") + " ");
        this.lBirthday.setForeground(Colours.BLACK);
        this.lGender.setText(StoreParams.res.getString("Gender") + " ");
        this.lGender.setForeground(Colours.BLACK);
        this.lAddr1.setText(StoreParams.res.getString("Address_1") + " ");
        this.lAddr2.setText(StoreParams.res.getString("Address_2") + " ");
        this.lCity.setText(StoreParams.res.getString("City") + " ");
        this.lState.setText(StoreParams.res.getString("State") + " ");
        this.lPostCode.setText(StoreParams.res.getString("Post_Code") + " ");
        this.tfPersonTitle.setFieldWidth(85);
        this.tfFirstName.setFieldWidth(150);
        this.tfBirthday.setFieldWidth(85);
        this.tfBirthday.setText("");
        this.tfJobTitle.setFieldWidth(150);
        this.cmbGender.setFieldWidth(150);
        for (Gender gender : this.genders) {
            this.cmbGender.addItem(gender);
        }
        this.cmbGender.setSelectedIndex(0);
        this.tfGenderOffline.setFieldWidth(150);
        this.tfAddr1.setFieldWidth(200);
        this.tfState.setFieldWidth(85);
        this.tfPostCode.setFieldWidth(85);
        this.tfAddr2.setFieldWidth(200);
        this.bSearch.setText(StoreParams.res.getString("Search_F12"));
        this.bSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacyPersonDlg.this.bSearch_actionPerformed(e);
            }
        });
        this.bDeletePerson.setText(StoreParams.res.getString("Delete_Person_F10"));
        this.bDeletePerson.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacyPersonDlg.this.bDeletePerson_actionPerformed(e);
            }
        });
        this.fingerprintSec = this.frParent.getSecurity(11141L);
        this.bScan.setText(StoreParams.res.getString("Scan_F4"));
        this.bScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LegacyPersonDlg.this.isInternalUserCode()) {
                    return;
                }
                if (LegacyPersonDlg.this.tfSalesRepCode.getText().length() > 0) {
                    if (LegacyPersonDlg.this.sParams.bUsingFingerprintLogin && LegacyPersonDlg.this.sParams.FingerprintProvider != null) {
                        String key = LegacyPersonDlg.this.tfSalesRepCode.getText().toUpperCase();
                        try {
                            if (LegacyPersonDlg.this.isFingerPrintRegistered(key) && DlgMessage.showMessage(LegacyPersonDlg.this.frParent, MessageFormat.format(StoreParams.res.getString("fingerprint_already_exists"), key, "\n"), StoreParams.res.getString("Stop"), 0, 3) != 0) {
                                return;
                            }
                            UareUFingerprintProvider.EnrollmentResult result = LegacyPersonDlg.this.sParams.FingerprintProvider.performEnrollment(key);
                            switch (result) {
                                case DUPLICATE: {
                                    DlgMessage.showMessage(LegacyPersonDlg.this.frParent, MessageFormat.format(StoreParams.res.getString("fingerprint_already_used"), "\n"), StoreParams.res.getString("Stop"), 0);
                                    break;
                                }
                                case ERROR: {
                                    DlgMessage.showMessage(LegacyPersonDlg.this.frParent, StoreParams.res.getString("Fingerprint_Scanner_Registration_failed"), StoreParams.res.getString("Stop"), 0);
                                    break;
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                } else {
                    DlgMessage.showMessage(LegacyPersonDlg.this.frParent, StoreParams.res.getString("Enter_SCode2"), StoreParams.res.getString("Stop"), 0);
                }
                LegacyPersonDlg.this.tfSalesRepCode.requestFocusInWindow();
            }
        });
        this.bAccept.setText(StoreParams.res.getString("F9_Create_Person"));
        this.bAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacyPersonDlg.this.bAccept_actionPerformed(e);
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacyPersonDlg.this.voidPerson();
                LegacyPersonDlg.this.dispose();
            }
        });
        this.bHistory.setText(StoreParams.res.getString("AltA_History"));
        this.bHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacyPersonDlg.this.bHistory_actionPerformed(e);
            }
        });
        this.lPhone.setHorizontalAlignment(4);
        this.lPhone.setText(StoreParams.res.getString("Contact") + " # ");
        this.lPhone.setForeground(Colours.BLACK);
        this.lWork.setHorizontalAlignment(4);
        this.lWork.setText(StoreParams.res.getString("Business") + " # ");
        this.lOther.setHorizontalAlignment(4);
        this.lOther.setText(StoreParams.res.getString("Other") + " # ");
        this.lEmail.setHorizontalAlignment(4);
        if (this.emailMandatory == (long)PersonInterfaceUtils.EmailPhoneValidation.Email.ordinal() || this.emailMandatory == (long)PersonInterfaceUtils.EmailPhoneValidation.Both.ordinal()) {
            this.lEmail.setText(StoreParams.res.getString("Email") + " * ");
        } else {
            this.lEmail.setText(StoreParams.res.getString("Email") + " ");
        }
        this.tfPhone.setFieldWidth(150);
        this.tfWork.setFieldWidth(150);
        this.tfOther.setFieldWidth(150);
        this.tfEmail.setFieldWidth(200);
        this.tfEmail.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                LegacyPersonDlg.this.validateDisplayedEmailAddress();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LegacyPersonDlg.this.validateDisplayedEmailAddress();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LegacyPersonDlg.this.validateDisplayedEmailAddress();
            }
        });
        ImageIcon sendEmailImage = new ImageIcon(this.getClass().getClassLoader().getResource("images/write_email.png"));
        this.bSendEmail.setIcon(sendEmailImage);
        this.bSendEmail.setToolTipText(StoreParams.res.getString("Send_Email"));
        this.bSendEmail.setBorder(BorderFactory.createEmptyBorder());
        this.bSendEmail.setContentAreaFilled(false);
        this.bSendEmail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacyPersonDlg.this.createEmail();
            }
        });
        this.lCountry.setText(StoreParams.res.getString("Country") + " ");
        this.lFormatting.setText(StoreParams.res.getString("formatting_off") + " ");
        this.chkSRep.setText(StoreParams.res.getString("Sales_Person"));
        this.chkSRep.setMaximumSize(new Dimension(150, 20));
        this.chkSRep.setMinimumSize(new Dimension(150, 20));
        this.chkSRep.setPreferredSize(new Dimension(150, 20));
        this.chkSRep.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LegacyPersonDlg.this.chkSRep_itemStateChanged(e);
            }
        });
        this.tfSalesRepCode.setFieldWidth(150);
        this.lSalesRepCode.setText(StoreParams.res.getString("Code") + " ");
        this.lPassword.setText(StoreParams.res.getString("Password") + " ");
        this.lPasswordConfirm.setText(StoreParams.res.getString("Confirm") + " ");
        this.pfPassword.setFieldWidth(150);
        this.pfPassword.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LegacyPersonDlg.this.pfPassword.selectAll();
            }
        });
        this.pfPasswordConfirm.setFieldWidth(150);
        this.pfPasswordConfirm.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LegacyPersonDlg.this.pfPasswordConfirm.selectAll();
            }
        });
        this.lTaxExemptReason.setText(StoreParams.res.getString("Tax_Exemption_Reason") + " ");
        this.lTaxExemptCertificate.setText(StoreParams.res.getString("Tax_Exemption_Certificate") + " ");
        this.cmbTaxExemptReason.setFieldWidth(200);
        this.cmbTaxExemptReason.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1 && !LegacyPersonDlg.this.systemEditing && !LegacyPersonDlg.this.taxExemptionSecurityGranted) {
                    if (Security.hasSecurity(LegacyPersonDlg.this.frParent, 11166L, LegacyPersonDlg.this.frParent.getUser().getMemidx(), 0, true)) {
                        LegacyPersonDlg.this.taxExemptionSecurityGranted = true;
                    } else if (LegacyPersonDlg.this.currentTaxExemptReason != null) {
                        LegacyPersonDlg.this.systemEditing = true;
                        try {
                            LegacyPersonDlg.this.cmbTaxExemptReason.setSelectedItem(LegacyPersonDlg.this.currentTaxExemptReason);
                        }
                        finally {
                            LegacyPersonDlg.this.systemEditing = false;
                        }
                    }
                }
            }
        });
        this.cmbTaxExemptReason.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LegacyPersonDlg.this.currentTaxExemptReason = (TaxExemptReason)LegacyPersonDlg.this.cmbTaxExemptReason.getSelectedItem();
            }
        });
        this.tfTaxExemptCertificate.setFieldWidth(150);
        this.chkPrivacy.setText(StoreParams.res.getString("Privacy"));
        this.chkPrivacy.setMaximumSize(new Dimension(100, 20));
        this.chkPrivacy.setMinimumSize(new Dimension(100, 20));
        this.chkPrivacy.setPreferredSize(new Dimension(100, 20));
        this.bVoid.setText(SP.getRS("Alt+N_New_Person"));
        this.bVoid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacyPersonDlg.this.setNewPerson(true);
            }
        });
        this.paFoot.setLayout(new GridBagLayout());
        this.paLoyalty.setLayout(new GridBagLayout());
        this.paCountry.setLayout(new GridBagLayout());
        this.paReferences.setLayout(new GridBagLayout());
        this.cmbCities.setFieldWidth(200);
        this.tfCitiesOffline.setFieldWidth(200);
        this.cmbCountries.setFieldWidth(200);
        this.tfCountriesOffline.setFieldWidth(200);
        this.cmbCountries.setSelectedItem(Settings.getCountry());
        this.countryChanged();
        Insets leftLabelInsets = new Insets(5, 5, 0, 0);
        Insets leftFieldInsets = new Insets(5, 0, 0, 0);
        Insets rightLabelInsets = new Insets(5, 5, 0, 0);
        Insets rightFieldInsets = new Insets(5, 0, 0, 5);
        Insets leftLabelInsetsBottomRow = new Insets(5, 5, 5, 0);
        Insets leftFieldInsetsBottomRow = new Insets(5, 0, 5, 0);
        this.getContentPane().add((Component)this.lScreenHeading, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.mainScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainScrollPane.getViewport().add(panelMain);
        this.getContentPane().add((Component)this.mainScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        panelMain.add((Component)this.lFirstName, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lLastName, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lPhone, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lEmail, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lPersonTitle, new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lBirthday, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lAddr1, new GridBagConstraints(0, 8, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lAddr2, new GridBagConstraints(0, 9, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lCity, new GridBagConstraints(0, 10, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lState, new GridBagConstraints(0, 11, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lPostCode, new GridBagConstraints(0, 12, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lCountry, new GridBagConstraints(0, 13, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.tfSearch, new GridBagConstraints(0, 13, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lJobTitle, new GridBagConstraints(0, 14, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lWork, new GridBagConstraints(0, 15, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
        panelMain.add((Component)this.lOther, new GridBagConstraints(0, 16, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsetsBottomRow, 0, 0));
        panelMain.add((Component)this.tfFirstName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfLastName, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.paPhone, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.paEmail, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        this.paEmail.add((Component)this.bSendEmail, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)this.tfPersonTitle, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        if (!this.sParams.bHidePrivateCheckBox) {
            panelMain.add((Component)this.chkPrivacy, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 95, 0, 0), 0, 0));
        }
        panelMain.add((Component)new SearchPanel(this.tfBirthday, SearchButton.SearchIcon.CALENDAR), new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfAddr1, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfAddr2, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add(this.cmbCities, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfCitiesOffline, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfState, new GridBagConstraints(1, 11, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfPostCode, new GridBagConstraints(1, 12, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.paCountry, new GridBagConstraints(1, 13, 1, 1, 1.0, 1.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfCountriesOffline, new GridBagConstraints(1, 13, 1, 1, 1.0, 1.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfJobTitle, new GridBagConstraints(1, 14, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfWork, new GridBagConstraints(1, 15, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        panelMain.add((Component)this.tfOther, new GridBagConstraints(1, 16, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsetsBottomRow, 0, 0));
        if (this.sParams.bUsingExtendedTax && this.sParams.bUsingTaxLookup) {
            panelMain.add((Component)this.lTaxExemptReason, new GridBagConstraints(0, 17, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
            panelMain.add((Component)this.lTaxExemptCertificate, new GridBagConstraints(0, 18, 1, 1, 0.0, 1.0, 13, 0, leftLabelInsets, 0, 0));
            panelMain.add(this.cmbTaxExemptReason, new GridBagConstraints(1, 17, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
            panelMain.add((Component)this.tfTaxExemptCertificate, new GridBagConstraints(1, 18, 1, 1, 1.0, 0.0, 17, 0, leftFieldInsets, 0, 0));
        }
        this.paReferences.add((Component)this.lGender, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 0, rightLabelInsets, 0, 0));
        this.paReferences.add(this.cmbGender, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, rightFieldInsets, 0, 0));
        this.paReferences.add((Component)this.tfGenderOffline, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, rightFieldInsets, 0, 0));
        int pRefSize = 0;
        for (Map.Entry entry : this.refGrps.entrySet()) {
            PersonRefGrp refgrp = (PersonRefGrp)entry.getValue();
            LabelNormal lblGrp = new LabelNormal();
            lblGrp.setText(refgrp.getShortName() + " ");
            lblGrp.setForeground(Colours.BLACK);
            PosComboBox<Reference> cmbGrp = new PosComboBox<Reference>(refgrp.getReferences());
            refgrp.setCombo(cmbGrp);
            BJTextField tfGrpOffline = new BJTextField();
            tfGrpOffline.setEditable(false);
            tfGrpOffline.setFocusable(false);
            tfGrpOffline.setFieldWidth(150);
            refgrp.setOfflineTextField(tfGrpOffline);
            cmbGrp.setFieldWidth(150);
            cmbGrp.setEnabled(refgrp.getFlag() == 2);
            this.paReferences.add((Component)lblGrp, new GridBagConstraints(0, pRefSize + 1, 1, 1, 0.0, 1.0, 13, 0, rightLabelInsets, 0, 0));
            this.paReferences.add(cmbGrp, new GridBagConstraints(1, pRefSize + 1, 1, 1, 0.0, 1.0, 17, 0, rightFieldInsets, 0, 0));
            this.paReferences.add((Component)tfGrpOffline, new GridBagConstraints(1, pRefSize + 1, 1, 1, 0.0, 1.0, 17, 0, rightFieldInsets, 0, 0));
            ++pRefSize;
        }
        panelMain.add((Component)this.paReferences, new GridBagConstraints(2, 2, 2, pRefSize + 1, 0.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.salesRepSec[0]) {
            panelMain.add((Component)this.chkSRep, new GridBagConstraints(3, pRefSize + 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panelMain.add((Component)this.lSalesRepCode, new GridBagConstraints(2, pRefSize + 4, 1, 1, 0.0, 1.0, 13, 0, rightLabelInsets, 0, 0));
            panelMain.add((Component)this.lPassword, new GridBagConstraints(2, pRefSize + 5, 1, 1, 0.0, 1.0, 13, 0, rightLabelInsets, 0, 0));
            panelMain.add((Component)this.lPasswordConfirm, new GridBagConstraints(2, pRefSize + 6, 1, 1, 0.0, 1.0, 13, 0, rightLabelInsets, 0, 0));
            panelMain.add((Component)this.tfSalesRepCode, new GridBagConstraints(3, pRefSize + 4, 1, 1, 0.0, 1.0, 17, 0, rightFieldInsets, 0, 0));
            panelMain.add((Component)this.pfPassword, new GridBagConstraints(3, pRefSize + 5, 1, 1, 0.0, 1.0, 17, 0, rightFieldInsets, 0, 0));
            panelMain.add((Component)this.pfPasswordConfirm, new GridBagConstraints(3, pRefSize + 6, 1, 1, 0.0, 1.0, 17, 0, rightFieldInsets, 0, 0));
            if (this.sParams.bUsingFingerprintLogin && this.fingerprintSec[2]) {
                panelMain.add((Component)this.bScan, new GridBagConstraints(3, pRefSize + 7, 1, 1, 0.0, 1.0, 17, 0, rightFieldInsets, 0, 0));
            }
        }
        this.getContentPane().add((Component)this.paLoyalty, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.paFoot, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.paFoot.add((Component)this.bHistory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 30, 0, 0), 0, 0));
        this.paFoot.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.paFoot.add((Component)this.bSearch, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 10), 0, 0));
        if (this.frParent.hasSecurity(11160L, 3)) {
            this.paFoot.add((Component)this.bDeletePerson, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 30, 5, 0), 0, 0));
        }
        this.paFoot.add((Component)this.bVoid, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.paFoot.add((Component)this.bAccept, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
        if (this.showHistory || RewardsUtils.usingAp21RetailRewards()) {
            this.lCustHist.setText(StoreParams.res.getString("Customer_History"));
            this.getContentPane().add((Component)this.lCustHist, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(20, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.tabbedPane, new GridBagConstraints(1, 1, 1, 3, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tabbedPane.setVisible(true);
            this.panelHistory.setLayout(null);
            this.tabbedPane.addTab(StoreParams.res.getString("SummaryTab"), this.historySummary);
            if (this.showHistory) {
                this.tabbedPane.addTab(StoreParams.res.getString("HistoryTab"), this.custHistory);
            }
        }
        if (this.sParams.bEnforceFormatting) {
            this.paFoot.add((Component)this.lFormatting, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, -75, 0, 0), 0, 0));
        }
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.EDIT_LOALTY_AT_STORE) && this.loyalSec[0]) {
            this.loyaltyScrollPane = new PosScrollPane(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height = 100;
                    return d;
                }

                @Override
                public Dimension getMinimumSize() {
                    Dimension d = super.getMinimumSize();
                    d.height = 100;
                    return d;
                }

                @Override
                public Dimension getMaximumSize() {
                    Dimension d = super.getMaximumSize();
                    d.height = 100;
                    return d;
                }
            };
            LoyaltyModel lm = new LoyaltyModel();
            this.tblLoyalty = new PosTable(this, lm);
            this.tblLoyalty.setSelectionMode(0);
            this.lLoyalty.setText(StoreParams.res.getString("Loyalty"));
            this.bAddLoyalty.setText(StoreParams.res.getString("F5_Add_New"));
            this.bEditLoyalty.setText(StoreParams.res.getString("F6_Edit"));
            this.tblLoyalty.renderer.setColumnFormat(0, null, 2);
            this.tblLoyalty.renderer.setColumnFormat(1, null, 2);
            this.tblLoyalty.renderer.setColumnFormat(2, null, 0);
            this.tblLoyalty.renderer.setColumnFormat(3, new DecimalFormat("#,##0"), 4);
            this.tblLoyalty.renderer.setColumnFormat(4, new DecimalFormat("#,##0"), 4);
            this.tblLoyalty.getColumnModel().getColumn(0).setMinWidth(100);
            this.tblLoyalty.getColumnModel().getColumn(1).setMinWidth(80);
            this.tblLoyalty.getColumnModel().getColumn(2).setMinWidth(80);
            this.tblLoyalty.getColumnModel().getColumn(3).setMinWidth(80);
            TableColumn creditStatusColumn = this.tblLoyalty.getColumnModel().getColumn(4);
            if (this.extendedLoyaltyProgram) {
                creditStatusColumn.setMinWidth(80);
            } else {
                creditStatusColumn.setMinWidth(0);
                creditStatusColumn.setPreferredWidth(0);
                creditStatusColumn.setMaxWidth(0);
            }
            this.tblLoyalty.getColumnModel().getColumn(0).setHeaderRenderer(this.tblLoyalty.headerLeftRen);
            this.tblLoyalty.getColumnModel().getColumn(1).setHeaderRenderer(this.tblLoyalty.headerLeftRen);
            this.tblLoyalty.getColumnModel().getColumn(2).setHeaderRenderer(this.tblLoyalty.headerCenterRen);
            this.tblLoyalty.getColumnModel().getColumn(3).setHeaderRenderer(this.tblLoyalty.headerRightRen);
            this.tblLoyalty.getColumnModel().getColumn(4).setHeaderRenderer(this.tblLoyalty.headerRightRen);
            this.tblLoyalty.getTableHeader().setResizingAllowed(true);
            this.tblLoyalty.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && LegacyPersonDlg.this.bEditLoyalty.isEnabled()) {
                        LegacyPersonDlg.this.bEditLoyalty.doClick();
                    }
                }
            });
            this.bAddLoyalty.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LegacyPersonDlg.this.bAddLoyalty_actionPerformed(e);
                }
            });
            this.bEditLoyalty.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LegacyPersonDlg.this.bEditLoyalty_actionPerformed(e);
                }
            });
            this.paLoyalty.add((Component)this.lLoyalty, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
            if (this.frParent.hasSecurity(11160L, 1) || this.frParent.hasSecurity(11160L, 2)) {
                this.paLoyalty.add((Component)this.bAddLoyalty, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(5, 5, 0, 5), 0, 0));
                this.paLoyalty.add((Component)this.bEditLoyalty, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 12, 0, new Insets(5, 5, 0, 5), 0, 0));
            }
            this.paLoyalty.add((Component)this.loyaltyScrollPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.loyaltyScrollPane.setViewportView(this.tblLoyalty);
        }
        this.bScan.setEnabled(this.sParams.bUsingFingerprintLogin && this.fingerprintSec[2]);
        this.tfFirstName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && LegacyPersonDlg.this.bSearch.isEnabled()) {
                    LegacyPersonDlg.this.bSearch.doClick();
                }
            }
        });
        this.tfLastName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && LegacyPersonDlg.this.bSearch.isEnabled()) {
                    LegacyPersonDlg.this.bSearch.doClick();
                }
            }
        });
        this.tfPhone.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && LegacyPersonDlg.this.bSearch.isEnabled()) {
                    LegacyPersonDlg.this.bSearch.doClick();
                }
            }
        });
        this.tfEmail.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && LegacyPersonDlg.this.bSearch.isEnabled()) {
                    LegacyPersonDlg.this.bSearch.doClick();
                }
            }
        });
        this.cmbCities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object o = LegacyPersonDlg.this.cmbCities.getSelectedItem();
                        if (o != null && o instanceof Location) {
                            Location l = (Location)o;
                            LegacyPersonDlg.this.tfPostCode.setText(l.getPostcode());
                            LegacyPersonDlg.this.tfState.setText(l.getState());
                            LegacyPersonDlg.this.cmbCities.setSelectedItem(l.getCity());
                        }
                    }
                });
            }
        });
        this.cmbCountries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!LegacyPersonDlg.this.currentCountry.equals(LegacyPersonDlg.this.cmbCountries.getSelectedItem().toString())) {
                            LegacyPersonDlg.this.cmbCities.reset(Location.getLocationList(LegacyPersonDlg.this.cmbCountries.getSelectedItem().toString()), LegacyPersonDlg.this.cmbCities.getTextField().getText());
                            LegacyPersonDlg.this.countryChanged();
                        }
                    }
                });
            }
        });
        this.tfSearch.setVisible(false);
        this.chkSRep_click();
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfFirstName);
        v.add(this.tfLastName);
        v.add(this.tfPhone);
        v.add(this.tfEmail);
        v.add(this.bSendEmail);
        v.add(this.tfPersonTitle);
        v.add(this.chkPrivacy);
        v.add(this.tfBirthday);
        v.add(this.tfAddr1);
        v.add(this.tfAddr2);
        v.add(this.cmbCities.getTextField());
        v.add(this.tfState);
        v.add(this.tfPostCode);
        v.add(this.cmbCountries);
        v.add(this.tfJobTitle);
        v.add(this.tfWork);
        v.add(this.tfOther);
        if (this.sParams.bUsingExtendedTax && this.sParams.bUsingTaxLookup) {
            v.add(this.cmbTaxExemptReason);
            v.add(this.tfTaxExemptCertificate);
        }
        v.add(this.cmbGender);
        if (this.salesRepSec[0]) {
            v.add(this.chkSRep);
            v.add(this.tfSalesRepCode);
            v.add(this.pfPassword);
            v.add(this.pfPasswordConfirm);
        }
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.EDIT_LOALTY_AT_STORE) && this.loyalSec[0]) {
            v.add(this.tblLoyalty);
        }
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void setVisibility(boolean isOnline) {
        this.bDeletePerson.setEnabled(isOnline);
        this.bAccept.setText(this.isNewPerson() ? SP.getRS("F9_Create_Person") : SP.getRS("F9_Accept"));
        this.bVoid.setText(this.isNewPerson() ? SP.getRS("F3_Reset") : SP.getRS("Alt+N_New_Person"));
        boolean editable = isOnline || this.isNewPerson();
        this.tfLastName.setEditable(editable);
        this.tfFirstName.setEditable(editable);
        this.tfPhone.setEditable(editable);
        this.tfEmail.setEditable(editable);
        this.tfPostCode.setEditable(editable);
        this.tfLastName.setFocusable(editable);
        this.tfFirstName.setFocusable(editable);
        this.tfPhone.setFocusable(editable);
        this.tfEmail.setFocusable(editable);
        this.tfPostCode.setFocusable(editable);
        this.tfPersonTitle.setEditable(editable);
        this.chkPrivacy.setVisible(editable);
        this.tfBirthday.setEnabled(editable);
        this.tfAddr1.setEditable(editable);
        this.tfAddr2.setEditable(editable);
        this.tfState.setEditable(editable);
        this.paCountry.setVisible(editable);
        this.tfCountriesOffline.setVisible(!editable);
        this.tfCountriesOffline.setEditable(editable);
        this.cmbCities.setEnabled(editable);
        this.cmbCities.setVisible(editable);
        this.tfCitiesOffline.setVisible(!editable);
        this.tfCitiesOffline.setEditable(editable);
        this.tfJobTitle.setEditable(editable);
        this.tfWork.setEditable(editable);
        this.tfOther.setEditable(editable);
        this.cmbGender.setEnabled(editable);
        this.cmbGender.setVisible(editable);
        this.tfGenderOffline.setEditable(editable);
        this.tfGenderOffline.setVisible(!editable);
        this.cmbTaxExemptReason.setEnabled(editable);
        this.tfTaxExemptCertificate.setEditable(editable);
        for (PersonRefGrp refGrp : this.refGrps.values()) {
            refGrp.setOfflineVisible(editable);
        }
        this.setOfflineHintText(editable);
    }

    private void setOfflineHintText(boolean isOnline) {
        if (this.isNewPerson()) {
            this.tfEmail.setHint("");
            this.tfPhone.setHint("");
        }
        this.tfPersonTitle.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfBirthday.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfAddr1.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfAddr2.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfState.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfJobTitle.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfWork.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfOther.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfTaxExemptCertificate.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfGenderOffline.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfCitiesOffline.setHint(isOnline ? "" : OFFLINE_HINT);
        this.tfCountriesOffline.setHint(isOnline ? "" : OFFLINE_HINT);
    }

    /*
     * Exception decompiling
     */
    private boolean isFingerPrintRegistered(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isEmailAddressValid() {
        String emailAddress = this.tfEmail.getText().trim();
        if (emailAddress.equals("")) {
            return true;
        }
        if (this.hasEmailAddressChanged(this.person, emailAddress) || PersonUtils.getEmailStatusFromPerson(this.person) == EmailStatus.ASSUMED_OK) {
            return this.sParams.getEmailValidator().validate(emailAddress);
        }
        return PersonUtils.getEmailStatusFromPerson(this.person) == EmailStatus.FORCED_OK;
    }

    protected void validateDisplayedEmailAddress() {
        if (this.isEmailAddressValid()) {
            this.paEmail.clear();
        } else {
            this.paEmail.showError(SP.getRS("Email_must_have_@"));
        }
    }

    protected void countryChanged() {
        this.tfPhone.setCountryCode((Country)this.cmbCountries.getSelectedItem());
        this.currentCountry = ((Country)this.cmbCountries.getSelectedItem()).getName();
        if (this.cmbCountries.getSelectedIndex() == 0 && !((Country)this.cmbCountries.getSelectedItem()).getName().isEmpty()) {
            this.paCountry.showWarning(MessageFormat.format(SP.getRS("Invalid_Country"), ((Country)this.cmbCountries.getSelectedItem()).getName()));
        } else {
            this.paCountry.clear();
        }
    }

    void bAccept_actionPerformed(ActionEvent e) {
        this.saveError = false;
        if (this.frParent.frameType == 10 && this.accountCustidx > 0L && this.person.getAttribute("peridx") != null) {
            String custidx;
            String string = custidx = this.person.getAttribute("custidx") != null ? StringUtils.nullToEmpty(this.person.getAttribute("custidx").getValue()) : "";
            if (!custidx.equals(String.valueOf(this.accountCustidx))) {
                DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Selected_person_does_not_belong_to_account"), ((PaSales)this.frParent.paBody).tfCust.getText()), SP.getRS("Stop"), 0);
                return;
            }
        }
        if (this.editMade()) {
            if (this.isGuestAccount()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("No_Edit_Guest_Person"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            if (this.person.getAttribute("peridx") == null && !this.frParent.hasSecurity(11160L, 1)) {
                DlgMessage.showMessage(this, StoreParams.res.getString("No_Add_Person_Security"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            if (this.person.getAttribute("peridx") != null) {
                if (this.person.getChild("member") != null && !this.frParent.hasSecurity(11104L, 2)) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("No_Edit_Staff_Security"), StoreParams.res.getString("Stop"), 0);
                    return;
                }
                if (!this.frParent.hasSecurity(11160L, 2)) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("No_Edit_Person_Security"), StoreParams.res.getString("Stop"), 0);
                    return;
                }
            }
            if (!this.validatePerson()) {
                return;
            }
            if (!this.frParent.getUser().isTraningUser() && !this.isGuestAccount() && RewardsUtils.usingAp21RetailRewards() && !this.historySummary.rewardsSignUpIfRequired()) {
                return;
            }
            this.buildXml();
            if (!this.frParent.getUser().isTraningUser()) {
                if (this.save(true)) {
                    if (!this.saveError) {
                        this.save(false);
                    }
                } else if (!this.saveError && this.isNewPerson()) {
                    this.offlineOnlySave();
                }
            }
        }
        if ((this.person.getAttribute("peridx") != null || this.frParent.getUser().isTraningUser()) && !this.saveError) {
            this.acceptPressed = true;
            this.cleanPerson();
            this.dispose();
        }
    }

    private boolean save(boolean online) {
        try {
            Element loyalty;
            XMLOutputter printer = new XMLOutputter();
            boolean queryResult = true;
            if (online) {
                Element prefetch = this.sParams.OnlineQueryProvider.getOnlineQuery("saveperson", printer.outputString(this.person) + "\u0003prefetch").getXML();
                if (prefetch == null) {
                    return false;
                }
                if (!prefetch.getAttributes().isEmpty()) {
                    if (prefetch.getAttribute("peridx") != null) {
                        this.person.setAttribute("prefetch_peridx", prefetch.getAttributeValue("peridx"));
                        this.person.getChild("locn").setAttribute("prefetch_locnidx", prefetch.getAttributeValue("locnidx"));
                        Element phoneNumbers = prefetch.getChild("phonenumbers");
                        if (phoneNumbers != null) {
                            for (Element prefetchPhoneNum : phoneNumbers.getChildren()) {
                                Element phoneNum = (Element)XPath.selectSingleNode((Object)this.person, (String)("locn/phonenum[@phonetyidx='" + prefetchPhoneNum.getAttributeValue("phonetyidx") + "']"));
                                if (phoneNum == null) continue;
                                phoneNum.setAttribute("prefetch_phonenumidx", prefetchPhoneNum.getAttributeValue("phonenumidx"));
                            }
                        }
                    }
                    if (prefetch.getAttribute("memidx") != null) {
                        this.person.getChild("member").setAttribute("prefetch_memidx", prefetch.getAttributeValue("memidx"));
                    }
                    if (prefetch.getAttribute("loyalidx") != null) {
                        List loyalties = this.person.getChildren("perloyalty");
                        String[] idxes = prefetch.getAttributeValue("loyalidx").split(",");
                        int pos = 0;
                        block5: for (int i = 0; i < idxes.length; ++i) {
                            while (pos < loyalties.size()) {
                                if ((loyalty = (Element)loyalties.get(pos++)).getAttribute("loyalidx") != null) continue;
                                loyalty.setAttribute("prefetch_loyalidx", idxes[i]);
                                continue block5;
                            }
                        }
                    }
                }
                this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("saveperson", printer.outputString(this.person) + "\u0003" + this.sParams.getStoreIdx()).getXML();
                if (this.sParams.root == null) {
                    queryResult = false;
                }
            } else {
                queryResult = this.sParams.getXML(this.frParent, "saveperson", printer.outputString(this.person) + "\u0003" + this.sParams.getStoreIdx(), false);
            }
            if (queryResult) {
                long peridx;
                Object[] objs;
                Element idxs = this.sParams.root;
                if (idxs.getName().equals("people")) {
                    objs = new Object[]{"create", "\n", "\n", "\n", "\n"};
                    if (DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("per_exists"), objs), StoreParams.res.getString("Stop"), 0, 3) == 0) {
                        if (idxs.getChildren("person").size() > 1) {
                            ArrayList<String> existingPeridxs = new ArrayList<String>();
                            for (Object p : idxs.getChildren("person")) {
                                Element per = (Element)p;
                                String currPeridx = XMLUtils.getValue(per, "peridx");
                                if (currPeridx.isEmpty()) continue;
                                existingPeridxs.add(currPeridx);
                            }
                            String searchCustidx = this.accountCustidx > 0L ? String.valueOf(this.accountCustidx) : "";
                            DlgPersonSearchResult.Result result = DlgPersonSearchResult.showDialog(this.frParent, this, SP.getRS("Person_Search"), true, online, searchCustidx, this.tfFirstName.getText(), this.tfLastName.getText(), this.tfPhone.getText(), this.tfEmail.getText(), "", existingPeridxs);
                            if (result.getButtonPressed() == DlgPersonSearchResult.Button.NEW) {
                                this.setNewPerson(true);
                                this.prePopulateNewPerson(result);
                            }
                            if (result.getButtonPressed() == DlgPersonSearchResult.Button.OK && result.getPerIdx() != 0L) {
                                try {
                                    Element person = this.loadPersonElement(String.valueOf(result.getPerIdx()), online);
                                    if (person != null) {
                                        this.setNewPerson(false);
                                        this.loadFromSearchData(person, false, online);
                                    }
                                }
                                catch (Exception ex) {
                                    PosUtils.logError(ex);
                                }
                            }
                        } else {
                            Element personElement = idxs.getChild("person");
                            long actualPeridx = XMLUtils.getLongValue(personElement, "pos_idx");
                            if (actualPeridx != 0L && XMLUtils.getLongValue(personElement, "widx") == SP.sParams.getStoreIdx()) {
                                personElement.setAttribute("peridx", String.valueOf(actualPeridx));
                            }
                            this.setNewPerson(false);
                            this.loadFromSearchData(personElement, false, online);
                        }
                    }
                    this.saveError = true;
                    this.person.setAttribute("firstname", "");
                    return false;
                }
                if (idxs.getChild("member") != null) {
                    if (idxs.getChild("member").getAttribute("error") != null) {
                        if (idxs.getChild("member").getAttribute("error").getValue().equals("MEMNAME_IN_USE")) {
                            objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("sper_code_used"), objs), StoreParams.res.getString("Error"), 0);
                        } else if (idxs.getChild("member").getAttribute("error").getValue().equals("CANT_CREATE_MEMBER")) {
                            objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("cant_create_member_offline"), objs), StoreParams.res.getString("Error"), 0);
                        } else {
                            DlgMessage.showMessage(this, idxs.getChild("member").getAttribute("error").getValue(), StoreParams.res.getString("Error"), 0);
                        }
                        this.saveError = true;
                        this.tfSalesRepCode.requestFocusInWindow();
                        this.person.setAttribute("firstname", "");
                        return false;
                    }
                    this.person.getChild("member").setAttribute(idxs.getChild("member").getAttribute("memidx").detach());
                    List grps = idxs.getChild("member").getChildren();
                    while (grps.size() > 0) {
                        this.person.getChild("member").addContent((Content)((Element)((Element)grps.get(0)).detach()));
                    }
                }
                this.person.setAttribute(idxs.getAttribute("peridx").detach());
                if (idxs.getChild("locn") != null) {
                    Element lidxs = idxs.getChild("locn");
                    this.person.getChild("locn").setAttribute(lidxs.getAttribute("locnidx").detach());
                    List phonenums = this.person.getChild("locn").getChildren("phonenum");
                    for (int i = 0; i < phonenums.size(); ++i) {
                        Element phonenum = (Element)phonenums.get(i);
                        if (phonenum.getAttribute("phonenumidx") != null) continue;
                        phonenum.setAttribute(PersonUtils.getPhone(idxs, PersonUtils.PhoneType.getPhoneType(phonenum.getAttribute("phonetyidx").getValue())).getAttribute("phonenumidx").detach());
                    }
                }
                List loyals = this.person.getChildren("perloyalty");
                List loyalidxs = idxs.getChildren("perloyalty");
                int idxsCnt = 0;
                for (int i = 0; i < loyals.size(); ++i) {
                    loyalty = (Element)loyals.get(i);
                    if (idxsCnt < loyalidxs.size() && ((Element)loyalidxs.get(idxsCnt)).getAttribute("error") != null) {
                        DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("cardNo_used"), loyalty.getAttributeValue("cardno"), "\n"), StoreParams.res.getString("Error"), 0);
                        this.saveError = true;
                        if (this.tblLoyalty != null) {
                            this.tblLoyalty.setRowSelectionInterval(idxsCnt, idxsCnt);
                        }
                        return false;
                    }
                    if (loyalty.getAttribute("rcidx") == null) continue;
                    loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("loyalidx").detach());
                    loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("cardno").detach());
                    ++idxsCnt;
                }
                if (this.tblLoyalty != null) {
                    for (LoyaltyCard loyaltyCard : ((LoyaltyModel)this.tblLoyalty.getModel()).loyaltyCards) {
                        loyaltyCard.flagAsEdited(false);
                        loyaltyCard.flagAsNew(false);
                    }
                }
                if (this.historySummary.isRewardsSignupRequested() && (peridx = XMLUtils.getLongValue(this.person, "peridx")) != 0L) {
                    this.historySummary.completeRequestedRewardsSignup(peridx);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private void offlineOnlySave() {
        boolean queryResult = false;
        if (PersonCrypt.getInstance().keyExists() || DlgMessage.showMessage(this.frParent, SP.getRS("Offline_Key_Check_Person", "\r\n"), SP.getRS("Offline_Key_Check_Person_Hdr"), 0, 2) == 0) {
            XMLOutputter printer = new XMLOutputter();
            queryResult = this.sParams.getXML(this.frParent, "saveofflineperson", printer.outputString(this.person) + "\u0003" + this.sParams.getStoreIdx(), false);
        }
        if (!queryResult) {
            this.saveError = true;
        } else {
            long peridx;
            this.person.setAttribute((Attribute)this.sParams.root.getAttribute("peridx").clone());
            List loyals = this.person.getChildren("perloyalty");
            List loyalidxs = this.sParams.root.getChildren("perloyalty");
            int idxsCnt = 0;
            for (int i = 0; i < loyals.size(); ++i) {
                Element loyalty = (Element)loyals.get(i);
                if (idxsCnt < loyalidxs.size() && ((Element)loyalidxs.get(idxsCnt)).getAttribute("error") != null) {
                    DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("cardNo_used"), loyalty.getAttributeValue("cardno"), "\n"), StoreParams.res.getString("Error"), 0);
                    this.saveError = true;
                    if (this.tblLoyalty != null) {
                        this.tblLoyalty.setRowSelectionInterval(idxsCnt, idxsCnt);
                    }
                    return;
                }
                if (loyalty.getAttribute("rcidx") == null) continue;
                loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("loyalidx").detach());
                loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("cardno").detach());
                ++idxsCnt;
            }
            if (this.tblLoyalty != null) {
                for (LoyaltyCard loyaltyCard : ((LoyaltyModel)this.tblLoyalty.getModel()).loyaltyCards) {
                    loyaltyCard.flagAsEdited(false);
                    loyaltyCard.flagAsNew(false);
                }
            }
            if (this.historySummary.isRewardsSignupRequested() && (peridx = XMLUtils.getLongValue(this.person, "peridx")) != 0L) {
                this.historySummary.completeRequestedRewardsSignup(peridx);
            }
            this.saveError = false;
            if (this.historySummary.isRewardsSignupRequested() && (peridx = XMLUtils.getLongValue(this.person, "peridx")) != 0L) {
                this.historySummary.completeRequestedRewardsSignup(peridx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void historySearch(boolean allStores) {
        StringBuffer sbFilter = new StringBuffer();
        if (allStores && !this.frParent.hasSecurity(11151L, 0)) {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        } else if (allStores && !this.sParams.checkIConn()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
        } else {
            this.title = StoreParams.res.getString("Cust_Order_Search_Filter");
            HistoryOptions options = new HistoryOptionsBuilder().transactionNumber().referenceNumber().productCode().transactionDates().build();
            StringBuffer result = new StringBuffer();
            DlgHistoryFilter histFilter = new DlgHistoryFilter(this.frParent, StoreParams.res.getString("Person_History_Search_Filter"), this.sParams.checkIConn(), options, sbFilter, result);
            histFilter.setVisible(true);
            if (result.toString().equals("OK")) {
                BJTextField searchField = allStores ? this.sParams.tfHistAll : this.sParams.tfHistStore;
                this.setCursor(StoreParams.waitCursor);
                try {
                    if (this.sParams.checkIConn()) {
                        String sExtraWhere = PosUtils.longVal(this.person.getAttribute("peridx").getValue()) < 0L ? "H.VHIDX = H.VHIDX AND H.\"ACTIVE\" > 0 AND decode(H.TR_TYPE, 614, H.NOTES1, NULL) IS NULL AND H.CLIENTIDX IN( SELECT P.PERIDX FROM PERSON P WHERE P.ACTIVE = 1 AND P.WIDX = " + this.sParams.getStoreIdx() + " AND P.POS_PERIDX = " + this.person.getAttribute("peridx").getValue() + ") " : "H.VHIDX = H.VHIDX AND H.\"ACTIVE\" > 0 AND decode(H.TR_TYPE, 614, H.NOTES1, NULL) IS NULL AND H.CLIENTIDX = " + this.person.getAttribute("peridx").getValue() + " ";
                        sExtraWhere = sExtraWhere + (allStores ? "" : " AND H.WIDX = " + this.sParams.getStoreIdx());
                        if (searchField.getToServ() == null) {
                            searchField.setCache(this.sParams.cacher, this.sParams.iconn, 265L, "382,367,368,369,370,371,372,375,861,961", "", sExtraWhere + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                        } else {
                            searchField.setWhere(sExtraWhere + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                        }
                    } else {
                        String sExtraWhere = "H.COMPLETE > 0 AND H.\"ACTIVE\" > 0 AND (H.TR_TYPE != 614 OR H.NOTES1 IS NULL)  AND H.CLIENTIDX = " + this.person.getAttribute("peridx").getValue();
                        if (searchField.getCacher() == null || searchField.getToServ() != null) {
                            searchField.setCache(this.sParams.cacher, 661L, "922,923,924", "RET_TRANH H LEFT JOIN RET_TRAND D ON D.VHIDX = H.VHIDX AND D.SEQUENCE_NUMBER = 0 LEFT JOIN SKU ON SKU.SKUIDX = D.SKUIDX LEFT JOIN CLR ON CLR.CLRIDX = SKU.CLRIDX LEFT JOIN STYLE S ON S.STYLEIDX = CLR.STYLEIDX", sExtraWhere + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                        } else {
                            searchField.setWhere(sExtraWhere + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                        }
                    }
                }
                finally {
                    this.setCursor(StoreParams.normalCursor);
                }
                searchField.clear();
                searchField.setShowSearchForOneResult(true);
                boolean wasOnline = this.sParams.checkIConn();
                searchField.doSearch(this);
                if (wasOnline && !this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                searchField.setShowSearchForOneResult(false);
                if (!searchField.getText().equals("")) {
                    this.setCursor(StoreParams.waitCursor);
                    try {
                        this.frParent.menu.populate(this.frParent, (int)searchField.getidx(), searchField.getText().substring(1));
                    }
                    finally {
                        this.setCursor(StoreParams.normalCursor);
                    }
                    this.bCancel.doClick();
                }
            }
        }
    }

    void bHistory_actionPerformed(ActionEvent e) {
        if (this.person.getAttribute("peridx") != null) {
            this.historySearch(true);
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("select_person"), StoreParams.res.getString("Stop"), 2);
        }
    }

    void bSearch_actionPerformed(ActionEvent e) {
        boolean isOnline = SP.sParams.checkIConn();
        String searchCustidx = this.accountCustidx > 0L ? String.valueOf(this.accountCustidx) : "";
        DlgPersonSearchResult.Result result = this.isNewPerson() ? DlgPersonSearchResult.showDialog(this.frParent, this, SP.getRS("Person_Search"), true, isOnline, searchCustidx, this.tfFirstName.getText(), this.tfLastName.getText(), this.tfPhone.getText(), this.tfEmail.getText(), this.tfPostCode.getText()) : DlgPersonSearchResult.showDialog(this.frParent, this, SP.getRS("Person_Search"), true, isOnline, searchCustidx);
        if (result.getButtonPressed() == DlgPersonSearchResult.Button.NEW) {
            this.setNewPerson(true);
            this.prePopulateNewPerson(result);
            return;
        }
        if (result.getButtonPressed() == DlgPersonSearchResult.Button.OK && result.getPerIdx() != 0L) {
            try {
                Element person = this.loadPersonElement(String.valueOf(result.getPerIdx()), isOnline);
                if (person != null) {
                    this.setNewPerson(false);
                    this.loadFromSearchData(person, false, isOnline);
                }
            }
            catch (Exception ex) {
                PosUtils.logError(ex);
            }
        }
    }

    private void prePopulateNewPerson(DlgPersonSearchResult.Result result) {
        this.tfFirstName.setText(result.getFirstName());
        this.tfFirstName.formatIfRequired();
        this.tfLastName.setText(result.getSurname());
        this.tfLastName.formatIfRequired();
        this.tfPostCode.setText(result.getPostCode());
        this.tfLastName.formatIfRequired();
        this.tfEmail.setText(result.getEmail());
        this.validateDisplayedEmailAddress();
        this.tfPhone.setText(this.tfPhone.formatThenCleanTextPhoneNumber(result.getPhone()));
        this.tfPhone.refreshValidIndicator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromSearchData(Element data, boolean suppressMessages, boolean isOnline) {
        this.setCursor(StoreParams.waitCursor);
        try {
            this.voidPerson();
            try {
                List contents = data.getChildren();
                while (contents.size() > 0) {
                    this.person.addContent((Content)((Element)((Element)contents.get(0)).detach()));
                }
                List attributes = data.getAttributes();
                while (attributes.size() > 0) {
                    this.person.setAttribute(((Attribute)attributes.get(0)).detach());
                }
            }
            catch (Exception ex) {
                PosUtils.logError(ex);
            }
            this.populate(isOnline);
            if ((this.showHistory || RewardsUtils.usingAp21RetailRewards()) && !this.isGuestAccount() && this.sParams.checkIConn()) {
                this.populateHistory();
            } else if (RewardsUtils.usingAp21RetailRewards() && !this.isGuestAccount() && !this.sParams.checkIConn()) {
                this.loadRewardsOffline();
            }
            if (isOnline && PersonUtils.isLocalPersonOutOfDate(this.person)) {
                XMLOutputter printer = new XMLOutputter();
                this.sParams.getXML(this.frParent, "saveperson", printer.outputString(this.person) + "\u0003" + this.sParams.getStoreIdx(), false);
            }
            this.bAccept.requestFocusInWindow();
            if (isOnline && !suppressMessages && !this.isEmailAddressValid()) {
                DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("email_validate_fail"), this.tfEmail.getText()), SP.getRS("Confirm_Email_Address"), 1);
                this.tfEmail.requestFocus();
            }
        }
        finally {
            this.setCursor(StoreParams.normalCursor);
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 120) {
            this.bAccept.doClick();
        } else if (e.getKeyCode() == 123 && this.bSearch.isEnabled()) {
            this.bSearch.doClick();
        } else if (e.getKeyCode() == 116 && this.frParent.hasSecurity(11160L, 2)) {
            this.bAddLoyalty.doClick();
        } else if (e.getKeyCode() == 117 && this.frParent.hasSecurity(11160L, 2)) {
            this.bEditLoyalty.doClick();
        } else if (e.getKeyCode() == 78 && e.isAltDown() && !this.isNewPerson()) {
            this.bVoid.doClick();
        } else if (e.getKeyCode() == 114 && this.isNewPerson()) {
            this.bVoid.doClick();
        } else if (e.getKeyCode() == 115 && !e.isAltDown()) {
            if (this.bScan.isEnabled()) {
                this.bScan.doClick();
            }
        } else if (e.getKeyCode() == 83 && e.getModifiers() == 8) {
            this.setFocus();
        } else if (e.getKeyCode() == 65 && e.isAltDown()) {
            this.bHistory.doClick();
        } else if (e.getKeyCode() == 70 && e.getModifiers() == 8 && this.sParams.bEnforceFormatting) {
            if (this.enforceFormatting) {
                this.setEnforceFormatting(false);
                this.lFormatting.setText(StoreParams.res.getString("formatting_on") + " ");
            } else {
                this.setEnforceFormatting(true);
                this.lFormatting.setText(StoreParams.res.getString("formatting_off") + " ");
            }
        } else if (e.getKeyCode() == 121 && this.bDeletePerson.isEnabled() && this.frParent.hasSecurity(11160L, 3)) {
            this.bDeletePerson.doClick();
        } else {
            return false;
        }
        return true;
    }

    void chkSRep_itemStateChanged(ItemEvent e) {
        this.chkSRep_click();
    }

    void chkSRep_click() {
        boolean enable;
        boolean bl = enable = !this.isInternalUserCode();
        if (!this.chkSRep.isSelected()) {
            enable = false;
            this.tfSalesRepCode.setText("");
            this.pfPassword.setText("");
            this.pfPasswordConfirm.setText("");
        }
        this.tfSalesRepCode.setEnabled(enable);
        this.pfPassword.setEnabled(enable);
        this.pfPasswordConfirm.setEnabled(enable);
        this.bScan.setEnabled(enable && this.sParams.bUsingFingerprintLogin && this.fingerprintSec[2]);
    }

    private boolean editMade() {
        String originNumber;
        Element locn;
        String dob;
        if (!this.tfPersonTitle.getText().equals(this.person.getAttribute("title") != null ? this.person.getAttribute("title").getValue() : "")) {
            return true;
        }
        if (!this.tfFirstName.getText().equals(this.person.getAttribute("firstname") != null ? this.person.getAttribute("firstname").getValue() : "")) {
            return true;
        }
        if (!this.tfLastName.getText().equals(this.person.getAttribute("surname") != null ? this.person.getAttribute("surname").getValue() : "")) {
            return true;
        }
        if (!this.tfJobTitle.getText().equals(this.person.getAttribute("jobtitle") != null ? this.person.getAttribute("jobtitle").getValue() : "")) {
            return true;
        }
        if (this.cmbGender.getSelectedIndex() >= 0 && !((Gender)this.cmbGender.getSelectedItem()).getDBValue().equals(this.person.getAttribute("sex") != null ? this.person.getAttribute("sex").getValue() : "")) {
            return true;
        }
        if (this.chkPrivacy.isSelected() && (this.person.getAttribute("privacy") != null ? this.person.getAttribute("privacy").getValue() : "0").equals("0") || !this.chkPrivacy.isSelected() && (this.person.getAttribute("privacy") != null ? this.person.getAttribute("privacy").getValue() : "0").equals("1")) {
            return true;
        }
        if (!this.tfBirthday.isValidDate()) {
            this.tfBirthday.actionValidate(false);
            if (!this.tfBirthday.isValidDate()) {
                return true;
            }
        }
        if ((dob = this.tfBirthday.getDateFormatter().toStringInternal()).length() == 0 && (this.person.getAttribute("dob") != null ? this.person.getAttribute("dob").getValue().length() : 0) > 0) {
            return true;
        }
        if (!dob.equals(this.person.getAttribute("dob") != null ? this.person.getAttribute("dob").getValue().substring(0, dob.length()) : "")) {
            return true;
        }
        Element references = this.person.getChild("references");
        if (references != null) {
            for (Map.Entry entry : this.refGrps.entrySet()) {
                if (((PersonRefGrp)entry.getValue()).getFlag() != 2 || ((PersonRefGrp)entry.getValue()).getCombo() == null) continue;
                Reference ref = (Reference)((PersonRefGrp)entry.getValue()).getCombo().getSelectedItem();
                String rcidx = "";
                if (ref != null && ref.getIdx() > 0L) {
                    rcidx = "" + ref.getIdx();
                }
                if (rcidx.equals(references.getAttribute("ref" + entry.getKey()) != null ? references.getAttribute("ref" + entry.getKey()).getValue() : "")) continue;
                return true;
            }
        }
        if ((locn = this.person.getChild("locn")) == null) {
            locn = new Element("locn");
        }
        if (!this.tfAddr1.getText().equals(locn.getAttribute("adrs1") != null ? locn.getAttribute("adrs1").getValue() : "")) {
            return true;
        }
        if (!this.tfAddr2.getText().equals(locn.getAttribute("adrs2") != null ? locn.getAttribute("adrs2").getValue() : "")) {
            return true;
        }
        if (!this.cmbCities.getTextField().getText().trim().equals(locn.getAttribute("city") != null ? locn.getAttribute("city").getValue().trim() : "")) {
            return true;
        }
        if (!this.tfState.getText().equals(locn.getAttribute("state") != null ? locn.getAttribute("state").getValue() : "")) {
            return true;
        }
        if (!this.tfPostCode.getText().equals(locn.getAttribute("postcode") != null ? locn.getAttribute("postcode").getValue() : "")) {
            return true;
        }
        if (this.cmbCountries.getSelectedIndex() > -1 && !this.cmbCountries.getSelectedItem().toString().equalsIgnoreCase(locn.getAttribute("country") != null ? locn.getAttribute("country").getValue() : "")) {
            return true;
        }
        Element phone = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.MAIN);
        String string = phone != null ? (this.enforcePhoneValidation ? this.tfPhone.formatThenCleanTextPhoneNumber(phone.getText()) : phone.getText()) : (originNumber = "");
        if (!this.tfPhone.getCleanText().equals(originNumber)) {
            return true;
        }
        phone = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.OTHER);
        if (!this.tfOther.getText().equals(phone != null ? phone.getText() : "")) {
            return true;
        }
        phone = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.WORK);
        if (!this.tfWork.getText().equals(phone != null ? phone.getText() : "")) {
            return true;
        }
        phone = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.EMAIL);
        if (!this.tfEmail.getText().equals(phone != null ? phone.getText() : "")) {
            return true;
        }
        if (!this.tfSalesRepCode.getText().toUpperCase().equals(XMLUtils.getValue(this.person.getChild("member"), "memname").toUpperCase())) {
            return true;
        }
        if (this.pfPassword.getPassword().length > 0) {
            return true;
        }
        if (this.sParams.bUsingExtendedTax && this.sParams.bUsingTaxLookup) {
            if (((TaxExemptReason)this.cmbTaxExemptReason.getSelectedItem()).getExemptIdx() != PosUtils.longVal(this.person.getAttribute("tax_exemptidx") != null ? this.person.getAttribute("tax_exemptidx").getValue() : "0")) {
                return true;
            }
            if (!this.tfTaxExemptCertificate.getText().equals(this.person.getAttribute("tax_exempt_certificate") != null ? this.person.getAttribute("tax_exempt_certificate").getValue() : "")) {
                return true;
            }
        }
        return this.tblLoyalty != null && ((LoyaltyModel)this.tblLoyalty.getModel()).editMade();
    }

    void bAddLoyalty_actionPerformed(ActionEvent e) {
        if (this.tblLoyalty != null) {
            LoyaltyCard newLoyalty = new LoyaltyCard();
            newLoyalty.flagAsNew(true);
            LegacyDlgEditLoyalty dlg = new LegacyDlgEditLoyalty(this.frParent, this, newLoyalty, ((LoyaltyModel)this.tblLoyalty.getModel()).loyaltyCards, LegacyDlgEditLoyalty.EditLoyaltyMode.ADD_NEW, false);
            if (dlg.getResult() == LegacyDlgEditLoyalty.EditLoyaltyResult.SAVE) {
                ((LoyaltyModel)this.tblLoyalty.getModel()).addLoyaltyCard(newLoyalty);
            }
            dlg.dispose();
            Object var3_3 = null;
        }
    }

    void bEditLoyalty_actionPerformed(ActionEvent e) {
        int selectedRow;
        if (this.tblLoyalty != null && (selectedRow = this.tblLoyalty.getSelectedRow()) > -1) {
            LegacyDlgEditLoyalty dlg;
            LoyaltyCard loyaltyCard = ((LoyaltyModel)this.tblLoyalty.getModel()).loyaltyCards.get(selectedRow);
            boolean securityOverridden = false;
            if (loyaltyCard.getLoyaltyProgram().getManagerOnly()) {
                if (!Security.hasSecurity(this.frParent, 11165L, this.frParent.getUser().getMemidx(), 0, true)) {
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("cant_edit_manager_loyalty"), loyaltyCard.getLoyaltyProgram().toString()), SP.getRS("Insufficient_security"), -1, 0);
                    return;
                }
                securityOverridden = true;
            }
            if ((dlg = new LegacyDlgEditLoyalty(this.frParent, this, loyaltyCard, ((LoyaltyModel)this.tblLoyalty.getModel()).loyaltyCards, LegacyDlgEditLoyalty.EditLoyaltyMode.EDIT_EXISTING, securityOverridden)).getResult() == LegacyDlgEditLoyalty.EditLoyaltyResult.SAVE) {
                ((LoyaltyModel)this.tblLoyalty.getModel()).fireTableDataChanged();
            } else if (dlg.getResult() == LegacyDlgEditLoyalty.EditLoyaltyResult.DELETE) {
                ((LoyaltyModel)this.tblLoyalty.getModel()).removeLoyaltyCard(loyaltyCard);
            }
            dlg.dispose();
            dlg = null;
        }
    }

    private void voidPerson() {
        this.systemEditing = true;
        try {
            this.sAccountCode = "";
            this.tfPersonTitle.setText("");
            this.tfFirstName.setText("");
            this.tfLastName.setText("");
            this.tfBirthday.setText("");
            this.tfJobTitle.setText("");
            this.cmbGender.setSelectedIndex(0);
            this.tfAddr1.setText("");
            this.tfAddr2.setText("");
            this.cmbCities.setSelectedItem("");
            this.tfState.setText("");
            this.tfPostCode.setText("");
            ((Country)this.cmbCountries.getItemAt(0)).reset();
            this.cmbCountries.setSelectedItem(Settings.getCountry());
            this.countryChanged();
            int checkboxSetting = this.sParams.bDefaultPrivateOn;
            if (checkboxSetting == 1) {
                this.chkPrivacy.setSelected(true);
            } else {
                this.chkPrivacy.setSelected(false);
            }
            this.tfPhone.setText("");
            this.tfOther.setText("");
            this.tfWork.setText("");
            this.tfEmail.setText("");
            this.chkSRep.setSelected(false);
            this.chkSRep_click();
            if (this.tblLoyalty != null) {
                ((LoyaltyModel)this.tblLoyalty.getModel()).reset();
            }
            this.cmbCities.reset(Location.getLocationList(Settings.getCountry().getName()));
            this.person.getChildren().clear();
            this.person.getAttributes().clear();
            this.historySummary.reset();
            this.custHistory.reset();
            this.cmbTaxExemptReason.setSelectedIndex(0);
            this.tfTaxExemptCertificate.setText("");
            this.setFocus();
        }
        finally {
            this.systemEditing = false;
        }
    }

    private void cleanPerson() {
        int i;
        int i2;
        List attributes = this.person.getAttributes();
        for (i2 = attributes.size() - 1; i2 >= 0; --i2) {
            if (!((Attribute)attributes.get(i2)).getValue().equals("")) continue;
            this.person.removeAttribute((Attribute)attributes.get(i2));
        }
        if (this.person.getChild("locn") != null) {
            attributes = this.person.getChild("locn").getAttributes();
            for (i2 = attributes.size() - 1; i2 >= 0; --i2) {
                if (!((Attribute)attributes.get(i2)).getValue().equals("")) continue;
                this.person.getChild("locn").removeAttribute((Attribute)attributes.get(i2));
            }
            List phonenums = this.person.getChild("locn").getChildren("phonenum");
            for (i = phonenums.size() - 1; i >= 0; --i) {
                if (!((Element)phonenums.get(i)).getText().equals("")) continue;
                this.person.getChild("locn").removeContent((Content)((Element)phonenums.get(i)));
            }
        }
        if (this.person.getChild("member") != null) {
            attributes = this.person.getChild("member").getAttributes();
            for (i2 = attributes.size() - 1; i2 >= 0; --i2) {
                if (!((Attribute)attributes.get(i2)).getValue().equals("")) continue;
                this.person.getChild("member").removeAttribute((Attribute)attributes.get(i2));
            }
        }
        List loyalties = this.person.getChildren("perloyalty");
        for (i = loyalties.size() - 1; i >= 0; --i) {
            if (((Element)loyalties.get(i)).getAttribute("rcidx") == null) {
                this.person.removeContent((Content)((Element)loyalties.get(i)));
                continue;
            }
            attributes = ((Element)loyalties.get(i)).getAttributes();
            for (int j = attributes.size() - 1; j >= 0; --j) {
                if (!((Attribute)attributes.get(j)).getValue().equals("")) continue;
                ((Element)loyalties.get(i)).removeAttribute((Attribute)attributes.get(j));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate(boolean online) {
        this.systemEditing = true;
        try {
            Element member;
            Element references;
            boolean bAccountCust = false;
            if (this.person.getAttribute("custidx") != null) {
                bAccountCust = true;
                String sCustidx = this.person.getAttribute("custidx").getValue();
                for (int i = 0; i < this.sParams.vMailOrderCustidxs.size(); ++i) {
                    if (!sCustidx.equals(this.sParams.vMailOrderCustidxs.elementAt(i))) continue;
                    bAccountCust = false;
                }
            }
            this.tfPersonTitle.setText(this.person.getAttribute("title") != null ? this.person.getAttribute("title").getValue() : null);
            this.tfFirstName.setText(this.person.getAttribute("firstname") != null ? this.person.getAttribute("firstname").getValue() : null);
            this.tfLastName.setText(this.person.getAttribute("surname") != null ? this.person.getAttribute("surname").getValue() : null);
            if (this.person.getAttribute("dob") != null) {
                this.tfBirthday.setValue(this.person.getAttribute("dob").getValue());
            }
            this.tfJobTitle.setText(this.person.getAttribute("jobtitle") != null ? this.person.getAttribute("jobtitle").getValue() : null);
            if (this.person.getAttribute("sex") != null) {
                this.cmbGender.setSelectedIndex(this.getGenderItemIndex(this.person.getAttribute("sex").getValue()));
            } else {
                this.cmbGender.setSelectedIndex(0);
            }
            this.sAccountCode = this.person.getAttribute("custcode") != null && bAccountCust ? " - " + StoreParams.res.getString("Account") + ": " + this.person.getAttribute("custcode").getValue() : "";
            this.chkPrivacy.setSelected(this.person.getAttribute("privacy") != null && this.person.getAttribute("privacy").getLongValue() == 1L);
            Element locn = this.person.getChild("locn");
            if (locn != null) {
                String country;
                this.tfAddr1.setText(locn.getAttribute("adrs1") != null ? locn.getAttribute("adrs1").getValue() : null);
                this.tfAddr1.setCaretPosition(0);
                this.tfAddr2.setText(locn.getAttribute("adrs2") != null ? locn.getAttribute("adrs2").getValue() : null);
                this.tfAddr2.setCaretPosition(0);
                this.cmbCities.setSelectedItem(locn.getAttribute("city") != null ? locn.getAttribute("city").getValue() : null);
                this.tfState.setText(locn.getAttribute("state") != null ? locn.getAttribute("state").getValue() : null);
                this.tfPostCode.setText(locn.getAttribute("postcode") != null ? locn.getAttribute("postcode").getValue() : null);
                String string = country = locn.getAttribute("country") != null ? locn.getAttribute("country").getValue() : "";
                if (country == null) {
                    country = "";
                }
                boolean countryFound = false;
                for (int i = 0; i < this.cmbCountries.getItemCount(); ++i) {
                    if (!((Country)this.cmbCountries.getItemAt(i)).toString().equalsIgnoreCase(country)) continue;
                    this.cmbCountries.setSelectedIndex(i);
                    this.cmbCities.reset(Location.getLocationList(this.cmbCountries.getSelectedItem().toString()), this.cmbCities.getTextField().getText());
                    this.countryChanged();
                    countryFound = true;
                    break;
                }
                if (!countryFound) {
                    this.cmbCountries.setSelectedIndex(0);
                    ((Country)this.cmbCountries.getItemAt(0)).reset();
                    ((Country)this.cmbCountries.getItemAt(0)).setName(country);
                    this.countryChanged();
                }
                List phonenums = locn.getChildren("phonenum");
                this.tfPhone.setHint("");
                this.tfEmail.setHint("");
                block13: for (int i = 0; i < phonenums.size(); ++i) {
                    Element phonenum = (Element)phonenums.get(i);
                    int phonetyidx = (int)XMLUtils.getLongValue(phonenum, "phonetyidx");
                    switch (phonetyidx) {
                        case 154: {
                            String err = XMLUtils.getValue(phonenum, "encrypted_state");
                            if (err.isEmpty()) {
                                this.tfPhone.setText(phonenum.getText());
                                continue block13;
                            }
                            this.tfPhone.setHint(SP.getRS(err));
                            continue block13;
                        }
                        case 631: {
                            this.tfOther.setText(phonenum.getText());
                            continue block13;
                        }
                        case 536: {
                            this.tfWork.setText(phonenum.getText());
                            continue block13;
                        }
                        case 159: {
                            String err = XMLUtils.getValue(phonenum, "encrypted_state");
                            if (err.isEmpty()) {
                                this.tfEmail.setText(phonenum.getText());
                            } else {
                                this.tfEmail.setHint(SP.getRS(err));
                            }
                            this.tfEmail.setCaretPosition(0);
                            continue block13;
                        }
                    }
                }
            }
            if ((references = this.person.getChild("references")) != null) {
                for (int i = 1; i <= 10; ++i) {
                    if (!this.refGrps.containsKey(i)) continue;
                    if (references.getAttribute("ref" + i) != null && !references.getAttribute("ref" + i).getValue().equals("")) {
                        ((PersonRefGrp)this.refGrps.get(i)).setComboSelected(references.getAttribute("ref" + i).getLongValue());
                        continue;
                    }
                    ((PersonRefGrp)this.refGrps.get(i)).setComboSelected(PosUtils.longVal(-1));
                }
            }
            if ((member = this.person.getChild("member")) != null) {
                this.chkSRep.setSelected(true);
                this.tfSalesRepCode.setText(member.getAttribute("memname") != null ? StringUtils.nullToEmpty(member.getAttribute("memname").getValue()).toUpperCase() : null);
                this.pfPassword.setText(member.getAttribute("mempass") != null ? member.getAttribute("mempass").getValue() : null);
                this.pfPasswordConfirm.setText(member.getAttribute("mempass") != null ? member.getAttribute("mempass").getValue() : null);
                this.chkSRep_click();
            }
            if (this.tblLoyalty != null) {
                ((LoyaltyModel)this.tblLoyalty.getModel()).setXml(this.person);
            }
            if (this.person.getAttribute("tax_exemptidx") != null) {
                this.cmbTaxExemptReason.setSelectedIndex(TaxExemptReason.findReasonIndex(this.taxExemptReasons, PosUtils.longVal(this.person.getAttribute("tax_exemptidx").getValue())));
            } else {
                this.cmbTaxExemptReason.setSelectedIndex(0);
            }
            if (this.person.getAttribute("tax_exempt_certificate") != null) {
                this.tfTaxExemptCertificate.setText(this.person.getAttribute("tax_exempt_certificate").getValue());
            }
            this.setPermissions(online);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        finally {
            this.systemEditing = false;
        }
    }

    private void setPermissions(boolean online) {
        this.bAddLoyalty.setEnabled(this.loyalSec[1] && online || this.isNewPerson());
        this.bEditLoyalty.setEnabled(this.loyalSec[2] && online);
        String name = "";
        if (online) {
            int secType = 1;
            if (this.person.getChild("member") != null) {
                secType = 2;
            }
            this.chkSRep.setEnabled(this.salesRepSec[secType] && !this.isInternalUserCode());
            this.setTitle(this.title + StoreParams.res.getString("_Status_ONLINE"));
            if (this.isNewPerson()) {
                this.lScreenHeading.setText(SP.getRS("New_Person"));
            } else {
                name = this.tfLastName.getText().length() > 0 ? this.tfLastName.getText().substring(0, 1).toUpperCase() : "";
                name = this.tfFirstName.getText() + " " + name;
                if (name.isEmpty()) {
                    name = SP.getRS("Existing_Person");
                }
                this.lScreenHeading.setText(name + this.sAccountCode);
            }
        } else {
            this.chkSRep.setEnabled(false);
            this.tfSalesRepCode.setEnabled(false);
            this.pfPassword.setEnabled(false);
            this.pfPasswordConfirm.setEnabled(false);
            this.setTitle(this.title + StoreParams.res.getString("_Status_OFFLINE"));
            if (this.isNewPerson()) {
                name = SP.getRS("New_Person");
            } else {
                name = this.tfLastName.getText().length() > 0 ? this.tfLastName.getText().substring(0, 1).toUpperCase() : "";
                name = this.tfFirstName.getText() + " " + name;
                if (name.isEmpty()) {
                    name = SP.getRS("Existing_Person");
                }
            }
            if (this.sAccountCode != null && !this.sAccountCode.equals("")) {
                this.lScreenHeading.setText(name + this.sAccountCode);
            } else {
                this.lScreenHeading.setText(String.format("<html><nobr>%s <span style=\"color: #D0021B;\">(%s)</span></nobr></html>", name, SP.getRS("Offline")));
            }
        }
        this.setVisibility(online);
    }

    private void buildXml() {
        Element references;
        this.person.setAttribute("upmemidx", String.valueOf(this.frParent.getUser().getMemidx()));
        this.person.setAttribute("title", this.tfPersonTitle.getText());
        this.person.setAttribute("firstname", this.tfFirstName.getText());
        this.person.setAttribute("surname", this.tfLastName.getText());
        this.person.setAttribute("dob", this.tfBirthday.getDateFormatter().toStringInternal());
        this.person.setAttribute("jobtitle", this.tfJobTitle.getText());
        this.person.setAttribute("privacy", this.chkPrivacy.isSelected() ? "1" : "0");
        if (this.frParent.frameType == 10 && this.accountCustidx > 0L) {
            this.person.setAttribute("custidx", String.valueOf(this.accountCustidx));
        }
        if (this.cmbGender.getSelectedIndex() >= 0) {
            this.person.setAttribute("sex", ((Gender)this.cmbGender.getSelectedItem()).getDBValue());
        } else {
            this.person.setAttribute("sex", "");
        }
        if (this.sParams.bUsingExtendedTax && this.sParams.bUsingTaxLookup) {
            if (this.cmbTaxExemptReason.getSelectedIndex() > 0) {
                this.person.setAttribute("tax_exemptidx", String.valueOf(((TaxExemptReason)this.cmbTaxExemptReason.getSelectedItem()).getExemptIdx()));
            } else {
                this.person.setAttribute("tax_exemptidx", "");
            }
            this.person.setAttribute("tax_exempt_certificate", this.tfTaxExemptCertificate.getText());
        }
        if (!this.bActive) {
            this.person.setAttribute("active", "0");
            this.bActive = true;
        } else {
            this.person.setAttribute("active", "1");
        }
        Element locn = this.person.getChild("locn");
        if (locn == null) {
            locn = new Element("locn");
            this.person.addContent((Content)locn);
        }
        locn.setAttribute("adrs1", this.tfAddr1.getText());
        locn.setAttribute("adrs2", this.tfAddr2.getText());
        locn.setAttribute("city", this.cmbCities.getTextField().getText());
        locn.setAttribute("state", this.tfState.getText());
        locn.setAttribute("postcode", this.tfPostCode.getText());
        locn.setAttribute("country", this.cmbCountries.getSelectedIndex() > -1 ? this.cmbCountries.getSelectedItem().toString() : "");
        Element phone = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.MAIN);
        if (phone != null) {
            phone.setText(this.tfPhone.getCleanText());
        } else {
            phone = new Element("phonenum");
            phone.setAttribute("phonetyidx", String.valueOf(PersonUtils.PhoneType.MAIN.getDatabaseValue()));
            phone.setText(this.tfPhone.getCleanText());
            locn.addContent((Content)phone);
        }
        Element work = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.WORK);
        if (work != null) {
            work.setText(this.tfWork.getText());
        } else if (!this.tfWork.getText().equals("")) {
            work = new Element("phonenum");
            work.setAttribute("phonetyidx", String.valueOf(PersonUtils.PhoneType.WORK.getDatabaseValue()));
            work.setText(this.tfWork.getText());
            locn.addContent((Content)work);
        }
        Element mobile = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.OTHER);
        if (mobile != null) {
            mobile.setText(this.tfOther.getText());
        } else if (!this.tfOther.getText().equals("")) {
            mobile = new Element("phonenum");
            mobile.setAttribute("phonetyidx", String.valueOf(PersonUtils.PhoneType.OTHER.getDatabaseValue()));
            mobile.setText(this.tfOther.getText());
            locn.addContent((Content)mobile);
        }
        Element email = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.EMAIL);
        boolean hasEmailChanged = this.hasEmailAddressChanged(email, this.tfEmail.getText());
        if (email != null) {
            email.setText(this.tfEmail.getText());
        } else if (!this.tfEmail.getText().equals("")) {
            email = new Element("phonenum");
            email.setAttribute("phonetyidx", String.valueOf(PersonUtils.PhoneType.EMAIL.getDatabaseValue()));
            email.setText(this.tfEmail.getText());
            locn.addContent((Content)email);
        }
        if (email != null) {
            email.setAttribute("email_changed", String.valueOf(hasEmailChanged));
        }
        if ((references = this.person.getChild("references")) != null) {
            for (Map.Entry entry : this.refGrps.entrySet()) {
                if (((PersonRefGrp)entry.getValue()).getFlag() != 2) continue;
                Long rcidx = ((Reference)((PersonRefGrp)entry.getValue()).getCombo().getSelectedItem()).getIdx();
                if (rcidx > 0L) {
                    references.setAttribute("ref" + entry.getKey(), rcidx.toString());
                    continue;
                }
                references.removeAttribute("ref" + entry.getKey());
            }
        }
        if (this.chkSRep.isSelected()) {
            Element member = this.person.getChild("member");
            if (member == null) {
                member = new Element("member");
                this.person.addContent((Content)member);
            }
            if (this.salesRepSec[2] && !this.isInternalUserCode()) {
                member.setAttribute("memname", this.tfSalesRepCode.getText().toUpperCase());
                member.setAttribute("memfull", this.tfFirstName.getText() + " " + this.tfLastName.getText());
                member.setAttribute("email", this.tfEmail.getText());
                if (this.pfPassword.getPassword().length > 0 || member.getAttribute("memidx") == null) {
                    member.setAttribute("mempwd", Utils.encrypt(String.valueOf(this.pfPassword.getPassword()).toUpperCase()));
                    member.setAttribute("mempwd2", "");
                }
            } else if (member.getAttribute("memfull") != null) {
                member.removeAttribute("memfull");
            }
        } else {
            this.person.removeChild("member");
        }
        this.person.removeChildren("perloyalty");
        if (this.tblLoyalty != null) {
            ((LoyaltyModel)this.tblLoyalty.getModel()).getXml(this.person);
        }
    }

    private void setFocus() {
        this.tfFirstName.requestFocusInWindow();
    }

    @Override
    public void okDialog() {
    }

    @Override
    public void cancelDialog() {
        this.bCancel.doClick();
    }

    private boolean validatePerson() {
        block41: {
            if (this.tfFirstName.getText().trim().equals("")) {
                DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a3"), StoreParams.res.getString("Stop"), 0);
                this.tfFirstName.requestFocusInWindow();
                return false;
            }
            if (!this.validatePersonName(this.tfFirstName.getText())) {
                if (this.enforceFormatting) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Name_Validation"), StoreParams.res.getString("Stop"), 0);
                } else {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Name_Digit_Validation"), StoreParams.res.getString("Stop"), 0);
                }
                this.tfFirstName.requestFocusInWindow();
                return false;
            }
            if (this.tfLastName.getText().trim().equals("")) {
                DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a3"), StoreParams.res.getString("Stop"), 0);
                this.tfLastName.requestFocusInWindow();
                return false;
            }
            if (!this.validatePersonName(this.tfLastName.getText())) {
                if (this.enforceFormatting) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Name_Validation"), StoreParams.res.getString("Stop"), 0);
                } else {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Name_Digit_Validation"), StoreParams.res.getString("Stop"), 0);
                }
                this.tfLastName.requestFocusInWindow();
                return false;
            }
            if (this.enforcePhoneValidation && this.hasContactChanged(this.person, this.tfPhone.getCleanText().trim()) && !this.tfPhone.isValidNumber()) {
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Invalid_Contact"), this.cmbCountries.getSelectedItem()), StoreParams.res.getString("Stop"), 0);
                this.tfPhone.requestFocusInWindow();
                return false;
            }
            if (this.tfEmail.getText().trim().equals("") && (this.emailMandatory == (long)PersonInterfaceUtils.EmailPhoneValidation.Email.ordinal() || this.emailMandatory == (long)PersonInterfaceUtils.EmailPhoneValidation.Both.ordinal())) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Email_Mandatory"), StoreParams.res.getString("Stop"), 0);
                this.tfEmail.requestFocusInWindow();
                return false;
            }
            if (this.hasEmailAddressChanged(this.person, this.tfEmail.getText().trim())) {
                this.tfEmail.setText(this.tfEmail.getText().trim());
                if (!this.tfEmail.getText().equals("") && !this.sParams.getEmailValidator().validate(this.tfEmail.getText())) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Email_must_have_@"), StoreParams.res.getString("Stop"), 0);
                    this.tfEmail.requestFocusInWindow();
                    return false;
                }
                if (this.kleberUtils.EmailValidationEnabled()) {
                    try {
                        KleberModels.KleberResponse<KleberModels.DtResponse.EmailResult> response = this.kleberUtils.ValidateEmail(this.tfEmail.getText());
                        if (!response.FeatureEnabled) break block41;
                        KleberModels.DtResponse.EmailResult result = (KleberModels.DtResponse.EmailResult)response.DtResponse.Result.get(0);
                        switch (result.StatusCode) {
                            case Valid: 
                            case AcceptAll: {
                                break;
                            }
                            case Invalid: {
                                DlgMessage.showMessage(this, result.StatusDescription, StoreParams.res.getString("Stop"), 0);
                                this.tfEmail.requestFocusInWindow();
                                return false;
                            }
                            default: {
                                if (DlgMessage.showMessage(this, result.StatusDescription + "\nWould you like to continue?", "Cannot verify", 0, 3, 1) != 0) {
                                    this.tfEmail.requestFocusInWindow();
                                    return false;
                                }
                                break;
                            }
                        }
                    }
                    catch (KleberApiException e) {
                        if (!(e.getCause() instanceof SocketTimeoutException ? DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Kleber_Email_Verify_Failure"), StoreParams.res.getString("Kleber_Timeout"), 0, 3) != 0 : DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Kleber_Email_Verify_Failure"), StoreParams.res.getString("Kleber_Connection_Failed"), 0, 3) != 0)) break block41;
                        return false;
                    }
                }
            }
        }
        if (!this.tfBirthday.isValidDate()) {
            this.tfBirthday.actionValidate(false);
            if (!this.tfBirthday.isValidDate()) {
                DlgMessage.showMessage(this, SP.getRS("Invalid_Date_Format"), SP.getRS("Error"), 0);
                this.tfBirthday.requestFocusInWindow();
                return false;
            }
        }
        boolean isNZ = NZ_COUNTRY_CODE.equals(((Country)this.cmbCountries.getSelectedItem()).getCode());
        if (!this.tfAddr1.getText().trim().equals("")) {
            if (Settings.isPostcodeMandatory()) {
                if (this.cmbCities.getTextField().getText().equals("")) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("City_validation"), StoreParams.res.getString("Stop"), 0);
                    this.cmbCities.getTextField().requestFocusInWindow();
                    return false;
                }
                if (!isNZ && this.tfState.getText().equals("")) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("State_validation"), StoreParams.res.getString("Stop"), 0);
                    this.tfState.requestFocusInWindow();
                    return false;
                }
                if (!isNZ && !this.tfState.getText().trim().equals("") && !this.validateState(this.tfState.getText()) && Settings.isStateValidation()) {
                    DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("State_Value_Not_Valid"), this.tfState.getText()), StoreParams.res.getString("Stop"), 0);
                    this.tfState.requestFocusInWindow();
                    return false;
                }
                if (this.tfPostCode.getText().equals("")) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Post_code_validation"), StoreParams.res.getString("Stop"), 0);
                    this.tfPostCode.requestFocusInWindow();
                    return false;
                }
            } else if (this.cmbCities.getTextField().getText().equals("")) {
                DlgMessage.showMessage(this, StoreParams.res.getString("City_validation"), StoreParams.res.getString("Stop"), 0);
                this.cmbCities.getTextField().requestFocusInWindow();
                return false;
            }
        }
        if (!this.tfAddr2.getText().trim().equals("") && this.tfAddr1.getText().equals("")) {
            DlgMessage.showMessage(this, StoreParams.res.getString("AddLine2_validation"), StoreParams.res.getString("Stop"), 0);
            this.tfAddr1.requestFocusInWindow();
            return false;
        }
        if (!isNZ && !this.tfState.getText().trim().equals("") && !this.validateState(this.tfState.getText()) && Settings.isStateValidation()) {
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("State_Value_Not_Valid"), this.tfState.getText()), StoreParams.res.getString("Stop"), 0);
            this.tfState.requestFocusInWindow();
            return false;
        }
        if (!this.cmbCities.getTextField().getText().trim().equals("") && Settings.isPostcodeMandatory()) {
            if (!isNZ && this.tfState.getText().equals("")) {
                DlgMessage.showMessage(this, StoreParams.res.getString("State_validation"), StoreParams.res.getString("Stop"), 0);
                this.tfState.requestFocusInWindow();
                return false;
            }
            if (this.tfPostCode.getText().equals("")) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Post_code_validation"), StoreParams.res.getString("Stop"), 0);
                this.tfPostCode.requestFocusInWindow();
                return false;
            }
        }
        if (this.cmbCities.getTextField().getText().length() > 50) {
            DlgMessage.showMessage(this, StoreParams.res.getString("City_length_validation"), StoreParams.res.getString("Stop"), 0);
            this.cmbCities.getTextField().requestFocusInWindow();
            return false;
        }
        if (this.chkSRep.isSelected()) {
            if (this.tfSalesRepCode.getText().equals("")) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Enter_SCode"), StoreParams.res.getString("Stop"), 0);
                this.tfSalesRepCode.requestFocusInWindow();
                return false;
            }
            Pattern pattern = Pattern.compile("\\s");
            if (pattern.matcher(this.tfSalesRepCode.getText()).find()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("SCode_Cannot_Have_Whitespace"), StoreParams.res.getString("Stop"), 0);
                this.tfSalesRepCode.requestFocusInWindow();
                return false;
            }
            if (!this.tfSalesRepCode.getText().toUpperCase().equals(XMLUtils.getValue(this.person.getChild("member"), "memname").toUpperCase()) && this.isInternalUserCode()) {
                DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Internal_Memname_Not_Allowed"), this.tfSalesRepCode.getText().toUpperCase().trim()), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (!String.valueOf(this.pfPassword.getPassword()).toUpperCase().equals(String.valueOf(this.pfPasswordConfirm.getPassword()).toUpperCase())) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Confirm_pass"), StoreParams.res.getString("Stop"), 0);
                this.pfPassword.requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    private boolean hasEmailAddressChanged(Element person, String newEmailAddress) {
        if (person == null) {
            return false;
        }
        Element phone = PersonUtils.getPhone(person, PersonUtils.PhoneType.EMAIL);
        String originalEmail = phone != null ? phone.getText() : "";
        return !newEmailAddress.equals(originalEmail);
    }

    private boolean hasContactChanged(Element person, String newContact) {
        if (person == null) {
            return false;
        }
        Element phone = PersonUtils.getPhone(person, PersonUtils.PhoneType.MAIN);
        String originalContact = phone != null ? phone.getText() : "";
        return !newContact.equals(originalContact);
    }

    private void createEmail() {
        this.tfEmail.setText(this.tfEmail.getText().trim());
        if (this.tfEmail.getText().equals("") || !this.sParams.getEmailValidator().validate(this.tfEmail.getText())) {
            DlgMessage.showMessage(this, StoreParams.res.getString("Email_must_have_@"), StoreParams.res.getString("Stop"), 0);
            this.tfEmail.requestFocusInWindow();
            return;
        }
        try {
            Runtime run = Runtime.getRuntime();
            run.exec("ShellExecNormal.exe mailto:" + this.tfEmail.getText());
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void setEnforceFormatting(boolean enforceFormatting) {
        this.enforceFormatting = enforceFormatting;
        for (FormattedStringField field : this.formattedStringFields) {
            field.setEnforceFormatting(this.enforceFormatting);
        }
    }

    public boolean validatePersonName(String name) {
        if (!this.sParams.bEnforceFormatting) {
            return true;
        }
        if (this.enforceFormatting) {
            return name.matches("[A-Z][ a-zA-Z'&/-]*");
        }
        return name.matches("[a-zA-Z0-9][ a-zA-Z0-9'&/-]*");
    }

    private boolean validateState(String state) {
        boolean bOk = false;
        String country = this.cmbCountries.getSelectedItem().toString();
        int count = 0;
        try (PreparedStatement pstmt = SP.sParams.conn.prepareStatement("SELECT DISTINCT(UPPER(COALESCE(STATE,''))) FROM POSTCODE WHERE UPPER(COUNTRY) = ? ");){
            pstmt.setString(1, country.toUpperCase());
            try (ResultSet result = pstmt.executeQuery();){
                while (result.next()) {
                    ++count;
                    if (!result.getString(1).equals(state.toUpperCase())) continue;
                    bOk = true;
                    break;
                }
            }
            if (count == 0) {
                bOk = true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return bOk;
    }

    void bDeletePerson_actionPerformed(ActionEvent e) {
        if (this.person.getAttribute("peridx") != null) {
            if (this.person.getChild("member") != null && !this.frParent.hasSecurity(11104L, 3)) {
                DlgMessage.showMessage(this, StoreParams.res.getString("No_Edit_Staff_Security"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            if (this.isGuestAccount()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("No_Edit_Guest_Person"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            if (DlgMessage.showMessage(this.frParent, StoreParams.res.getString("del_person_confirm"), StoreParams.res.getString("del_person"), 0, 2) != 0) {
                return;
            }
            try {
                this.bActive = false;
                this.buildXml();
                if (!this.frParent.getUser().isTraningUser()) {
                    this.save_inactive_person(true);
                    this.save_inactive_person(false);
                }
                this.setNewPerson(true);
                if (this.person.getAttribute("peridx") != null || this.frParent.getUser().isTraningUser()) {
                    this.cleanPerson();
                    this.dispose();
                }
            }
            catch (Exception ex) {
                PosUtils.logError(ex);
            }
        }
    }

    private void save_inactive_person(boolean bonline) {
        XMLOutputter printer = new XMLOutputter();
        if (bonline) {
            this.sParams.OnlineQueryProvider.getOnlineQuery("saveperson", printer.outputString(this.person) + "\u0003" + this.sParams.getStoreIdx()).getXML();
        } else {
            this.sParams.getXML(this.frParent, "saveperson", printer.outputString(this.person) + "\u0003" + this.sParams.getStoreIdx(), bonline);
        }
    }

    private void loadRewardsOffline() {
        long peridx = XMLUtils.getLongValue(this.person, "peridx");
        RewardsAccount customerRewardsProgram = new RewardsAccount();
        customerRewardsProgram.loadOffline(peridx);
        this.historySummary.populateRewards(peridx, customerRewardsProgram);
    }

    private void populateHistory() {
        try {
            Element root = this.sParams.OnlineQueryProvider.getOnlineQuery("cust_hist", this.person.getAttribute("peridx").getValue() + "," + String.valueOf(this.sParams.getStoreIdx())).getXML();
            if (root != null) {
                if (this.showHistory && root.getChild("summaries") != null) {
                    List summaries = root.getChild("summaries").getChildren();
                    Vector<CustSummaryItem> data = new Vector<CustSummaryItem>();
                    for (int i = 0; i < summaries.size(); ++i) {
                        Element summaryItem = (Element)summaries.get(i);
                        if (summaryItem.getAttribute("period") == null || summaryItem.getAttribute("spend") == null) continue;
                        CustSummaryItem summary = new CustSummaryItem(summaryItem.getAttributeValue("period"), summaryItem.getAttributeValue("spend"));
                        data.add(summary);
                    }
                    if (root.getChild("total") != null) {
                        data.add(new CustSummaryItem("", ""));
                        data.add(new CustSummaryItem("Total", ""));
                        Element total = root.getChild("total");
                        if (total.getAttribute("dateStart") != null && total.getAttribute("dateEnd") != null) {
                            data.add(new CustSummaryItem(total.getAttributeValue("dateStart"), total.getAttributeValue("dateEnd"), total.getAttributeValue("total")));
                        }
                    }
                    this.historySummary.populateSummaryData(data);
                }
                if (RewardsUtils.usingAp21RetailRewards()) {
                    RewardsAccount customerRewardsProgram = new RewardsAccount();
                    Element rewards = root.getChild("rewards_account");
                    if (rewards != null) {
                        customerRewardsProgram.loadFromXml(XMLUtils.getLongValue(this.person, "peridx"), rewards);
                    }
                    this.historySummary.populateRewards(XMLUtils.getLongValue(this.person, "peridx"), customerRewardsProgram);
                }
                if (this.showHistory) {
                    Element trans = root.getChild("trans");
                    if (trans != null) {
                        int showingFirst = trans.getAttribute("showing_first") != null ? PosUtils.intVal(trans.getAttribute("showing_first").getValue()) : 0;
                        List transactions = trans.getChildren();
                        Vector<TranHist> data = new Vector<TranHist>();
                        PosDateFormatter dateFormatter = new PosDateFormatter(null);
                        if (transactions.size() > 0) {
                            for (int i = 0; i < transactions.size(); ++i) {
                                Element transaction = (Element)transactions.get(i);
                                TranHist hist = new TranHist();
                                if (transaction.getAttribute("trans_number") != null) {
                                    hist.setTransNum(transaction.getAttribute("trans_number").getIntValue());
                                }
                                if (transaction.getAttribute("trans_date") != null) {
                                    dateFormatter.setTimestampInternal(transaction.getAttribute("trans_date").getValue());
                                    hist.setTransDate(dateFormatter.toString());
                                }
                                if (transaction.getAttribute("trans_store") != null) {
                                    hist.setStore(transaction.getAttribute("trans_store").getValue());
                                }
                                if (transaction.getAttribute("trans_name") != null) {
                                    hist.setType(transaction.getAttribute("trans_name").getValue());
                                }
                                if (transaction.getAttribute("trans_total") != null) {
                                    hist.setTotal(transaction.getAttribute("trans_total").getDoubleValue());
                                }
                                if (transaction.getAttribute("trans_docket") != null) {
                                    hist.setDocket(transaction.getAttribute("trans_docket").getValue());
                                }
                                if (transaction.getAttribute("tr_type") != null) {
                                    hist.setTrType(transaction.getAttribute("tr_type").getIntValue());
                                }
                                data.add(hist);
                            }
                            this.custHistory.populateTransTable(data, showingFirst);
                        }
                    }
                    if (root.getChild("details") != null) {
                        List details = root.getChild("details").getChildren();
                        Vector<TranDetail> detailData = new Vector<TranDetail>();
                        if (details.size() > 0) {
                            for (int i = 0; i < details.size(); ++i) {
                                Element detail = (Element)details.get(i);
                                TranDetail hist_det = new TranDetail();
                                if (detail.getAttribute("vhidx") != null) {
                                    hist_det.setVhidx(detail.getAttribute("vhidx").getIntValue());
                                }
                                if (detail.getAttribute("vshidx") != null) {
                                    hist_det.setVshidx(detail.getAttribute("vshidx").getIntValue());
                                }
                                if (detail.getAttribute("sku") != null) {
                                    hist_det.setSku(detail.getAttribute("sku").getValue());
                                }
                                if (detail.getAttribute("description") != null) {
                                    hist_det.setDescription(detail.getAttribute("description").getValue());
                                }
                                if (detail.getAttribute("qty") != null) {
                                    hist_det.setQty(detail.getAttribute("qty").getIntValue());
                                }
                                if (detail.getAttribute("net") != null) {
                                    hist_det.setNet(detail.getAttribute("net").getDoubleValue());
                                }
                                detailData.add(hist_det);
                            }
                            this.custHistory.populateDetailData(detailData);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    public void ViewTransaction() {
        if (this.custHistory.isRowSelected()) {
            this.frParent.menu.populate(this.frParent, this.custHistory.getSelectedTrType(), this.custHistory.getSelectedTransDocket());
            this.bCancel.doClick();
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("select_transaction"), StoreParams.res.getString("Stop"), 2);
        }
    }

    public void loadActivePerson(boolean focusEmail) {
        boolean isOnline = SP.sParams.checkIConn();
        this.populate(isOnline);
        if ((this.showHistory || RewardsUtils.usingAp21RetailRewards()) && !this.isGuestAccount() && isOnline) {
            this.populateHistory();
        } else if (RewardsUtils.usingAp21RetailRewards() && !this.isGuestAccount() && !this.sParams.checkIConn()) {
            this.loadRewardsOffline();
        }
        if (focusEmail) {
            this.tfEmail.requestFocus();
        }
    }

    @Override
    public void setCursor(final Cursor cursor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LegacyPersonDlg.this.getGlassPane().setCursor(cursor);
                LegacyPersonDlg.this.getGlassPane().setVisible(cursor == StoreParams.waitCursor);
            }
        });
    }

    private int getGenderItemIndex(String dbValue) {
        for (int i = 0; i < this.genders.size(); ++i) {
            if (!this.genders.get(i).getDBValue().equals(dbValue)) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPersonDefaultReferences() {
        Element refsElement = this.person.getChild("references");
        if (refsElement == null) {
            refsElement = new Element("references");
            this.person.addContent((Content)refsElement);
        }
        try (SqlQuery qryReftbl = new SqlQuery(SP.sParams.conn, "SELECT WHSE.RG_ORD AS WHSE_REF, PER.RG_ORD AS PER_REF FROM REFTBL WHSE JOIN REFTBL PER ON WHSE.RGIDX = PER.RGIDX WHERE WHSE.TBLIDX = 18 AND PER.TBLIDX = 12 ORDER BY PER.RG_ORD");){
            while (qryReftbl.next()) {
                SqlQuery qryWhse;
                block30: {
                    int personRefOrd = qryReftbl.getInt("PER_REF");
                    int whseRefOrd = qryReftbl.getInt("WHSE_REF");
                    qryWhse = new SqlQuery(SP.sParams.conn, String.format("SELECT REF%s AS WHSE_RCIDX FROM WHSE WHERE WIDX = ? ", whseRefOrd), SP.sParams.getStoreIdx());
                    Throwable throwable = null;
                    try {
                        String whseRcidx;
                        if (qryWhse.next() && !StringUtils.isNullOrEmpty(whseRcidx = qryWhse.getString("WHSE_RCIDX"))) {
                            refsElement.setAttribute("ref" + personRefOrd, whseRcidx);
                        }
                        if (qryWhse == null) continue;
                        if (throwable == null) break block30;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (qryWhse == null) throw throwable3;
                            if (throwable == null) {
                                qryWhse.close();
                                throw throwable3;
                            }
                            try {
                                qryWhse.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        qryWhse.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                qryWhse.close();
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        int i = 1;
        while (i <= 10) {
            if (this.refGrps.containsKey(i)) {
                if (refsElement != null && !StringUtils.isNullOrEmpty(XMLUtils.getValue(refsElement, "ref" + i))) {
                    ((PersonRefGrp)this.refGrps.get(i)).setComboSelected(XMLUtils.getLongValue(refsElement, "ref" + i));
                } else {
                    ((PersonRefGrp)this.refGrps.get(i)).setComboSelected(PosUtils.longVal(-1));
                }
            }
            ++i;
        }
    }

    public void suppressOmneoPersonMaint(boolean suppressOmneoPersonMaint) {
        this.suppressOmneoPersonMaint = suppressOmneoPersonMaint;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.frParent.isAlternativePersonMaintEnabled() && !this.suppressOmneoPersonMaint) {
            if (!this.loadOmneoPersonView() && this.isNewPerson()) {
                this.showSearch();
                super.setVisible(visible);
            }
        } else {
            if (visible && this.isNewPerson()) {
                this.showSearch();
            }
            super.setVisible(visible);
        }
    }

    private void showSearch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean online = SP.sParams.checkIConn();
                String searchCustidx = LegacyPersonDlg.this.accountCustidx > 0L ? String.valueOf(LegacyPersonDlg.this.accountCustidx) : "";
                DlgPersonSearchResult.Result result = DlgPersonSearchResult.showDialog(LegacyPersonDlg.this.frParent, LegacyPersonDlg.this, SP.getRS("Person_Search"), true, online, searchCustidx);
                if (result.getButtonPressed() == DlgPersonSearchResult.Button.NEW) {
                    LegacyPersonDlg.this.setNewPerson(true);
                    LegacyPersonDlg.this.prePopulateNewPerson(result);
                    return;
                }
                if (result.getButtonPressed() == DlgPersonSearchResult.Button.OK && result.getPerIdx() != 0L) {
                    try {
                        Element person = LegacyPersonDlg.this.loadPersonElement(String.valueOf(result.getPerIdx()), online);
                        if (person != null) {
                            LegacyPersonDlg.this.setNewPerson(false);
                            LegacyPersonDlg.this.loadFromSearchData(person, false, online);
                        }
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadOmneoPersonView() {
        try (DlgOmneoPerson dlg = new DlgOmneoPerson(this.frParent);){
            long selectedPeridx;
            if (this.person.getAttribute("peridx") != null) {
                long peridx = 0L;
                try {
                    peridx = this.person.getAttribute("peridx").getLongValue();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
                dlg.setPersonFromAp21(peridx);
            }
            dlg.loadPage();
            dlg.setVisible(true);
            if (dlg.hasFailedToLoad()) {
                boolean peridx = false;
                return peridx;
            }
            if (!dlg.isPersonSelected()) {
                this.bCancel.doClick();
                boolean peridx = true;
                return peridx;
            }
            String docketNumber = StringUtils.nullToEmpty(dlg.getDocketNumber());
            if (docketNumber.length() > 0) {
                if (docketNumber.toUpperCase().startsWith("D")) {
                    docketNumber = docketNumber.substring(1);
                }
                if (!this.frParent.populate(docketNumber)) {
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("cant_find_transaction_in_ap21"), docketNumber, "\n"), SP.getRS("cant_find_transaction_in_ap21_title"));
                }
            }
            if ((selectedPeridx = dlg.getPersonId()) != 0L) {
                boolean isOnline = SP.sParams.checkIConn();
                Element personElement = this.loadPersonElement(String.valueOf(selectedPeridx), isOnline);
                if (personElement == null) return true;
                this.setNewPerson(false);
                this.loadFromSearchData(personElement, true, isOnline);
                this.bAccept.doClick();
                return true;
            }
            String cardNumber = StringUtils.nullToEmpty(dlg.getCardNumber());
            if (cardNumber.length() <= 0) return true;
            DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("cant_find_person_in_ap21"), cardNumber, "\n"), SP.getRS("cant_find_person_in_ap21_title"));
            this.bCancel.doClick();
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return true;
    }

    public boolean isAcceptPressed() {
        return this.acceptPressed;
    }

    public boolean isGuestAccount() {
        return XMLUtils.getLongValue(this.person, "guest_account") == 1L;
    }

    private boolean isInternalUserCode() {
        String user = StringUtils.nullToEmpty(this.tfSalesRepCode.getText()).toUpperCase().trim();
        return user.equals("BASS") || user.equals("SYS") || user.equals("WORKFLOW") || user.equals("PRINTSVR");
    }

    private Element loadPersonElement(String peridx, boolean online) throws Exception {
        Element personElement = null;
        if (online) {
            personElement = this.sParams.OnlineQueryProvider.getOnlineQuery("person", peridx + "," + this.sParams.getStoreIdx(), false).getXML();
            long actualPeridx = XMLUtils.getLongValue(personElement, "pos_idx");
            if (actualPeridx != 0L && XMLUtils.getLongValue(personElement, "widx") == SP.sParams.getStoreIdx()) {
                personElement.setAttribute("peridx", String.valueOf(actualPeridx));
            }
        } else {
            personElement = XMLLocal.getElement(SP.sParams.conn, "person", peridx);
        }
        if (personElement == null || personElement.getAttribute("peridx") == null) {
            DlgMessage.showMessage(this, SP.getRS("Person_Load_Failed"), SP.getRS("Error"), 0);
            return null;
        }
        return personElement;
    }

    private class LoyaltyModel
    extends AbstractTableModel {
        private static final int PROGRAM_COLUMN = 0;
        private static final int CARD_NUMBER_COLUMN = 1;
        private static final int EXPIRY_COLUMN = 2;
        private static final int BALANCE_COLUMN = 3;
        private static final int CREDIT_STATUS_BALANCE_COLUMN = 4;
        private static final int COL_COUNT = 5;
        List<LoyaltyCard> deletedCards = new ArrayList<LoyaltyCard>();
        List<LoyaltyCard> loyaltyCards = new ArrayList<LoyaltyCard>();

        private LoyaltyModel() {
        }

        @Override
        public int getRowCount() {
            return this.loyaltyCards.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return (String)LegacyPersonDlg.this.colNames[col];
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Reference.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return PosDouble.class;
                }
                case 4: {
                    return PosDouble.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.loyaltyCards.size() || row < 0) {
                return "";
            }
            switch (col) {
                case 0: {
                    return this.loyaltyCards.get(row).getLoyaltyProgram();
                }
                case 1: {
                    return this.loyaltyCards.get(row).getCardNumber();
                }
                case 2: {
                    return this.loyaltyCards.get(row).getExpiryDate();
                }
                case 3: {
                    return new PosDouble(Math.floor(this.loyaltyCards.get(row).getBalance()));
                }
                case 4: {
                    return new PosDouble(Math.floor(this.loyaltyCards.get(row).getCreditStatusBalance()));
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void removeLoyaltyCard(LoyaltyCard loyaltyCard) {
            this.deletedCards.add(loyaltyCard);
            this.loyaltyCards.remove(loyaltyCard);
            this.fireTableDataChanged();
        }

        public void addLoyaltyCard(LoyaltyCard loyaltyCard) {
            this.loyaltyCards.add(loyaltyCard);
            this.fireTableDataChanged();
            LegacyPersonDlg.this.tblLoyalty.setRowSelectionInterval(this.loyaltyCards.size() - 1, this.loyaltyCards.size() - 1);
        }

        public void getXml(Element root) {
            Element loyalty;
            DecimalFormat df = new DecimalFormat("#");
            df.setMaximumFractionDigits(4);
            for (LoyaltyCard loyaltyCard : this.loyaltyCards) {
                loyalty = new Element("perloyalty");
                loyalty.setAttribute("rcidx", String.valueOf(loyaltyCard.getLoyaltyProgram().getLoyalty().getIdx()));
                if (loyaltyCard.getExpiryDate().getTimestamp() != null) {
                    loyalty.setAttribute("expiry", loyaltyCard.getExpiryDate().getTimestamp().toString());
                } else {
                    loyalty.setAttribute("expiry", "");
                }
                if (loyaltyCard.getCardId() != 0L) {
                    loyalty.setAttribute("loyalidx", String.valueOf(loyaltyCard.getCardId()));
                }
                loyalty.setText(loyaltyCard.getLoyaltyProgram().getLoyalty().getCode());
                if (!loyaltyCard.getCardNumber().equals("")) {
                    loyalty.setAttribute("cardno", loyaltyCard.getCardNumber());
                }
                if (loyaltyCard.getBalance() != 0.0) {
                    loyalty.setAttribute("ltot", df.format(loyaltyCard.getBalance()));
                }
                if (loyaltyCard.getCreditStatusBalance() != 0.0) {
                    loyalty.setAttribute("credit_status", df.format(loyaltyCard.getCreditStatusBalance()));
                }
                root.addContent((Content)loyalty);
            }
            for (LoyaltyCard deletedCard : this.deletedCards) {
                if (deletedCard.getCardId() == 0L) continue;
                loyalty = new Element("perloyalty");
                loyalty.setAttribute("loyalidx", String.valueOf(deletedCard.getCardId()));
                root.addContent((Content)loyalty);
            }
        }

        public void setXml(Element root) {
            try {
                List loyals = root.getChildren("perloyalty");
                for (int i = 0; i < loyals.size(); ++i) {
                    LoyaltyCard loyaltyCard = new LoyaltyCard();
                    Reference loyaltyReference = new Reference(((Element)loyals.get(i)).getAttribute("rcidx").getLongValue());
                    loyaltyReference.setShowName(true);
                    loyaltyCard.setLoyaltyProgram(loyaltyReference);
                    if (loyaltyCard.getLoyaltyProgram().getLoyalty() == null) continue;
                    if (((Element)loyals.get(i)).getAttribute("expiry") != null && !((Element)loyals.get(i)).getAttribute("expiry").getValue().equals("")) {
                        loyaltyCard.getExpiryDate().setTimestampInternal(((Element)loyals.get(i)).getAttribute("expiry").getValue());
                    }
                    if (((Element)loyals.get(i)).getAttribute("cardno") != null) {
                        loyaltyCard.setCardNumber(((Element)loyals.get(i)).getAttribute("cardno").getValue());
                    }
                    if (((Element)loyals.get(i)).getAttribute("ltot") != null) {
                        loyaltyCard.setBalance(PosUtils.doubleValInternal(((Element)loyals.get(i)).getAttribute("ltot").getValue()));
                    }
                    if (((Element)loyals.get(i)).getAttribute("credit_status") != null) {
                        loyaltyCard.setCreditStatusBalance(PosUtils.doubleValInternal(((Element)loyals.get(i)).getAttribute("credit_status").getValue()));
                    }
                    loyaltyCard.setCardId(PosUtils.longVal(((Element)loyals.get(i)).getAttribute("loyalidx").getValue()));
                    loyaltyCard.flagAsNew(false);
                    this.loyaltyCards.add(loyaltyCard);
                }
                this.fireTableDataChanged();
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }

        public boolean editMade() {
            if (this.deletedCards.size() > 0) {
                return true;
            }
            for (LoyaltyCard loyaltyCard : this.loyaltyCards) {
                if (!loyaltyCard.isEdited() && !loyaltyCard.isNew()) continue;
                return true;
            }
            return false;
        }

        public void reset() {
            this.loyaltyCards.clear();
            this.deletedCards.clear();
            this.fireTableDataChanged();
        }
    }
}

