/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.util.List;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.person.EmailStatus;
import org.jdom.Element;

public class PersonUtils {
    public static EmailStatus getEmailStatus(Element email) {
        if (StringUtils.isNullOrEmpty(XMLUtils.getValue(email, "email_state"))) {
            return EmailStatus.ASSUMED_OK;
        }
        return EmailStatus.getStateFromInt((int)XMLUtils.getLongValue(email, "email_state"));
    }

    public static EmailStatus getEmailStatusFromPerson(Element person) {
        Element email = PersonUtils.getPhone(person, PhoneType.EMAIL);
        if (email == null) {
            return EmailStatus.ASSUMED_OK;
        }
        return PersonUtils.getEmailStatus(email);
    }

    public static String getPerName(Element person) {
        String retVal = "";
        if (person.getAttribute("title") != null) {
            retVal = StringUtils.nullToEmpty(person.getAttribute("title").getValue());
        }
        if (person.getAttribute("firstname") != null) {
            retVal = retVal + " " + StringUtils.nullToEmpty(person.getAttribute("firstname").getValue());
        }
        if (person.getAttribute("surname") != null) {
            retVal = retVal + " " + StringUtils.nullToEmpty(person.getAttribute("surname").getValue());
        }
        return retVal.trim();
    }

    public static String getPerSurname(Element person) {
        String retVal = "";
        if (person.getAttribute("surname") != null) {
            retVal = StringUtils.nullToEmpty(person.getAttribute("surname").getValue());
        }
        return retVal.trim();
    }

    public static String getPerFirstname(Element person) {
        String retVal = "";
        if (person.getAttribute("firstname") != null) {
            retVal = StringUtils.nullToEmpty(person.getAttribute("firstname").getValue());
        }
        return retVal.trim();
    }

    public static String getPhoneNum(Element person, PhoneType phoneType) {
        Element e = PersonUtils.getPhone(person, phoneType);
        if (e != null) {
            return e.getText();
        }
        return "";
    }

    public static Element getPhone(Element person, PhoneType phoneType) {
        try {
            if (person.getChild("locn") != null) {
                List phonenums = person.getChild("locn").getChildren("phonenum");
                for (int i = 0; i < phonenums.size(); ++i) {
                    if (!((Element)phonenums.get(i)).getAttribute("phonetyidx").getValue().equals(String.valueOf(phoneType.getDatabaseValue()))) continue;
                    return (Element)phonenums.get(i);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static boolean checkPersonExistsLocally(long peridx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalPersonOutOfDate(Element person) {
        String perIdx = XMLUtils.getValue(person, "peridx");
        if (perIdx.isEmpty()) {
            return false;
        }
        String updt = XMLUtils.getValue(person, "updt");
        if (updt.isEmpty()) {
            return true;
        }
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT 1 FROM PERSON P WHERE P.PERIDX = ? AND COALESCE(P.UPDT, CAST('1900-01-01' AS TIMESTAMP)) >= CAST(? AS TIMESTAMP)", perIdx, updt);){
            boolean bl = !qry.next();
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public static enum PhoneType {
        MAIN(154L),
        EMAIL(159L),
        WORK(536L),
        OTHER(631L);

        private long databaseValue;

        private PhoneType(long databaseValue) {
            this.databaseValue = databaseValue;
        }

        public long getDatabaseValue() {
            return this.databaseValue;
        }

        public static PhoneType getPhoneType(String databaseValue) {
            return PhoneType.getPhoneType(PosUtils.longVal(databaseValue));
        }

        public static PhoneType getPhoneType(long databaseValue) {
            for (PhoneType p : PhoneType.values()) {
                if (p.databaseValue != databaseValue) continue;
                return p;
            }
            return null;
        }
    }
}

