/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jpos.DlgManualLoyaltyDiscount;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.LoyaltyRedemptionPanel;
import jpos.PaSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.XMLUtils;
import jpos.person.PersonUtils;
import jpos.rewards.Gift;
import jpos.rewards.GiftSku;
import jpos.rewards.GiftSkuScanDlg;
import jpos.rewards.RewardsAccount;
import jpos.rewards.RewardsProgressBar;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelStrong;
import jpos.ui.LabelSubHeadingStrong;
import jpos.ui.TouchList;

public class GiftRedemptionPanel
extends LoyaltyRedemptionPanel {
    private LabelNormal labelImage = new LabelNormal();
    private LabelSubHeadingStrong labelPerson = new LabelSubHeadingStrong();
    private LabelNormal labelProgram = new LabelNormal("");
    private LabelNormal labelTier = new LabelNormal("");
    RewardsProgressBar progressNextTier = new RewardsProgressBar(RewardsProgressBar.DisplayType.NEXT_TIER);
    RewardsProgressBar progressNextReward = new RewardsProgressBar(RewardsProgressBar.DisplayType.NEXT_REWARD);
    private LabelStrong labelRedeemGiftTitle = new LabelStrong();
    private TouchList<Gift> giftList = new TouchList();
    private PosScrollPane scrollPane = new PosScrollPane(this.giftList);
    private DialogButton bOK = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private RewardsAccount rewardsAccount;
    private DlgManualLoyaltyDiscount parentDlg;
    private GiftSku selectedGift;

    public GiftRedemptionPanel(DlgManualLoyaltyDiscount parentDlg) {
        super(parentDlg);
        this.parentDlg = parentDlg;
        try {
            this.init();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void init() {
        this.setBackground(Color.WHITE);
        this.progressNextTier.setBackground(Color.WHITE);
        this.progressNextReward.setBackground(Color.WHITE);
        this.progressNextTier.setPreferredSize(new Dimension(132, 132));
        this.progressNextReward.setPreferredSize(new Dimension(132, 132));
        this.labelImage.setIcon(new ImageIcon(SP.sParams.imagepath + "GiftIconLarge.png"));
        this.labelImage.setHorizontalAlignment(0);
        this.labelProgram.setMaxWidth(400);
        this.labelTier.setMaxWidth(400);
        this.labelRedeemGiftTitle.setText(SP.getRS("Choose_Gift"));
        DefaultListCellRenderer renderer = (DefaultListCellRenderer)this.giftList.getCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.scrollPane.setMinimumSize(new Dimension(320, 100));
        this.scrollPane.setPreferredSize(new Dimension(320, 100));
        this.bOK.setText(SP.getRS("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftRedemptionPanel.this.getParentDlg().okDialog();
            }
        });
        this.bCancel.setText(SP.getRS("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftRedemptionPanel.this.getParentDlg().cancelDialog();
            }
        });
        this.giftList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    GiftRedemptionPanel.this.bOK.doClick();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.labelImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.labelPerson, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.labelProgram, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.labelTier, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        JPanel progressPanel = new JPanel(new GridBagLayout());
        progressPanel.setBackground(Color.WHITE);
        progressPanel.add((Component)this.progressNextTier, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        progressPanel.add((Component)this.progressNextReward, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)progressPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.labelRedeemGiftTitle, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 2, 10), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 50, 5, 50), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBackground(Color.WHITE);
        buttonPanel.add((Component)this.bOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 32, 5), 0, 0));
        buttonPanel.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 32, 10), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollPane.getViewport().add(this.giftList);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.giftList);
        v.add(this.bOK);
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    @Override
    public void load() {
        this.rewardsAccount = null;
        try {
            if (this.parentDlg.frParent instanceof FrSales) {
                FrSales sales = (FrSales)this.parentDlg.frParent;
                if (sales.rewardsApiManager.loadAccount(XMLUtils.getLongValue(sales.getPerson(), "peridx"))) {
                    this.rewardsAccount = sales.rewardsApiManager.getAccount();
                    Vector<Gift> unusedGifts = new Vector<Gift>();
                    Vector<Gift> usedGifts = ((PaSales)sales.paBody).tblStyles.getGifts();
                    for (Gift g : this.rewardsAccount.getAvailableGifts()) {
                        if (usedGifts.contains(g)) continue;
                        unusedGifts.add(g);
                    }
                    this.giftList.setListData(unusedGifts);
                } else {
                    DlgMessage.showMessage(this.getParentDlg(), sales.rewardsApiManager.getLastError(), SP.getRS("Error"), 0);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.getParentDlg().setTitle(SP.getRS("Gift_Redemption"));
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.labelPerson.setText(PersonUtils.getPerName(this.getPerson()));
        if (this.rewardsAccount != null) {
            this.labelProgram.setText(this.rewardsAccount.getRewardsProgram().toString());
            this.labelTier.setText(MessageFormat.format(SP.getRS("Rewards_Tier"), this.rewardsAccount.getCurrentTier().toString()));
            this.progressNextTier.setVisible(this.progressNextTier.updateProgressBar(this.rewardsAccount, this.getAccrueSpendTotal(), false));
            this.progressNextReward.setVisible(this.progressNextReward.updateProgressBar(this.rewardsAccount, this.getAccrueSpendTotal(), false));
        }
    }

    @Override
    public boolean validateInputs() {
        if (this.giftList.getSelectedValue() != null) {
            GiftSkuScanDlg dlg = new GiftSkuScanDlg(this.parentDlg.frParent, (Gift)this.giftList.getSelectedValue());
            dlg.setVisible(true);
            long giftSkuidx = dlg.getSelectedSkuidx();
            if (giftSkuidx > 0L) {
                this.selectedGift = new GiftSku((Gift)this.giftList.getSelectedValue(), giftSkuidx);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public GiftSku getSelectedGift() {
        return this.selectedGift;
    }
}

