/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import jpos.StyleLine;
import jpos.User;
import jpos.logging.RollingLog;
import jpos.rewards.GiftSku;
import jpos.rewards.IRewardsApiManager;
import jpos.rewards.RetailRewardsApi;
import jpos.rewards.RetailRewardsDataTransaction;
import jpos.rewards.RewardsAccount;

public class RetailRewardsApiManager
implements IRewardsApiManager {
    private RetailRewardsApi api = new RetailRewardsApi();
    private long perIdx;
    private TransactionState rewardsTransaction = new TransactionState(new RetailRewardsDataTransaction(), RedemptionState.UNUSED);
    private Vector<TransactionState> giftTransactions = new Vector();

    public RetailRewardsApiManager() {
        this.reverseAllIncompleteRedemptions();
    }

    private List<TransactionState> getAllTransactions() {
        Vector<TransactionState> allTransactions = new Vector<TransactionState>();
        allTransactions.add(this.rewardsTransaction);
        allTransactions.addAll(this.giftTransactions);
        return allTransactions;
    }

    @Override
    public boolean requestBalance(String cardNo, long peridx) {
        this.reverseAllIncompleteRedemptions();
        return this.api.requestBalance(peridx);
    }

    @Override
    public boolean hasUncommittedRedemption() {
        for (TransactionState transaction : this.getAllTransactions()) {
            if (transaction.state != RedemptionState.REDEEMED) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRequestedRedemption() {
        for (TransactionState transaction : this.getAllTransactions()) {
            if (transaction.state != RedemptionState.REQUESTED) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCardNo(String cardNo) {
    }

    @Override
    public void setPerIdx(long perIdx) {
        this.perIdx = perIdx;
        this.rewardsTransaction.transaction.setPeridx(perIdx);
        for (TransactionState transaction : this.giftTransactions) {
            transaction.transaction.setPeridx(perIdx);
        }
    }

    @Override
    public void setRequestAmount(double amount) {
        this.rewardsTransaction.transaction.setAmount(amount);
        this.rewardsTransaction.state = amount > 0.0 ? RedemptionState.REQUESTED : RedemptionState.UNUSED;
        RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Requested %s", this.rewardsTransaction.getDescription()));
    }

    @Override
    public void setRequestGifts(Vector<StyleLine> gifts) {
        this.giftTransactions.clear();
        for (StyleLine line : gifts) {
            RetailRewardsDataTransaction transaction = new RetailRewardsDataTransaction();
            transaction.setPeridx(this.perIdx);
            transaction.setGiftLine(line);
            this.giftTransactions.add(new TransactionState(transaction, RedemptionState.REQUESTED));
        }
    }

    @Override
    public double getBalance() {
        return this.api.getBalance();
    }

    @Override
    public String getLastError() {
        return this.api.getLastError();
    }

    @Override
    public boolean redeem(User user) {
        boolean result = false;
        for (TransactionState transState : this.getAllTransactions()) {
            if (transState.state == RedemptionState.REDEEMED) {
                result = true;
                continue;
            }
            if (transState.state == RedemptionState.REQUESTED) {
                String requestId = UUID.randomUUID().toString();
                GiftSku giftSku = null;
                if (transState.transaction.getGift() != null) {
                    giftSku = new GiftSku(transState.transaction.getGift(), transState.transaction.getGiftSkuIdx());
                }
                if (this.api.requestRedeem(transState.transaction.getPeridx(), user.getMemidx(), requestId, transState.transaction.getAmount(), giftSku)) {
                    transState.transaction.saveRedemption(requestId, user.getMemidx());
                    transState.state = RedemptionState.REDEEMED;
                    RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Successfully redeemed %s", transState.getDescription()));
                    result = true;
                    continue;
                }
                RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Failed to redeem %s\nError: %s", transState.getDescription(), this.api.getLastError()));
                return false;
            }
            if (transState.state == RedemptionState.UNUSED) continue;
            return false;
        }
        return result;
    }

    @Override
    public boolean reverseTransaction() {
        boolean result = true;
        for (TransactionState transState : this.getAllTransactions()) {
            if (transState.transaction == null || transState.state != RedemptionState.REDEEMED) continue;
            if (this.api.requestReverse(transState.transaction.getPeridx(), transState.transaction.getRequestId())) {
                transState.transaction.reverseRedemption();
                transState.state = RedemptionState.CANCELED;
                RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Successfully reversed %s", transState.getDescription()));
                continue;
            }
            transState.transaction.logFailedReversal();
            RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Failed to reverse %s\nError: %s", transState.getDescription(), this.api.getLastError()));
            result = false;
        }
        return result;
    }

    @Override
    public boolean commitTransaction(long vhidx) {
        boolean result = true;
        for (TransactionState transState : this.getAllTransactions()) {
            if (transState == null || transState.state != RedemptionState.REDEEMED) continue;
            if (this.api.requestConfirm(transState.transaction.getPeridx(), transState.transaction.getRequestId()) && transState.transaction.finishRedemption(vhidx)) {
                transState.state = RedemptionState.COMPLETED;
                RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Confirmed %s, vhidx %s ", transState.getDescription(), vhidx));
                continue;
            }
            RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Failed to confirm %s\nError: %s", transState.getDescription(), this.api.getLastError()));
            result = false;
        }
        return result;
    }

    @Override
    public void reverseAllIncompleteRedemptions() {
        ArrayList<RetailRewardsDataTransaction> transactions = RetailRewardsDataTransaction.getAllTransactionsToReverse();
        for (RetailRewardsDataTransaction transaction : transactions) {
            if (this.api.requestReverse(transaction.getPeridx(), transaction.getRequestId())) {
                transaction.reverseRedemption();
                RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Successfully reversed %s rewards for peridx %s", transaction.getAmount(), transaction.getPeridx()));
                continue;
            }
            transaction.logFailedReversal();
            RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Failed to reverse %s rewards for peridx %s\nError: %s", transaction.getAmount(), transaction.getPeridx(), this.api.getLastError()));
        }
    }

    @Override
    public boolean loadAccount(long peridx) {
        return this.api.loadAccount(peridx);
    }

    @Override
    public long getAccountId() {
        return this.api.getAccountId();
    }

    @Override
    public boolean signUp(long peridx, long programId, User user) {
        return this.api.signUp(peridx, programId, user.getMemidx());
    }

    @Override
    public RewardsAccount getAccount() {
        return this.api.getAccount();
    }

    @Override
    public double getTierMinimumSpend() {
        return this.api.getCurrentTierMinimumSpend();
    }

    private class TransactionState {
        private RetailRewardsDataTransaction transaction;
        private RedemptionState state;

        private TransactionState(RetailRewardsDataTransaction transaction, RedemptionState state) {
            this.transaction = transaction;
            this.state = state;
        }

        private String getDescription() {
            if (this.transaction.getGift() != null) {
                return String.format("Rewards redemption of giftId %s (skuIdx = %s) for perIdx %s", this.transaction.getGift().getGiftId(), this.transaction.getGiftSkuIdx(), this.transaction.getPeridx());
            }
            return String.format("Rewards redemption of value %s for perIdx %s", this.transaction.getAmount(), this.transaction.getPeridx());
        }
    }

    private static enum RedemptionState {
        UNUSED,
        REQUESTED,
        REDEEMED,
        CANCELED,
        COMPLETED;

    }
}

