/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.sql.Connection;
import java.util.List;
import java.util.Vector;
import jpos.Currency;
import jpos.PosDateFormatter;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.coupons.Coupon;
import jpos.coupons.CouponManager;
import jpos.rewards.Gift;
import jpos.rewards.RewardsProgram;
import jpos.rewards.RewardsTier;
import org.jdom.Element;

public class RewardsAccount {
    private long accountId;
    private long peridx;
    private RewardsProgram rewardsProgram;
    private RewardsTier currentTier;
    private double currentRewardsBalance;
    private double pointsValue;
    private double pointsCap;
    private RewardsTier nextTier;
    private double nextTierQualifySpend;
    private double spendToNextTier;
    private double tierMinimumSpend;
    private double spendToRewardTotal;
    private double spendToNextReward;
    private AccountState accountState;
    private Vector<Gift> availableGifts;
    private Vector<Coupon> availableCoupons;
    private CouponManager couponManager = new CouponManager();

    public RewardsAccount() {
        this.reset();
    }

    private void reset() {
        this.accountId = 0L;
        this.peridx = 0L;
        this.rewardsProgram = new RewardsProgram(0L, "", SP.sParams.storeCurrency, false, false, false);
        this.currentTier = new RewardsTier(0L, "", false, 0.0);
        this.currentRewardsBalance = 0.0;
        this.nextTier = new RewardsTier(0L, "", false, 0.0);
        this.nextTierQualifySpend = 0.0;
        this.spendToNextTier = 0.0;
        this.tierMinimumSpend = 0.0;
        this.spendToRewardTotal = 0.0;
        this.spendToNextReward = 0.0;
        this.availableGifts = new Vector();
        this.availableCoupons = new Vector();
        this.accountState = AccountState.NO_ACCOUNT;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getPeridx() {
        return this.peridx;
    }

    public RewardsProgram getRewardsProgram() {
        return this.rewardsProgram;
    }

    public RewardsTier getCurrentTier() {
        return this.currentTier;
    }

    public double getCurrentRewardsBalance() {
        return this.currentRewardsBalance;
    }

    public AccountState getAccountState() {
        return this.accountState;
    }

    public double getNextTierQualifySpend() {
        return this.nextTierQualifySpend;
    }

    public double getSpendToNextTier() {
        return this.spendToNextTier;
    }

    public RewardsTier getNextTier() {
        return this.nextTier;
    }

    public double getSpendToRewardTotal() {
        return this.spendToRewardTotal;
    }

    public double getSpendToNextReward() {
        return this.spendToNextReward;
    }

    public Vector<Gift> getAvailableGifts() {
        return this.availableGifts;
    }

    public Vector<Coupon> getAvailableCoupons() {
        return this.availableCoupons;
    }

    public double getCurrentTierMinimumSpend() {
        return this.tierMinimumSpend;
    }

    public double getPointsValue() {
        return this.pointsValue;
    }

    public double getPointsCap() {
        return this.pointsCap;
    }

    public void loadFromXml(long peridx, Element rewards) {
        this.loadFromXml(peridx, rewards, SP.sParams.conn);
    }

    public void loadFromXml(long peridx, Element rewards, Connection conn) {
        this.reset();
        this.accountId = XMLUtils.getLongValue(rewards, "account_id");
        if (this.accountId > 0L) {
            this.peridx = peridx;
            Currency currency = SP.sParams.storeCurrency;
            String programCurrencyIdx = XMLUtils.getValue(rewards, "program_currency_id");
            if (!StringUtils.isNullOrEmpty(programCurrencyIdx) && !programCurrencyIdx.equals(currency.getIdx())) {
                currency = new Currency(conn, programCurrencyIdx);
            }
            this.rewardsProgram = new RewardsProgram(XMLUtils.getLongValue(rewards, "program_id"), XMLUtils.getValue(rewards, "program_name"), currency, XMLUtils.getBooleanValue(rewards, "program_prevent_prepop_amt_pos_flag"), XMLUtils.getBooleanValue(rewards, "program_reissue_rewards_on_return"), XMLUtils.getBooleanValue(rewards, "immediate_rewards"));
            this.currentTier = new RewardsTier(XMLUtils.getLongValue(rewards, "tier_id"), XMLUtils.getValue(rewards, "tier_name"), XMLUtils.getBooleanValue(rewards, "tier_accrual_on_full_price_only"), XMLUtils.getDoubleValue(rewards, "tier_min_spend_to_redeem"));
            this.currentRewardsBalance = XMLUtils.getDoubleValue(rewards, "rewards_balance");
            this.pointsValue = XMLUtils.getDoubleValue(rewards, "points_value");
            this.pointsCap = XMLUtils.getDoubleValue(rewards, "points_cap");
            this.nextTier = new RewardsTier(XMLUtils.getLongValue(rewards, "next_tier_id"), XMLUtils.getValue(rewards, "next_tier_name"), XMLUtils.getBooleanValue(rewards, "next_tier_accrual_on_full_price_only"), XMLUtils.getDoubleValue(rewards, "next_tier_minimum_spend"));
            this.spendToNextTier = XMLUtils.getDoubleValue(rewards, "spend_to_next_tier");
            this.nextTierQualifySpend = XMLUtils.getDoubleValue(rewards, "next_tier_qualify_spend");
            this.tierMinimumSpend = XMLUtils.getDoubleValue(rewards, "tier_min_spend_to_redeem");
            this.spendToRewardTotal = XMLUtils.getDoubleValue(rewards, "spend_to_reward_total");
            this.spendToNextReward = XMLUtils.getDoubleValue(rewards, "spend_to_next_reward");
            this.availableGifts = this.loadGiftsFromXml(rewards.getChild("gifts"));
            if (this.couponManager.requestGetCoupons(peridx)) {
                this.availableCoupons = this.couponManager.getCoupons();
            }
            this.accountState = AccountState.LOADED_ONLINE;
        } else if (peridx != 0L) {
            this.loadPendingOfflineSignUp(peridx);
        }
    }

    private Vector<Gift> loadGiftsFromXml(Element giftsXml) {
        Vector<Gift> data = new Vector<Gift>();
        if (giftsXml != null) {
            List giftList = giftsXml.getChildren("gift");
            for (int i = 0; i < giftList.size(); ++i) {
                Element giftElement = (Element)giftList.get(i);
                Gift g = new Gift();
                g.setGiftId(XMLUtils.getLongValue(giftElement, "gift_id"));
                g.setGiftIssueId(XMLUtils.getLongValue(giftElement, "gift_issue_id"));
                g.setName(XMLUtils.getValue(giftElement, "gift_name"));
                g.setDescription(XMLUtils.getValue(giftElement, "gift_description"));
                PosDateFormatter dateFormatter = new PosDateFormatter(null, 3, 3, 0);
                dateFormatter.setTimestampInternal(XMLUtils.getValue(giftElement, "expiry_date"));
                g.setExpiryDate(dateFormatter.getTimestamp());
                List styleList = giftElement.getChild("styles").getChildren("style");
                for (int j = 0; j < styleList.size(); ++j) {
                    g.getValidStyles().add(XMLUtils.getValue((Element)styleList.get(j), "style_id"));
                }
                data.add(g);
            }
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadOffline(long peridx) {
        this.reset();
        if (this.loadPendingOfflineSignUp(peridx)) {
            return true;
        }
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT A.ACCOUNT_IDX, P.PROGRAM_IDX, P.PROGRAM_NAME, P.REISSUE_REWARDS_ON_RETURN, T.TIER_IDX, T.TIER_NAME, T.MINIMUM_SPEND_TO_REDEEM FROM REWARDS_ACCOUNT A JOIN REWARDS_PROGRAM P ON A.PROGRAM_IDX = P.PROGRAM_IDX JOIN REWARDS_PROGRAM_TIER T ON A.TIER_IDX = T.TIER_IDX WHERE A.\"ACTIVE\" = 1 AND A.PERIDX = ? ORDER BY A.ACCOUNT_IDX", peridx);){
            if (!query.next()) return false;
            this.peridx = peridx;
            this.accountId = query.getLong("ACCOUNT_IDX");
            this.rewardsProgram = new RewardsProgram(query.getLong("PROGRAM_IDX"), query.getString("PROGRAM_NAME"), SP.sParams.storeCurrency, false, query.getBoolean("REISSUE_REWARDS_ON_RETURN"), false);
            this.currentTier = new RewardsTier(query.getLong("TIER_IDX"), query.getString("TIER_NAME"), false, query.getDouble("MINIMUM_SPEND_TO_REDEEM"));
            this.accountState = AccountState.LOADED_OFFLINE;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadPendingOfflineSignUp(long peridx) {
        try (SqlQuery queryPending = new SqlQuery(SP.sParams.conn, "SELECT P.PROGRAM_IDX, P.PROGRAM_NAME, P.REISSUE_REWARDS_ON_RETURN FROM REWARDS_PENDING_SIGN_UP A JOIN REWARDS_PROGRAM P ON A.PROGRAM_IDX = P.PROGRAM_IDX WHERE A.PERIDX = ? ", peridx);){
            if (!queryPending.next()) return false;
            this.peridx = peridx;
            this.accountId = 0L;
            this.rewardsProgram = new RewardsProgram(queryPending.getLong("PROGRAM_IDX"), queryPending.getString("PROGRAM_NAME"), SP.sParams.storeCurrency, false, queryPending.getBoolean("REISSUE_REWARDS_ON_RETURN"), false);
            this.accountState = AccountState.PENDING_OFFLINE;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    public boolean signUpOffline(long peridx, long programId, long staffId) {
        this.reset();
        try {
            int result = SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE REWARDS_PENDING_SIGN_UP SET PROGRAM_IDX = ?, WIDX = ?, MEMIDX = ? WHERE PERIDX = ?", programId, SP.sParams.getStoreIdx(), staffId, peridx);
            if (result == 0) {
                SqlQuery.executeUpdate(SP.sParams.conn, "INSERT INTO REWARDS_PENDING_SIGN_UP(PROGRAM_IDX, WIDX, MEMIDX, PERIDX) VALUES(?, ?, ?, ?)", programId, SP.sParams.getStoreIdx(), staffId, peridx);
            }
            SP.sParams.yTabInsert("REWARDS_PENDING_SIGN_UP", "PERIDX", String.valueOf(peridx));
            return this.loadPendingOfflineSignUp(peridx);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public void activateAccountLocally() {
        if (this.accountId == 0L || this.peridx == 0L) {
            return;
        }
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT 1 FROM REWARDS_ACCOUNT WHERE ACCOUNT_IDX = ?", this.accountId);){
            if (query.next()) {
                SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE REWARDS_ACCOUNT SET PERIDX = ?, TIER_IDX = ?, PROGRAM_IDX = ?, \"ACTIVE\" = 1 WHERE ACCOUNT_IDX = ?", this.peridx, this.currentTier.getId(), this.rewardsProgram.getId(), this.accountId);
            } else {
                SqlQuery.executeUpdate(SP.sParams.conn, "INSERT INTO REWARDS_ACCOUNT(ACCOUNT_IDX, PERIDX, TIER_IDX, PROGRAM_IDX, \"ACTIVE\") VALUES(?, ?, ?, ?, 1)", this.accountId, this.peridx, this.currentTier.getId(), this.rewardsProgram.getId());
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static enum AccountState {
        NO_ACCOUNT,
        LOADED_ONLINE,
        LOADED_OFFLINE,
        PENDING_OFFLINE;

    }
}

