/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.MLengthTextArea;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.XMLUtils;
import jpos.browser.ListWrapper;
import jpos.person.PersonContext;
import jpos.rewards.RewardsAccount;
import jpos.rewards.RewardsAdjustType;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelStrong;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class RewardsAdjustDlg
extends PosDialog {
    private RewardsAdjustType adjustType;
    private PersonContext currentPerson;
    private double maxReissueAmt = 0.0;
    private String parentIdx;
    private long memIdx;
    JPanel panel = new JPanel();
    GridBagLayout gridBagLayout = new GridBagLayout();
    DialogButton bAdjust = new DialogButton("");
    DialogButton bCancel = new DialogButton("");
    LabelStrong lPersonName = new LabelStrong();
    LabelNormal lRewardsName = new LabelNormal();
    LabelNormal lRewardsTier = new LabelNormal();
    LabelNormal lRewardsBalance = new LabelNormal();
    LabelStrong lReissueHeading = new LabelStrong();
    LabelNormal lAdjAmount = new LabelNormal();
    DecimalField dfAdjAmount;
    PosScrollPane scrollNotes = new PosScrollPane();
    MLengthTextArea adjNotes = new MLengthTextArea(250);
    LabelNormal lNotes = new LabelNormal();

    public RewardsAdjustDlg(PosFrame frame, String title, PersonContext person, RewardsAdjustType type, double maxReissueAmount, String parentTransIdx) {
        super(frame, title, true);
        try {
            this.adjustType = type;
            this.currentPerson = person;
            this.maxReissueAmt = maxReissueAmount;
            this.parentIdx = parentTransIdx;
            this.memIdx = frame.getUser().getMemidx();
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    public RewardsAdjustDlg(PosFrame frame, String title, PersonContext person, RewardsAdjustType type) {
        this(frame, title, person, type, 0.0, "");
    }

    void jbInit() throws Exception {
        this.panel.setLayout(this.gridBagLayout);
        this.bCancel.setText(SP.getRS("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RewardsAdjustDlg.this.cancelDialog();
            }
        });
        if (this.adjustType == RewardsAdjustType.REDEEM) {
            this.bAdjust.setText(SP.getRS("Redeem"));
        } else {
            this.bAdjust.setText(SP.getRS("Reissue"));
        }
        this.bAdjust.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RewardsAdjustDlg.this.okDialog();
            }
        });
        if (this.adjustType == RewardsAdjustType.REDEEM) {
            this.lPersonName.setText(this.currentPerson.firstName + ' ' + this.currentPerson.surname);
            this.lRewardsName.setText(this.currentPerson.rewardsProgramName);
            this.lRewardsTier.setText(MessageFormat.format(SP.getRS("Rewards_Tier"), this.currentPerson.rewardsTierName));
            this.lRewardsBalance.setText(MessageFormat.format(SP.getRS("Rewards_Balance_Long"), this.currentPerson.formatRewardAmount(this.currentPerson.rewardsBalance)));
        } else {
            this.lReissueHeading.setText(SP.getRS("Reissue_Rewards"));
        }
        if (this.adjustType == RewardsAdjustType.REDEEM) {
            this.lAdjAmount.setText(SP.getRS("Rewards_Redemption_Amount"));
        } else {
            this.lAdjAmount.setText(MessageFormat.format(SP.getRS("Reissue_Enter_Amount_Upto"), this.currentPerson.formatRewardAmount(this.maxReissueAmt)));
        }
        this.dfAdjAmount = new DecimalField(this.currentPerson.getRewardsCurrency());
        this.dfAdjAmount.setFieldWidth(180);
        this.dfAdjAmount.setText("0");
        this.lNotes.setText(StoreParams.res.getString("Notes"));
        this.scrollNotes.setHorizontalScrollBarPolicy(31);
        this.scrollNotes.setMinimumSize(new Dimension(300, 100));
        this.scrollNotes.setPreferredSize(new Dimension(300, 100));
        this.getContentPane().add(this.panel);
        this.scrollNotes.getViewport().add((Component)this.adjNotes, null);
        if (this.adjustType == RewardsAdjustType.REDEEM) {
            this.panel.add((Component)this.lPersonName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(15, 20, 0, 0), 0, 0));
            this.panel.add((Component)this.lRewardsName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.panel.add((Component)this.lRewardsTier, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.panel.add((Component)this.lRewardsBalance, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 16, 0, new Insets(15, 20, 0, 0), 0, 0));
        } else {
            this.panel.add((Component)this.lReissueHeading, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 16, 0, new Insets(15, 20, 0, 0), 0, 0));
        }
        this.panel.add((Component)this.lAdjAmount, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 16, 0, new Insets(25, 20, 0, 0), 0, 0));
        this.panel.add((Component)this.dfAdjAmount, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.panel.add((Component)this.lNotes, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 16, 0, new Insets(15, 20, 0, 0), 0, 0));
        this.panel.add((Component)this.scrollNotes, new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 20, 0, 20), 0, 0));
        this.panel.add((Component)this.bCancel, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 13, 0, new Insets(40, 80, 15, 2), 0, 0));
        this.panel.add((Component)this.bAdjust, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 17, 0, new Insets(40, 2, 15, 80), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfAdjAmount);
        v.add(this.adjNotes);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RewardsAdjustDlg.this.dfAdjAmount.requestFocus();
            }
        });
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    private boolean validateAdjustment(RewardsAdjustType type) {
        double amount = this.dfAdjAmount.getDouble();
        if (amount <= 0.0) {
            DlgMessage.showMessage(this, SP.getRS("Rewards_Adjust_Greater_Than_Zero"), SP.getRS("Stop"), 0);
            this.dfAdjAmount.setText(0.0);
            return false;
        }
        if (type == RewardsAdjustType.REISSUE && amount > this.maxReissueAmt) {
            String message = MessageFormat.format(SP.getRS("Rewards_Reissue_Cannot_Exceed_Max"), this.currentPerson.formatRewardAmount(this.maxReissueAmt));
            DlgMessage.showMessage(this, message, SP.getRS("Stop"), 0);
            return false;
        }
        if (type == RewardsAdjustType.REDEEM && amount > this.currentPerson.rewardsBalance) {
            String message = MessageFormat.format(SP.getRS("Rewards_Redeem_Cannot_Exceed_Balance"), this.currentPerson.formatRewardAmount(this.currentPerson.rewardsBalance));
            DlgMessage.showMessage(this, message, SP.getRS("Stop"), 0);
            return false;
        }
        if (StringUtils.isNullOrEmpty(this.adjNotes.getText())) {
            String message = SP.getRS("Rewards_Adjust_Enter_Notes");
            DlgMessage.showMessage(this, message, SP.getRS("Stop"), 0);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void okDialog() {
        block13: {
            if (!this.validateAdjustment(this.adjustType)) {
                return;
            }
            try {
                String message;
                this.setCursor(StoreParams.waitCursor);
                Element payload = new Element("rewards_transaction");
                payload.setAttribute("widx", String.valueOf(SP.sParams.getStoreIdx()));
                payload.setAttribute("memidx", String.valueOf(this.memIdx));
                payload.setAttribute("account_idx", this.currentPerson.rewardsAccountIdx);
                double amount = this.dfAdjAmount.getDouble();
                if (this.adjustType == RewardsAdjustType.REDEEM) {
                    amount *= -1.0;
                }
                payload.setAttribute("amount", String.valueOf(amount));
                if (this.adjustType == RewardsAdjustType.REISSUE) {
                    payload.setAttribute("parent_idx", this.parentIdx);
                }
                String description = "";
                if (this.adjNotes != null) {
                    description = this.adjNotes.getText();
                }
                payload.setAttribute("description", description);
                XMLOutputter printer = new XMLOutputter();
                Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("rewards_manual", printer.outputString(payload)).getXML();
                if (result != null && XMLUtils.getBooleanValue(result, "result")) {
                    Element rewards;
                    boolean showHistory = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.DISPLAY_POS_PERSON_SPENDING);
                    if (showHistory) {
                        PersonContext.updateContextFromHistoryXml(result, this.currentPerson);
                        PersonContext.updateContextFromTransactionsXml(result, this.currentPerson);
                    }
                    if ((rewards = result.getChild("rewards_account")) != null) {
                        RewardsAccount rewardsAccount = new RewardsAccount();
                        rewardsAccount.loadFromXml(XMLUtils.getLongValue(result, "peridx"), rewards);
                        PersonContext.updateContextFromRewardsAccount(rewardsAccount, this.currentPerson);
                        Element redemptionHistory = rewards.getChild("redemption_history");
                        if (redemptionHistory != null) {
                            this.currentPerson.rewardRedemptionTransactions = new ListWrapper(new ArrayList());
                            PersonContext.updateContextFromRedemptionHistoryXml(redemptionHistory, this.currentPerson);
                        }
                    }
                    break block13;
                }
                String string = message = result != null ? XMLUtils.getValue(result, "message") : SP.getRS("No_Response");
                if (this.adjustType == RewardsAdjustType.REDEEM) {
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Redeem_Rewards_Failed"), message), SP.getRS("Error"), 0);
                } else {
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Reissue_Rewards_Failed"), message), SP.getRS("Error"), 0);
                }
                return;
            }
            finally {
                this.setCursor(StoreParams.normalCursor);
            }
        }
        this.dispose();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

