/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jpos.DecimalField;
import jpos.DlgManualLoyaltyDiscount;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.LoyaltyRedemptionPanel;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.XMLUtils;
import jpos.person.PersonUtils;
import jpos.rewards.RewardsAccount;
import jpos.rewards.RewardsProgressBar;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelStrong;
import jpos.ui.LabelSubHeadingStrong;

public class RewardsRedemptionPanel
extends LoyaltyRedemptionPanel {
    private LabelNormal labelImage = new LabelNormal();
    private LabelSubHeadingStrong labelPerson = new LabelSubHeadingStrong();
    private LabelNormal labelProgram = new LabelNormal("");
    private LabelNormal labelTier = new LabelNormal("");
    private LabelNormal labelTierMinimumSpend = new LabelNormal("");
    private LabelNormal labelRewardsBalance = new LabelNormal("");
    private LabelNormal labelTransactionValue = new LabelNormal("");
    private LabelNormal labelBelowMinimumSpendWarning = new LabelNormal("");
    private LabelNormal labelPointsCappedWarning = new LabelNormal("");
    RewardsProgressBar progressNextTier = new RewardsProgressBar(RewardsProgressBar.DisplayType.NEXT_TIER);
    RewardsProgressBar progressNextReward = new RewardsProgressBar(RewardsProgressBar.DisplayType.NEXT_REWARD);
    private LabelStrong labelRedeemAmountTitle = new LabelStrong();
    private DecimalField dfRedeemAmount;
    private DialogButton bOK;
    private DialogButton bCancel;
    private double availableRewards;
    private RewardsAccount rewardsAccount;
    private DlgManualLoyaltyDiscount parentDlg;

    public RewardsRedemptionPanel(DlgManualLoyaltyDiscount parentDlg) {
        super(parentDlg);
        this.dfRedeemAmount = new DecimalField(SP.sParams.storeCurrency);
        this.bOK = new DialogButton("");
        this.bCancel = new DialogButton("");
        this.availableRewards = 0.0;
        this.parentDlg = parentDlg;
        try {
            this.init();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void init() {
        this.setBackground(Color.WHITE);
        this.progressNextTier.setBackground(Color.WHITE);
        this.progressNextReward.setBackground(Color.WHITE);
        this.progressNextTier.setPreferredSize(new Dimension(132, 132));
        this.progressNextReward.setPreferredSize(new Dimension(132, 132));
        this.labelImage.setIcon(new ImageIcon(SP.sParams.imagepath + "RewardsIcon.png"));
        this.labelImage.setHorizontalAlignment(0);
        this.labelProgram.setMaxWidth(400);
        this.labelTier.setMaxWidth(400);
        this.labelPointsCappedWarning.setHorizontalAlignment(0);
        this.labelPointsCappedWarning.setForeground(Color.decode("#92740C"));
        this.labelRedeemAmountTitle.setText(SP.getRS("Rewards_Redeem_Amount"));
        this.labelBelowMinimumSpendWarning.setLabelWidth(320);
        this.dfRedeemAmount.setFieldWidth(320);
        this.dfRedeemAmount.setText("0");
        this.labelBelowMinimumSpendWarning.setHorizontalAlignment(0);
        this.labelBelowMinimumSpendWarning.setForeground(Color.decode("#92740C"));
        this.bOK.setText(SP.getRS("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RewardsRedemptionPanel.this.getParentDlg().okDialog();
            }
        });
        this.bCancel.setText(SP.getRS("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RewardsRedemptionPanel.this.getParentDlg().cancelDialog();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.labelImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 5, 10), 0, 0));
        this.add((Component)this.labelPerson, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.labelProgram, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.labelTier, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.labelTierMinimumSpend, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.labelPointsCappedWarning, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.labelTransactionValue, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.labelRewardsBalance, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 5, 10), 0, 0));
        JPanel progressPanel = new JPanel(new GridBagLayout());
        progressPanel.setBackground(Color.WHITE);
        progressPanel.add((Component)this.progressNextTier, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        progressPanel.add((Component)this.progressNextReward, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)progressPanel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.labelRedeemAmountTitle, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 2, 10), 0, 0));
        this.add((Component)this.dfRedeemAmount, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 50, 5, 50), 0, 0));
        this.add((Component)this.labelBelowMinimumSpendWarning, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBackground(Color.WHITE);
        buttonPanel.add((Component)this.bOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 32, 5), 0, 0));
        buttonPanel.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 32, 10), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfRedeemAmount);
        v.add(this.bOK);
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    @Override
    public double getAmount() {
        return this.dfRedeemAmount.getDouble();
    }

    @Override
    public void load() {
        this.availableRewards = 0.0;
        this.rewardsAccount = null;
        boolean preventPrepopAmtFlag = false;
        try {
            if (this.parentDlg.frParent instanceof FrSales) {
                FrSales sales = (FrSales)this.parentDlg.frParent;
                if (sales.rewardsApiManager.loadAccount(XMLUtils.getLongValue(sales.getPerson(), "peridx"))) {
                    this.rewardsAccount = sales.rewardsApiManager.getAccount();
                    this.availableRewards = this.rewardsAccount.getCurrentRewardsBalance();
                    preventPrepopAmtFlag = this.rewardsAccount.getRewardsProgram().getPreventPrepopAmtFlag();
                } else {
                    DlgMessage.showMessage(this.getParentDlg(), sales.rewardsApiManager.getLastError(), SP.getRS("Error"), 0);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        if (!preventPrepopAmtFlag) {
            this.dfRedeemAmount.setText(Math.min(this.availableRewards, this.getTransactionTotal()));
        }
        this.getParentDlg().setTitle(SP.getRS("Rewards_Redemption"));
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.labelPerson.setText(PersonUtils.getPerName(this.getPerson()));
        if (this.rewardsAccount != null) {
            this.labelProgram.setText(this.rewardsAccount.getRewardsProgram().toString());
            this.labelTier.setText(MessageFormat.format(SP.getRS("Rewards_Tier"), this.rewardsAccount.getCurrentTier().toString()));
            if (this.rewardsAccount.getCurrentTierMinimumSpend() > 0.0) {
                this.labelTierMinimumSpend.setText(MessageFormat.format(SP.getRS("Tier_Minimum_Spend"), SP.sParams.storeCurrency.prependSymbol(PosDouble.valueOf(this.rewardsAccount.getCurrentTierMinimumSpend()).toString())));
            } else {
                this.labelTierMinimumSpend.setText("");
            }
            if (this.getTransactionTotal() >= this.rewardsAccount.getCurrentTierMinimumSpend()) {
                this.dfRedeemAmount.setEnabled(true);
                this.dfRedeemAmount.setText(Math.min(this.availableRewards, this.getTransactionTotal()));
                this.labelBelowMinimumSpendWarning.setText("");
            } else {
                this.dfRedeemAmount.setEditable(false);
                this.dfRedeemAmount.setText(0.0);
                if (this.rewardsAccount.getCurrentRewardsBalance() > 0.0) {
                    this.labelBelowMinimumSpendWarning.setText(SP.getRS("Below_Tier_Minimum_Spend_Warning"));
                }
            }
            this.labelPointsCappedWarning.setText(this.pointsCapped() ? SP.getRS("Points_Capped_Warning") : "");
            this.progressNextTier.setVisible(this.progressNextTier.updateProgressBar(this.rewardsAccount, this.getAccrueSpendTotal(), this.pointsCapped()));
            this.progressNextReward.setVisible(this.progressNextReward.updateProgressBar(this.rewardsAccount, this.getAccrueSpendTotal(), this.pointsCapped()));
        }
        this.labelTransactionValue.setText(MessageFormat.format(SP.getRS("Rewards_Current_Transaction"), SP.sParams.storeCurrency.prependSymbol(PosDouble.valueOf(this.getTransactionTotal()).toString())));
        this.labelRewardsBalance.setText(MessageFormat.format(SP.getRS("Rewards_Balance_Long"), SP.sParams.storeCurrency.prependSymbol(PosDouble.valueOf(this.availableRewards).toString())));
    }

    @Override
    public boolean validateInputs() {
        if (this.dfRedeemAmount.getDouble() < 0.0) {
            this.dfRedeemAmount.setText(0.0);
        }
        if (this.getAmount() > this.availableRewards) {
            DlgMessage.showMessage(this.getParentDlg(), SP.getRS("Redemption_exceeds_available_rewards"), SP.getRS("Invalid_Redemption_Amount"), 0);
            return false;
        }
        if (this.getAmount() > this.getTransactionTotal()) {
            DlgMessage.showMessage(this.getParentDlg(), SP.getRS("Redemption_exceeds_transaction_total"), SP.getRS("Invalid_Redemption_Amount"), 0);
            return false;
        }
        return true;
    }

    public boolean pointsCapped() {
        return this.rewardsAccount.getPointsCap() > 0.0 && this.rewardsAccount.getPointsValue() >= this.rewardsAccount.getPointsCap();
    }
}

