/*
 * Decompiled with CFR 0.152.
 */
package jpos.searchfields;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.SwingUtilities;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.searchfields.BarcodeSearchField;
import jpos.searchfields.ClrSearchField;
import jpos.searchfields.SearchPanel;
import jpos.searchfields.SizeSearchField;
import jpos.ui.TouchTextField;

public abstract class ProductClrSizeSearch {
    private boolean searching = false;
    private SizeSearchField sizeSearchField;
    private ClrSearchField clrSearchField;
    private BarcodeSearchField barcodeSearchField;
    private SearchPanel barcodeSearchPanel;
    private TouchTextField.FontSize fontSize;
    private Window parent;

    public abstract boolean processSku(long var1, String var3);

    /*
     * Exception decompiling
     */
    public boolean processBarcodeScan(String barcode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BarcodeSearchField getBarcodeSearchField() {
        return this.barcodeSearchField;
    }

    public ClrSearchField getClrSearchField() {
        return this.clrSearchField;
    }

    public SizeSearchField getSizeSearchField() {
        return this.sizeSearchField;
    }

    public SearchPanel getSearchPanel() {
        return this.barcodeSearchPanel;
    }

    public ProductClrSizeSearch(Window parent, TouchTextField.FontSize fontSize) {
        this.fontSize = fontSize;
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.barcodeSearchField = new BarcodeSearchField(this.fontSize){

            @Override
            public void actionSearch() {
                ProductClrSizeSearch.this.searching = true;
                if (this.getText().equals(StoreParams.invalidBarcode)) {
                    this.clear();
                }
                super.actionSearch();
                this.requestFocus();
                this.selectAll();
            }

            @Override
            public void actionValidate() {
                block56: {
                    if (!ProductClrSizeSearch.this.searching) {
                        return;
                    }
                    ProductClrSizeSearch.this.searching = false;
                    if (!this.getText().equals(StoreParams.invalidBarcode)) {
                        super.actionValidate();
                        try (PreparedStatement stmtClr = SP.sParams.conn.prepareStatement("SELECT C.CLRIDX, C.CLRNAME FROM CLR C WHERE C.STYLEIDX =?");){
                            stmtClr.setLong(1, this.getidx());
                            try (ResultSet resultClr = stmtClr.executeQuery();){
                                if (!resultClr.next()) break block56;
                                long clridx = resultClr.getLong(1);
                                String clrname = resultClr.getString(2);
                                if (resultClr.next()) {
                                    ProductClrSizeSearch.this.clrSearchField.search(this.getidx(), this.getText());
                                    break block56;
                                }
                                try (PreparedStatement stmtSku = SP.sParams.conn.prepareStatement("SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = ?");){
                                    stmtSku.setLong(1, clridx);
                                    try (ResultSet resultSku = stmtSku.executeQuery();){
                                        if (resultSku.next()) {
                                            final long skuidx = resultSku.getLong(1);
                                            final String defaultBarcode = resultSku.getString(2);
                                            if (resultSku.next()) {
                                                ProductClrSizeSearch.this.sizeSearchField.search(clridx, this.getText(), clrname);
                                            } else {
                                                this.setText(defaultBarcode);
                                                SwingUtilities.invokeLater(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        if (!ProductClrSizeSearch.this.processSku(skuidx, defaultBarcode)) {
                                                            this.setText(StoreParams.invalidBarcode);
                                                            this.selectAll();
                                                        } else {
                                                            this.clear();
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            PosUtils.logError(e);
                        }
                    }
                }
            }
        };
        this.barcodeSearchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ProductClrSizeSearch.this.barcodeSearchField.selectAll();
            }
        });
        this.barcodeSearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ProductClrSizeSearch.this.processBarcodeScan(ProductClrSizeSearch.this.barcodeSearchField.getText())) {
                    ProductClrSizeSearch.this.barcodeSearchField.setText(StoreParams.invalidBarcode);
                    ProductClrSizeSearch.this.barcodeSearchField.selectAll();
                } else {
                    ProductClrSizeSearch.this.barcodeSearchField.clear();
                }
            }
        });
        this.sizeSearchField = new SizeSearchField(){

            @Override
            public void actionValidate() {
                super.actionValidate();
                String tempDefaultBarcode = "";
                long tempSkuidx = 0L;
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.SKUIDX = ?");){
                    stmt.setLong(1, this.getidx());
                    try (ResultSet result = stmt.executeQuery();){
                        if (result.next()) {
                            tempDefaultBarcode = result.getString(1);
                            tempSkuidx = this.getidx();
                        }
                    }
                }
                catch (SQLException e) {
                    PosUtils.logError(e);
                }
                final long skuidx = tempSkuidx;
                final String defaultBarcode = tempDefaultBarcode;
                ProductClrSizeSearch.this.barcodeSearchField.setText(tempDefaultBarcode);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!ProductClrSizeSearch.this.processSku(skuidx, defaultBarcode)) {
                            ProductClrSizeSearch.this.barcodeSearchField.setText(StoreParams.invalidBarcode);
                            ProductClrSizeSearch.this.barcodeSearchField.selectAll();
                        } else {
                            ProductClrSizeSearch.this.barcodeSearchField.clear();
                        }
                    }
                });
            }
        };
        this.clrSearchField = new ClrSearchField(){

            @Override
            public void actionValidate() {
                super.actionValidate();
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = ?");){
                    stmt.setLong(1, this.getidx());
                    try (ResultSet result = stmt.executeQuery();){
                        if (result.next()) {
                            final long skuidx = result.getLong(1);
                            final String defaultBarcode = result.getString(2);
                            if (result.next()) {
                                ProductClrSizeSearch.this.sizeSearchField.search(this.getidx(), ProductClrSizeSearch.this.barcodeSearchField.getText(), this.getText());
                            } else {
                                ProductClrSizeSearch.this.barcodeSearchField.setText(defaultBarcode);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!ProductClrSizeSearch.this.processSku(skuidx, defaultBarcode)) {
                                            ProductClrSizeSearch.this.barcodeSearchField.setText(StoreParams.invalidBarcode);
                                            ProductClrSizeSearch.this.barcodeSearchField.selectAll();
                                        } else {
                                            ProductClrSizeSearch.this.barcodeSearchField.clear();
                                        }
                                    }
                                });
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    PosUtils.logError(e);
                }
            }
        };
        this.barcodeSearchPanel = new SearchPanel(this.barcodeSearchField);
        this.clrSearchField.setVisible(false);
        this.sizeSearchField.setVisible(false);
        this.parent.add(this.clrSearchField);
        this.parent.add(this.sizeSearchField);
    }

    public boolean hasValue() {
        return !StringUtils.isNullOrEmpty(this.barcodeSearchField.getText()) && !this.barcodeSearchField.getText().equals(StoreParams.invalidBarcode);
    }
}

