/*
 * Decompiled with CFR 0.152.
 */
package jpos.stockreceipt;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jpos.stockreceipt.DateOnlyXmlAdapter;
import jpos.stockreceipt.StockTransaction;
import jpos.stockreceipt.TransactionItem;

@XmlRootElement(name="NonASNTransaction")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NonASNTransaction
extends StockTransaction {
    @XmlElement(name="ConNote")
    String conNote;
    @XmlElement(name="DelIns")
    String delIns;
    @XmlElement(name="ShipDate")
    @XmlJavaTypeAdapter(value=DateOnlyXmlAdapter.class)
    Date shipDate;
    @XmlElement(name="LastReceivedTime")
    Date lastReceivedTime;
    @XmlElement(name="Carrier")
    String carrier;
    @XmlElementWrapper(name="Items")
    @XmlElement(name="TransactionItem")
    List<TransactionItem> items;

    public List<TransactionItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<TransactionItem>();
        }
        return this.items;
    }

    public void setItems(List<TransactionItem> items) {
        this.items = items;
    }

    public String GetConNote() {
        return this.conNote;
    }

    public void setConNote(String conNote) {
        this.conNote = conNote;
    }

    public Date GetShipDate() {
        return this.shipDate;
    }

    public void setShipDate(Date shipDate) {
        this.shipDate = shipDate;
    }

    public Date getLastReceivedTime() {
        return this.lastReceivedTime;
    }

    public void setLastReceivedTime(Date lastReceivedTime) {
        this.lastReceivedTime = lastReceivedTime;
    }

    public double getTotalQty() {
        double total = 0.0;
        for (TransactionItem item : this.items) {
            total += item.qty;
        }
        return total;
    }

    public String getDelIns() {
        return this.delIns;
    }

    public void setDelIns(String delIns) {
        this.delIns = delIns;
    }

    public void setReceivedQty(String barcode, long skuIdx, double qty) {
        for (TransactionItem item : this.items) {
            if (!item.barcode.equals(barcode)) continue;
            item.currReceivedQty = qty;
            return;
        }
        TransactionItem item = new TransactionItem();
        item.skuidx = skuIdx;
        item.barcode = barcode;
        item.currReceivedQty = qty;
        item.qty = 0.0;
        item.prevReceivedQty = 0.0;
        this.items.add(item);
    }

    public static NonASNTransaction createTransactionFromXmlString(String tran) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{NonASNTransaction.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        StringReader reader = new StringReader(tran);
        return (NonASNTransaction)unmarshaller.unmarshal((Reader)reader);
    }

    public static String serialise(NonASNTransaction tran) throws Exception {
        StringWriter sw = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{NonASNTransaction.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)tran, (Writer)sw);
        return sw.toString();
    }

    public double getOvers() {
        double overs = 0.0;
        for (TransactionItem ti : this.items) {
            if (!(ti.getCurrReceivedQty() > 0.0) || !(ti.getQty() < ti.getCurrReceivedQty() + ti.getPrevReceivedQty())) continue;
            overs += ti.getCurrReceivedQty() + ti.getPrevReceivedQty() - ti.getQty();
        }
        return overs;
    }

    public double getUnders() {
        double unders = 0.0;
        for (TransactionItem ti : this.items) {
            if (!(ti.getQty() > ti.getCurrReceivedQty() + ti.getPrevReceivedQty())) continue;
            unders += ti.getQty() - (ti.getCurrReceivedQty() + ti.getPrevReceivedQty());
        }
        return unders;
    }
}

