/*
 * Decompiled with CFR 0.152.
 */
package jpos.taxlookup;

import jpos.Location;
import jpos.SP;
import jpos.SqlQuery;
import jpos.SystemSettings;
import jpos.basscom.utils.Utils;

public class AvaTaxSettings {
    private String account;
    private String license;
    private String remoteUrl;
    private String companyCode;
    private String appName = "Apparel21 POS";
    private String appVersion = "a0o40000003jMCDAA2";
    private String machineName;
    private Location storeLocation = null;

    public AvaTaxSettings() {
        this.loadSettings();
        this.machineName = SP.sParams.tillnum;
    }

    private void loadSettings() {
        this.storeLocation = new Location(SP.sParams.getStore(SP.sParams.getStoreIdx()).getLocnidx());
        String avaTaxSql = "";
        try (SqlQuery sqlComp = new SqlQuery(SP.sParams.conn, "SELECT 'REF' || RG_ORD FROM REFTBL WHERE TBLIDX = 18 AND RGIDX = 22");){
            if (sqlComp.next()) {
                String refColName = sqlComp.getString(1);
                avaTaxSql = "SELECT A.COMPANY_CODE, A.ACCOUNT_NUM, A.LICENSE_KEY, A.REMOTE_URL FROM AVATAX_SETTINGS A, WHSE W, STOREPARAMS S WHERE W.STORENO = S.STORENO AND W." + refColName + " = A.COMPANYIDX";
            } else {
                avaTaxSql = "SELECT A.COMPANY_CODE, A.ACCOUNT_NUM, A.LICENSE_KEY, A.REMOTE_URL FROM AVATAX_SETTINGS A WHERE A.COMPANYIDX = " + SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.DEFAULT_COMPANY) + " ORDER BY A.COMPANYIDX";
            }
            try (SqlQuery sqlSettings = new SqlQuery(SP.sParams.conn, avaTaxSql);){
                if (sqlSettings.next()) {
                    this.companyCode = sqlSettings.getString(1);
                    this.account = sqlSettings.getString(2);
                    this.license = sqlSettings.getString(3);
                    this.remoteUrl = sqlSettings.getString(4);
                }
            }
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public String getAccount() {
        return this.account;
    }

    public String getLicense() {
        return this.license;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public String getCompanyCode() {
        return this.companyCode;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public Location getStoreLocation() {
        return this.storeLocation;
    }
}

