/*
 * Decompiled with CFR 0.152.
 */
package jpos.tillbalance;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import jpos.DecimalField;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.tillbalance.Denomination;
import jpos.tillbalance.TenDets;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class DlgTillBalanceCount
extends PosDialog {
    private boolean bEditable = false;
    private boolean bShowingVariances = false;
    private static final String sDENOMINATION = SP.getRS("Denomination");
    private static final String sCOUNT = SP.getRS("Count");
    private static final String sAMOUNT = SP.getRS("Amount");
    private TenDets tenDetOrig;
    private TenDets tenDetCopy;
    private StringBuffer sbOkPressed;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private PosScrollPane scrollPane = new PosScrollPane();
    private PosTable tblCount;
    private AbstractTableModel tableModel;
    private LabelSubHeading lTotal = new LabelSubHeading();
    private LabelSubHeading lExpected = new LabelSubHeading();
    private LabelSubHeading lVariance = new LabelSubHeading();
    private DecimalField dfTotal;
    private DecimalField dfExpected;
    private DecimalField dfVariance;
    private DialogButton bOK;
    private DialogButton bCancel;
    private DialogButton bAdd;

    public DlgTillBalanceCount(PosFrame frame, String title, boolean modal, String message, TenDets pTenDet, boolean pbEditable, boolean pbShowingVariances, StringBuffer psbOkPressed) {
        super(frame, MessageFormat.format(SP.getRS("tender_count_title"), pTenDet.payType.code), modal);
        this.dfTotal = new DecimalField(this.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.dfExpected = new DecimalField(this.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.dfVariance = new DecimalField(this.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.bOK = new DialogButton("");
        this.bCancel = new DialogButton("");
        this.bAdd = new DialogButton("");
        this.frParent = frame;
        this.sParams = this.frParent.sParams;
        this.bEditable = pbEditable;
        this.bShowingVariances = pbShowingVariances;
        this.tenDetCopy = pTenDet.copy();
        this.tenDetOrig = pTenDet;
        this.sbOkPressed = psbOkPressed;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.tableModel = this.tenDetCopy.payType.isCash ? new CashTableModel() : new OtherTableModel();
        this.tblCount = new PosTable(this, this.tableModel);
        this.tblInit();
        this.lTotal.setHorizontalAlignment(2);
        this.lTotal.setText(SP.getRS("Total"));
        this.lExpected.setHorizontalAlignment(2);
        this.lExpected.setText(SP.getRS("Expected"));
        this.lVariance.setHorizontalAlignment(2);
        this.lVariance.setText(SP.getRS("Variance"));
        this.dfTotal.setEnabled(false);
        this.dfTotal.setFieldWidth(110);
        this.dfExpected.setEnabled(false);
        this.dfExpected.setFieldWidth(110);
        this.dfVariance.setEnabled(false);
        this.dfVariance.setFieldWidth(110);
        this.bAdd.setText(StoreParams.res.getString("Add_Line"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTillBalanceCount.this.addLine();
            }
        });
        this.bAdd.setEnabled(this.bEditable);
        this.bOK.setText(StoreParams.res.getString("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTillBalanceCount.this.okDialog();
            }
        });
        this.bOK.setEnabled(this.bEditable);
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTillBalanceCount.this.cancelDialog();
            }
        });
        this.scrollPane.setMinimumSize(new Dimension(400, 482));
        this.scrollPane.setPreferredSize(new Dimension(400, 482));
        this.setLayout(this.gridBagLayout);
        this.scrollPane.getViewport().add((Component)this.tblCount, null);
        this.getContentPane().add((Component)this.scrollPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 2.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.tenDetCopy.payType.isCash) {
            this.getContentPane().add((Component)this.bAdd, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        }
        this.getContentPane().add((Component)this.dfTotal, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.lTotal, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        if (this.bShowingVariances) {
            this.getContentPane().add((Component)this.dfExpected, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.dfVariance, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.lExpected, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.lVariance, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        }
        this.getContentPane().add((Component)this.bOK, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.bCancel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tblCount);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
        this.populate();
    }

    private void tblInit() {
        this.tblCount.setSelectionMode(0);
        if (this.tenDetCopy.payType.isCash) {
            this.tblCount.getColumnModel().getColumn(0).setPreferredWidth(200);
            this.tblCount.getColumnModel().getColumn(0).setMinWidth(95);
            this.tblCount.getColumnModel().getColumn(0).setMaxWidth(700);
            this.tblCount.getColumnModel().getColumn(1).setPreferredWidth(200);
            this.tblCount.getColumnModel().getColumn(1).setMinWidth(95);
            this.tblCount.getColumnModel().getColumn(1).setMaxWidth(700);
            this.tblCount.getColumnModel().getColumn(0).setHeaderRenderer(this.tblCount.headerRightRen);
            this.tblCount.getColumnModel().getColumn(1).setHeaderRenderer(this.tblCount.headerRightRen);
            this.tblCount.renderer.setColumnFormat(0, null, 4);
            this.tblCount.renderer.setColumnFormat(1, StoreParams.qtyFormat, 4);
            ((DecimalField)this.tblCount.qtyEd.getComponent()).setHorizontalAlignment(4);
            this.tblCount.getColumnModel().getColumn(1).setCellEditor(this.tblCount.qtyEd);
        } else {
            this.tblCount.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.tblCount.getColumnModel().getColumn(0).setMinWidth(20);
            this.tblCount.getColumnModel().getColumn(0).setMaxWidth(50);
            this.tblCount.getColumnModel().getColumn(1).setPreferredWidth(200);
            this.tblCount.getColumnModel().getColumn(1).setMinWidth(95);
            this.tblCount.getColumnModel().getColumn(1).setMaxWidth(700);
            this.tblCount.getColumnModel().getColumn(0).setHeaderRenderer(this.tblCount.headerLeftRen);
            this.tblCount.getColumnModel().getColumn(1).setHeaderRenderer(this.tblCount.headerRightRen);
            this.tblCount.renderer.setColumnFormat(0, StoreParams.qtyFormat, 4);
            this.tblCount.renderer.setColumnFormat(1, this.sParams.currFormat, 4);
            this.tblCount.getColumnModel().getColumn(1).setCellEditor(this.tblCount.currEd);
            this.tblCount.currEd.getComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int nRow;
                    if (e.getKeyCode() == 40 && (nRow = DlgTillBalanceCount.this.tblCount.getSelectedRow()) > -1 && nRow == DlgTillBalanceCount.this.tblCount.getRowCount() - 1) {
                        DlgTillBalanceCount.this.addLine();
                    }
                }
            });
        }
        this.tblCount.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DlgTillBalanceCount.this.setTotals();
            }
        });
    }

    private void addLine() {
        ((OtherTableModel)this.tableModel).data.add(new PosDouble(0.0));
        ((OtherTableModel)this.tableModel).fireTableRowsInserted(this.tblCount.getRowCount() - 1, this.tblCount.getRowCount() - 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DlgTillBalanceCount.this.tblCount.setRowSelectionInterval(DlgTillBalanceCount.this.tblCount.getRowCount() - 1, DlgTillBalanceCount.this.tblCount.getRowCount() - 1);
                DlgTillBalanceCount.this.tblCount.setColumnSelectionInterval(1, 1);
                DlgTillBalanceCount.this.tblCount.scrollRectToVisible(DlgTillBalanceCount.this.tblCount.getCellRect(DlgTillBalanceCount.this.tblCount.getSelectedRow(), 1, true));
            }
        });
    }

    private void populate() {
        this.dfExpected.setText(this.tenDetCopy.nExpected);
        for (int i = 0; i < this.tenDetCopy.data.size(); ++i) {
            if (this.tenDetCopy.payType.isCash) {
                ((CashTableModel)this.tableModel).data.add((Denomination)this.tenDetCopy.data.elementAt(i));
                continue;
            }
            ((OtherTableModel)this.tableModel).data.add((PosDouble)this.tenDetCopy.data.elementAt(i));
        }
        if (!this.tenDetCopy.payType.isCash && ((OtherTableModel)this.tableModel).data.size() == 0) {
            ((OtherTableModel)this.tableModel).data.add(new PosDouble(0.0));
        }
        this.tableModel.fireTableDataChanged();
        if (this.tblCount.getRowCount() > 0) {
            this.tblCount.setRowSelectionInterval(0, 0);
            if (this.tenDetCopy.payType.isCash) {
                this.tblCount.setColumnSelectionInterval(1, 1);
            } else {
                this.tblCount.setColumnSelectionInterval(1, 1);
            }
        }
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void okDialog() {
        if (!this.bEditable) {
            return;
        }
        if (this.tblCount.isEditing()) {
            this.tblCount.getCellEditor().stopCellEditing();
        }
        this.tenDetOrig.data.clear();
        this.tenDetOrig.nCounted = 0.0;
        if (this.tenDetCopy.payType.isCash) {
            for (int i = 0; i < ((CashTableModel)this.tableModel).data.size(); ++i) {
                this.tenDetOrig.data.add(((CashTableModel)this.tableModel).data.elementAt(i));
                this.tenDetOrig.nCounted += ((Denomination)this.tenDetOrig.data.elementAt(i)).getAmount();
            }
        } else {
            for (int i = 0; i < ((OtherTableModel)this.tableModel).data.size(); ++i) {
                if (((OtherTableModel)this.tableModel).data.elementAt(i).doubleValue() == 0.0) continue;
                this.tenDetOrig.data.add(((OtherTableModel)this.tableModel).data.elementAt(i));
                this.tenDetOrig.nCounted += ((OtherTableModel)this.tableModel).data.elementAt(i).doubleValue();
            }
        }
        this.sbOkPressed.setLength(0);
        this.sbOkPressed.append("1");
        this.dispose();
    }

    private void setTotals() {
        double nTotal = 0.0;
        if (this.tenDetCopy.payType.isCash) {
            for (int i = 0; i < ((CashTableModel)this.tableModel).data.size(); ++i) {
                nTotal += ((CashTableModel)this.tableModel).data.elementAt(i).getAmount();
            }
        } else {
            for (int i = 0; i < ((OtherTableModel)this.tableModel).data.size(); ++i) {
                nTotal += ((OtherTableModel)this.tableModel).data.elementAt(i).doubleValue();
            }
        }
        this.dfTotal.setText(nTotal);
        this.dfVariance.setText(this.dfTotal.getDouble() - this.dfExpected.getDouble());
        if (this.dfVariance.getDouble() == 0.0) {
            this.dfVariance.setDisabledTextColor(Colours.BLACK);
        } else {
            this.dfVariance.setDisabledTextColor(Colours.RED);
        }
    }

    private class OtherTableModel
    extends AbstractTableModel {
        private static final int ROW_NUM_COLUMN = 0;
        private static final int AMOUNT_COLUMN = 1;
        private static final int COL_COUNT = 2;
        Vector<PosDouble> data = new Vector();

        private OtherTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 1: {
                    return DlgTillBalanceCount.this.bEditable;
                }
            }
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.data.size() || row < 0) {
                return "";
            }
            switch (col) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return this.data.elementAt(row);
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return PosDouble.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row >= this.data.size() || row < 0 || value == null) {
                return;
            }
            switch (col) {
                case 1: {
                    double nAmount = PosUtils.doubleValFormatted(value.toString());
                    if (!(nAmount <= 9.9999999999E10)) break;
                    this.data.set(row, PosDouble.valueOf(nAmount));
                    break;
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 1: {
                    return sAMOUNT;
                }
            }
            return "";
        }
    }

    private class CashTableModel
    extends AbstractTableModel {
        private static final int CODE_COLUMN = 0;
        private static final int COUNT_COLUMN = 1;
        private static final int COL_COUNT = 2;
        Vector<Denomination> data = new Vector();

        private CashTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return DlgTillBalanceCount.this.bEditable;
                }
            }
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.data.size() || row < 0) {
                return "";
            }
            switch (col) {
                case 0: {
                    return this.data.elementAt(row);
                }
                case 1: {
                    return new Integer(this.data.elementAt((int)row).nCount);
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 1: {
                    return Integer.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row >= this.data.size() || row < 0 || value == null) {
                return;
            }
            switch (col) {
                case 1: {
                    int nCount = PosUtils.intVal((String)value);
                    if (nCount < 0) break;
                    this.data.elementAt((int)row).nCount = nCount;
                    break;
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return sDENOMINATION;
                }
                case 1: {
                    return sCOUNT;
                }
            }
            return "";
        }
    }
}

