/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPasswordField;
import jpos.ui.Fonts;
import jpos.ui.TouchTextField;
import jpos.ui.UIConstants;

public class TouchPasswordField
extends JPasswordField {
    private int fieldWidth = -1;
    private TouchTextField.FontSize fontSize = TouchTextField.FontSize.NORMAL;
    private TouchTextField hintField;

    public TouchPasswordField() {
        this(null, TouchTextField.FontSize.NORMAL);
    }

    public TouchPasswordField(TouchTextField.FontSize fontSize) {
        this(null, fontSize);
    }

    public TouchPasswordField(String text, TouchTextField.FontSize fontSize) {
        super(text);
        this.fontSize = fontSize;
        this.init();
    }

    private void init() {
        if (this.fontSize == TouchTextField.FontSize.NORMAL) {
            this.setFont(Fonts.PlainText);
        } else {
            this.setFont(Fonts.H2);
        }
        this.hintField = new TouchTextField(this.fontSize);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.getFieldWidth() > -1) {
            d.width = this.getFieldWidth();
        }
        d.height = this.getFieldHeight();
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (this.getFieldWidth() > -1) {
            d.width = this.getFieldWidth();
        }
        d.height = this.getFieldHeight();
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.getFieldWidth() > -1) {
            d.width = this.getFieldWidth();
        }
        d.height = this.getFieldHeight();
        return d;
    }

    public int getFieldHeight() {
        return UIConstants.INPUT_HEIGHT;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public void setFieldWidth(int fieldWidth) {
        this.fieldWidth = fieldWidth;
    }

    public void setHint(String hint) {
        this.hintField.setHint(hint);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getPassword().length == 0) {
            this.hintField.setBounds(this.getBounds());
            this.hintField.setOpaque(false);
            this.hintField.paint(g);
        }
    }
}

