/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.Window;
import java.text.MessageFormat;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.voucher.DlgStatusDetails;
import jpos.voucher.VoucherAdapter;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherType;
import jpos.voucher.VoucherUtils;

public class VoucherIssueAdapter
extends VoucherAdapter {
    private Vector<String> existingVouchers;
    private Window parentWindow;
    private VoucherType voucherType = null;
    private String _recipientFirstName = "";
    private String _recipientSurname = "";
    private String _recipientEmail = "";
    private String _message = "";
    private Boolean _isDigital = false;

    public VoucherIssueAdapter(Window parentWindow, Vector<String> existingVouchers) {
        this.existingVouchers = existingVouchers;
        this.parentWindow = parentWindow;
    }

    @Override
    public boolean processNumber(String voucherNumber) {
        return this.processNumber(voucherNumber, false);
    }

    public boolean processNumber(String voucherNumber, boolean test) {
        String mappedVoucher;
        if (voucherNumber == null || voucherNumber.equals("")) {
            return false;
        }
        this.voucherType = VoucherUtils.getVoucherType(voucherNumber);
        if (this.voucherType != null && !StringUtils.isNullOrEmpty(mappedVoucher = VoucherGatewayManager.getMappedVoucher(voucherNumber))) {
            voucherNumber = mappedVoucher;
            this.voucherType = null;
        }
        for (int i = 0; i < this.existingVouchers.size(); ++i) {
            if (!PosUtils.PadRight(this.existingVouchers.elementAt(i), 20, "0").equals(PosUtils.PadRight(voucherNumber, 20, "0"))) continue;
            DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_number_already_on_transaction"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (this.voucherType == null && VoucherGatewayManager.isGatewayInUse() && VoucherGatewayManager.getInstance().isValidGatewayVoucher(voucherNumber)) {
            if (!VoucherGatewayManager.isGatewayReady(this.parentWindow)) {
                return false;
            }
            this.createGatewayVoucher(VoucherGatewayManager.getInstance().getGateway(), voucherNumber);
            return true;
        }
        if (this.voucherType == null || this.voucherType.getIssueType() == VoucherType.IssueType.PROMO || this.voucherType.isImport()) {
            DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_number_not_valid"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (!this.voucherType.isActive()) {
            if (!this.voucherType.isRangeAtStore()) {
                DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_not_at_store"), StoreParams.res.getString("Stop"), 0);
            } else {
                DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_type_suspended"), StoreParams.res.getString("Stop"), 0);
            }
            return false;
        }
        if (this.voucherType.useCheckDigit() && !VoucherUtils.verifyCheckDigit(voucherNumber)) {
            DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_number_not_valid"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (VoucherGatewayManager.isGatewayInUse()) {
            DlgMessage.showMessage(this.parentWindow, MessageFormat.format(SP.getRS("voucher_issue_gateway_only"), VoucherGatewayManager.getInstance().getGatewayTypeName()), SP.getRS("Stop"), 0);
            return false;
        }
        this.createVoucher(this.voucherType, voucherNumber);
        if (this.getVoucher().isIssued()) {
            DlgMessage dlgMessage = new DlgMessage(this.parentWindow, SP.getRS("Stop"), StoreParams.res.getString("voucher_issued"), 2, 0);
            dlgMessage.getOkButton().setText(SP.getRS("Details"));
            dlgMessage.getCancelButton().setText(SP.getRS("Close"));
            if (dlgMessage.showMessage() == 0) {
                DlgStatusDetails dlgStatusDetails = new DlgStatusDetails((PosFrame)this.parentWindow, StoreParams.res.getString("Gift_Voucher_Balance_Enquiry"), true);
                dlgStatusDetails.loadDetails(this);
                dlgStatusDetails.setVisible(true);
            }
            this.destroyVoucher();
            return false;
        }
        return true;
    }

    public String GetRecipientFirstName() {
        return this._recipientFirstName;
    }

    public void SetRecipientFirstName(String value) {
        this._recipientFirstName = value;
    }

    public String GetRecipientSurname() {
        return this._recipientSurname;
    }

    public void SetRecipientSurname(String value) {
        this._recipientSurname = value;
    }

    public String GetRecipientEmail() {
        return this._recipientEmail;
    }

    public void SetRecipientEmail(String value) {
        this._recipientEmail = value;
    }

    public boolean IsDigital() {
        return this._isDigital;
    }

    public void SetDigital(boolean value) {
        if (value) {
            this.createGatewayVoucher(VoucherGatewayManager.getInstance().getGateway(), this._recipientEmail);
            this._isDigital = true;
        } else {
            this._isDigital = false;
        }
    }

    public String GetMessage() {
        return this._message;
    }

    public void SetMessage(String value) {
        this._message = value;
    }
}

