/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher.vii;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import jpos.voucher.vii.Request;
import jpos.voucher.vii.ViiConfig;

@XmlRootElement(name="Request")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoadRequest
extends Request {
    private static final String OFFLINE_TAG = "10";
    @XmlElement(name="CardNumber")
    private String cardNumber;
    @XmlElement(name="Amount")
    private String amount;
    @XmlElement(name="ExternalReference")
    private String externalReference;
    @XmlElement(name="Stan")
    private String stan;
    @XmlElement(name="TransactionDate")
    private String transactionDate;
    @XmlElement(name="TransactionTime")
    private String transactionTime;
    @XmlElement(name="Offline")
    private String offline;

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public String getStan() {
        return this.stan;
    }

    public void setStan(String stan) {
        this.stan = stan;
    }

    public String getTransactionDate() {
        return this.transactionDate;
    }

    public String getTransactionTime() {
        return this.transactionTime;
    }

    public void setTransactionDateTime(Date date) {
        this.transactionDate = new SimpleDateFormat("dd/MM/yyyy").format(date);
        this.transactionTime = new SimpleDateFormat("HHmmss").format(date);
    }

    public boolean isOffline() {
        return this.offline != null;
    }

    public void setOffline(boolean offline) {
        this.offline = offline ? OFFLINE_TAG : null;
    }

    protected LoadRequest() {
    }

    public LoadRequest(ViiConfig config, String cardNumber, double amount, String reference) {
        super(config, "Load");
        this.cardNumber = cardNumber;
        this.amount = this.formatAmount(amount);
        this.externalReference = reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateRetryTemplate() throws JAXBException {
        String tempTransactionId = this.getTransactionId();
        boolean tempOffline = this.isOffline();
        try {
            this.setTransactionId(UUID.randomUUID().toString());
            this.setOffline(true);
            String string = this.serialise(false);
            return string;
        }
        finally {
            this.setTransactionId(tempTransactionId);
            this.setOffline(tempOffline);
        }
    }
}

