/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher.vii;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import jpos.voucher.vii.Request;
import jpos.voucher.vii.ViiConfig;
import jpos.voucher.vii.ViiOrderItem;

@XmlRootElement(name="Request")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NewOrderRequest
extends Request {
    private static final String OFFLINE_TAG = "10";
    public String cardNumber;
    public Order Order;

    public String getCardNumber() {
        return this.cardNumber;
    }

    protected NewOrderRequest() {
    }

    public NewOrderRequest(ViiConfig config, String recipientName, String recipientSurname, String recipientEmail, String message, double amount, String reference, double quantity, boolean isRefund) {
        super(config, "NewOrder");
        this.Order = new Order();
        this.Order.storedValueCardOrderSourceId = config.getDigitalConfig().getSourceId();
        this.Order.storedValueCardOrderStatusId = "20";
        this.Order.sourceReferenceId = reference;
        this.Order.paymentType = OFFLINE_TAG;
        this.Order.paymentStatus = "20";
        this.Order.setSettlementDate(new Date());
        this.Order.totalAmount = this.formatAmount(amount);
        this.Order.orderPerson = new OrderPerson();
        this.Order.orderPerson.firstName = recipientName;
        this.Order.orderPerson.lastName = recipientSurname;
        this.Order.orderPerson.email = recipientEmail;
        this.Order.Packages = this.createPackage(config, recipientName, recipientSurname, recipientEmail, message, amount, quantity, isRefund);
    }

    public NewOrderRequest(ViiConfig config, List<ViiOrderItem> orderItems, String salesRepFirstName, String salesRepSurname) {
        super(config, "NewOrder");
        this.Order = new Order();
        this.Order.storedValueCardOrderSourceId = config.getDigitalConfig().getSourceId();
        this.Order.storedValueCardOrderStatusId = "20";
        this.Order.sourceReferenceId = orderItems.get(0).getExternalReference();
        this.Order.paymentType = OFFLINE_TAG;
        this.Order.paymentStatus = "20";
        this.Order.setSettlementDate(new Date());
        double totalAmount = 0.0;
        for (ViiOrderItem item : orderItems) {
            totalAmount += item.getGross();
        }
        this.Order.totalAmount = this.formatAmount(totalAmount);
        this.Order.orderPerson = new OrderPerson();
        this.Order.orderPerson.firstName = salesRepFirstName;
        this.Order.orderPerson.lastName = salesRepSurname;
        this.Order.orderPerson.email = "";
        for (ViiOrderItem orderItem : orderItems) {
            this.Order.Packages = this.createPackage(config, orderItem.getRecipientName(), orderItem.getRecipientSurname(), orderItem.getRecipientEmail(), orderItem.getMessage(), orderItem.getGross(), orderItem.getQty(), orderItem.isRefundVoucher(), this.Order.Packages);
        }
    }

    public Packages createPackage(ViiConfig config, String recipientName, String recipientSurname, String recipientEmail, String message, double amount, double quantity, boolean isRefund) {
        Packages newPackages = new Packages();
        Package newPackage = new Package();
        newPackage.deliveryMethod = "Email";
        newPackage.deliveryCost = "0";
        newPackage.firstName = recipientName;
        newPackage.lastName = recipientSurname;
        newPackage.email = recipientEmail;
        newPackage.orderItems = this.createOrderDetails(config, amount, quantity, message, recipientName, isRefund);
        newPackages.Package.add(0, newPackage);
        return newPackages;
    }

    public Packages createPackage(ViiConfig config, String recipientName, String recipientSurname, String recipientEmail, String message, double amount, double quantity, boolean isRefund, Packages currentPackages) {
        Packages newPackages = currentPackages != null ? (currentPackages.Package.isEmpty() ? new Packages() : currentPackages) : new Packages();
        Package newPackage = newPackages.getPackage(recipientName, recipientSurname, recipientEmail);
        if (newPackage == null) {
            newPackage = new Package();
            newPackage.deliveryMethod = "Email";
            newPackage.deliveryCost = "0";
            newPackage.firstName = recipientName;
            newPackage.lastName = recipientSurname;
            newPackage.email = recipientEmail;
            newPackages.Package.add(0, newPackage);
        }
        newPackage.orderItems = this.createOrderDetails(config, amount, quantity, message, recipientName, isRefund, newPackage.orderItems);
        return newPackages;
    }

    public OrderItems createOrderDetails(ViiConfig config, double amount, double quantity, String message, String toName, boolean isRefund) {
        OrderItems orderItems = new OrderItems();
        OrderDetail newOrderDetail = new OrderDetail();
        newOrderDetail.quantity = String.valueOf((int)quantity);
        newOrderDetail.cardDesign = isRefund ? config.getDigitalConfig().getDigitalRefundCardDesign() : config.getDigitalConfig().getCardDesign();
        newOrderDetail.carrierCode = "";
        newOrderDetail.giftCardProgramId = "";
        newOrderDetail.toName = toName;
        newOrderDetail.carrierMessage = message;
        newOrderDetail.bin = config.getDigitalConfig().getMailOrderBin();
        newOrderDetail.cardFaceValue = this.formatAmount(amount);
        orderItems.orderDetail.add(0, newOrderDetail);
        return orderItems;
    }

    public OrderItems createOrderDetails(ViiConfig config, double amount, double quantity, String message, String toName, boolean isRefund, OrderItems currentOrderItems) {
        OrderItems orderItems = currentOrderItems == null ? new OrderItems() : currentOrderItems;
        OrderDetail newOrderDetail = new OrderDetail();
        newOrderDetail.quantity = String.valueOf((int)quantity);
        newOrderDetail.cardDesign = isRefund ? config.getDigitalConfig().getDigitalRefundCardDesign() : config.getDigitalConfig().getCardDesign();
        newOrderDetail.carrierCode = "";
        newOrderDetail.giftCardProgramId = "";
        newOrderDetail.toName = toName;
        newOrderDetail.carrierMessage = message;
        newOrderDetail.bin = config.getDigitalConfig().getMailOrderBin();
        newOrderDetail.cardFaceValue = this.formatAmount(amount);
        orderItems.orderDetail.add(0, newOrderDetail);
        return orderItems;
    }

    public String generateRetryTemplate() throws JAXBException {
        return this.serialise(false);
    }

    @XmlRootElement(name="Packages")
    public static class Packages {
        public List<Package> Package = new ArrayList<Package>();

        public Package getPackage(String recipientName, String recipientSurname, String recipientEmail) {
            for (Package pack : this.Package) {
                if (!pack.email.toLowerCase().trim().equals(recipientEmail.toLowerCase().trim())) continue;
                return pack;
            }
            return null;
        }
    }

    @XmlRootElement(name="Package")
    public static class Package {
        @XmlElement(name="DeliveryMethod")
        public String deliveryMethod;
        @XmlElement(name="Salutation")
        public String salutation;
        @XmlElement(name="FirstName")
        public String firstName;
        @XmlElement(name="LastName")
        public String lastName;
        @XmlElement(name="Email")
        public String email;
        @XmlElement(name="Position")
        public String position;
        @XmlElement(name="Company")
        public String company;
        @XmlElement(name="Department")
        public String department;
        @XmlElement(name="AddressLine1")
        public String addressLine1;
        @XmlElement(name="AddressLine2")
        public String addressLine2;
        @XmlElement(name="Suburb")
        public String suburb;
        @XmlElement(name="State")
        public String state;
        @XmlElement(name="PostCode")
        public String postCode;
        @XmlElement(name="PhoneNumber")
        public String phoneNumber;
        @XmlElement(name="DeliveryCost")
        public String deliveryCost;
        @XmlElement(name="OrderItems")
        public OrderItems orderItems;

        public String getDeliveryMethod() {
            return this.deliveryMethod;
        }

        public String getSalutation() {
            return this.salutation;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getPosition() {
            return this.position;
        }

        public String getCompany() {
            return this.company;
        }

        public String getDepartment() {
            return this.department;
        }

        public String getAddressLine1() {
            return this.addressLine1;
        }

        public String getAddressLine2() {
            return this.addressLine2;
        }

        public String getSuburb() {
            return this.suburb;
        }

        public String getState() {
            return this.state;
        }

        public String getPostCode() {
            return this.postCode;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public String getDeliveryCost() {
            return this.deliveryCost;
        }
    }

    @XmlRootElement(name="OrderItems")
    public static class OrderItems {
        @XmlElement(name="OrderDetail")
        public List<OrderDetail> orderDetail = new ArrayList<OrderDetail>();
    }

    @XmlRootElement(name="OrderDetail")
    public static class OrderDetail {
        @XmlElement(name="Quantity")
        public String quantity;
        @XmlElement(name="CardDesign")
        public String cardDesign;
        @XmlElement(name="CarrierCode")
        public String carrierCode;
        @XmlElement(name="CardFaceValue")
        public String cardFaceValue;
        @XmlElement(name="Discount")
        public String discount;
        @XmlElement(name="Bin")
        public String bin;
        @XmlElement(name="GiftCardProgramId")
        public String giftCardProgramId;
        @XmlElement(name="ToName")
        public String toName;
        @XmlElement(name="CarrierMessage")
        public String carrierMessage;
        @XmlElement(name="FromMessage")
        public String fromMessage;

        public String getQuantity() {
            return this.quantity;
        }

        public String getCardDesign() {
            return this.cardDesign;
        }

        public String getCarrierCode() {
            return this.carrierCode;
        }

        public String getCardFaceValue() {
            return this.cardFaceValue;
        }

        public String getDiscount() {
            return this.discount;
        }

        public String getBin() {
            return this.bin;
        }

        public String getGiftCardProgramId() {
            return this.giftCardProgramId;
        }

        public String getToName() {
            return this.toName;
        }

        public String getCarrierMessage() {
            return this.carrierMessage;
        }

        public String getFromMessage() {
            return this.fromMessage;
        }
    }

    @XmlRootElement(name="OrderPerson")
    public static class OrderPerson {
        @XmlElement(name="Salutation")
        private String salutation;
        @XmlElement(name="FirstName")
        private String firstName;
        @XmlElement(name="LastName")
        private String lastName;
        @XmlElement(name="Email")
        private String email;
        @XmlElement(name="PhoneNumber")
        private String phoneNumber;
        @XmlElement(name="AddressLine1")
        private String addressLine1;
        @XmlElement(name="AddressLine2")
        private String addressLine2;
        @XmlElement(name="Suburb")
        private String suburb;
        @XmlElement(name="State")
        private String state;
        @XmlElement(name="PostCode")
        private String postCode;
        @XmlElement(name="Country")
        private String country;

        public String getSalutation() {
            return this.salutation;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getEmail() {
            return this.email;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public String getAddressLine1() {
            return this.addressLine1;
        }

        public String getAddressLine2() {
            return this.addressLine2;
        }

        public String getSuburb() {
            return this.suburb;
        }

        public String getState() {
            return this.state;
        }

        public String getPostCode() {
            return this.postCode;
        }

        public String getCountry() {
            return this.country;
        }
    }

    @XmlRootElement(name="Order")
    public static class Order {
        @XmlElement(name="StoredValueCardOrderSourceId")
        private String storedValueCardOrderSourceId;
        @XmlElement(name="StoredValueCardOrderStatusId")
        private String storedValueCardOrderStatusId;
        @XmlElement(name="PaymentStatus")
        private String paymentStatus;
        @XmlElement(name="SourceReferenceId")
        private String sourceReferenceId;
        @XmlElement(name="TotalAmount")
        private String totalAmount;
        @XmlElement(name="GstAmount")
        private String gstAmount;
        @XmlElement(name="PaymentType")
        private String paymentType;
        @XmlElement(name="SettlementDate")
        private String settlementDate;
        @XmlElement(name="TransactionDate")
        private String transactionDate;
        @XmlElement(name="OrderPerson")
        private OrderPerson orderPerson;
        @XmlElement(name="Packages")
        private Packages Packages;

        public String getstoredValueCardOrderSourceId() {
            return this.storedValueCardOrderSourceId;
        }

        public String getstoredValueCardOrderStatusId() {
            return this.storedValueCardOrderStatusId;
        }

        public String getPaymentStatus() {
            return this.paymentStatus;
        }

        public String getSourceReferenceId() {
            return this.sourceReferenceId;
        }

        public String getTotalAmount() {
            return this.totalAmount;
        }

        public String getGstAmount() {
            return this.gstAmount;
        }

        public String getPaymentType() {
            return this.paymentType;
        }

        public String getSettlementDate() {
            return this.settlementDate;
        }

        public String getTransactionDate() {
            return this.transactionDate;
        }

        public void setTransactionDateTime(Date date) {
            this.transactionDate = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss aa").format(date);
        }

        public void setSettlementDate(Date date) {
            this.settlementDate = new SimpleDateFormat("dd/MM/yyyy").format(date);
        }
    }
}

