/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher.vii;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class XmlSerialiser {
    private static Map<Class<?>, JAXBContext> serialiserMap = new HashMap();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serialise(Object object) throws JAXBException {
        try (StringWriter writer = new StringWriter();){
            Marshaller marshaller = XmlSerialiser.getSerialiser(object.getClass()).createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal(object, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T deserialise(Class<T> toClass, String xml) throws JAXBException {
        try (StringReader reader = new StringReader(xml);){
            T t = toClass.cast(XmlSerialiser.getSerialiser(toClass).createUnmarshaller().unmarshal((Reader)reader));
            return t;
        }
    }

    private static synchronized JAXBContext getSerialiser(Class<?> forClass) throws JAXBException {
        JAXBContext context = serialiserMap.get(forClass);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{forClass});
            serialiserMap.put(forClass, context);
        }
        return context;
    }
}

