/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.event.KeyEvent;
import jpos.AttachedLoyaltyManager;
import jpos.FrSales;
import jpos.LoyaltyRedemptionPanel;
import jpos.PaSales;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.capillary.CapillaryLoyaltyRedemptionPanel;
import jpos.rewards.GiftSku;
import org.jdom.Element;

public class DlgManualLoyaltyDiscount
extends PosDialog
implements AutoCloseable {
    private LoyaltyRedemptionPanel detailsPanel;
    private boolean okPressed = false;
    private Element person;
    private AttachedLoyaltyManager.LoyaltyInfo loyaltyInfo;
    private boolean giftMode = false;
    private GiftSku selectedGift = null;

    public DlgManualLoyaltyDiscount(FrSales frame, Element person, AttachedLoyaltyManager.LoyaltyInfo loyaltyInfo) {
        this(frame, person, loyaltyInfo, false);
    }

    public DlgManualLoyaltyDiscount(FrSales frame, Element person, AttachedLoyaltyManager.LoyaltyInfo loyaltyInfo, boolean giftMode) {
        super((PosFrame)frame, SP.getRS("Loading_dots"), true, true);
        this.frParent = frame;
        this.person = person;
        this.loyaltyInfo = loyaltyInfo;
        this.giftMode = giftMode;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.setResizable(false);
        this.detailsPanel = LoyaltyRedemptionPanel.LoyaltyRedemptionPanelFactory.create(this, this.loyaltyInfo.getLoyaltyDetails().getLoyalty().getIdx(), this.giftMode);
        this.detailsPanel.setPerson(this.person);
        this.detailsPanel.setLoyaltyInfo(this.loyaltyInfo);
        if (this.frParent instanceof FrSales) {
            FrSales sales = (FrSales)this.frParent;
            this.detailsPanel.setTransactionTotal(((PaSales)sales.paBody).tblStyles.getDueAvailableForManualLoyalty() + this.loyaltyInfo.getNewLoyaltyAmount());
            this.detailsPanel.setAccrueSpendTotal(((PaSales)sales.paBody).tblStyles.getDueApplicableForRewardsAccrual());
        }
        this.detailsPanel.load();
        this.add(this.detailsPanel);
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    public void okDialog() {
        if (this.detailsPanel.validateInputs()) {
            this.okPressed = true;
            this.selectedGift = this.detailsPanel.getSelectedGift();
            this.dispose();
        }
    }

    @Override
    public void cancelDialog() {
        this.okPressed = false;
        this.dispose();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public double getAmount() {
        return this.detailsPanel.getAmount();
    }

    public void setAmount(double amount) {
        this.detailsPanel.setAmount(amount);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    @Override
    public void close() throws Exception {
        this.detailsPanel.destroyPanel();
    }

    public GiftSku getSelectedGift() {
        return this.selectedGift;
    }

    public double getPoints() {
        if (this.detailsPanel instanceof CapillaryLoyaltyRedemptionPanel) {
            return ((CapillaryLoyaltyRedemptionPanel)this.detailsPanel).getPoints();
        }
        return 0.0;
    }

    public void setPoints(double points) {
        if (this.detailsPanel instanceof CapillaryLoyaltyRedemptionPanel) {
            ((CapillaryLoyaltyRedemptionPanel)this.detailsPanel).setPoints(points);
        }
    }

    public double getPointsBalance() {
        if (this.detailsPanel instanceof CapillaryLoyaltyRedemptionPanel) {
            return ((CapillaryLoyaltyRedemptionPanel)this.detailsPanel).getPointsBalance();
        }
        return 0.0;
    }

    public void setPointsBalance(double points) {
        if (this.detailsPanel instanceof CapillaryLoyaltyRedemptionPanel) {
            ((CapillaryLoyaltyRedemptionPanel)this.detailsPanel).setPointsBalance(points);
        }
    }

    public String getThirdPartyCouponCode() {
        if (this.detailsPanel instanceof CapillaryLoyaltyRedemptionPanel) {
            return ((CapillaryLoyaltyRedemptionPanel)this.detailsPanel).getCouponCode();
        }
        return null;
    }
}

