/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.MLengthTextArea;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.TouchList;

public class DlgReservationType
extends PosDialog {
    private TouchList<Reference> lstRefcode;
    private DialogButton bOK = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private long rgidx;
    private StringBuffer notes;
    private boolean notesAreMandatory;
    private static final int maxNotesLength = 250;
    private Vector<Reference> refcodes = new Vector();
    private MLengthTextArea tpNotes;
    private LabelNormal lResvType = new LabelNormal();
    private LabelNormal lNotes = new LabelNormal();
    private PosScrollPane scrollNotes = new PosScrollPane();
    private PosScrollPane scrollResvType = new PosScrollPane();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private String rcidx;
    private boolean accepted = false;

    public DlgReservationType(PosFrame frame, String title, boolean notesAreMandatory) {
        super(frame, title, true);
        this.notes = new StringBuffer();
        this.notesAreMandatory = notesAreMandatory;
        try {
            this.jbInit(title);
            this.pack();
            PosUtils.centreWindow(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getReservationTypeIdx() {
        return this.rcidx;
    }

    public String getNotes() {
        return this.notes.toString();
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    void jbInit(String title) throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout);
        this.bOK.setText(StoreParams.res.getString("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReservationType.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReservationType.this.cancelDialog();
            }
        });
        this.scrollResvType.setPreferredSize(new Dimension(259, 200));
        this.scrollNotes.setPreferredSize(new Dimension(259, 131));
        if (this.rgidx > -1L) {
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT RCIDX, CODE, NAME FROM REFCODE WHERE RGIDX = ? AND ACTIVE = 1 ORDER BY CODE", String.valueOf(466));){
                int cnt = 0;
                int index = 0;
                this.lResvType.setText(StoreParams.res.getString("Select_Reservation_Type"));
                while (sql.next()) {
                    Reference reference = new Reference(sql.getString(3), sql.getString(2), sql.getLong(1));
                    reference.setShowName(true);
                    this.refcodes.add(reference);
                    ++cnt;
                }
                this.lstRefcode = new TouchList<Reference>(this.refcodes);
                if (!this.refcodes.isEmpty()) {
                    this.lstRefcode.setSelectedIndex(index);
                }
                this.lstRefcode.setSelectionMode(0);
            }
            catch (SQLException e) {
                this.dispose();
            }
        }
        if (this.lstRefcode == null) {
            this.lstRefcode = new TouchList();
        }
        this.tpNotes = new MLengthTextArea(250);
        this.tpNotes.setText(this.notes.toString());
        this.tpNotes.setBorder(this.lstRefcode.getBorder());
        this.lResvType.setHorizontalAlignment(2);
        this.lNotes.setText(StoreParams.res.getString("Enter_any_additional"));
        if (this.rgidx > -1L) {
            this.getContentPane().add((Component)this.scrollResvType, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 24, 0, 29), 100, 0));
            this.scrollResvType.getViewport().add(this.lstRefcode, null);
            this.getContentPane().add((Component)this.lResvType, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(21, 24, 4, 0), 0, 0));
        }
        this.getContentPane().add((Component)this.scrollNotes, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 24, 0, 29), 100, 0));
        this.scrollNotes.getViewport().add((Component)this.tpNotes, null);
        this.getContentPane().add((Component)this.bOK, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 0, new Insets(18, 0, 17, 0), 0, 0));
        this.getContentPane().add((Component)this.bCancel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 0, new Insets(18, 0, 17, 0), 0, 0));
        this.getContentPane().add((Component)this.lNotes, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(16, 24, 4, 0), 0, 0));
    }

    @Override
    public boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    private void setEditable(boolean editable) {
        this.bOK.setEnabled(editable);
        this.lstRefcode.setEnabled(editable);
        this.tpNotes.setEnabled(editable);
    }

    @Override
    public void okDialog() {
        if (this.lstRefcode.getSelectedIndex() == -1) {
            return;
        }
        this.rcidx = String.valueOf(((Reference)this.lstRefcode.getSelectedValue()).getIdx());
        if (this.notesAreMandatory && this.tpNotes.getText().length() == 0) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Additional_Notes_Required"), this.getTitle(), 0);
        } else {
            this.notes.replace(0, this.notes.length(), this.tpNotes.getText());
            this.accepted = true;
            this.dispose();
        }
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }
}

