/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;
import jpos.FadeListener;
import jpos.ui.LabelSmall;

public class FadeLabel
extends LabelSmall {
    private Timer mainTimer;
    private Timer autoFadeOutTimer;
    private float fadeIncrement;
    private float alpha;
    private int fadeMilliseconds;
    private int refreshRateMilliseconds;
    private String toolTipMessage;
    private List<FadeListener> fadeListeners = new Vector<FadeListener>();

    public FadeLabel() {
        this(2000, 100, null);
    }

    public FadeLabel(int fadeMilliseconds) {
        this(fadeMilliseconds, 100, null);
    }

    public FadeLabel(int fadeMilliseconds, String hoverMessage) {
        this(fadeMilliseconds, 100, hoverMessage);
    }

    public FadeLabel(int fadeMilliseconds, int refreshRateMilliseconds) {
        this(fadeMilliseconds, refreshRateMilliseconds, null);
    }

    public FadeLabel(int fadeMilliseconds, int refreshRateMilliseconds, String toolTipMessage) {
        this.fadeMilliseconds = fadeMilliseconds;
        this.refreshRateMilliseconds = refreshRateMilliseconds;
        this.toolTipMessage = toolTipMessage;
        this.setAlpha(1.0f);
        this.mainTimer = new Timer(refreshRateMilliseconds, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float alpha = FadeLabel.this.getAlpha();
                alpha += FadeLabel.this.fadeIncrement;
                if (FadeLabel.this.fadeIncrement < 0.0f && alpha <= 0.0f) {
                    alpha = 0.0f;
                    FadeLabel.this.mainTimer.stop();
                } else if (FadeLabel.this.fadeIncrement > 0.0f && alpha >= 1.0f) {
                    alpha = 1.0f;
                    FadeLabel.this.mainTimer.stop();
                }
                FadeLabel.this.setAlpha(alpha);
                if (alpha == 0.0f) {
                    FadeLabel.this.notifyListeners(false);
                }
            }
        });
        this.mainTimer.setRepeats(true);
        this.mainTimer.setCoalesce(true);
        this.autoFadeOutTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FadeLabel.this.fadeOut();
            }
        });
        this.autoFadeOutTimer.setRepeats(false);
        this.setAlpha(0.0f);
    }

    public void setAlpha(float value) {
        if (this.alpha != value) {
            float old = this.alpha;
            this.alpha = value;
            this.firePropertyChange("alpha", old, this.alpha);
            this.repaint();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        super.paint(g2d);
        g2d.dispose();
    }

    public void fadeIn() {
        this.fadeIn(0);
    }

    public void fadeIn(int autoFadeMilliseconds) {
        this.notifyListeners(true);
        this.setToolTipText(this.toolTipMessage);
        this.fadeIncrement = 1.0f / (float)(this.fadeMilliseconds / this.refreshRateMilliseconds);
        this.startTimer(this.mainTimer);
        if (autoFadeMilliseconds > 0) {
            this.autoFadeOutTimer.setInitialDelay(autoFadeMilliseconds + this.fadeMilliseconds);
            this.startTimer(this.autoFadeOutTimer);
        }
    }

    public void fadeOut() {
        this.setToolTipText(null);
        this.fadeIncrement = 0.0f - 1.0f / (float)(this.fadeMilliseconds / this.refreshRateMilliseconds);
        this.startTimer(this.mainTimer);
    }

    private void startTimer(Timer timer) {
        if (timer.isRunning()) {
            timer.stop();
        }
        timer.start();
    }

    public void setToolTipMessage(String toolTipMessage) {
        this.toolTipMessage = toolTipMessage;
    }

    public int getFadeMilliseconds() {
        return this.fadeMilliseconds;
    }

    private void notifyListeners(boolean show) {
        for (FadeListener listener : this.fadeListeners) {
            if (listener == null) continue;
            if (show) {
                listener.onShow();
                continue;
            }
            listener.onHide();
        }
    }

    public void addFadeListener(FadeListener listener) {
        this.fadeListeners.add(listener);
    }

    public void removeFadeListener(FadeListener listener) {
        this.fadeListeners.remove(listener);
    }
}

