/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.NoteType;
import jpos.PaReservations;
import jpos.PaReserveFoot;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SkuReservation;
import jpos.StoreParams;

public class FrReservations
extends PosFrame {
    Vector<NoteType> perNoteTypes = new Vector();
    boolean runningDelete = false;
    boolean runningSell = false;
    boolean runningSave = false;

    public FrReservations(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 11, 11126L, psParams, StoreParams.res.getString("Stock_Reservations"));
        this.paBody = new PaReservations(this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaReserveFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
        NoteType.readNoteTypes(this.perNoteTypes, 12L, 0L, this.sParams);
    }

    @Override
    public void resetStatus() {
        ((PaReserveFoot)this.paFoot).statusBar.reset();
    }

    @Override
    public void printReceipt(boolean reprint) {
        if (reprint) {
            int row = ((PaReservations)this.paBody).tblReserve.getSelectedRow();
            if (row == -1 && ((PaReservations)this.paBody).tblReserve.getRowCount() == 1) {
                row = 0;
            }
            if (row == -1) {
                DlgMessage.showMessage(this, StoreParams.res.getString("select_line"), StoreParams.res.getString("Reprint"), 1);
            } else {
                ((PaReservations)this.paBody).tblReserve.getReservation(row).printDockets(this, true);
                ((PaReservations)this.paBody).tblReserve.getReservation(row).printLabels(this);
            }
        }
    }

    @Override
    protected void setTransnum() {
    }

    @Override
    public boolean validateTrans() {
        return false;
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaReserveFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void setFocus() {
        ((PaReservations)this.paBody).tfPerName.requestFocus();
    }

    @Override
    public void setStatusText(String msg) {
        ((PaReserveFoot)this.paFoot).statusBar.setText(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delLines() {
        boolean locked = false;
        String lineTransnum = "";
        if (this.runningDelete) {
            return;
        }
        try {
            this.runningDelete = true;
            int row = ((PaReservations)this.paBody).tblReserve.getSelectedRow();
            if (row == -1 && ((PaReservations)this.paBody).tblReserve.getRowCount() == 1) {
                row = 0;
            }
            if (row == -1) {
                DlgMessage.showMessage(this, StoreParams.res.getString("select_reservation_unreserve"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            SkuReservation res = ((PaReservations)this.paBody).tblReserve.getReservation(row);
            lineTransnum = res.getTransnum();
            if (!res.getStyleLine().isValid()) {
                Object[] objs = new Object[]{"\n", "\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("reservation_unaccessible"), objs), StoreParams.res.getString("Reservation_") + " " + lineTransnum, 0);
            } else {
                if (!this.lockTransaction(lineTransnum, lineTransnum, 614)) {
                    return;
                }
                locked = true;
                if (!res.isUpToDate(false)) {
                    DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("reservation_modified"), "\n"), StoreParams.res.getString("Reservation_") + " " + res.getTransnum(), 0);
                    return;
                }
                String msg = StoreParams.res.getString("confirm_unreserve") + "\n";
                msg = msg + StoreParams.res.getString("Customer") + " : " + ((PaReservations)this.paBody).tblReserve.getValueAt(row, 0) + "\n";
                if (DlgMessage.showMessage(this, msg = msg + StoreParams.res.getString("Product_Code") + " : " + ((PaReservations)this.paBody).tblReserve.getValueAt(row, 5) + (((PaReservations)this.paBody).tblReserve.getValueAt(row, 6).toString().length() > 0 ? "." + ((PaReservations)this.paBody).tblReserve.getValueAt(row, 6) : "") + (((PaReservations)this.paBody).tblReserve.getValueAt(row, 7).toString().length() > 0 ? "." + ((PaReservations)this.paBody).tblReserve.getValueAt(row, 7) : ""), StoreParams.res.getString("Unreserve"), 0, 3) == 0) {
                    res = ((PaReservations)this.paBody).tblReserve.removeReservation(row);
                    if (!this.getUser().isTraningUser()) {
                        try {
                            PosUtils.startTrans(this.sParams.conn);
                            res.reverseReservation(this.getUser().getMemidx(), this.getUser().getPeridx(), null);
                            PosUtils.endTrans(this.sParams.conn);
                        }
                        catch (Exception e) {
                            PosUtils.releaseTrans(this.sParams.conn);
                            PosUtils.logError(e);
                        }
                    }
                }
            }
        }
        finally {
            this.runningDelete = false;
            if (locked) {
                this.clearLock(lineTransnum, 614);
            }
        }
    }

    @Override
    protected void setTransType() {
    }

    @Override
    public boolean isVoid() {
        return true;
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        return false;
    }

    public void refresh() {
        if (this.isLoggedIn(false)) {
            this.setCursor(StoreParams.waitCursor);
            ((PaReservations)this.paBody).clear();
            ((PaReservations)this.paBody).populate("");
            this.setCursor(StoreParams.normalCursor);
        }
    }

    @Override
    protected void updateSec(boolean[] formSec) {
        if (this.isLoggedIn(false)) {
            this.setCursor(StoreParams.waitCursor);
            ((PaReservations)this.paBody).populate("");
            this.setCursor(StoreParams.normalCursor);
        } else {
            ((PaReservations)this.paBody).clear();
        }
    }

    public void sellItem() {
        if (this.runningSell) {
            return;
        }
        try {
            this.runningSell = true;
            int row = ((PaReservations)this.paBody).tblReserve.getSelectedRow();
            if (row == -1 && ((PaReservations)this.paBody).tblReserve.getRowCount() == 1) {
                row = 0;
            }
            if (row == -1) {
                DlgMessage.showMessage(this, StoreParams.res.getString("select_reservation_sell"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            if (!((PaReservations)this.paBody).tblReserve.getReservation(row).getStyleLine().isValid()) {
                Object[] objs = new Object[]{"\n", "\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("reservation_unaccessible"), objs), StoreParams.res.getString("Reservation_") + " " + ((PaReservations)this.paBody).tblReserve.getReservation(row).getTransnum(), 0);
            } else {
                if (((PaReservations)this.paBody).tblReserve.getReservation(row).getStyleLine().isAvailQtyChanged()) {
                    this.saveLine(row);
                }
                this.clearLock(((PaReservations)this.paBody).tblReserve.getReservation(row).getTransnum(), 614);
                if (this.menu.addReservation(this, ((PaReservations)this.paBody).tblReserve.getReservation(row))) {
                    ((PaReservations)this.paBody).tblReserve.removeReservation(row);
                }
            }
        }
        finally {
            this.runningSell = false;
        }
    }

    public void save() {
        if (this.runningSave) {
            return;
        }
        try {
            this.runningSave = true;
            for (int i = 0; i < ((PaReservations)this.paBody).tblReserve.getRowCount(); ++i) {
                this.saveLine(i);
            }
            this.clearScreenLocks();
            ((PaReservations)this.paBody).update();
        }
        finally {
            this.runningSave = false;
        }
    }

    private void saveLine(int i) {
        SkuReservation res = ((PaReservations)this.paBody).tblReserve.getReservation(i);
        if (res.getStyleLine().isAvailQtyChanged()) {
            try {
                PosUtils.startTrans(this.sParams.conn);
                res.updateAvailQty();
                PosUtils.endTrans(this.sParams.conn);
            }
            catch (SQLException e) {
                PosUtils.releaseTrans(this.sParams.conn);
                PosUtils.logError(e);
            }
        }
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 118) {
            ((PaReserveFoot)this.paFoot).bSell.doClick();
        } else if (e.getKeyCode() == 119) {
            ((PaReserveFoot)this.paFoot).bSave.doClick();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void notesSet() {
    }

    @Override
    public void setNotes(Vector<NoteType> pnoteTypes) {
        int row = ((PaReservations)this.paBody).tblReserve.getSelectedRow();
        if (row > -1) {
            Vector<NoteType> types = new Vector<NoteType>(pnoteTypes);
            types.addAll(this.perNoteTypes);
            this.notes.clear();
            SkuReservation reservation = ((PaReservations)this.paBody).tblReserve.getReservation(row);
            for (int i = 0; i < types.size(); ++i) {
                if (types.elementAt(i).getTblidx() == 23L) {
                    types.elementAt(i).setKeyIdx(reservation.getVhidx(), true);
                    continue;
                }
                if (types.elementAt(i).getTblidx() != 12L) continue;
                types.elementAt(i).setKeyIdx(reservation.getPeridx(), reservation.getPeridx() < 0L);
            }
            try {
                this.addNotes(types, reservation.getNotesXML());
                this.addNotes(types, reservation.getPerson().getChildren("note"));
            }
            catch (Exception ex) {
                PosUtils.logError(ex);
            }
            super.setNotes(types);
        }
    }

    @Override
    public boolean checkExit() {
        if (((PaReservations)this.paBody).tblReserve.model.data.size() > 0 && ((PaReserveFoot)this.paFoot).bSave.isEnabled()) {
            return super.checkExit();
        }
        return true;
    }

    @Override
    public void refreshImage() {
        ((PaReservations)this.paBody).tblReserve.RefreshImage();
    }

    @Override
    public void processLogin() {
    }
}

