/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.text.MessageFormat;
import jpos.StoreParams;

public enum HeadOfficeError {
    None(0){

        @Override
        public String getErrorMsg() {
            return "";
        }
    }
    ,
    DatabaseMismatch(1){

        @Override
        public String getErrorMsg() {
            return MessageFormat.format(StoreParams.res.getString("HO_DB_Mismatch"), lineFeeds);
        }
    }
    ,
    PosVersionGreaterThanHeadOffice(2){

        @Override
        public String getErrorMsg() {
            return MessageFormat.format(StoreParams.res.getString("POS_Version_Greater_Than_HO"), lineFeeds);
        }
    }
    ,
    StoreNotFound(3){

        @Override
        public String getErrorMsg() {
            return MessageFormat.format(StoreParams.res.getString("HO_Store_NotFound"), lineFeeds);
        }
    };

    private int errorCode;
    private static final Object[] lineFeeds;

    private HeadOfficeError(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public static HeadOfficeError getErrorType(int i) {
        switch (i) {
            case 1: {
                return DatabaseMismatch;
            }
            case 2: {
                return PosVersionGreaterThanHeadOffice;
            }
            case 3: {
                return StoreNotFound;
            }
        }
        return None;
    }

    public abstract String getErrorMsg();

    static {
        lineFeeds = new Object[]{"\n", "\n", "\n"};
    }
}

