/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.FocusManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jpos.ui.TouchTextArea;

public class MLengthTextArea
extends TouchTextArea {
    private int maxLength = -1;

    public MLengthTextArea(int length) {
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        this.maxLength = length;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    MLengthTextArea.this.tabPressed(e);
                }
            }
        });
    }

    private void tabPressed(KeyEvent e) {
        e.consume();
        if (e.isShiftDown()) {
            FocusManager.getCurrentManager().focusPreviousComponent(this);
        } else {
            FocusManager.getCurrentManager().focusNextComponent(this);
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new MaxLengthDocument();
    }

    protected class MaxLengthDocument
    extends PlainDocument {
        protected MaxLengthDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (MLengthTextArea.this.maxLength == -1 || MLengthTextArea.this.maxLength >= MLengthTextArea.this.getDocument().getLength() + str.length()) {
                super.insertString(offs, str, a);
            }
        }
    }
}

