/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import jpos.AttachedLoyaltyManager;
import jpos.DecimalField;
import jpos.DlgManualLoyaltyDiscount;
import jpos.LoyaltyRedemptionPanel;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.person.PersonUtils;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import org.jdom.Element;

public class ManualLoyaltyRedemptionPanel
extends LoyaltyRedemptionPanel {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private LabelNormal lblDiscountTitle = new LabelNormal();
    private LabelNormal lblDiscountName = new LabelNormal();
    private LabelNormal lblPersonTitle = new LabelNormal();
    private LabelNormal lblPersonName = new LabelNormal();
    private LabelNormal lblLoyaltyAmountTitle = new LabelNormal();
    private DecimalField dfLoyaltyAmount;
    private DialogButton bOK;

    public ManualLoyaltyRedemptionPanel(DlgManualLoyaltyDiscount parentDlg) {
        super(parentDlg);
        this.dfLoyaltyAmount = new DecimalField(SP.sParams.storeCurrency);
        this.bOK = new DialogButton("");
        try {
            this.init();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void init() {
        this.lblDiscountTitle.setHorizontalAlignment(2);
        this.lblDiscountTitle.setText(SP.getRS("Loyalty_Program"));
        this.lblDiscountName.setHorizontalAlignment(2);
        this.lblPersonTitle.setHorizontalAlignment(2);
        this.lblPersonTitle.setText(SP.getRS("Person"));
        this.lblPersonName.setHorizontalAlignment(2);
        this.lblLoyaltyAmountTitle.setHorizontalAlignment(2);
        this.lblLoyaltyAmountTitle.setText(SP.getRS("Amount"));
        this.dfLoyaltyAmount.setFieldWidth(110);
        this.dfLoyaltyAmount.setText("0");
        this.bOK.setText(StoreParams.res.getString("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualLoyaltyRedemptionPanel.this.getParentDlg().okDialog();
            }
        });
        this.lblDiscountTitle.setLabelWidth(70);
        this.lblDiscountName.setLabelWidth(320);
        this.lblPersonTitle.setLabelWidth(70);
        this.lblPersonName.setLabelWidth(320);
        this.lblLoyaltyAmountTitle.setLabelWidth(70);
        this.setLayout(this.gridBagLayout);
        this.add((Component)this.lblDiscountTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblDiscountName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblPersonTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblPersonName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblLoyaltyAmountTitle, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.dfLoyaltyAmount, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.bOK, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfLoyaltyAmount);
        v.add(this.bOK);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.getParentDlg().setTitle(SP.getRS("Loyalty_Redemption"));
    }

    @Override
    public double getAmount() {
        return Math.max(this.dfLoyaltyAmount.getDouble(), 0.0);
    }

    @Override
    public void setPerson(Element person) {
        super.setPerson(person);
        this.lblPersonName.setText(PersonUtils.getPerName(person));
    }

    @Override
    public void setLoyaltyInfo(AttachedLoyaltyManager.LoyaltyInfo loyaltyInfo) {
        super.setLoyaltyInfo(loyaltyInfo);
        this.lblDiscountName.setText(loyaltyInfo.getLoyaltyDetails().getDiscount().getName());
    }
}

