/*
 * Decompiled with CFR 0.152.
 */
package jpos.Promotions;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Vector;
import jpos.DiscLine;
import jpos.DlgMessage;
import jpos.MultiLineDisc;
import jpos.PosUtils;
import jpos.Promotions.DataSetHelper;
import jpos.Promotions.DetailRecord;
import jpos.Promotions.JRetailPromotions;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StyleLine;
import jpos.StyleTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PromotionUtils {
    public static final int SKU_ROW = 0;
    public static final int DISCOUNT_ROW = 1;
    public static final int PROMO_ROW = 2;
    public static final int LOYALTY_ROW = 3;
    public static final int COUPON_ROW = 4;
    private static JRetailPromotions retailPromotions = null;

    public static void preInitialiseDiscountEngine() {
        PromotionUtils.getEngine();
        PromotionUtils.resetDiscountEngine();
    }

    private static JRetailPromotions getEngine() {
        if (retailPromotions == null) {
            retailPromotions = new JRetailPromotions();
        }
        return retailPromotions;
    }

    public static void checkPromotionVersion() {
        if (!retailPromotions.promotionsVersionsMatch()) {
            retailPromotions = null;
            retailPromotions = new JRetailPromotions();
        }
    }

    public static void processTransaction(StyleTable tblStyles, String perIdx, boolean enablePromotions, HashMap<String, String> extraProperties) {
        try {
            tblStyles.cleanTableForDiscountEngine();
            String dataset = PromotionUtils.styleTableToXML(tblStyles.model.getData());
            dataset = PromotionUtils.getEngine().ProcessTransactionsFromXmlDataSet(dataset, perIdx, enablePromotions, extraProperties);
            Vector<DetailRecord> detailRecords = PromotionUtils.datasetToDetailRecords(dataset);
            PromotionUtils.mergeStyleTableWithDetailRecords(tblStyles, detailRecords);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            DlgMessage.showMessage(null, e.getMessage());
        }
    }

    public static void resetDiscountEngine() {
        try {
            Document doc = DataSetHelper.createNewDataset();
            String dataset = DataSetHelper.getXmlStringFromXmlDocument(doc);
            PromotionUtils.getEngine().ProcessTransactionsFromXmlDataSet(dataset, "", false, null);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            DlgMessage.showMessage(null, e.getMessage());
        }
    }

    public static String styleTableToXML(Vector<Object> data) {
        try {
            Document doc = DataSetHelper.createNewDataset();
            Element parent = doc.getDocumentElement();
            for (int i = 0; i < data.size(); ++i) {
                DetailRecord detailRecord;
                if ((!(data.elementAt(i) instanceof StyleLine) || !((StyleLine)data.elementAt(i)).isNew()) && (!(data.elementAt(i) instanceof DiscLine) || !((DiscLine)data.elementAt(i)).isNew()) || !(detailRecord = new DetailRecord(data.elementAt(i), i + 1)).isValid()) continue;
                detailRecord.addRecordToNode(parent);
            }
            return DataSetHelper.getXmlStringFromXmlDocument(doc);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return "";
        }
    }

    public static Vector<DetailRecord> datasetToDetailRecords(String xml) {
        Vector<DetailRecord> vRecords = new Vector<DetailRecord>();
        try {
            Document doc = DataSetHelper.getDatasetFromXml(xml);
            NodeList defaultNodes = doc.getElementsByTagName("DEFAULT");
            for (int i = 0; i < defaultNodes.getLength(); ++i) {
                vRecords.add(new DetailRecord(defaultNodes.item(i)));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return vRecords;
    }

    private static void mergeStyleTableWithDetailRecords(StyleTable tblStyles, Vector<DetailRecord> detailRecords) {
        Vector<Object> originalIndexes = new Vector<Object>();
        for (int i = 0; i < tblStyles.model.getData().size(); ++i) {
            originalIndexes.add(tblStyles.model.getData().elementAt(i));
        }
        int row = 0;
        int lastSkuID = 0;
        for (int i = 0; i < detailRecords.size(); ++i) {
            long attachedPromoidx;
            long l = attachedPromoidx = detailRecords.elementAt(i).getAttachedProidx() != null ? PosUtils.longVal(detailRecords.elementAt(i).getAttachedProidx()) : 0L;
            if (detailRecords.elementAt(i).getRowType() == null) continue;
            int rowType = PosUtils.intVal(detailRecords.elementAt(i).getRowType());
            if (rowType == 0) {
                if (PosUtils.intVal(detailRecords.elementAt(i).getItemID()) > 0) {
                    lastSkuID = PosUtils.intVal(detailRecords.elementAt(i).getItemID());
                    ((StyleLine)originalIndexes.elementAt(lastSkuID - 1)).setQty(PosUtils.doubleValInternal(detailRecords.elementAt(i).getQuantity()));
                    ((StyleLine)originalIndexes.elementAt(lastSkuID - 1)).setAttachedPromoIdx(attachedPromoidx);
                    continue;
                }
                if (PosUtils.intVal(detailRecords.elementAt(i).getItemID()) != 0) continue;
                StyleLine originalStyleLine = (StyleLine)originalIndexes.elementAt(lastSkuID - 1);
                long skuidx = originalStyleLine.getSkuidx();
                double quantity = PosUtils.doubleValInternal(detailRecords.elementAt(i).getQuantity());
                StyleLine newLine = new StyleLine(skuidx, quantity, SP.sParams);
                newLine.setOrigQty(0.0);
                newLine.setPrice(originalStyleLine.getPrice());
                newLine.setSplitFromStyleLine(originalStyleLine);
                newLine.setAttachedPromoIdx(attachedPromoidx);
                double origQty = originalStyleLine.getQty();
                double origPacked = originalStyleLine.getPackedQty();
                double origPickup = originalStyleLine.getPickUpQty();
                if (origPacked > origQty) {
                    double pack = origQty;
                    originalStyleLine.setPackedQty(pack);
                    double remainder = origPacked - pack;
                    newLine.setPackedQty(remainder);
                    double origOutstandingPacked = originalStyleLine.getOutstandingPackedQty();
                    if (origPickup > origOutstandingPacked) {
                        double pickup = origOutstandingPacked;
                        originalStyleLine.setPickUpQty(pickup);
                        remainder = origPickup - pickup;
                        newLine.setPickUpQty(remainder);
                    }
                }
                if (!newLine.isValid()) continue;
                for (row = tblStyles.model.getData().indexOf(originalIndexes.elementAt(lastSkuID - 1)) + 1; row < tblStyles.model.getData().size() && !(tblStyles.model.getData().elementAt(row) instanceof StyleLine); ++row) {
                }
                if (row > -1) {
                    tblStyles.model.getData().add(row, newLine);
                } else {
                    tblStyles.model.getData().add(newLine);
                    row = tblStyles.model.getData().size() - 1;
                }
                if (row > -1) {
                    tblStyles.model.fireTableRowsInserted(row, row);
                }
                originalIndexes.add(newLine);
                lastSkuID = originalIndexes.size();
                continue;
            }
            if (rowType == 1 && PosUtils.intVal(detailRecords.elementAt(i).getItemID()) == 0) {
                long discountIdx = PosUtils.longVal(detailRecords.elementAt(i).getIdx());
                row = tblStyles.model.getData().indexOf(originalIndexes.elementAt(lastSkuID - 1));
                tblStyles.setDisc(discountIdx, PosUtils.doubleValInternal(detailRecords.elementAt(i).getPercentage()) * 100.0, row, true, false, -1L, 0L, PromotionUtils.getMessageCode(1, PosUtils.intVal(detailRecords.elementAt(i).getRowState())));
                continue;
            }
            if (rowType == 3) {
                row = tblStyles.model.getData().indexOf(originalIndexes.elementAt(lastSkuID - 1));
                long discountIdx = PosUtils.longVal(detailRecords.elementAt(i).getIdx());
                tblStyles.setDisc(discountIdx, PosUtils.doubleValInternal(detailRecords.elementAt(i).getPercentage()) * 100.0, row, true, true, -1L, 0L, PromotionUtils.getMessageCode(3, PosUtils.intVal(detailRecords.elementAt(i).getRowState())));
                continue;
            }
            if (rowType == 2) {
                row = tblStyles.model.getData().indexOf(originalIndexes.elementAt(lastSkuID - 1));
                long promoIdx = PosUtils.longVal(detailRecords.elementAt(i).getIdx());
                tblStyles.setDisc(720L, PosUtils.doubleValInternal(detailRecords.elementAt(i).getPercentage()) * 100.0, row, true, false, -1L, promoIdx, PromotionUtils.getMessageCode(2, PosUtils.intVal(detailRecords.elementAt(i).getRowState())));
                continue;
            }
            if (rowType != 4) continue;
            row = tblStyles.model.getData().indexOf(originalIndexes.elementAt(lastSkuID - 1));
            long promoIdx = PosUtils.longVal(detailRecords.elementAt(i).getIdx());
            tblStyles.setDisc(849L, PosUtils.doubleValInternal(detailRecords.elementAt(i).getPercentage()) * 100.0, row, true, false, -1L, promoIdx, PromotionUtils.getMessageCode(4, PosUtils.intVal(detailRecords.elementAt(i).getRowState())));
        }
    }

    public static MultiLineDisc.MessageCode getMessageCode(int rowType, int rowState) {
        MultiLineDisc.MessageCode messageCode = MultiLineDisc.MessageCode.NORMAL;
        block0 : switch (rowType) {
            case 3: {
                switch (rowState) {
                    case 0: {
                        messageCode = MultiLineDisc.MessageCode.NORMAL;
                        break block0;
                    }
                    case 1: {
                        messageCode = MultiLineDisc.MessageCode.BASED_ON_ORIG_PRICE;
                        break block0;
                    }
                    case 2: {
                        messageCode = MultiLineDisc.MessageCode.TOTAL_ALREADY_ZERO;
                        break block0;
                    }
                    case 3: {
                        messageCode = MultiLineDisc.MessageCode.NO_FURTHER_DISCOUNTS;
                        break block0;
                    }
                    case 4: {
                        messageCode = MultiLineDisc.MessageCode.OTHER_DISCOUNTS_BETTER_THAN_LOYALTY;
                        break block0;
                    }
                    case 5: {
                        messageCode = MultiLineDisc.MessageCode.MINIMUM_PURCHASE_NOT_REACHED;
                        break block0;
                    }
                }
                messageCode = MultiLineDisc.MessageCode.NORMAL;
                break;
            }
            default: {
                messageCode = MultiLineDisc.MessageCode.NORMAL;
            }
        }
        return messageCode;
    }

    public static String getPromoName(long promoIdx, Connection conn) {
        if (promoIdx == 0L) {
            return "";
        }
        String promoName = "";
        try (SqlQuery sql = new SqlQuery(conn, "SELECT NAME FROM PROMO WHERE PROIDX = " + promoIdx);){
            if (sql.next() && (promoName = sql.getString(1)) == null) {
                promoName = "";
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return promoName;
    }
}

