/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import jpos.PosUtils;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.User;
import jpos.person.PersonUtils;

public class SalesRep {
    private long nMemidx = 0L;
    private long nPeridx = 0L;
    private String sMemName = "";
    private String sPerFirstName = "";
    private String sPerSurName = "";

    public SalesRep() {
    }

    public SalesRep(long memidx, long peridx, String perFirstName, String perSurName, String memName) {
        this.setSalesRep(memidx, peridx, perFirstName, perSurName, memName);
    }

    public SalesRep(User user) {
        this.setSalesRep(user);
    }

    public SalesRep(SalesRep salesRep) {
        this.setSalesRep(salesRep);
    }

    public SalesRep(long peridx, StoreParams sParams) {
        this.setSalesRep(peridx, sParams);
    }

    public long getMemidx() {
        return this.nMemidx;
    }

    public long getPeridx() {
        return this.nPeridx;
    }

    public String getMemName() {
        return this.sMemName;
    }

    public String getPerFirstName() {
        return this.sPerFirstName;
    }

    public String getPerSurName() {
        return this.sPerSurName;
    }

    public String getName() {
        String name = "";
        if (this.sPerFirstName != null && !this.sPerFirstName.equals("")) {
            name = this.sPerFirstName + " ";
        }
        if (this.sPerSurName != null && !this.sPerSurName.equals("")) {
            name = name + this.sPerSurName.substring(0, 1);
        }
        return name;
    }

    public String toString() {
        return this.getName();
    }

    public void setSalesRep(long npMemidx, long npPeridx, String spPerFirstName, String spPerSurName, String spMemName) {
        this.nMemidx = npMemidx;
        this.nPeridx = npPeridx;
        this.sPerFirstName = spPerFirstName;
        this.sPerSurName = spPerSurName;
        this.sMemName = spMemName;
    }

    public void setSalesRep(User pUser) {
        this.nMemidx = pUser.getMemidx();
        this.nPeridx = pUser.getPeridx();
        this.sPerFirstName = pUser.getPerFirstName();
        this.sPerSurName = pUser.getPerSurName();
        this.sMemName = pUser.getMemName();
    }

    public void setSalesRep(SalesRep pSalesRep) {
        this.nMemidx = pSalesRep.getMemidx();
        this.nPeridx = pSalesRep.getPeridx();
        this.sPerFirstName = pSalesRep.getPerFirstName();
        this.sPerSurName = pSalesRep.getPerSurName();
        this.sMemName = pSalesRep.getMemName();
    }

    public void setSalesRep(long npPeridx, StoreParams sParams) {
        this.nPeridx = npPeridx;
        try (SqlQuery sql = new SqlQuery(sParams.conn, "SELECT M.MEMIDX, M.MEMNAME, P.FIRSTNAME, P.SURNAME FROM MEMBER M, PERSON P WHERE M.\"ACTIVE\" = 1 AND M.MEMIDX = P.MEMIDX AND P.PERIDX = " + this.nPeridx);){
            if (sql.next()) {
                this.nMemidx = sql.getLong(1);
                this.sMemName = sql.getString(2);
                this.sPerFirstName = sql.getString(3);
                this.sPerSurName = sql.getString(4);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void clear() {
        this.nMemidx = 0L;
        this.nPeridx = 0L;
        this.sMemName = "";
        this.sPerFirstName = "";
        this.sPerSurName = "";
    }

    public static boolean isSalesRepValid(SalesRep salesRep) {
        return salesRep != null && salesRep.getPeridx() > 0L && salesRep.getMemidx() > 0L && PersonUtils.checkPersonExistsLocally(salesRep.getPeridx());
    }
}

