/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import jpos.PosUtils;
import jpos.SP;
import jpos.basscom.utils.Utils;

public class StkEnquirySettings {
    private boolean showWhseCode = true;
    private boolean showWhseName = false;
    private boolean showWhseRef = false;
    private String whseRefCol = "";
    private String whseRefGroup = "REF1";
    private long whseRefRgidx = 0L;
    public SortBy sortBy = SortBy.TOTAL_STOCK;

    public StkEnquirySettings() {
        this.loadSettings();
    }

    private void loadSettings() {
        Vector<String> settings;
        int tokenCount;
        this.showWhseCode = true;
        this.showWhseName = false;
        this.showWhseRef = false;
        this.whseRefRgidx = 0L;
        this.whseRefCol = "REF1";
        this.whseRefGroup = "";
        if (SP.sParams.sStockEnqSetup != null && SP.sParams.sStockEnqSetup.length() > 0 && (tokenCount = Utils.stringTokenize(SP.sParams.sStockEnqSetup, "@", settings = new Vector<String>())) >= 5) {
            this.showWhseCode = PosUtils.booleanVal(settings.elementAt(0));
            this.showWhseName = PosUtils.booleanVal(settings.elementAt(1));
            this.showWhseRef = PosUtils.booleanVal(settings.elementAt(2));
            this.whseRefRgidx = PosUtils.longVal(settings.elementAt(3));
            switch (PosUtils.intVal(settings.elementAt(4))) {
                case 1: {
                    this.sortBy = SortBy.WHSE_CODE;
                    break;
                }
                case 2: {
                    this.sortBy = SortBy.WHSE_NAME;
                    break;
                }
                case 3: {
                    this.sortBy = SortBy.WHSE_REF;
                    break;
                }
                default: {
                    this.sortBy = SortBy.TOTAL_STOCK;
                }
            }
            if (this.whseRefRgidx != 0L) {
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT A.COLNAME, G.L_NAME FROM REFTBLALL A, REFGRP G WHERE A.TBLIDX = 18 AND A.RGIDX = ? AND A.RGIDX = G.RGIDX");){
                    stmt.setLong(1, this.whseRefRgidx);
                    try (ResultSet r = stmt.executeQuery();){
                        if (r.next()) {
                            this.whseRefCol = r.getString(1);
                            this.whseRefGroup = r.getString(2);
                        }
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
    }

    public boolean isShowWhseCode() {
        return this.showWhseCode;
    }

    public boolean isShowWhseName() {
        return this.showWhseName;
    }

    public boolean isShowWhseRef() {
        return this.showWhseRef;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getWhseRefGroup() {
        return this.whseRefGroup;
    }

    public long getwhseRefRgidx() {
        return this.whseRefRgidx;
    }

    public String getWhseRefCol() {
        return this.whseRefCol;
    }

    public static enum SortBy {
        WHSE_CODE,
        WHSE_NAME,
        WHSE_REF,
        TOTAL_STOCK;

    }
}

