/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Gen;
import ReceiptPrinter.IOErrorHandler;
import ReceiptPrinter.ThreadReceipt;
import bass.eftpos.EFTPOS;
import bass.eftpos.EFTPOSListener;
import bass.eftpos.EFTPOSSettingsPersister;
import bass.eftpos.StringUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import jpos.Currency;
import jpos.DlgMessage;
import jpos.EmailValidator;
import jpos.GeneralTillSettings;
import jpos.HeadOfficeError;
import jpos.OrderCountListener;
import jpos.PosDateFormatter;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.SearchProvider;
import jpos.Security;
import jpos.Settings;
import jpos.SignInSettings;
import jpos.SqlQuery;
import jpos.StatusListener;
import jpos.Store;
import jpos.SystemSettings;
import jpos.UareU.UareUFingerprintProvider;
import jpos.XMLLocal;
import jpos.XMLUtils;
import jpos.basscom.AXGen;
import jpos.basscom.cache.Cacher;
import jpos.basscom.components.ToServ;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.utils.PeriodCalc;
import jpos.basscom.utils.Utils;
import jpos.cachesearches.CacheSearchProvider;
import jpos.display.device.PosSaleDisplayDevice;
import jpos.logging.RollingLog;
import jpos.menu.PosMenuItem;
import jpos.onlinequeries.OnlineQueryProvider;
import jpos.onlinereports.OnlineReportProvider;
import jpos.pay.PayUtils;
import jpos.pay.PaymentGatewayConfig;
import jpos.pay.PrinterProvider;
import jpos.pay.braintree.Braintree;
import jpos.pay.eftpos.EftposUtils;
import jpos.pay.openpay.Openpay;
import jpos.pay.paypal.Paypal;
import jpos.pay.zip.ZipPay;
import jpos.ui.Fonts;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class StoreParams {
    private static String defaultDatabaseEncoding = "";
    public static String VERSION = PosUtils.getAp21VersionNumber(true);
    public static final double MAX_QTY = 9999999.0;
    public static final double MAX_PRICE = 9.99999999E8;
    public static final double MAX_TOTAL_AMOUNT = 9.9999999999E10;
    public static final int ACTIVE_TRAIN = -1;
    public static final int ACTIVE_NORMAL = 1;
    public static ResourceBundle res = ResourceBundle.getBundle("translate", Locale.getDefault());
    public static final String DISC_MSG = res.getString("Discount");
    public static final String LOYALTY_MSG = res.getString("Loyalty_Discount");
    public static final String PROMO_MSG = res.getString("Promotion");
    public static final String COUPON_MSG = res.getString("Coupon");
    public static final String refundmsg = res.getString("Refund_Exchange");
    public static final String refundreasmsg = res.getString("Return_Reason");
    public static final String invalidBarcode = res.getString("invalid");
    public static final String invalidTrans = res.getString("Invalid_Trans_");
    public static final String cartonContentInvalid = res.getString("cartonContentInvalid");
    public static final String totalText = res.getString("Total");
    public static final String noTrans = res.getString("No_Trans_entered");
    public static final String invalidWith = res.getString("Invalid_Withdrawal_");
    public static final long perCaheidx = 321L;
    public static final String perTables = "";
    public static final String perWhere = "(P.RETAIL_CUST = 1 OR P.RETAIL_REP = 1) AND P.\"ACTIVE\"=1";
    private Vector<Store> stores = new Vector();
    public Vector<Reference> carriers = new Vector();
    public Hashtable<String, Long> hGenerators = new Hashtable();
    public Element root;
    protected Cursor commsCursor;
    public static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    public static final Cursor normalCursor = Cursor.getPredefinedCursor(0);
    protected Vector<PosMenuItem> menuReports = new Vector();
    private StatusListener statusListener = new StatusListener();
    private OrderCountListener orderCountListener = new OrderCountListener();
    private Map<PaymentGatewayConfig.PaymentGatewayType, PaymentGatewayConfig> allPaymentGatewayConfigs = new HashMap<PaymentGatewayConfig.PaymentGatewayType, PaymentGatewayConfig>();
    private boolean allPaymentGatewaysPopulated = false;
    private ZipPay zipPay;
    private Braintree braintree;
    private Paypal paypal;
    private Openpay openpay;
    private PaymentGatewayConfig afterpay;
    public OnlineQueryProvider OnlineQueryProvider = null;
    public OnlineReportProvider OnlineReportProvider = null;
    public CacheSearchProvider CacheSearchProvider = null;
    public PrinterProvider PrinterProvider = null;
    public UareUFingerprintProvider FingerprintProvider = null;
    private static String dbHost = "till1";
    static String dbFile = "C:/Program Files/Apparel 21/Apparel 21 POS/pos.fdb";
    private static String dbPort = "3050";
    private static String dbUser = "BASSPOS";
    private static String dbPassword;
    static final String DBURL;
    static final String DBDriver = "org.firebirdsql.jdbc.FBDriver";
    String HOfficeURL;
    public String imagepath;
    String productImagePath;
    String slideShowPath;
    private String logpath;
    private String labelPrintingPath;
    private Boolean escapeLabelPrintStrings;
    public String printerPort;
    String importpath;
    double pollInterval = 0.0;
    String sDatabaseVersion;
    int nPrinterTimeout;
    Store store;
    private long storeCustidx = 0L;
    private String storeACN = "";
    public String tillnum;
    public ToServ iconn;
    public Cacher cacher;
    public Connection conn;
    private Connection sequenceConnection;
    private Connection docketConnection;
    public DecimalFormat currFormat;
    public DecimalFormat currTotFormat;
    public static final DecimalFormat qtyFormat;
    public static final int qtyPrecision = 4;
    public static final DecimalFormat extendedTaxFormat;
    public static final int extendedTaxPrecision = 4;
    public static final DecimalFormat costFormat;
    public DecimalFormat costFormatPublic = new DecimalFormat("#.####");
    public static final int costPrecision = 4;
    private EmailValidator emailValidator = null;
    public String sRetailReferencesToDisplay = "";
    public String saleTypeIdxs = "";
    public String refundTypeIdxs = "";
    private double lbCancFee = 0.0;
    private boolean lbCancFeePer = false;
    private double lbAdminFee = 0.0;
    private boolean lbAdminFeePer = false;
    private double lbMinDepos = 0.0;
    private boolean lbMinDeposAll = false;
    private boolean lbMinDeposPer = false;
    private double lbMinSale = 0.0;
    private double specOrdMinDepos = 0.0;
    private boolean specOrdMinDeposPer = false;
    private double specOrdCancFee = 0.0;
    private boolean specOrdCancFeePer = false;
    private double specOrdAdminFee = 0.0;
    private boolean specOrdAdminFeePer = false;
    private String[] lb_dwmy = new String[2];
    private int[] lb_day = new int[2];
    private int[] lb_week = new int[2];
    private int[] lb_month = new int[2];
    private int[] lb_next_type = new int[2];
    private String LBdateCalc = "";
    public long lbCancFeeSku = 0L;
    public long specOrdAdminFeeSku = 0L;
    public long specOrdCancFeeSku = 0L;
    public long lbAdminFeeSku = 0L;
    private long creditCardFeeSku = 0L;
    long variance_sku = 0L;
    public int nCreditNoteExpiryMonths = 0;
    public boolean bUsingLaybys = false;
    public boolean bUsingSpecialOrders = false;
    long specialOrderRgidx = 0L;
    String specialOrdersRef = "";
    public Vector<String> gvSkus = new Vector();
    public Vector<String> defaultSkus = new Vector();
    public Currency storeCurrency;
    public boolean bUsingDebtorSale = false;
    public boolean bUsingCustOrders = false;
    public boolean bUsingSOHInCustOrders = false;
    public boolean bUsingSOHInStockReceipts = false;
    public boolean bReceiptPerCarton = false;
    boolean kitOrderEntry = false;
    public double EODFloat = 0.0;
    public boolean EODFixed = false;
    boolean last_line_status = false;
    boolean payRefs = false;
    public BJTextField tfHistStore = new BJTextField();
    public BJTextField tfHistAll = new BJTextField();
    public long promptForPerson = 0L;
    public static final long PFP_NO = 0L;
    public static final long PFP_END_OF_SALE = 1L;
    public static final long PFP_START_OF_SALE = 2L;
    private boolean promptForPriceOverrideReason = false;
    String trainUsers = "";
    public boolean integratedEFT = false;
    String eftposDriver = "";
    public EFTPOS eftpos;
    public boolean isEFTPOSLoggedIn = false;
    public boolean bUsingFingerprintLogin = false;
    private boolean bFingerprintChecked = false;
    public boolean bLargeFontForTotals = false;
    public boolean bDoingNewSave = false;
    public boolean bAccuralAccounting = false;
    public Vector<String> vMailOrderCustidxs = new Vector();
    public String sWhseRefSecWherePERSON = "";
    public String sWhseRefSecWhereRETAIL = "";
    public String sWhseRefSecWhereWHSEStkEnq = "";
    public String sWhseRefSecWhereWHSEStkTransOut = "";
    public String sWhseRefSecWhereWHSEStkReceipts = "";
    public String sWhseRefSecWhereWHSETransRequests = "";
    public String sRefSecWhereSUPPLIER = "";
    public String sValidLoyaltyIdxs = "";
    public String sExcludeDefSkusWhere = "";
    public boolean bEnforceFormatting = false;
    public long nMaxSalesReps = 12L;
    private static String sArmsLengthWhere;
    public String eftposReceipt;
    public boolean bUsingExtendedTax = false;
    public boolean bCanRemoveTax = true;
    public boolean bUsingTaxLookup = false;
    public long nPlanningPeriodLevel = 0L;
    public String sStockEnqSetup = "";
    public String sPromptForEmailReceipt = "";
    public boolean bUsingBudgets = false;
    public boolean misMatchVersion = false;
    public boolean useDisplayDevice = false;
    public String displayDeviceName = "";
    public PosSaleDisplayDevice displayDevice = null;
    public boolean bHidePrivateCheckBox = false;
    public int bDefaultPrivateOn;
    public boolean bShipFromCurrentStore = false;
    public boolean allowPartialPacking = false;
    public boolean bDisableReceiptAllCarton = false;
    public boolean bMyFit = false;
    public boolean bAllowSalesRepByLine = false;
    public boolean bAllowAssociationByLine = false;
    public boolean bApplyFTDRestrictions = false;
    public boolean bAccountPayRefs = false;
    public boolean bRecptCost = false;
    public String gatewayIdx = "";
    public boolean bPurgePromoCache = false;
    public boolean bUsingCapillaryRewards = false;
    public EFTPOSListener eftposListener = new EFTPOSListener(){

        public void printReceipt(boolean customerReceipt, boolean signatureRequired, String receipt) {
            StoreParams.this.eftposReceipt = receipt;
            if (!customerReceipt) {
                try {
                    if (signatureRequired) {
                        receipt = receipt + "\n\nSIGNATURE:\n\n\n----------------------------";
                    }
                    IOErrorHandler errorHandler = new IOErrorHandler();
                    ThreadReceipt r = new ThreadReceipt(StoreParams.this.docketConnection, 0L, 0L, false, errorHandler);
                    r.setParams(Gen.DocketType.PRINT_TEXT, null, 0L, receipt, false, null);
                    r.setDaemon(true);
                    r.start();
                    try {
                        r.join(StoreParams.this.nPrinterTimeout * 1000);
                    }
                    catch (InterruptedException e) {
                        PosUtils.logError(e);
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }

        public String translate(String key, Object ... parameters) {
            try {
                return SP.getRS(key, parameters);
            }
            catch (MissingResourceException e) {
                if (parameters != null && parameters.length > 0) {
                    return key + Arrays.toString(parameters);
                }
                return key;
            }
        }
    };
    EFTPOSSettingsPersister eftposSettingsPersister = new EFTPOSSettingsPersister(){

        public void saveSettings(String settings) {
            try (Connection localConnection = StoreParams.createNewConnection();){
                GeneralTillSettings.saveSettings(GeneralTillSettings.SettingsType.EFTPOS, settings, localConnection);
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String loadSettings() {
            try (Connection localConnection = StoreParams.createNewConnection();){
                String string = GeneralTillSettings.loadSettings(GeneralTillSettings.SettingsType.EFTPOS, localConnection);
                return string;
            }
            catch (Exception e) {
                PosUtils.logError(e);
                return StoreParams.perTables;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String loadDeviceKey() {
            try (Connection localConnection = StoreParams.createNewConnection();){
                String string = GeneralTillSettings.getMX51Key(localConnection);
                return string;
            }
            catch (Exception e) {
                PosUtils.logError(e);
                return StoreParams.perTables;
            }
        }

        public String loadAP21Version() {
            return VERSION;
        }
    };

    public static void onFingerPrintScanned(String key) {
        SP.sParams.FingerprintProvider.doOnFingerPrintScanned(key);
    }

    public static Boolean printReceipt(String receipt, Boolean signatureRequired) {
        try {
            receipt = receipt.replace("&#13;&#10;", "&#10;").replace("&#10;", "\r\n");
            SP.sParams.eftposListener.printReceipt(false, signatureRequired.booleanValue(), receipt);
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public static Boolean printReport(String report) {
        try {
            report = report.replace("&#10;", "\n").replace("&#13;", "\r");
            if (!report.endsWith("\n")) {
                report = report + "\n";
            }
            IOErrorHandler errorHandler = new IOErrorHandler();
            ThreadReceipt r = new ThreadReceipt(SP.sParams.docketConnection, 0L, 0L, false, errorHandler);
            r.setParams(Gen.DocketType.PRINT_TEXT, null, 0L, report, false, null);
            r.setDaemon(true);
            r.start();
            try {
                r.join(SP.sParams.nPrinterTimeout * 1000);
                return true;
            }
            catch (InterruptedException e) {
                PosUtils.logError(e);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    public StoreParams() {
        try {
            this.conn = StoreParams.createNewConnection();
            this.docketConnection = StoreParams.createNewConnection();
            this.sequenceConnection = StoreParams.createNewConnection();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(res.getString("Could_not_connect_to"), "\n", ex.getMessage()), res.getString("Error"), 0);
            PosUtils.logError(ex);
            System.exit(0);
        }
    }

    public StoreParams(boolean validate) throws Exception {
        try {
            Object[] objs4;
            Throwable throwable;
            SqlQuery sql;
            boolean exit;
            long widx;
            block191: {
                try {
                    this.tillnum = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, PosUtils.getStackTrace(e), "Error", 0);
                    PosUtils.logError(e);
                }
                try {
                    this.conn = StoreParams.createNewConnection();
                    this.docketConnection = StoreParams.createNewConnection();
                    this.sequenceConnection = StoreParams.createNewConnection();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, MessageFormat.format(res.getString("Could_not_connect_to"), "\n", ex.getMessage()), res.getString("Error"), 0);
                    PosUtils.logError(ex);
                    System.exit(0);
                }
                widx = 0L;
                exit = false;
                sql = new SqlQuery(this.conn, "SELECT HO_ERROR FROM STOREPARAMS WHERE HO_ERROR in (1,2,3)");
                throwable = null;
                try {
                    HeadOfficeError hoError;
                    if (sql.next() && !(hoError = HeadOfficeError.getErrorType(sql.getInt(1))).equals((Object)HeadOfficeError.None) && !hoError.equals((Object)HeadOfficeError.PosVersionGreaterThanHeadOffice)) {
                        JOptionPane.showMessageDialog(null, hoError.getErrorMsg());
                        exit = true;
                    }
                }
                catch (Throwable hoError) {
                    throwable = hoError;
                    throw hoError;
                }
                finally {
                    if (sql != null) {
                        if (throwable != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable hoError) {
                                throwable.addSuppressed(hoError);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
                if (exit) {
                    System.exit(0);
                }
                sql = new SqlQuery(this.conn, "SELECT W.WIDX, S.HEADOFFICEIPSEC, S.IMAGEPATH, S.PRINTERPORT, S.POLL_INTERVAL, S.DIALUPSCRIPT, S.IMPORTPATH, S.FONT, S.FONTSIZE, W.FLOATAMT, W.FLOATFIXED, S.LOOKUP_PRICE, S.LOOKANDFEEL, INTEGRATED_EFT, EFTPOS_DRIVER, S.LOGPATH, COALESCE(MAJOR, 0) || '.' || COALESCE(MINOR, 0) || COALESCE(PATCH, ''), S.PRINTER_TIMEOUT, S.FINGERPRINT, S.LARGE_FONT, COALESCE(W.EXT_TAX, 0), 0, S.LABEL_PRINTING_PATH, S.LABEL_PRINTING_TEMPLATE,  COALESCE(S.LABEL_PRINT_ESCAPE_STRINGS, 1), COALESCE(S.LINE_DISPLAY_DEVICE, 0) AS LINE_DISPLAY_DEVICE, COALESCE(S.LINE_DISPLAY_DEVICE_NAME, '') AS LINE_DISPLAY_DEVICE_NAME, COALESCE(S.AVATAX_LOOKUP, 0), COALESCE(W.CAN_REMOVE_TAX, 0), COALESCE(SSA.hideprivacycheckbox, 0) AS hideprivacycheckbox, COALESCE(SSA.DEFAULT_PRIVACY_ON, 0) AS DEFAULT_PRIVACY_ON, COALESCE(SSA.ALLOW_SHIP_FROM_STORE,0) AS ALLOW_SHIP_FROM_STORE, COALESCE(SSA.ALLOW_PARTIAL_PACKING,0) AS ALLOW_PARTIAL_PACKING, COALESCE(SSA.DISABLE_RECEIPTALL_CARTON,0) AS DISABLE_RECEIPTALL_CARTON, COALESCE(SSA.MYFIT,0) AS MYFIT, COALESCE(SSA.ALLOW_SALES_REP_BY_LINE,0) AS ALLOW_SALES_REP_BY_LINE, COALESCE(SSA.ALLOW_ASSOCIATION_BY_LINE,0) AS ALLOW_ASSOCIATION_BY_LINE, COALESCE(SSA.APPLY_FTD_RESTRICTIONS,0) AS APPLY_FTD_RESTRICTIONS, COALESCE(SSA.ACCPAYREFS,0) AS ACCPAYREFS, COALESCE(SSA.RECPTCOST,0) AS RECPTCOST FROM STOREPARAMS S, WHSE W LEFT JOIN STORE_SETUP_ATTRIBUTES SSA ON w.widx = ssa.widx WHERE W.STORENO = S.STORENO");
                throwable = null;
                try {
                    String fontName;
                    if (!sql.next()) {
                        if (validate) {
                            Object[] objs2 = new Object[]{"\n"};
                            JOptionPane.showMessageDialog(null, MessageFormat.format(res.getString("You_have_not_set_up"), objs2));
                            exit = true;
                        }
                        break block191;
                    }
                    widx = sql.getLong(1);
                    this.HOfficeURL = sql.getString(2);
                    if (this.HOfficeURL == null || this.HOfficeURL.length() == 0) {
                        throw new Exception("Head Office URL is not defined");
                    }
                    if (!this.HOfficeURL.substring(this.HOfficeURL.length() - 1).equals("/")) {
                        this.HOfficeURL = this.HOfficeURL + "/";
                    }
                    this.imagepath = this.formatDirectoryName(sql.getString(3), "images");
                    this.productImagePath = this.imagepath + "ProductImages/";
                    this.slideShowPath = this.imagepath + "SlideShow/";
                    this.logpath = this.formatDirectoryName(sql.getString(16), "logs");
                    this.labelPrintingPath = this.formatDirectoryOrPrinterName(sql.getString(23), "labels");
                    this.escapeLabelPrintStrings = sql.getBoolean(25);
                    this.printerPort = sql.getString(4);
                    if (this.printerPort == null || this.printerPort.length() == 0) {
                        this.printerPort = "lpt1";
                    }
                    this.pollInterval = sql.getDouble(5);
                    this.importpath = this.formatDirectoryName(sql.getString(7), "import");
                    this.EODFloat = sql.getDouble(10);
                    this.EODFixed = sql.getInt(11) == 1;
                    this.integratedEFT = PosUtils.booleanVal(sql.getInt(14));
                    this.eftposDriver = StringUtils.nullToEmpty((String)sql.getString(15));
                    if (this.eftposDriver.isEmpty()) {
                        this.integratedEFT = false;
                    }
                    this.useDisplayDevice = sql.getBoolean("LINE_DISPLAY_DEVICE");
                    this.displayDeviceName = sql.getString("LINE_DISPLAY_DEVICE_NAME");
                    this.sDatabaseVersion = sql.getString(17);
                    this.nPrinterTimeout = sql.getInt(18);
                    this.bFingerprintChecked = sql.getBoolean(19);
                    this.bLargeFontForTotals = sql.getBoolean(20);
                    this.bUsingExtendedTax = PosUtils.booleanVal(sql.getInt(21));
                    this.bUsingTaxLookup = PosUtils.booleanVal(sql.getInt(28));
                    this.bCanRemoveTax = PosUtils.booleanVal(sql.getInt(29));
                    this.bHidePrivateCheckBox = PosUtils.booleanVal(sql.getInt(30));
                    this.bDefaultPrivateOn = sql.getInt(31);
                    this.bShipFromCurrentStore = PosUtils.booleanVal(sql.getInt(32));
                    this.allowPartialPacking = PosUtils.booleanVal(sql.getInt(33));
                    this.bDisableReceiptAllCarton = PosUtils.booleanVal(sql.getInt(34));
                    this.bMyFit = PosUtils.booleanVal(sql.getInt(35));
                    this.bAllowSalesRepByLine = PosUtils.booleanVal(sql.getInt(36));
                    this.bAllowAssociationByLine = PosUtils.booleanVal(sql.getInt(37));
                    this.bApplyFTDRestrictions = PosUtils.booleanVal(sql.getInt(38));
                    this.bAccountPayRefs = PosUtils.booleanVal(sql.getInt(39));
                    this.bRecptCost = PosUtils.booleanVal(sql.getInt(40));
                    if (!VERSION.equals(this.sDatabaseVersion)) {
                        JOptionPane.showMessageDialog(null, res.getString("version_conflict") + ":\n" + res.getString("program_version") + ": " + VERSION + "\n" + res.getString("database_version") + ": " + this.sDatabaseVersion, res.getString("Warning"), 2);
                    }
                    if (sql.getInt(13) == 1) {
                        try {
                            UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(null, AXGen.getStackTrace(e), "Error", 0);
                            PosUtils.logError(e);
                        }
                    }
                    if ((fontName = sql.getString(8)) != null && fontName.length() > 0) {
                        Fonts.changeFontName(fontName);
                    }
                }
                catch (Throwable fontName) {
                    throwable = fontName;
                    throw fontName;
                }
                finally {
                    if (sql != null) {
                        if (throwable != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable fontName) {
                                throwable.addSuppressed(fontName);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            }
            if (exit) {
                System.exit(0);
            }
            sql = new SqlQuery(this.conn, "SELECT W.STORENO, W.WIDX, R.CODE, R.NAME, R.LINKIDX, W.CURRIDX, W.CUSTIDX, L.ACN, L.TRADENAME FROM WHSE W JOIN REFCODE R ON R.RCIDX = W.WIDX LEFT JOIN LOCN L ON R.LINKIDX = L.LOCNIDX WHERE R.RGIDX = 7 AND R.\"ACTIVE\" = 1 ORDER BY R.CODE");
            throwable = null;
            try {
                while (sql.next()) {
                    Store newStore = new Store(sql.getString("NAME"), sql.getString("CODE"), sql.getString("STORENO"), sql.getLong("WIDX"), sql.getString("TRADENAME"), sql.getLong("LINKIDX"));
                    if (widx == newStore.getWidx()) {
                        this.store = newStore;
                        this.storeCurrency = new Currency(this.conn, sql.getString("CURRIDX"));
                        this.currFormat = this.storeCurrency.generateDetailFormat();
                        this.currTotFormat = this.storeCurrency.generateTotalFormat();
                        this.storeCustidx = sql.getLong("CUSTIDX");
                        this.storeACN = sql.getString("ACN");
                    }
                    this.stores.add(newStore);
                }
            }
            catch (Throwable newStore) {
                throwable = newStore;
                throw newStore;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable newStore) {
                            throwable.addSuppressed(newStore);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
            if (this.store == null) {
                Object[] objs3 = new Object[]{"\n"};
                JOptionPane.showMessageDialog(null, MessageFormat.format(res.getString("You_have_not_set_up"), objs3), res.getString("No_Store_data"), 0);
                System.exit(0);
            }
            if (this.bAccountPayRefs) {
                this.store.setStoreCompany(this.getStoreCompany(this.store.getWidx()));
            }
            this.getRetStoreSetup();
            sql = new SqlQuery(this.conn, "SELECT RCIDX, CODE, NAME FROM REFCODE WHERE RGIDX = 202 AND \"ACTIVE\" = 1");
            throwable = null;
            try {
                while (sql.next()) {
                    this.carriers.add(new Reference(sql.getString(3), sql.getString(2), sql.getLong(1)));
                }
            }
            catch (Throwable newStore) {
                throwable = newStore;
                throw newStore;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable newStore) {
                            throwable.addSuppressed(newStore);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
            this.sValidLoyaltyIdxs = perTables;
            sql = new SqlQuery(this.conn, "SELECT RCIDX FROM REFCODE WHERE RGIDX = 366 AND RCIDX <> 787 AND \"ACTIVE\" = 1");
            throwable = null;
            try {
                while (sql.next()) {
                    if (this.sValidLoyaltyIdxs.length() > 0) {
                        this.sValidLoyaltyIdxs = this.sValidLoyaltyIdxs + "," + sql.getString(1);
                        continue;
                    }
                    this.sValidLoyaltyIdxs = sql.getString(1);
                }
            }
            catch (Throwable newStore) {
                throwable = newStore;
                throw newStore;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable newStore) {
                            throwable.addSuppressed(newStore);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
            if (this.sValidLoyaltyIdxs.length() == 0) {
                this.sValidLoyaltyIdxs = "0";
            }
            this.iconn = new ToServ(this.conn);
            this.cacher = new Cacher(1L, this.conn);
            ImageIcon cursorIcon = new ImageIcon(this.imagepath + "comcursor.png");
            this.commsCursor = cursorIcon.getIconHeight() == -1 || cursorIcon.getIconWidth() == -1 ? Cursor.getPredefinedCursor(3) : Toolkit.getDefaultToolkit().createCustomCursor(cursorIcon.getImage(), new Point(0, 0), "Comms cursor");
            this.getReports();
            this.nMaxSalesReps = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.MAX_SALES_REPS_IN_LIST);
            this.sRetailReferencesToDisplay = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.REFERENCES_TO_PROMPT_FOR);
            this.bEnforceFormatting = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_FORMATTING_IN_PERSON_MAINT);
            if (this.sRetailReferencesToDisplay == null || this.sRetailReferencesToDisplay.length() == 0) {
                this.sRetailReferencesToDisplay = "0";
            }
            this.specialOrderRgidx = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.MADE_TO_MEASURE);
            if (this.specialOrderRgidx > 0L) {
                this.bUsingSpecialOrders = true;
                this.specialOrdersRef = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.MADE_TO_MEASURE);
            }
            this.bUsingBudgets = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.BUDGETS);
            this.bUsingFingerprintLogin = SignInSettings.getInstance().isFingerprintEnabled() && this.bFingerprintChecked;
            this.promptForPerson = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.PROMPT_FOR_CUST_ENTRY_SCREEN);
            this.bUsingExtendedTax = this.bUsingExtendedTax && SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.USE_EXTENDED_TAX);
            this.bAccuralAccounting = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.LB_SO_POSTING_METHOD);
            this.nPlanningPeriodLevel = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.RETAIL_PLANNING_PERIODS);
            this.sStockEnqSetup = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.STOCK_ENQUIRY_SETUP);
            this.sPromptForEmailReceipt = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.PROMPT_FOR_DIGITAL_RECEIPT);
            this.promptForPriceOverrideReason = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_FOR_PRICE_OVERRIDE_REASON);
            this.bUsingSOHInCustOrders = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.SHOW_SOH_IN_CUST_ORDERS);
            this.bUsingSOHInStockReceipts = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.SHOW_SOH_IN_STOCK_RECEIPTS);
            this.bReceiptPerCarton = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.RECEIPT_PER_CARTON);
            Vector<String> v627 = new Vector<String>();
            int toks627 = Utils.stringTokenize(SystemSettings.getInstance().getText(SystemSettings.SystemSetting.CREDIT_NOTE_AND_GIFT_VOUCHER_SETUP), "@", v627);
            if (toks627 > 0) {
                this.nCreditNoteExpiryMonths = PosUtils.intVal(v627.elementAt(0));
            }
            String mailOrderCustIn = perTables;
            Long blobidx = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.MAIL_ORDER_SETUP);
            if (blobidx > 0L) {
                mailOrderCustIn = Utils.getBLOBText(this.conn, blobidx);
            } else {
                String sMailOrderCustomers = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.MAIL_ORDER_SETUP);
                if (sMailOrderCustomers != null && sMailOrderCustomers.length() > 0) {
                    Vector<String> vTemp = new Vector<String>();
                    Utils.stringTokenize(sMailOrderCustomers, "@", vTemp);
                    if (vTemp.size() >= 4 && vTemp.elementAt(3) != null && vTemp.elementAt(3).length() > 0) {
                        mailOrderCustIn = vTemp.elementAt(3);
                    }
                }
            }
            if (mailOrderCustIn != null && mailOrderCustIn.length() > 0) {
                Utils.stringTokenize(mailOrderCustIn, ",", this.vMailOrderCustidxs);
            }
            Vector<String> vDefSkus = new Vector<String>();
            Utils.stringTokenize(SystemSettings.getInstance().getText(SystemSettings.SystemSetting.DEFAULT_SKUS), "@", vDefSkus);
            if (vDefSkus.size() > 0) {
                this.lbCancFeeSku = PosUtils.longVal(vDefSkus.elementAt(0));
            }
            if (vDefSkus.size() > 1) {
                this.variance_sku = PosUtils.longVal(vDefSkus.elementAt(1));
            }
            if (vDefSkus.size() > 2) {
                Utils.stringTokenize(vDefSkus.elementAt(2), ",", this.gvSkus);
            }
            if (vDefSkus.size() > 3) {
                this.lbAdminFeeSku = PosUtils.longVal(vDefSkus.elementAt(3));
            }
            if (vDefSkus.size() > 4) {
                this.specOrdCancFeeSku = PosUtils.longVal(vDefSkus.elementAt(4));
            }
            if (vDefSkus.size() > 5) {
                this.specOrdAdminFeeSku = PosUtils.longVal(vDefSkus.elementAt(5));
            }
            if (vDefSkus.size() > 8) {
                this.creditCardFeeSku = PosUtils.longVal(vDefSkus.elementAt(8));
            }
            for (int i = 0; i <= 8; ++i) {
                if (i == 2 || vDefSkus.size() <= i) continue;
                this.defaultSkus.add(vDefSkus.elementAt(i));
            }
            this.defaultSkus.addAll(this.gvSkus);
            try (SqlQuery sql2 = new SqlQuery(this.conn, "SELECT S.STYLEIDX FROM STYLE S, CLR C, SKU K WHERE S.STYLEIDX = C.STYLEIDX AND C.CLRIDX = K.CLRIDX AND K.SKUIDX IN(" + this.lbCancFeeSku + "," + this.variance_sku + "," + this.lbAdminFeeSku + "," + this.specOrdCancFeeSku + "," + this.specOrdAdminFeeSku + ") ");){
                while (sql2.next()) {
                    if (this.sExcludeDefSkusWhere.length() == 0) {
                        this.sExcludeDefSkusWhere = sql2.getString(1);
                        continue;
                    }
                    this.sExcludeDefSkusWhere = this.sExcludeDefSkusWhere + "," + sql2.getString(1);
                }
            }
            if (this.sExcludeDefSkusWhere.length() > 0) {
                this.sExcludeDefSkusWhere = " AND S.STYLEIDX NOT IN (" + this.sExcludeDefSkusWhere + ") ";
            }
            if (SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.TRAINING_USERS) != 0L) {
                sql2 = new SqlQuery(this.conn, "SELECT BLOBTEXT FROM BLOBTEXT WHERE BLOBIDX = " + SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.TRAINING_USERS));
                var12_34 = null;
                try {
                    if (sql2.next()) {
                        this.trainUsers = sql2.getString(1);
                    }
                }
                catch (Throwable throwable2) {
                    var12_34 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sql2 != null) {
                        if (var12_34 != null) {
                            try {
                                sql2.close();
                            }
                            catch (Throwable throwable3) {
                                var12_34.addSuppressed(throwable3);
                            }
                        } else {
                            sql2.close();
                        }
                    }
                }
            }
            sql2 = new SqlQuery(this.conn, "SELECT \"EXTEND\" FROM REFCODE WHERE RGIDX = 379 AND \"ACTIVE\" = 1");
            var12_34 = null;
            try {
                if (sql2.next()) {
                    this.setLBDetails(sql2.getString(1));
                    this.bUsingLaybys = true;
                    if (sql2.next()) {
                        objs4 = new Object[]{"\n", "\n"};
                        JOptionPane.showMessageDialog(null, MessageFormat.format(res.getString("to_many_layby"), objs4), res.getString("Warning"), 2);
                    }
                }
            }
            catch (Throwable objs4) {
                var12_34 = objs4;
                throw objs4;
            }
            finally {
                if (sql2 != null) {
                    if (var12_34 != null) {
                        try {
                            sql2.close();
                        }
                        catch (Throwable objs4) {
                            var12_34.addSuppressed(objs4);
                        }
                    } else {
                        sql2.close();
                    }
                }
            }
            sql2 = new SqlQuery(this.conn, "SELECT \"EXTEND\" FROM REFCODE WHERE RGIDX = 405 AND \"ACTIVE\" = 1");
            var12_34 = null;
            try {
                if (sql2.next()) {
                    this.setSpecOrdDetails(sql2.getString(1));
                    if (sql2.next()) {
                        objs4 = new Object[]{"\n", "\n"};
                        JOptionPane.showMessageDialog(null, MessageFormat.format(res.getString("too_many_specOrd"), objs4), res.getString("Warning"), 2);
                    }
                } else {
                    this.bUsingSpecialOrders = false;
                }
            }
            catch (Throwable throwable4) {
                var12_34 = throwable4;
                throw throwable4;
            }
            finally {
                if (sql2 != null) {
                    if (var12_34 != null) {
                        try {
                            sql2.close();
                        }
                        catch (Throwable throwable5) {
                            var12_34.addSuppressed(throwable5);
                        }
                    } else {
                        sql2.close();
                    }
                }
            }
            if (Security.isFeatureOn(this.conn, 11112L)) {
                this.bUsingDebtorSale = true;
            }
            if (Security.isFeatureOn(this.conn, 11133L)) {
                this.kitOrderEntry = true;
            }
            if (Security.isFeatureOn(this.conn, 11156L)) {
                this.bUsingCustOrders = true;
            }
            String sExtraWhere = perTables;
            if (this.sRetailReferencesToDisplay != null && this.sRetailReferencesToDisplay.length() > 0) {
                sExtraWhere = " AND RGIDX IN(" + this.sRetailReferencesToDisplay + ") ";
            }
            try (SqlQuery sql3 = new SqlQuery(this.conn, "SELECT COUNT(*) FROM REFTBL WHERE TBLIDX = 23 " + sExtraWhere);){
                if (sql3.next()) {
                    this.payRefs = sql3.getInt(1) > 0;
                }
            }
            this.tfHistStore.setVisible(false);
            this.tfHistStore.hideSearchCols(new String[]{"'L' || W.STORENO || H.TRANS_NUMBER", "RW.CODE || CHR(32)"});
            this.tfHistStore.setSearchOrderBy("DESC");
            this.tfHistStore.setTitleExt("- " + res.getString("Hist_for") + " " + this.getStore(this.getStoreIdx()).getName());
            this.tfHistAll.setVisible(false);
            this.tfHistAll.hideSearchCols(new String[]{"'L' || W.STORENO || H.TRANS_NUMBER"});
            this.tfHistAll.setSearchOrderBy("DESC");
            this.tfHistAll.setTitleExt("- " + res.getString("Hist_for") + " " + res.getString("All_Stores"));
            if (this.integratedEFT) {
                this.eftpos = (EFTPOS)Class.forName(this.eftposDriver).newInstance();
            }
            this.sWhseRefSecWherePERSON = Utils.GetWhseSecWhereSQL(this.conn, this.getStoreIdx(), 0, "P", 1);
            if (this.sWhseRefSecWherePERSON != null && this.sWhseRefSecWherePERSON.length() > 0) {
                this.sWhseRefSecWherePERSON = " AND " + this.sWhseRefSecWherePERSON;
            }
            this.sWhseRefSecWhereRETAIL = Utils.GetWhseSecWhereSQL(this.conn, this.getStoreIdx(), 1, "H", 1);
            if (this.sWhseRefSecWhereRETAIL != null && this.sWhseRefSecWhereRETAIL.length() > 0) {
                this.sWhseRefSecWhereRETAIL = " AND " + this.sWhseRefSecWhereRETAIL;
            }
            this.sWhseRefSecWhereWHSEStkEnq = Utils.GetWhseSecWhereSQL(this.conn, this.getStoreIdx(), 2, "W", 1);
            if (this.sWhseRefSecWhereWHSEStkEnq != null && this.sWhseRefSecWhereWHSEStkEnq.length() > 0) {
                this.sWhseRefSecWhereWHSEStkEnq = " AND " + this.sWhseRefSecWhereWHSEStkEnq;
            }
            this.sWhseRefSecWhereWHSEStkTransOut = Utils.GetWhseSecWhereSQL(this.conn, this.getStoreIdx(), 3, "W", 1);
            if (this.sWhseRefSecWhereWHSEStkTransOut != null && this.sWhseRefSecWhereWHSEStkTransOut.length() > 0) {
                this.sWhseRefSecWhereWHSEStkTransOut = " AND " + this.sWhseRefSecWhereWHSEStkTransOut;
            }
            this.sWhseRefSecWhereWHSETransRequests = Utils.GetWhseSecWhereSQL(this.conn, this.getStoreIdx(), 5, "W", 1);
            if (this.sWhseRefSecWhereWHSETransRequests != null && this.sWhseRefSecWhereWHSETransRequests.length() > 0) {
                this.sWhseRefSecWhereWHSETransRequests = " AND " + this.sWhseRefSecWhereWHSETransRequests;
            }
            this.sWhseRefSecWhereWHSEStkReceipts = Utils.GetWhseSecWhereSQL(this.conn, this.getStoreIdx(), 4, "W", 1);
            if (this.sWhseRefSecWhereWHSEStkReceipts != null && this.sWhseRefSecWhereWHSEStkReceipts.length() > 0) {
                this.sWhseRefSecWhereWHSEStkReceipts = " AND " + this.sWhseRefSecWhereWHSEStkReceipts;
            }
            this.sRefSecWhereSUPPLIER = Utils.GetWhseSecWhereSQL(this.conn, this.getStoreIdx(), 6, "SR", 1);
            if (this.sRefSecWhereSUPPLIER == null) {
                this.sRefSecWhereSUPPLIER = perTables;
            } else if (this.sRefSecWhereSUPPLIER.length() > 0) {
                this.sRefSecWhereSUPPLIER = " and " + this.sRefSecWhereSUPPLIER;
            }
            this.OnlineQueryProvider = new OnlineQueryProvider(this);
            this.OnlineReportProvider = new OnlineReportProvider(this);
            this.CacheSearchProvider = new CacheSearchProvider(this);
            this.PrinterProvider = new PrinterProvider();
            if (this.bUsingFingerprintLogin) {
                this.FingerprintProvider = new UareUFingerprintProvider(this);
            }
            this.iconn.setSearchProvider(new SearchProvider(this));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, PosUtils.getStackTrace(e), "Error", 0);
            PosUtils.logError(e);
            throw e;
        }
    }

    private boolean openEFTPOS(PosFrame frame, Element hoSettings) {
        boolean result = false;
        StringBuffer retMessage = new StringBuffer();
        if (this.eftpos.open(this.eftposListener, this.eftposSettingsPersister, this.getStore().getStoreNo(), hoSettings, retMessage)) {
            if (retMessage.length() > 0) {
                DlgMessage.showMessage(frame, retMessage.toString(), this.eftpos.getProviderName(), -1, 2);
            }
            this.isEFTPOSLoggedIn = true;
            result = true;
        } else {
            EftposUtils.debugPoint(frame, "Eftpos failed to initialise.\n" + retMessage.toString());
        }
        return result;
    }

    private int getStoreCompany(long widx) {
        Throwable throwable;
        SqlQuery sql;
        String refCol = perTables;
        int storeCompany = -1;
        try {
            sql = new SqlQuery(this.conn, "SELECT 'REF' || rg_ord FROM refobj o JOIN reftbl t ON t.tblname = o.tblname WHERE o.table_name = 'WHSE' AND rgidx = 22");
            throwable = null;
            try {
                if (sql.next()) {
                    refCol = sql.getString(1);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        try {
            sql = new SqlQuery(this.conn, "SELECT c.code FROM whse w JOIN refcode c ON c.rcidx = w." + refCol + " " + "WHERE w.widx = " + widx);
            throwable = null;
            try {
                if (sql.next()) {
                    storeCompany = sql.getInt(1);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return storeCompany;
    }

    public void initEFTPOS() {
        PosFrame frame;
        block11: {
            if (!this.integratedEFT || this.isEFTPOSLoggedIn) {
                return;
            }
            frame = PosMenuController.getInstance().getOpenFrame();
            try {
                int retryDialogOption;
                Element hoSettings = null;
                if (this.eftpos.getProviderName().equalsIgnoreCase("Adyen")) {
                    PaymentGatewayConfig adyen = new PaymentGatewayConfig(PaymentGatewayConfig.PaymentGatewayType.ADYEN, false);
                    hoSettings = adyen.getPaymentGatewayXml();
                    this.gatewayIdx = adyen.getGatewayIdx();
                }
                if (this.openEFTPOS(frame, hoSettings)) break block11;
                do {
                    if ((retryDialogOption = DlgMessage.showMessage(frame, res.getString("iEFTPOS_Connection_Fail_Message"), res.getString("iEFTPOS_Connection_Fail_Title"), 3, 0)) == 0) {
                        if (!this.openEFTPOS(frame, hoSettings)) continue;
                    } else {
                        this.integratedEFT = false;
                    }
                    break;
                } while (retryDialogOption == 0);
            }
            catch (Exception ex) {
                PosUtils.logError(ex);
                this.integratedEFT = false;
            }
        }
        if (frame != null) {
            frame.configureEftposMenu();
        }
        if (this.integratedEFT && this.isEFTPOSLoggedIn) {
            try {
                this.reverseIncompleteEFTs(frame);
            }
            catch (Exception ex) {
                PosUtils.logError(ex);
            }
        }
    }

    public boolean reverseIncompleteEFTs(Window parent) {
        PayUtils.checkEFTsInProgessDet(parent);
        return PayUtils.checkEFTsInProgessHdr();
    }

    public boolean getXML(PosFrame frame, String action, String data, boolean online) {
        if (online) {
            return this.getXML(frame, action, data);
        }
        try {
            this.root = XMLLocal.getElement(this.conn, action, data);
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public boolean getXML(PosFrame frame, String action, String data) {
        StringBuffer retdata = new StringBuffer();
        this.root = null;
        boolean retVal = true;
        Cursor frameCursor = frame.getCursor();
        frame.setCursor(this.commsCursor);
        if (this.iconn.postToServlet(action, data, "jpos.basscom.servlets.XmlServ", this.conn, retdata, false, false) == 0) {
            this.last_line_status = false;
            frame.menu.setStatus(false);
            retVal = false;
        } else {
            try {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((Reader)new StringReader(retdata.toString()));
                this.root = doc.getRootElement();
                if (this.root.getName().equals("error")) {
                    if (!this.root.getAttribute("desc").getValue().equals("No Docket")) {
                        DlgMessage.showMessage(frame, this.root.getAttribute("desc").getValue(), res.getString("Error"), -1, 0);
                    }
                    retVal = false;
                } else if (this.root.getAttribute("version") == null) {
                    Object[] objs = new Object[]{"\n"};
                    if (JOptionPane.showConfirmDialog(frame, res.getString("pre_701") + "\n" + MessageFormat.format(res.getString("exp_problems"), objs), res.getString("Warning"), 0, 2) == 1) {
                        retVal = false;
                    }
                } else if (!this.root.getAttribute("version").getValue().equals(VERSION)) {
                    Object[] objs = new Object[]{"\n"};
                    if (JOptionPane.showConfirmDialog(frame, res.getString("web_server_version") + " " + this.root.getAttribute("version").getValue() + "\n" + res.getString("store_version") + " " + VERSION + "\n" + MessageFormat.format(res.getString("exp_problems"), objs), res.getString("Warning"), 0, 2) == 1) {
                        retVal = false;
                    }
                } else {
                    this.root.removeAttribute("version");
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
                retVal = false;
            }
        }
        frame.setCursor(frameCursor);
        return retVal;
    }

    public boolean checkIConn() {
        return this.checkIConn(this.conn);
    }

    public boolean checkIConn(Connection connection) {
        return this.iconn.getStatus(connection) == 1;
    }

    public long getVarianceSku() {
        return this.variance_sku;
    }

    public long getStoreIdx() {
        return this.store.getWidx();
    }

    public Store getStore() {
        return this.store;
    }

    public Store getStore(long widx) {
        for (int i = 0; i < this.stores.size(); ++i) {
            if (this.stores.elementAt(i).getWidx() != widx) continue;
            return this.stores.elementAt(i);
        }
        return new Store("unknown", res.getString("unknown"), "000", widx);
    }

    public Store getStore(String storenum) {
        for (int i = 0; i < this.stores.size(); ++i) {
            if (!this.stores.elementAt(i).getStoreNo().equals(storenum)) continue;
            return this.stores.elementAt(i);
        }
        return null;
    }

    public int executeSequenceUpdate(String updateSql, Object ... binds) throws SQLException {
        try {
            return SqlQuery.executeUpdate(this.sequenceConnection, updateSql, binds);
        }
        catch (SQLException e) {
            this.resetSequenceConnection();
            return SqlQuery.executeUpdate(this.sequenceConnection, updateSql, binds);
        }
    }

    public long getNextTransferNum(String requestedFrom) throws Exception {
        return this.getNextTransactionNum("TRANSFER_NUM", requestedFrom);
    }

    public long getNextCreditNum(String requestedFrom) throws Exception {
        return this.getNextTransactionNum("CREDITNOTE_NUM", requestedFrom);
    }

    public long getNextLayByNum(String requestedFrom) throws Exception {
        return this.getNextTransactionNum("LAYBY_NUM", requestedFrom);
    }

    public long getNextSpecialOrderNum(String requestedFrom) throws Exception {
        return this.getNextTransactionNum("SPECORDER_NUM", requestedFrom);
    }

    public long getNextCustomerOrderNum(String requestedFrom) throws Exception {
        return this.getNextTransactionNum("CUSTORDER_NUM", requestedFrom);
    }

    public long getNextDocketNum(String requestedFrom) throws SQLException {
        return this.getNextTransactionNum("DOCKET_NUM", requestedFrom);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getNextTransactionNumTry(String columnName, String requestedFrom) {
        long transnum = -1L;
        try (PreparedStatement stmt = this.sequenceConnection.prepareStatement("UPDATE WHSE SET " + columnName + " = COALESCE(" + columnName + ", 0)+1 " + "WHERE WIDX = ? RETURNING " + columnName);){
            stmt.setLong(1, this.getStoreIdx());
            try (ResultSet results = stmt.executeQuery();){
                if (results.next()) {
                    transnum = results.getLong(1);
                    RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, String.format("Next %s Sequence %s requested from %s", columnName, transnum, requestedFrom));
                }
            }
            long l = transnum;
            return l;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return -1L;
        }
    }

    private long getNextTransactionNum(String columnName, String requestedFrom) {
        long transnum = -1L;
        JDialog dialog = null;
        try {
            if (!this.conn.isValid(0)) {
                PosUtils.logError(String.format("Blocked next %s sequence request from %s due to broken main connection.", columnName, requestedFrom));
                return transnum;
            }
        }
        catch (SQLException e) {
            PosUtils.logError(String.format("Blocked next %s sequence request from %s due to broken main connection. (SQLException: %s)", columnName, requestedFrom, e.getMessage()));
            return transnum;
        }
        for (long waitCount = 1L; waitCount < 7L; ++waitCount) {
            if (waitCount == 2L) {
                dialog = this.getOptionPane();
            }
            if ((transnum = this.getNextTransactionNumTry(columnName, requestedFrom)) != -1L) {
                if (dialog != null) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
                return transnum;
            }
            try {
                TimeUnit.SECONDS.sleep(waitCount);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.resetSequenceConnection();
        }
        return transnum;
    }

    private void resetSequenceConnection() {
        this.closeSequenceConnection();
        try {
            this.sequenceConnection = StoreParams.createNewConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JDialog getOptionPane() {
        JOptionPane pane = new JOptionPane();
        pane.setMessage(res.getString("Failed_Communication_To_Main_Till"));
        JDialog dialog = pane.createDialog(null, "Warning");
        dialog.setModal(false);
        dialog.setVisible(true);
        return dialog;
    }

    public double getLBCancFee(double due) {
        if (this.bUsingExtendedTax) {
            return 0.0;
        }
        if (this.lbCancFeePer) {
            return this.rnd(due * (this.lbCancFee / 100.0));
        }
        return this.rnd(this.lbCancFee);
    }

    public double getLBAdminFee(double due) {
        if (this.bUsingExtendedTax) {
            return 0.0;
        }
        if (this.lbAdminFeePer) {
            return this.rnd(due * (this.lbAdminFee / 100.0));
        }
        return this.rnd(this.lbAdminFee);
    }

    public double getMinLbSale() {
        return this.lbMinSale;
    }

    public boolean getLbMinDeposAll() {
        return this.lbMinDeposAll;
    }

    public double getMinLbDep(double due) {
        if (this.lbMinDeposPer) {
            return this.rnd(due * (this.lbMinDepos / 100.0));
        }
        return this.rnd(this.lbMinDepos);
    }

    public double getSpecOrdCancFee(double due) {
        if (this.bUsingExtendedTax) {
            return 0.0;
        }
        if (this.specOrdCancFeePer) {
            return this.rnd(due * (this.specOrdCancFee / 100.0));
        }
        return this.rnd(this.specOrdCancFee);
    }

    public double getSpecOrdAdminFee(double due) {
        if (this.bUsingExtendedTax) {
            return 0.0;
        }
        if (this.specOrdAdminFeePer) {
            return this.rnd(due * (this.specOrdAdminFee / 100.0));
        }
        return this.rnd(this.specOrdAdminFee);
    }

    public double getMinSpecOrdDep(double due) {
        if (this.specOrdMinDeposPer) {
            return this.rnd(due * (this.specOrdMinDepos / 100.0));
        }
        return this.rnd(this.specOrdMinDepos);
    }

    private static String getDatabaseEncoding(String username, String password) {
        if (defaultDatabaseEncoding.length() == 0) {
            try {
                defaultDatabaseEncoding = "NONE";
                Class.forName(DBDriver);
                Properties props = new Properties();
                props.setProperty("user", username);
                props.setProperty("password", password);
                try (Connection connection = DriverManager.getConnection(DBURL, props);
                     SqlQuery s = new SqlQuery(connection, "SELECT TRIM(COALESCE(RDB$CHARACTER_SET_NAME, 'NONE')) FROM RDB$DATABASE");){
                    if (s.next()) {
                        defaultDatabaseEncoding = s.getString(1);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultDatabaseEncoding;
    }

    public static Connection createNewConnection() throws Exception {
        Connection connection = null;
        String encoding = StoreParams.getDatabaseEncoding(dbUser, dbPassword);
        try {
            Class.forName(DBDriver);
            Properties props = new Properties();
            props.setProperty("user", dbUser);
            props.setProperty("password", dbPassword);
            props.setProperty("encoding", encoding);
            connection = DriverManager.getConnection(DBURL, props);
            connection.setHoldability(1);
        }
        catch (SQLException e) {
            throw new Exception(" \nDatabaseURL:" + DBURL + " User:" + dbUser + "\n" + e.getMessage());
        }
        return connection;
    }

    public static Connection getSysdbaConn() throws Exception {
        Connection connection = null;
        String encoding = StoreParams.getDatabaseEncoding(dbUser, dbPassword);
        try {
            Class.forName(DBDriver);
            Properties props = new Properties();
            props.setProperty("user", "SYSDBA");
            props.setProperty("password", "S5Y7S3D9BA");
            props.setProperty("encoding", encoding);
            connection = DriverManager.getConnection(DBURL, props);
            connection.setHoldability(1);
        }
        catch (SQLException e) {
            throw new Exception(" \nDatabaseURL:" + DBURL + " User:" + "SYSDBA" + "\n" + e.getMessage());
        }
        return connection;
    }

    public Statement getStmt() {
        try {
            if (this.conn == null) {
                throw new SQLException(res.getString("Could_not_connect_to1"));
            }
            return this.conn.createStatement();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return null;
        }
    }

    public double rnd(double val) {
        return this.storeCurrency.round(val);
    }

    public double rndEven(double val) {
        return this.storeCurrency.roundEven(val);
    }

    public double rndEvenRecall(double val) {
        return this.storeCurrency.roundEvenRecall(val);
    }

    public Date getLDueDate(String dateCalc) {
        this.setDateCalc(dateCalc);
        if (this.lb_dwmy[0] != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setLenient(true);
            cal.add(5, 1);
            Date d = new Date(PeriodCalc.getNextDate(this.lb_dwmy[0], this.lb_day[0], this.lb_week[0], this.lb_month[0], this.lb_next_type[0], cal).getTime().getTime());
            PosDateFormatter.truncateTime(d);
            return d;
        }
        return null;
    }

    public Date getPDueDate(String dateCalc, Date date) {
        this.setDateCalc(dateCalc);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        Date d = null;
        if (this.lb_dwmy[1] != null && !this.lb_dwmy[1].equals(perTables)) {
            d = new Date(PeriodCalc.getNextDate(this.lb_dwmy[1], this.lb_day[1], this.lb_week[1], this.lb_month[1], this.lb_next_type[1], cal).getTime().getTime());
            PosDateFormatter.truncateTime(d);
            return d;
        }
        return null;
    }

    private void getReports() {
        this.loadAp21InsightMenuItem();
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT G.DESCRIP, G.GENREPIDX, G.BLOBIDX FROM GENREP G WHERE G.\"ACTIVE\" = 1 ORDER BY G.DESCRIP");){
            while (sql.next()) {
                PosMenuItem menuRunReport = new PosMenuItem(sql.getString(1));
                if (sql.getLong(3) == 0L) {
                    menuRunReport.setActionCommand("8@" + sql.getString(2));
                } else {
                    menuRunReport.setActionCommand("9@" + sql.getString(2));
                }
                this.menuReports.add(menuRunReport);
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void loadAp21InsightMenuItem() {
        String param = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.AP21_INSIGHT);
        if (param == null || param.split("@", 2)[0].isEmpty()) {
            return;
        }
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT 1 FROM WHSE_API WHERE WIDX = ? AND API_TYPE = 'TRS' AND \"ACTIVE\" = 0", this.getStoreIdx());){
            if (sql.next()) {
                return;
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        PosMenuItem menuInsight = new PosMenuItem(res.getString("Ap21_Insight"));
        menuInsight.setActionCommand(String.valueOf(29) + "@" + param);
        this.menuReports.add(menuInsight);
    }

    private void setLBDetails(String extend) {
        StringTokenizer toks = new StringTokenizer(extend, "@", true);
        if (toks.countTokens() > 15) {
            String token = toks.nextToken();
            if (!token.equals("@")) {
                this.lbMinSale = PosUtils.doubleValInternal(token);
                toks.nextToken();
                extend = extend.substring(extend.indexOf("@"));
            }
            extend = extend.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                if (token.indexOf(",") > -1) {
                    this.lbMinDepos = PosUtils.doubleValInternal(token.substring(0, token.indexOf(",")));
                    this.lbMinDeposAll = PosUtils.booleanVal(token.substring(token.indexOf(",") + 1));
                } else {
                    this.lbMinDepos = PosUtils.doubleValInternal(token);
                }
                toks.nextToken();
                extend = extend.substring(extend.indexOf("@"));
            }
            extend = extend.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lbMinDeposPer = !PosUtils.booleanVal(token);
                toks.nextToken();
                extend = extend.substring(extend.indexOf("@"));
            }
            extend = extend.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lbCancFee = PosUtils.doubleValInternal(token);
                toks.nextToken();
                extend = extend.substring(extend.indexOf("@"));
            }
            extend = extend.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lbCancFeePer = !PosUtils.booleanVal(token);
                toks.nextToken();
                extend = extend.substring(extend.indexOf("@"));
            }
            if ((toks = new StringTokenizer(extend = this.setDateCalc(this.LBdateCalc = extend.substring(1)), "@", true)).hasMoreTokens()) {
                token = toks.nextToken();
                if (!token.equals("@")) {
                    this.lbAdminFee = PosUtils.doubleValInternal(token);
                    toks.nextToken();
                    extend = extend.substring(extend.indexOf("@"));
                    this.LBdateCalc = this.LBdateCalc.substring(0, this.LBdateCalc.length() - 1);
                }
                extend = extend.substring(1);
                this.LBdateCalc = this.LBdateCalc.substring(0, this.LBdateCalc.length() - 1);
                token = toks.nextToken();
                if (!token.equals("@")) {
                    this.lbAdminFeePer = !PosUtils.booleanVal(token);
                    this.LBdateCalc = this.LBdateCalc.substring(0, this.LBdateCalc.lastIndexOf("@"));
                }
            }
        }
    }

    private void setSpecOrdDetails(String extend) {
        Vector<String> vect = new Vector<String>(6);
        if (Utils.stringTTokenize(extend, "@", vect) == 6) {
            this.specOrdMinDepos = PosUtils.doubleValInternal(vect.get(0));
            this.specOrdMinDeposPer = vect.get(1).equals("0");
            this.specOrdCancFee = PosUtils.doubleValInternal(vect.get(2));
            this.specOrdCancFeePer = vect.get(3).equals("0");
            this.specOrdAdminFee = PosUtils.doubleValInternal(vect.get(4));
            this.specOrdAdminFeePer = vect.get(5).equals("0");
        }
    }

    private String setDateCalc(String dateCalc) {
        try {
            StringTokenizer toks = new StringTokenizer(dateCalc, "@", true);
            String token = toks.nextToken();
            if (!token.equals("@")) {
                this.lb_dwmy[0] = token;
                toks.nextToken();
                dateCalc = dateCalc.substring(dateCalc.indexOf("@"));
            } else {
                this.lb_dwmy[0] = null;
            }
            dateCalc = dateCalc.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lb_day[0] = PosUtils.intVal(token);
                toks.nextToken();
                dateCalc = dateCalc.substring(dateCalc.indexOf("@"));
            } else {
                this.lb_day[0] = -1;
            }
            dateCalc = dateCalc.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lb_week[0] = PosUtils.intVal(token);
                toks.nextToken();
                dateCalc = dateCalc.substring(dateCalc.indexOf("@"));
            } else {
                this.lb_week[0] = -1;
            }
            dateCalc = dateCalc.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lb_month[0] = PosUtils.intVal(token);
                toks.nextToken();
                dateCalc = dateCalc.substring(dateCalc.indexOf("@"));
            } else {
                this.lb_month[0] = -1;
            }
            dateCalc = dateCalc.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lb_next_type[0] = PosUtils.intVal(token);
                toks.nextToken();
                dateCalc = dateCalc.substring(dateCalc.indexOf("@"));
            } else {
                this.lb_next_type[0] = -1;
            }
            dateCalc = dateCalc.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lb_dwmy[1] = token;
                toks.nextToken();
                dateCalc = dateCalc.substring(dateCalc.indexOf("@"));
            } else {
                this.lb_dwmy[1] = null;
            }
            dateCalc = dateCalc.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lb_day[1] = PosUtils.intVal(token);
                toks.nextToken();
                dateCalc = dateCalc.substring(dateCalc.indexOf("@"));
            } else {
                this.lb_day[1] = -1;
            }
            dateCalc = dateCalc.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lb_week[1] = PosUtils.intVal(token);
                toks.nextToken();
                dateCalc = dateCalc.substring(dateCalc.indexOf("@"));
            } else {
                this.lb_week[1] = -1;
            }
            dateCalc = dateCalc.substring(1);
            token = toks.nextToken();
            if (!token.equals("@")) {
                this.lb_month[1] = PosUtils.intVal(token);
                toks.nextToken();
                dateCalc = dateCalc.substring(dateCalc.indexOf("@"));
            } else {
                this.lb_month[1] = -1;
            }
            try {
                dateCalc = dateCalc.substring(1);
                token = toks.nextToken();
                if (!token.equals("@")) {
                    this.lb_next_type[1] = PosUtils.intVal(token);
                    dateCalc = dateCalc.substring(1);
                } else {
                    this.lb_next_type[1] = -1;
                }
            }
            catch (Exception e) {
                this.lb_next_type[1] = -1;
            }
            if (dateCalc.length() > 0) {
                dateCalc = dateCalc.substring(1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return dateCalc;
    }

    protected String getLBDateCalc() {
        return this.LBdateCalc;
    }

    public boolean isLaybyFeeSku(long skuidx) {
        return skuidx == this.lbAdminFeeSku || skuidx == this.lbCancFeeSku;
    }

    public void dispose() {
        try {
            this.disposeFingerprintProvider();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
        try {
            this.disposeDisplayDevice();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.closeSequenceConnection();
        if (this.docketConnection != null) {
            try {
                this.docketConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeSequenceConnection() {
        if (this.sequenceConnection != null) {
            try {
                this.sequenceConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void yTabInsert(String sTableName, String sColumnName, String sIdx) {
        try (Statement stmt = this.getStmt();){
            stmt.executeUpdate("INSERT into Y" + sTableName + "(Y" + sColumnName + ", " + sColumnName + ")" + " values(" + this.nextVal("XY" + sTableName) + ", " + sIdx + ")");
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public long nextVal(String sGenerator) {
        long nNextVal = 0L;
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT " + PosUtils.nextValSyntax(sGenerator) + " FROM DUAL");){
            if (sql.next()) {
                nNextVal = sql.getLong(1);
                this.hGenerators.put(sGenerator, new Long(nNextVal));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return nNextVal;
    }

    public long currVal(String sGenerator) {
        Long nCurrVal = this.hGenerators.get(sGenerator);
        sGenerator = sGenerator.toUpperCase();
        if (nCurrVal != null) {
            return nCurrVal;
        }
        PosUtils.logError("FATAL ERROR: Failed to get currVal for generator: " + sGenerator);
        JOptionPane.showMessageDialog(null, res.getString("generator_error") + "\nGenerator: " + sGenerator, res.getString("Warning"), 0);
        System.exit(0);
        return 0L;
    }

    public void runHelp() {
        try {
            Runtime.getRuntime().exec("ShellExecNormal.exe " + this.HOfficeURL + "WebHelp/Retail_POS.htm");
        }
        catch (Exception e2) {
            PosUtils.logError(e2);
        }
    }

    public void runOnlineTraining() {
        try {
            Runtime.getRuntime().exec("ShellExecNormal.exe http://help.apparel21.com");
        }
        catch (Exception e2) {
            PosUtils.logError(e2);
        }
    }

    private void getRetStoreSetup() {
        boolean exit = false;
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT SALE_TYP_IDXS, REFUND_TYP_IDXS from RET_STORE_SETUP");){
            if (!sql.next()) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(res.getString("You_have_not_set_up_payments"), "\n"), res.getString("No_Tender_data"), 0);
                exit = true;
            } else {
                this.saleTypeIdxs = sql.getString(1);
                this.refundTypeIdxs = sql.getString(2);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        if (exit) {
            System.exit(0);
        }
        if (this.saleTypeIdxs == null || this.saleTypeIdxs.equals(" ")) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(res.getString("You_have_not_set_up_payments"), "\n"), res.getString("No_Tender_data"), 0);
            System.exit(0);
        }
    }

    public long getStoreCustidx() {
        return this.storeCustidx;
    }

    public String getStoreACN() {
        if (this.storeACN == null) {
            return perTables;
        }
        return this.storeACN;
    }

    public String getArmsLengthWhere() {
        if (sArmsLengthWhere.length() == 0) {
            sArmsLengthWhere = " AND ((W.CURRIDX = (SELECT CURRIDX FROM WHSE WHERE WIDX = " + this.getStoreIdx() + ")) ";
            if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.AUTO_INTER_COMPANY_TRANS)) {
                try (SqlQuery sql = new SqlQuery(this.conn, "SELECT 'REF' || RG_ORD FROM REFTBL WHERE TBLIDX = 18 AND RGIDX = 22");){
                    if (sql.next()) {
                        sArmsLengthWhere = sArmsLengthWhere + " OR (W." + sql.getString(1) + "  <> (SELECT " + sql.getString(1) + " FROM WHSE WHERE WIDX = " + this.getStoreIdx() + ")) ";
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
            sArmsLengthWhere = sArmsLengthWhere + ")";
        }
        return sArmsLengthWhere;
    }

    public static String getDbHost() {
        return dbHost;
    }

    public static String getDbFile() {
        return dbFile;
    }

    public static String getDbUser() {
        return dbUser;
    }

    public static String getDbPassword() {
        return dbPassword;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getNextTillSequence() {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT COALESCE(SEQ,0) + 1 FROM TILL_SEQUENCE WHERE TILL_NAME = " + PosUtils.StringToSqlString(this.tillnum));){
            if (sql.next()) {
                long l2 = sql.getLong(1);
                return l2;
            }
            long l = 1L;
            return l;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean incrementTillSequence() {
        try (Statement stmt = this.getStmt();){
            if (stmt.executeUpdate("UPDATE TILL_SEQUENCE SET SEQ = COALESCE(SEQ,0) + 1 WHERE TILL_NAME = " + PosUtils.StringToSqlString(this.tillnum)) == 0) {
                stmt.executeUpdate("INSERT INTO TILL_SEQUENCE(SEQ, TILL_NAME) VALUES (1, " + PosUtils.StringToSqlString(this.tillnum) + ")");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public void disposeFingerprintProvider() {
        if (this.bUsingFingerprintLogin && this.FingerprintProvider != null) {
            this.FingerprintProvider.dispose();
            this.FingerprintProvider = null;
        }
    }

    public String getLogpath() {
        return this.logpath;
    }

    public String getLabelPrintingPath() {
        return this.labelPrintingPath;
    }

    public Boolean getEscapeLabelPrintStrings() {
        return this.escapeLabelPrintStrings;
    }

    public StatusListener getStatusListener() {
        return this.statusListener;
    }

    public OrderCountListener getOrderCountListener() {
        return this.orderCountListener;
    }

    public Connection getDocketConnection() {
        return this.docketConnection;
    }

    private String formatDirectoryName(String directory, String defaultName) {
        if (directory == null || directory.length() == 0) {
            directory = defaultName + "/";
        } else if (!directory.substring(directory.length() - 1).equals("/")) {
            directory = directory + "/";
        }
        return directory;
    }

    private String formatDirectoryOrPrinterName(String directory, String defaultName) {
        if (directory == null || directory.length() == 0) {
            return defaultName + "/";
        }
        if (directory.startsWith("\\\\")) {
            return directory;
        }
        if (!directory.substring(directory.length() - 1).equals("/")) {
            directory = directory + "/";
        }
        return directory;
    }

    public EmailValidator getEmailValidator() {
        if (this.emailValidator == null) {
            this.emailValidator = new EmailValidator(SystemSettings.getInstance().getText(SystemSettings.SystemSetting.EMAIL_VALIDATION_FORMULA));
        }
        return this.emailValidator;
    }

    public long getCreditCardFeeSku() {
        return this.creditCardFeeSku;
    }

    public boolean getPromptForPriceOverrideReason() {
        return this.promptForPriceOverrideReason;
    }

    public void initDisplayDevice() {
        if (this.useDisplayDevice) {
            this.displayDevice = new PosSaleDisplayDevice(this);
            this.displayDevice.displayWelcomeMessage();
        }
    }

    public void disposeDisplayDevice() {
        if (this.useDisplayDevice && this.displayDevice != null) {
            this.displayDevice.clearDisplayScreen();
            this.displayDevice = null;
        }
    }

    public String getDeliveryLabelDirectory() {
        PosUtils.createDirectory("Delivery Labels");
        return "Delivery Labels";
    }

    public String getDeliveryLabelLogDirectory() {
        String path = "Delivery Labels" + File.separator + "Logs";
        PosUtils.createDirectory(path);
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isStoreRefenceInList(long rgidx, String[] rcidxs) {
        if (rgidx <= 0L) return false;
        if (rcidxs.length <= 0) return false;
        try (Statement stmt = this.getStmt();){
            Long storeRcidx = Utils.getWhseReference(stmt, this.getStoreIdx(), rgidx);
            if (storeRcidx == null) return false;
            String[] stringArray = rcidxs;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String rcidx = stringArray[n2];
                if (!rcidx.isEmpty() && Long.parseLong(rcidx) == storeRcidx) {
                    boolean bl = true;
                    return bl;
                }
                ++n2;
            }
            return false;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
        catch (NumberFormatException e) {
            PosUtils.logError(e);
        }
        return false;
    }

    public boolean isForceScanInStockReceipt() {
        if (Settings.hasSettingForReceiptForceScan()) {
            return Settings.isForceScanInStockReceipt();
        }
        Long rgidx = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.STOCK_RECEIPT_FORCE_SCAN);
        String rcidxs = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.STOCK_RECEIPT_FORCE_SCAN);
        return this.isStoreRefenceInList(rgidx, rcidxs.split(","));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isForceScanInTransferOut() {
        String[] rcidxs;
        if (Settings.hasSettingForTransferOutForceScan()) {
            return Settings.isForceScanInTransferOut();
        }
        Long blobidx = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.TRANSFER_OUT_FORCE_SCAN);
        if (blobidx == null) return false;
        if (blobidx == 0L) {
            return false;
        }
        String parstr = Utils.getBLOBText(SP.sParams.conn, blobidx);
        if (parstr.isEmpty()) return false;
        if (parstr == null) {
            return false;
        }
        String[] parser = parstr.split("@");
        Long rgidx = Long.parseLong(parser[0]);
        if (parser.length == 1) {
            return false;
        }
        String[] stringArray = rcidxs = parser[1].split(",");
        if (rcidxs == null) {
            return false;
        }
        try (Statement stmt = this.getStmt();){
            Long storeRcidx = Utils.getWhseReference(stmt, this.getStoreIdx(), rgidx);
            int i = 0;
            while (i < rcidxs.length) {
                Long rcidx = Long.parseLong(rcidxs[i]);
                if (rcidx.equals(storeRcidx)) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
        catch (NumberFormatException e) {
            PosUtils.logError(e);
        }
        return false;
    }

    public boolean isStockReceiptByCarton() {
        if (Settings.hasSettingForReceiptByCarton()) {
            return Settings.isStockReceiptByCarton();
        }
        Long rgidx = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.STOCK_RECEIPT_BY_CARTON);
        String rcidxs = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.STOCK_RECEIPT_BY_CARTON);
        return this.isStoreRefenceInList(rgidx, rcidxs.split(","));
    }

    public boolean isAutoPrintLabelOnReceipt() {
        Long parLinkidx = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.AUTO_PRINT_DISPLAY_LABELS_ON_RECEIPT);
        return parLinkidx > 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getAutoPrintLabelQty() {
        Long blolbIdx = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.AUTO_PRINT_DISPLAY_LABELS_ON_RECEIPT);
        String parstr = Utils.getBLOBText(SP.sParams.conn, blolbIdx);
        if (parstr.isEmpty()) return 0;
        if (parstr == null) {
            return 0;
        }
        String[] parser = parstr.split("@");
        Long rgidx = parser[0].equals(perTables) ? null : Long.valueOf(Long.parseLong(parser[0]));
        try (Statement stmt = this.getStmt();){
            Long storeRcidx = Utils.getWhseReference(stmt, this.getStoreIdx(), rgidx);
            int i = 1;
            while (i < parser.length) {
                Long rcidx;
                Long l = rcidx = parser[i].equals(perTables) ? null : Long.valueOf(Long.parseLong(parser[i]));
                if (rcidx.equals(storeRcidx)) {
                    int n = Integer.parseInt(parser[i + 1]);
                    return n;
                }
                i += 2;
            }
            return 0;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return 0;
        }
        catch (NumberFormatException e) {
            PosUtils.logError(e);
        }
        return 0;
    }

    public ZipPay getZipPay(boolean silent) {
        if (this.zipPay == null && this.checkIConn()) {
            Element element = this.OnlineQueryProvider.getOnlineQuery("zip_api", perTables).getXML();
            if (element != null && element.getName() == "zip_api") {
                this.zipPay = new ZipPay(this, element.getAttributeValue("api_url"), element.getAttributeValue("api_key"), element.getAttributeValue("location_id"));
            } else if (!silent) {
                JOptionPane.showMessageDialog(null, "Zip payment is not available for this store", "Error", 0);
            }
        }
        return this.zipPay;
    }

    public ZipPay getZipPay() {
        return this.getZipPay(false);
    }

    public Openpay getOpenpay(boolean silent) {
        if (this.openpay == null && this.checkIConn()) {
            PaymentGatewayConfig config = this.getPaymentGatewayConfig(PaymentGatewayConfig.PaymentGatewayType.OPENPAY);
            if (!this.allPaymentGatewaysPopulated) {
                StringBuilder error = new StringBuilder();
                error.append("Could not retrieve Openpay credentials from Head Office.");
                error.append("\r\n");
                error.append("Please check your internet connection and try again.");
                JOptionPane.showMessageDialog(null, error.toString(), "Error", 0);
            } else if (config != null && config.getPaymentGatewayXml() != null) {
                if (StringUtils.isNullOrEmpty((String)config.getPassword()) || StringUtils.isNullOrEmpty((String)config.getApiUrl())) {
                    JOptionPane.showMessageDialog(null, res.getString("openpay_auth_failed"), "Error", 0);
                } else {
                    this.openpay = new Openpay(this, config);
                }
            } else if (!silent) {
                StringBuilder error = new StringBuilder();
                error.append("Openpay is not available for this store.");
                error.append("\r\n");
                error.append("Please contact Head Office.");
                JOptionPane.showMessageDialog(null, error.toString(), "Error", 0);
            }
        }
        return this.openpay;
    }

    public Openpay getOpenpay() {
        return this.getOpenpay(false);
    }

    public PaymentGatewayConfig getAfterpay(boolean silent) {
        if (this.afterpay == null && this.checkIConn()) {
            PaymentGatewayConfig config = this.getPaymentGatewayConfig(PaymentGatewayConfig.PaymentGatewayType.AFTER_PAY);
            if (!this.allPaymentGatewaysPopulated) {
                StringBuilder error = new StringBuilder();
                error.append("Could not retrieve Afterpay credentials from Head Office.");
                error.append("\r\n");
                error.append("Please check your internet connection and try again.");
                JOptionPane.showMessageDialog(null, error.toString(), "Error", 0);
            } else if (config != null && config.getPaymentGatewayXml() != null) {
                if (StringUtils.isNullOrEmpty((String)config.getPassword()) || StringUtils.isNullOrEmpty((String)config.getApiUrl()) || StringUtils.isNullOrEmpty((String)config.getMerchantID())) {
                    JOptionPane.showMessageDialog(null, res.getString("afterpay_auth_failed"), "Error", 0);
                } else {
                    this.afterpay = config;
                }
            } else if (!silent) {
                StringBuilder error = new StringBuilder();
                error.append("Afterpay is not available for this store.");
                error.append("\r\n");
                error.append("Please contact Head Office.");
                JOptionPane.showMessageDialog(null, error.toString(), "Error", 0);
            }
        }
        return this.afterpay;
    }

    public PaymentGatewayConfig AfterpayConfig() {
        return this.getAfterpay(false);
    }

    public Braintree getBraintree() {
        if (this.braintree == null && this.checkIConn()) {
            PaymentGatewayConfig config = this.getPaymentGatewayConfig(PaymentGatewayConfig.PaymentGatewayType.BRAINTREE);
            if (!this.allPaymentGatewaysPopulated) {
                StringBuilder error = new StringBuilder();
                error.append("Could not retrieve Braintree credentials from Head Office.");
                error.append("\r\n");
                error.append("Please check your internet connection and try again.");
                JOptionPane.showMessageDialog(null, error.toString(), "Error", 0);
            } else if (config != null && config.getPaymentGatewayXml() != null) {
                if (StringUtils.isNullOrEmpty((String)config.getMerchantID()) || StringUtils.isNullOrEmpty((String)config.getPrivateKey()) || StringUtils.isNullOrEmpty((String)config.getPublicKey())) {
                    JOptionPane.showMessageDialog(null, res.getString("braintree_auth_failed"), "Error", 0);
                } else {
                    this.braintree = new Braintree(config);
                }
            } else {
                StringBuilder error = new StringBuilder();
                error.append("Braintree is not available for this store.");
                error.append("\r\n");
                error.append("Please contact Head Office.");
                JOptionPane.showMessageDialog(null, error.toString(), "Error", 0);
            }
        }
        return this.braintree;
    }

    public Paypal getPaypal() {
        if (this.paypal == null && this.checkIConn()) {
            PaymentGatewayConfig config = this.getPaymentGatewayConfig(PaymentGatewayConfig.PaymentGatewayType.PAYPAL_REST);
            if (!this.allPaymentGatewaysPopulated) {
                StringBuilder error = new StringBuilder();
                error.append("Could not retrieve PayPal credentials from Head Office.");
                error.append("\r\n");
                error.append("Please check your internet connection and try again.");
                JOptionPane.showMessageDialog(null, error.toString(), "Error", 0);
            } else if (config != null && config.getPaymentGatewayXml() != null) {
                if (StringUtils.isNullOrEmpty((String)config.getMerchantID()) || StringUtils.isNullOrEmpty((String)config.getPassword())) {
                    JOptionPane.showMessageDialog(null, res.getString("paypal_auth_failed"), "Error", 0);
                } else {
                    this.paypal = new Paypal(config);
                }
            } else {
                StringBuilder error = new StringBuilder();
                error.append("PayPal is not available for this store.");
                error.append("\r\n");
                error.append("Please contact Head Office.");
                JOptionPane.showMessageDialog(null, error.toString(), "Error", 0);
            }
        }
        return this.paypal;
    }

    public void getPaymentGatewayConfigs() {
        Element payGatewayXml;
        if (this.checkIConn() && (payGatewayXml = SP.sParams.OnlineQueryProvider.getOnlineQuery("all_payment_gateways", String.valueOf(SP.sParams.getStoreIdx()), false).getXML()) != null) {
            this.allPaymentGatewayConfigs.clear();
            for (Object gatewayConfig : payGatewayXml.getChildren()) {
                PaymentGatewayConfig.PaymentGatewayType key;
                if (!((Element)gatewayConfig).getName().equals("payment_gateway") || (key = PaymentGatewayConfig.PaymentGatewayType.fromDatabaseTypeValue(XMLUtils.getLongValue((Element)gatewayConfig, "gateway_type"))) == null || this.allPaymentGatewayConfigs.containsKey((Object)key)) continue;
                this.allPaymentGatewayConfigs.put(key, new PaymentGatewayConfig((Element)gatewayConfig));
            }
            this.allPaymentGatewaysPopulated = true;
        }
    }

    public PaymentGatewayConfig getPaymentGatewayConfig(PaymentGatewayConfig.PaymentGatewayType type) {
        return this.allPaymentGatewayConfigs.get((Object)type);
    }

    public boolean areAllPaymentGatewaysPopulated() {
        return this.allPaymentGatewaysPopulated;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSlypStoreId() {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT SLYP_STORE_ID FROM WHSE WHERE WIDX = " + this.getStoreIdx());){
            if (sql.next()) {
                String string2 = sql.getString(1);
                return string2;
            }
            String string = perTables;
            return string;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return null;
        }
    }

    public boolean isEftposProviderAdyen() {
        return this.eftpos != null && this.eftpos.getProviderName().equalsIgnoreCase("Adyen");
    }

    public void setPromoCachePurgeFlag(boolean purge) {
        this.bPurgePromoCache = purge;
    }

    public boolean getPromoCachePurgeFlag() {
        return this.bPurgePromoCache;
    }

    public String getPosPath() {
        File file = new File(perTables);
        String path = perTables;
        try {
            path = file.getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    static {
        try {
            ResourceBundle dbhost = ResourceBundle.getBundle("dbhost");
            try {
                dbHost = dbhost.getString("db.host");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                dbFile = dbhost.getString("db.file");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                dbPort = dbhost.getString("db.port");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                dbUser = dbhost.getString("db.user");
            }
            catch (MissingResourceException missingResourceException) {}
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        dbPassword = PosUtils.getPassword(dbUser);
        DBURL = "jdbc:firebirdsql:" + dbHost + "/" + dbPort + ":" + dbFile;
        qtyFormat = new DecimalFormat("#,##0.####");
        extendedTaxFormat = new DecimalFormat("#,##0.####");
        costFormat = new DecimalFormat("#.####");
        sArmsLengthWhere = perTables;
    }
}

