/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jpos.ui.TouchTextField;

public class StringField
extends TouchTextField {
    private int maxLength = -1;

    public StringField() {
        this(-1);
    }

    public StringField(TouchTextField.FontSize fontSize) {
        this(-1, fontSize);
    }

    public StringField(int length) {
        this(length, TouchTextField.FontSize.NORMAL);
    }

    public StringField(int length, TouchTextField.FontSize fontSize) {
        super(fontSize);
        this.init(length);
    }

    private void init(int length) {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                StringField.this.callf();
            }
        });
        this.maxLength = length;
    }

    public void callf() {
        this.selectAll();
    }

    @Override
    protected Document createDefaultModel() {
        return new MyDocument();
    }

    public boolean allowEdit() {
        return true;
    }

    protected class MyDocument
    extends PlainDocument {
        protected MyDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (StringField.this.allowEdit() && (StringField.this.maxLength == -1 || str == null || StringField.this.maxLength >= offs + str.length())) {
                super.insertString(offs, str, a);
            }
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (StringField.this.allowEdit()) {
                super.replace(offset, length, text, attrs);
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (StringField.this.allowEdit()) {
                super.remove(offs, len);
            }
        }
    }
}

