/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.TotalsTableModel;
import jpos.ui.Fonts;
import jpos.ui.UIConstants;

public class TotalsTable
extends PosTable {
    private PosTable parentTable;

    public TotalsTable(Window parentWindow, PosTable parentTable, TotalsTableModel tableModel) {
        super(parentWindow, tableModel);
        this.parentTable = parentTable;
        this.init();
    }

    private void init() {
        this.setFocusable(false);
        this.setCellSelectionEnabled(false);
        this.setAutoResizeMode(0);
        PosScrollPane scrollPane = new PosScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = TotalsTable.this.getModel().getRowCount() * UIConstants.TABLE_ROW_HEIGHT + 2;
                return d;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getPreferredSize();
                d.height = TotalsTable.this.getModel().getRowCount() * UIConstants.TABLE_ROW_HEIGHT + 2;
                return d;
            }
        };
        this.setScrollPane(scrollPane);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getHorizontalScrollBar().setModel(this.parentTable.getScrollPane().getHorizontalScrollBar().getModel());
        this.parentTable.renderer.copyContents(this.renderer);
        this.setTableHeader(null);
        this.setFont(Fonts.BoldText);
        this.parentTable.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (TotalsTable.this.parentTable.getScrollPane().getVerticalScrollBar().isVisible()) {
                    TotalsTable.this.getScrollPane().setVerticalScrollBarPolicy(22);
                } else {
                    TotalsTable.this.getScrollPane().setVerticalScrollBarPolicy(21);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.parentTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                TotalsTable.this.setColumnWidths();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    private void setColumnWidths() {
        for (int i = 0; i < this.parentTable.getColumnCount(); ++i) {
            if (this.getColumnCount() <= i) continue;
            this.getColumnModel().getColumn(i).setMaxWidth(this.parentTable.getColumnModel().getColumn(i).getWidth());
            this.getColumnModel().getColumn(i).setPreferredWidth(this.parentTable.getColumnModel().getColumn(i).getWidth());
            this.getColumnModel().getColumn(i).setMinWidth(this.parentTable.getColumnModel().getColumn(i).getWidth());
        }
    }
}

