/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.StringTokenizer;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.Security;
import jpos.SignInSettings;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.basscom.utils.Utils;

public class User {
    private boolean fingerprintLogin = false;
    private long nMemidx = -1L;
    private long nPeridx = -1L;
    private String sMemName;
    private String sMemPass;
    private String sPerFirstName;
    private String sPerSurName;
    private Timestamp clockedOn = null;
    private boolean requireClockon = false;
    private boolean trainingUser = false;
    StoreParams sParams;
    private boolean hasLoginSec = false;

    public User(StoreParams psParams) {
        this.sParams = psParams;
    }

    public User(long pmemidx, long pperidx, String pmemName, String pperFirstName, String pperSurname, Timestamp pclockedOn, StoreParams psParams) {
        this.sParams = psParams;
        this.nMemidx = pmemidx;
        this.nPeridx = pperidx;
        this.sMemName = pmemName;
        this.sPerFirstName = pperFirstName;
        this.sPerSurName = pperSurname;
        this.clockedOn = pclockedOn;
    }

    public User(long pMemIdx, StoreParams psParams) {
        this.nMemidx = pMemIdx;
        this.sParams = psParams;
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT PERIDX, MEMNAME, FIRSTNAME, SURNAME FROM MEMBER, PERSON WHERE MEMBER.\"ACTIVE\" = 1 AND MEMBER.MEMIDX = PERSON.MEMIDX AND MEMBER.MEMIDX = " + this.nMemidx);){
            if (sql.next()) {
                this.nPeridx = sql.getLong(1);
                this.sMemName = sql.getString(2);
                this.sPerFirstName = sql.getString(3);
                this.sPerSurName = sql.getString(4);
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public boolean isFingerprintLogin() {
        return this.fingerprintLogin;
    }

    public boolean attemptLogin(String pMemName, String pass, long secidx, boolean passRequired, boolean fingerprintLogin) {
        return this.attemptLogin(pMemName, pass, secidx, passRequired, fingerprintLogin, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean attemptLogin(String pMemName, String pass, long secidx, boolean passRequired, boolean fingerprintLogin, boolean isPassPol) {
        this.nMemidx = -1L;
        boolean canLogin = false;
        this.fingerprintLogin = fingerprintLogin;
        if (pMemName == null) return false;
        if (pMemName.equals("")) {
            return false;
        }
        boolean retval = false;
        try {
            String select = null;
            select = secidx == 0L ? "SELECT COALESCE(M.MEMPWD, ''), M.MEMIDX, P.PERIDX, H.TRAND, COALESCE(P.FIRSTNAME, ''), COALESCE(P.SURNAME, ''), 1, M.MEMNAME FROM MEMBER M LEFT JOIN RET_TRANH H ON M.CLOCKEDON = H.VHIDX, PERSON P WHERE M.\"ACTIVE\" = 1 AND M.MEMIDX = P.MEMIDX AND UPPER(M.MEMNAME) = " + PosUtils.StringToSqlString(pMemName.toUpperCase()) + " " + this.sParams.sWhseRefSecWherePERSON : "SELECT COALESCE(M.MEMPWD, ''), M.MEMIDX, P.PERIDX, H.TRAND, COALESCE(P.FIRSTNAME, ''), COALESCE(P.SURNAME, ''), GS.\"READ\", M.MEMNAME FROM PERSON P, MEMBER M LEFT JOIN RET_TRANH H ON M.CLOCKEDON = H.VHIDX LEFT JOIN GRPMEM G ON G.MEMIDX = M.MEMIDX LEFT JOIN GRPSEC GS ON GS.GRPIDX = G.GRPIDX AND GS.SECIDX =" + secidx + " " + "WHERE M.\"ACTIVE\" = 1 AND M.MEMIDX = P.MEMIDX AND UPPER(M.MEMNAME) = " + PosUtils.StringToSqlString(pMemName.toUpperCase()) + " " + this.sParams.sWhseRefSecWherePERSON + " " + "ORDER BY COALESCE(GS.\"READ\",0) DESC";
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, select);){
                if (isPassPol) {
                    if (sql.next()) {
                        canLogin = true;
                    }
                } else if (sql.next() && (!passRequired || Utils.encrypt(pass.toUpperCase()).equals(sql.getString(1)))) {
                    canLogin = true;
                }
                if (canLogin) {
                    this.nMemidx = sql.getLong(2);
                    this.nPeridx = sql.getLong(3);
                    this.sPerFirstName = sql.getString(5);
                    this.sPerSurName = sql.getString(6);
                    this.sMemName = sql.getString(8);
                    this.sMemPass = pass;
                    this.hasLoginSec = PosUtils.booleanVal(sql.getString(7));
                    if (!this.hasLoginSec) {
                        boolean bl = false;
                        return bl;
                    }
                    retval = true;
                    this.clockedOn = sql.getTimestamp(4);
                    this.requireClockon = false;
                    if (SignInSettings.getInstance().getClockOnWorkgroups().size() > 0) {
                        String groupList = String.join((CharSequence)",", SignInSettings.getInstance().getClockOnWorkgroups());
                        try (SqlQuery sqlGroups = new SqlQuery(this.sParams.conn, "SELECT 1 FROM GRPMEM WHERE GRPIDX IN (" + groupList + ") AND MEMIDX =" + this.nMemidx);){
                            if (sqlGroups.next()) {
                                this.requireClockon = true;
                            }
                        }
                    }
                    this.checkAndSetTrainingUser();
                    return retval;
                }
                this.invalidate();
                return retval;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return retval;
    }

    public void invalidate() {
        this.nMemidx = -1L;
        this.nPeridx = -1L;
        this.trainingUser = false;
        this.hasLoginSec = false;
        this.fingerprintLogin = false;
    }

    public boolean isLoggedIn() {
        return this.nMemidx != -1L && this.hasLoginSec;
    }

    public boolean hasSecurity(PosFrame parent, long secidx, int secLevel, boolean overridable, Security.OverrideUser overrideUser) {
        return Security.hasSecurity(parent, secidx, this.nMemidx, secLevel, overridable, overrideUser);
    }

    public boolean hasSecurity(long secidx, int secLevel) {
        return Security.hasSecurity(secidx, this.nMemidx, secLevel);
    }

    public boolean[] getSecurity(long secidx) {
        return Security.getSecurity(secidx, this.nMemidx);
    }

    public boolean hasRefSec(long rcidx) {
        boolean bRet = false;
        bRet = this.hasRefSec(new Reference(rcidx).getGroupIdx(), rcidx);
        return bRet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRefSec(long rgidx, long rcidx) {
        try (Statement stmt = this.sParams.getStmt();){
            try (ResultSet result = stmt.executeQuery("SELECT G.RGIDX, G.SECENABLE FROM REFGRP G, REFCODE R WHERE R.RGIDX = G.RGIDX AND R.RCIDX = " + rcidx);){
                if (result.next() && !PosUtils.booleanVal(result.getInt(2))) {
                    boolean bl = true;
                    return bl;
                }
            }
            result = stmt.executeQuery("SELECT 1 FROM DEFSEC D, GRPMEM G WHERE D.RGIDX_FLAG = -1 AND D.GRPIDX = G.GRPIDX AND G.MEMIDX = " + this.nMemidx);
            var8_9 = null;
            try {
                if (result.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (result != null) {
                    if (var8_9 != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = stmt.executeQuery("SELECT 1 FROM DEFSEC D, GRPMEM G WHERE D.RGIDX_FLAG = " + rgidx + " AND D.RCIDX_FLAG = -1 AND D.GRPIDX = G.GRPIDX AND G.MEMIDX = " + this.nMemidx);
            var8_9 = null;
            try {
                if (result.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (result != null) {
                    if (var8_9 != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            if (rcidx == 0L) {
                result = stmt.executeQuery("SELECT 1 FROM REFSEC R, GRPMEM G WHERE R.GRPIDX = G.GRPIDX AND G.MEMIDX = " + this.nMemidx + " AND R.RGIDX = " + rgidx + " AND RCIDX IS NULL");
                var8_9 = null;
                try {
                    if (!result.next()) return false;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable) {
                    var8_9 = throwable;
                    throw throwable;
                }
                finally {
                    if (result != null) {
                        if (var8_9 != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable) {
                                var8_9.addSuppressed(throwable);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            result = stmt.executeQuery("SELECT 1 FROM REFSEC R, GRPMEM G WHERE R.GRPIDX = G.GRPIDX AND R.RCIDX = " + rcidx + " AND G.MEMIDX = " + this.nMemidx);
            var8_9 = null;
            try {
                if (!result.next()) return false;
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (result != null) {
                    if (var8_9 != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            PosUtils.logError(ex);
        }
        return false;
    }

    public boolean clockedOn() {
        return this.clockedOn != null;
    }

    public void clockOn(String notes, boolean bFingerprint) {
        String sFingerprint = bFingerprint ? "1" : "0";
        try {
            PosUtils.startTrans(this.sParams.conn);
            String docknum = this.trainingUser ? "null" : PosUtils.StringToSqlString(PosUtils.padZeroes(this.sParams.getNextDocketNum("User.clockOn"), 8));
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TILL_NUMBER,  SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, COMPLETE, TRAND, NOTES1, NOTES2, DOCKET_NUMBER, SALE_DATE) VALUES( " + this.sParams.nextVal("XRET_TRANH") + ", 543, " + (this.trainingUser ? -1 : 1) + ", " + this.sParams.getStoreIdx() + ", " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", " + " " + this.nPeridx + ", " + this.nMemidx + ", " + this.nPeridx + ", " + this.nMemidx + ", 1, CURRENT_TIMESTAMP, " + PosUtils.StringToSqlString(notes) + ", " + PosUtils.StringToSqlString(sFingerprint) + ", " + docknum + ", TRUNC_DATE(current_timestamp) )");
                Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.sParams.currVal("XRET_TRANH"));
                this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.sParams.currVal("XRET_TRANH"));
                stmt.executeUpdate("UPDATE MEMBER SET CLOCKEDON = " + this.sParams.currVal("XRET_TRANH") + " WHERE MEMIDX = " + this.nMemidx);
            }
            this.clockedOn = new Timestamp(new Date().getTime());
            PosUtils.endTrans(this.sParams.conn);
        }
        catch (Exception e) {
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
        }
    }

    public void clockOff(String notes, boolean bFingerprint) {
        String sFingerprint = bFingerprint ? "1" : "0";
        try {
            PosUtils.startTrans(this.sParams.conn);
            String docknum = this.trainingUser ? "null" : PosUtils.StringToSqlString(PosUtils.padZeroes(this.sParams.getNextDocketNum("User.clockOff"), 8));
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TILL_NUMBER,  SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, COMPLETE, TRAND, NOTES1, NOTES2, DOCKET_NUMBER, SALE_DATE) VALUES( " + this.sParams.nextVal("XRET_TRANH") + ", 544, " + (this.trainingUser ? -1 : 1) + ", " + this.sParams.getStoreIdx() + ", " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", " + " " + this.nPeridx + ", " + this.nMemidx + ", " + this.nPeridx + ", " + this.nMemidx + ", 1, CURRENT_TIMESTAMP, " + PosUtils.StringToSqlString(notes) + ", " + PosUtils.StringToSqlString(sFingerprint) + ", " + docknum + ", TRUNC_DATE(current_timestamp) )");
                Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.sParams.currVal("XRET_TRANH"));
                this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.sParams.currVal("XRET_TRANH"));
                stmt.executeUpdate("UPDATE MEMBER SET CLOCKEDON = 0 WHERE MEMIDX = " + this.nMemidx);
            }
            PosUtils.endTrans(this.sParams.conn);
        }
        catch (Exception e) {
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
            return;
        }
        this.clockedOn = null;
    }

    public boolean requireClockOn() {
        return this.requireClockon && !this.clockedOn();
    }

    public String toString() {
        return this.getLoginName();
    }

    public static String getClockedOnNames() {
        String names = "";
        int nCount = 0;
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT COALESCE(P.FIRSTNAME, ''), COALESCE(P.SURNAME, '') FROM MEMBER M, PERSON P WHERE COALESCE(M.CLOCKEDON, 0)>0 AND M.MEMIDX = P.MEMIDX");){
            while (sql.next()) {
                String sFullName = User.formatDisplayName(sql.getString(1), sql.getString(2));
                names = names.isEmpty() ? sFullName : names + ", " + (++nCount == 5 ? "\n" : "") + sFullName;
                if (nCount != 5) continue;
                nCount = 0;
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        return names.length() > 0 ? names : null;
    }

    public Timestamp clockedOnTime() {
        return this.clockedOn;
    }

    public String getLoginName() {
        return User.formatDisplayName(this.sPerFirstName, this.sPerSurName);
    }

    public static String formatDisplayName(String firstname, String lastname) {
        String name = "";
        if (firstname != null && !firstname.equals("")) {
            name = firstname + " ";
        }
        if (lastname != null && !lastname.equals("")) {
            name = name + lastname.substring(0, 1);
        }
        return name;
    }

    public long getMemidx() {
        return this.nMemidx;
    }

    public long getPeridx() {
        return this.nPeridx;
    }

    public String getMemName() {
        return this.sMemName;
    }

    public String getMemPass() {
        return this.sMemPass;
    }

    public String getPerFirstName() {
        return this.sPerFirstName;
    }

    public String getPerSurName() {
        return this.sPerSurName;
    }

    public boolean isTraningUser() {
        return this.trainingUser;
    }

    public boolean hasLoginSec() {
        return this.hasLoginSec;
    }

    public void setMemidx(long npMemidx) {
        this.nMemidx = npMemidx;
    }

    public void setPeridx(long npPeridx) {
        this.nPeridx = npPeridx;
    }

    public void checkAndSetTrainingUser() {
        this.trainingUser = false;
        if (this.sParams.trainUsers.indexOf("\u0003") > -1) {
            StringTokenizer toks = new StringTokenizer(this.sParams.trainUsers.substring(0, this.sParams.trainUsers.indexOf("\u0003")), ",");
            while (toks.hasMoreTokens()) {
                if (!toks.nextToken().equals(String.valueOf(this.nMemidx))) continue;
                this.trainingUser = true;
                break;
            }
        }
    }

    public void setTrainingUser(boolean trainingUser) {
        this.trainingUser = trainingUser;
    }
}

