/*
 * Decompiled with CFR 0.152.
 */
package jpos.associations;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jpos.FrSales;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.associations.Association;
import jpos.associations.AssociationTable;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelStrong;
import jpos.ui.TouchTextField;

public class AssociationSearchScreen
extends PosDialog
implements AutoCloseable {
    private static final int WIDTH = 800;
    private static final String loadedFormat = "<html><nobr><span style=\"font-weight:bold\">%s</span></nobr></html>";
    private AssociationTable associationList;
    private TouchTextField searchField = new TouchTextField();
    private DialogButton okButton = new DialogButton("");
    private DialogButton cancelButton = new DialogButton("");
    private LabelNormal loadAllLabel = new LabelNormal();
    private LabelStrong loadedLabel = new LabelStrong();
    PosFrame parentFrame;
    private int selection = -1;
    private int position;
    private long rpcidx;
    private String screenName = SP.getRS("Assoc_Button");

    public AssociationSearchScreen(PosFrame frame, int position, long rpcidx, String screenName) {
        super(frame, screenName, true);
        this.screenName = screenName;
        this.prepForScreen(frame, position, rpcidx);
    }

    public AssociationSearchScreen(PosFrame frame, int position, long rpcidx) {
        super(frame, SP.getRS("Assoc_Button"), true);
        this.prepForScreen(frame, position, rpcidx);
    }

    private void prepForScreen(PosFrame frame, int position, long rpcidx) {
        this.parentFrame = frame;
        this.position = position;
        this.rpcidx = rpcidx;
        this.init();
        this.populate(true);
        this.pack();
        this.resizeDialog(this.parentFrame, 0.4f, 0.4f);
    }

    public int getSelection() {
        return this.selection;
    }

    private void init() {
        this.associationList = new AssociationTable(this);
        this.associationList.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && e.getSource() instanceof ListSelectionModel) {
                    boolean selectionExists = false;
                    ListSelectionModel listModel = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        if (!listModel.isSelectedIndex(i)) continue;
                        selectionExists = true;
                        AssociationSearchScreen.this.selection = i;
                    }
                }
            }
        });
        this.associationList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && AssociationSearchScreen.this.associationList.getSelectedRow() > -1) {
                    AssociationSearchScreen.this.okDialog();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Component focusComp = AssociationSearchScreen.this.getFocusOwner();
                if (focusComp == null || focusComp != AssociationSearchScreen.this.associationList && focusComp.getParent() != AssociationSearchScreen.this.associationList) {
                    if (e.getKeyCode() == 38) {
                        if (AssociationSearchScreen.this.associationList.getSelectedRow() > 0) {
                            AssociationSearchScreen.this.associationList.changeSelection(AssociationSearchScreen.this.associationList.getSelectedRow() - 1, AssociationSearchScreen.this.associationList.getSelectedColumn(), false, false);
                        }
                    } else if (e.getKeyCode() == 40 && AssociationSearchScreen.this.associationList.getSelectedRow() < AssociationSearchScreen.this.associationList.getRowCount() - 1) {
                        AssociationSearchScreen.this.associationList.changeSelection(AssociationSearchScreen.this.associationList.getSelectedRow() + 1, AssociationSearchScreen.this.associationList.getSelectedColumn(), false, false);
                    }
                }
            }
        });
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssociationSearchScreen.this.okDialog();
            }
        });
        this.cancelButton.setText(StoreParams.res.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssociationSearchScreen.this.cancelDialog();
            }
        });
        this.searchField.setHint("Filter " + this.screenName);
        this.searchField.setFieldWidth(800);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AssociationSearchScreen.this.associationList.filter(AssociationSearchScreen.this.searchField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AssociationSearchScreen.this.associationList.filter(AssociationSearchScreen.this.searchField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AssociationSearchScreen.this.associationList.filter(AssociationSearchScreen.this.searchField.getText());
            }
        });
        this.associationList.getScrollPane().setPreferredSize(new Dimension(800, 400));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        controlPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        controlPanel.setPreferredSize(new Dimension(800, controlPanel.getPreferredSize().height));
        JPanel panelMain = new JPanel(new GridBagLayout());
        panelMain.add((Component)this.searchField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        panelMain.add((Component)this.associationList.getScrollPane(), new GridBagConstraints(0, 1, 1, 1, 0.6, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        panelMain.add((Component)controlPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add(panelMain);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.searchField);
        v.add(this.associationList);
        v.add(this.okButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.pack();
        this.setFocusTraversalPolicy(ftp);
    }

    private void resizeDialog(Window frParent, float scaleWidth, float scaleHeight) {
        Rectangle parentRect = frParent.getBounds();
        int width = (int)((float)parentRect.width * scaleWidth);
        int height = (int)((float)parentRect.height * scaleHeight);
        int x = parentRect.x + (parentRect.width - width) / 2;
        int y = parentRect.y + (parentRect.height - height) / 2;
        this.setBounds(x, y, width, height);
    }

    private void populate(boolean limited) {
        this.searchField.setText("");
        this.associationList.populateAssociations(limited, this.rpcidx);
        this.associationList.selectFirstRow();
        if (this.associationList.getRowCount() < 20) {
            this.loadAllLabel.setVisible(true);
            this.loadedLabel.setText(String.format(loadedFormat, MessageFormat.format(SP.getRS("Associations_Loaded"), MessageFormat.format("<span style=\"font-weight:normal\">{0}/</span>{1}", this.associationList.getRowCount(), 20))));
        } else {
            this.loadAllLabel.setVisible(false);
            this.loadedLabel.setText(MessageFormat.format(this.associationList.getRowCount() == 1 ? SP.getRS("Association_Loaded") : SP.getRS("Associations_Loaded"), this.associationList.getRowCount()));
        }
    }

    @Override
    public void cancelDialog() {
        this.selection = -1;
        this.dispose();
    }

    public Association getSelectedAssociation() {
        return this.associationList.getSelectedAssociation();
    }

    @Override
    public void okDialog() {
        if (this.associationList.getSelectedAssociation() != null) {
            Association association = this.associationList.getSelectedAssociation();
            long ascIdx = association.getAscID();
            String ascName = association.getName();
            if (association != null) {
                if (ascIdx > 0L && ascName != "" && ascName != null) {
                    this.dispose();
                } else {
                    PosUtils.logError("Failed to get association - attempt to restart POS and if persists contact support.");
                }
            }
        }
        this.dispose();
    }

    public void setAssociationToLines(Association assoc) {
        ((FrSales)this.parentFrame).setAscAtPosition(this.position, assoc);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void close() {
        this.dispose();
    }
}

