/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom;

public class LongBuffer
implements Comparable<LongBuffer> {
    long lValue;
    public static final long NULL_VALUE = Long.MIN_VALUE;

    public LongBuffer() {
        this.lValue = Long.MIN_VALUE;
    }

    public LongBuffer(long i) {
        this.lValue = i;
    }

    public LongBuffer(LongBuffer i) {
        this.lValue = i.longValue();
    }

    public void setValue() {
        this.lValue = Long.MIN_VALUE;
    }

    public void setValue(long i) {
        this.lValue = i;
    }

    public void setValue(LongBuffer i) {
        this.lValue = i.longValue();
    }

    public long longValue() {
        return this.lValue;
    }

    public boolean isNull() {
        return this.lValue == Long.MIN_VALUE;
    }

    public boolean isNotNull() {
        return this.lValue != Long.MIN_VALUE;
    }

    public static long[] tolongArray(LongBuffer[] lbs) {
        long[] la = new long[lbs.length];
        for (int i = 0; i < lbs.length; ++i) {
            la[i] = lbs[i].longValue();
        }
        return la;
    }

    public static Long[] toLongArray(LongBuffer[] lbs) {
        Long[] la = new Long[lbs.length];
        for (int i = 0; i < lbs.length; ++i) {
            la[i] = new Long(lbs[i].longValue());
        }
        return la;
    }

    public String toString() {
        if (this.lValue == Long.MIN_VALUE) {
            return "";
        }
        return Long.toString(this.lValue);
    }

    public int hashCode() {
        return (int)(this.lValue % Integer.MAX_VALUE);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.lValue == ((LongBuffer)o).lValue;
    }

    @Override
    public int compareTo(LongBuffer o) {
        if (this.lValue < o.lValue) {
            return -1;
        }
        if (this.lValue > o.lValue) {
            return 1;
        }
        return 0;
    }
}

