/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import jpos.basscom.AXGen;
import jpos.basscom.DateBuffer;
import jpos.basscom.DecBuffer;
import jpos.basscom.IntBuffer;
import jpos.basscom.LongBuffer;

public class SqlSel {
    private Connection con;
    private Statement stmt;
    private PreparedStatement pStmt;
    private ResultSet result;
    private ResultSetMetaData metaData;
    private StringBuffer sqlStatement;
    private StringBuffer select = new StringBuffer();
    private StringBuffer from = new StringBuffer();
    private StringBuffer where = new StringBuffer();
    private StringBuffer groupBy = new StringBuffer();
    private StringBuffer having = new StringBuffer();
    private StringBuffer orderBy = new StringBuffer();
    private Vector<Object> into = new Vector(20, 10);

    public SqlSel(Connection con, String sqlStatement) {
        this.con = con;
        this.sqlStatement = new StringBuffer(sqlStatement);
    }

    public void appendInto(Object into) {
        this.into.addElement(into);
    }

    public String getSelect() {
        if (this.sqlStatement != null) {
            return this.sqlStatement.toString();
        }
        StringBuffer sel = new StringBuffer("Select " + this.select + "\r\nfrom " + this.from);
        if (!this.where.toString().equals("")) {
            sel.append("\r\nwhere " + this.where);
        }
        if (!this.groupBy.toString().equals("")) {
            sel.append("\r\ngroup by " + this.groupBy);
        }
        if (!this.having.toString().equals("")) {
            sel.append("\r\nhaving " + this.having);
        }
        if (!this.orderBy.toString().equals("")) {
            sel.append("\r\norder by " + this.orderBy);
        }
        return sel.toString();
    }

    public void execute() throws SQLException {
        try {
            if (this.pStmt == null) {
                if (this.con == null) {
                    throw new SQLException("Connection is null\r\n");
                }
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.stmt = this.con.createStatement();
                this.stmt.execute(this.getSelect());
                try {
                    if (this.result != null) {
                        this.result.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.result = this.stmt.getResultSet();
            } else {
                this.pStmt.execute();
                try {
                    if (this.result != null) {
                        this.result.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.result = this.pStmt.getResultSet();
            }
            if (this.result == null) {
                throw new SQLException("result null error\r\n");
            }
            this.metaData = this.result.getMetaData();
        }
        catch (SQLException e) {
            throw new SQLException("Select execute error\r\n" + this.getSelect() + "\r\n" + e.getMessage() + AXGen.getStackTrace(e));
        }
    }

    public boolean next() throws SQLException {
        return this.next(0);
    }

    public boolean next(int elem) throws SQLException {
        Object intoObj = null;
        int type = 0;
        if (this.result == null) {
            this.execute();
        }
        try {
            if (!this.result.next()) {
                return false;
            }
            for (int loop = 0; loop < this.into.size(); ++loop) {
                Comparable<DecBuffer> db;
                type = this.metaData.getColumnType(loop + 1);
                intoObj = this.into.elementAt(loop);
                if (intoObj instanceof StringBuffer) {
                    String s = this.result.getString(loop + 1);
                    StringBuffer sb = (StringBuffer)this.into.elementAt(loop);
                    sb.delete(0, sb.length());
                    if (s == null) continue;
                    sb.append(s);
                    continue;
                }
                if (intoObj instanceof IntBuffer) {
                    IntBuffer ib = (IntBuffer)this.into.elementAt(loop);
                    ib.setValue(this.result.getInt(loop + 1));
                    if (!this.result.wasNull()) continue;
                    ib.setValue();
                    continue;
                }
                if (intoObj instanceof LongBuffer) {
                    LongBuffer lb = (LongBuffer)this.into.elementAt(loop);
                    if (type == 93 || type == 91 || type == 92) {
                        Timestamp ts = this.result.getTimestamp(loop + 1);
                        if (ts != null) {
                            lb.setValue(ts.getTime());
                        }
                    } else {
                        lb.setValue(this.result.getLong(loop + 1));
                    }
                    if (!this.result.wasNull()) continue;
                    lb.setValue();
                    continue;
                }
                if (intoObj instanceof DecBuffer) {
                    db = (DecBuffer)this.into.elementAt(loop);
                    ((DecBuffer)db).setValue(this.result.getDouble(loop + 1));
                    if (!this.result.wasNull()) continue;
                    ((DecBuffer)db).setValue();
                    continue;
                }
                if (intoObj instanceof DateBuffer) {
                    db = (DateBuffer)this.into.elementAt(loop);
                    ((DateBuffer)db).setValue(this.result.getDate(loop + 1));
                    if (!this.result.wasNull()) continue;
                    ((DateBuffer)db).setValue();
                    continue;
                }
                System.out.println("Mismatched types. SQL Type:" + AXGen.sqlTypeToDesc(type) + "!");
                System.out.println(" into Class:" + this.into.elementAt(loop).getClass().getName() + "!");
            }
            return true;
        }
        catch (SQLException e) {
            throw new SQLException("Select next error\r\nType:(" + type + ")" + AXGen.sqlTypeToDesc(type) + "\r\n" + this.getSelect() + "\r\n" + e.getMessage() + AXGen.getStackTrace(e));
        }
        catch (Exception e) {
            throw new SQLException("Select next exception error\r\n" + this.getSelect() + "\r\n" + e.getMessage() + AXGen.getStackTrace(e));
        }
    }

    public void close() {
        try {
            if (this.result != null) {
                this.result.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (this.pStmt != null) {
                this.pStmt.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.metaData = null;
        this.result = null;
        this.pStmt = null;
        this.stmt = null;
    }

    public void finalize() throws SQLException, Throwable {
        this.close();
        super.finalize();
    }
}

