/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.swing;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.FocusManager;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jpos.basscom.swing.BDefTblCellCheckBoxRenderer;
import jpos.basscom.swing.BDefTblCellEditor;
import jpos.basscom.swing.BDefTblCellRenderer;
import jpos.basscom.swing.BDefTblRowHdrRenderer;
import jpos.basscom.swing.BJCheckBox;
import jpos.basscom.swing.BJDialog;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.swing.event.BTblSearchListener;
import jpos.basscom.swing.event.BTblValidateListener;
import jpos.basscom.utils.TypConv;
import jpos.basscom.utils.Utils;
import jpos.ui.TouchTable;

public class BJTable
extends TouchTable {
    static ResourceBundle res = ResourceBundle.getBundle("TransJavaCommon");
    protected boolean bivEditMsgToParent = true;
    public static final int COL_ALGIN_LEFT = 2;
    public static final int COL_ALGIN_CENTER = 0;
    public static final int COL_ALGIN_RIGHT = 4;
    public static final int COL_TYPE_STRING = 0;
    public static final int COL_TYPE_BOOLEAN = 4;
    public static final String ROW_EDITED = "-";
    public static final String ROW_ADDED = "+";
    public static final String ROW_DELETED = "x";
    private int nivRow = -1;
    private int nivEditedRow = -1;
    private int nivCol = -1;
    private int nivEditedCol = -1;
    private boolean bivCellEdited = false;
    private boolean bivSortEnabled = false;
    private boolean ascending = true;
    private boolean bivAlignColHdr = false;
    private boolean bivInclRowHdr = true;
    private boolean bivSetRowHdrFlags = true;
    private MyTableModel tblModel;
    private transient Vector<BTblValidateListener> BTblValidateListeners;
    private transient Vector<BTblSearchListener> BTblSearchListeners;
    protected int DBType = 0;
    protected final int INTERNALREFOFFSET = 100;

    public BJTable(int pDBType) {
        this.DBType = pDBType;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public BJTable() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.tblModel = new MyTableModel();
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BJTable.this.rowClick(e);
            }
        });
        this.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BJTable.this.columnClick(e);
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){
            boolean bRClick = false;

            @Override
            public void mouseReleased(MouseEvent e) {
                this.bRClick = false;
                if (e.isPopupTrigger()) {
                    this.bRClick = true;
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!this.bRClick) {
                    BJTable.this.headerLClick(e);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BJTable.this.nivCol > -1 && BJTable.this.getColumnType(BJTable.this.nivCol) == 4 && BJTable.this.isCellEditable(BJTable.this.nivRow, BJTable.this.nivCol) && BJTable.this.actionEdit()) {
                    if (BJTable.this.getCellValueAt(BJTable.this.nivRow, BJTable.this.nivCol).equals("true")) {
                        BJTable.this.setCellValueAt("false", BJTable.this.nivRow, BJTable.this.nivCol);
                    } else {
                        BJTable.this.setCellValueAt("true", BJTable.this.nivRow, BJTable.this.nivCol);
                    }
                }
                if (e.getClickCount() == 2) {
                    if (BJTable.this.getColumnType(BJTable.this.nivCol) == 4) {
                        return;
                    }
                    if ((e.getModifiers() & 1) == 1) {
                        if (BJTable.this.isCellEditable(BJTable.this.nivRow, BJTable.this.nivCol) && BJTable.this.actionEdit()) {
                            BJTable.this.bivCellEdited = false;
                            BJTable.this.fireActionShiftSearch(BJTable.this.nivRow, BJTable.this.nivCol);
                        }
                    } else if (BJTable.this.isCellEditable(BJTable.this.nivRow, BJTable.this.nivCol) && BJTable.this.actionEdit()) {
                        BJTable.this.bivCellEdited = false;
                        BJTable.this.actionSearch2(BJTable.this.nivRow, BJTable.this.nivCol);
                        BJTable.this.fireActionSearch(BJTable.this.nivRow, BJTable.this.nivCol);
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\t') {
                    // empty if block
                }
                BJTable.this.fireActionKeyPressed(e);
                if (e.getKeyCode() == 10) {
                    BJTable.this.actionEnter();
                    return;
                }
                if (e.getKeyCode() == 32) {
                    if (BJTable.this.nivCol > -1 && BJTable.this.getColumnType(BJTable.this.nivCol) == 4 && BJTable.this.isCellEditable(BJTable.this.nivRow, BJTable.this.nivCol) && BJTable.this.actionEdit()) {
                        if (BJTable.this.getCellValueAt(BJTable.this.nivRow, BJTable.this.nivCol).equals("true")) {
                            BJTable.this.setCellValueAt("false", BJTable.this.nivRow, BJTable.this.nivCol);
                        } else {
                            BJTable.this.setCellValueAt("true", BJTable.this.nivRow, BJTable.this.nivCol);
                        }
                    }
                    BJTable.this.setCellFocus(BJTable.this.nivRow, BJTable.this.nivCol);
                } else if (e.getKeyCode() == 123) {
                    if (BJTable.this.getColumnType(BJTable.this.nivCol) == 4) {
                        return;
                    }
                    if (BJTable.this.isEditing()) {
                        BJTable.this.stopCellEditingAt(BJTable.this.getEditingRow(), BJTable.this.getEditingColumn());
                    }
                    if ((e.getModifiers() & 1) == 1) {
                        if (BJTable.this.isCellEditable(BJTable.this.nivRow, BJTable.this.nivCol) && BJTable.this.actionEdit()) {
                            BJTable.this.bivCellEdited = false;
                            BJTable.this.fireActionShiftSearch(BJTable.this.nivRow, BJTable.this.nivCol);
                        }
                    } else if (BJTable.this.isCellEditable(BJTable.this.nivRow, BJTable.this.nivCol) && BJTable.this.actionEdit()) {
                        BJTable.this.bivCellEdited = false;
                        BJTable.this.actionSearch2(BJTable.this.nivRow, BJTable.this.nivCol);
                        BJTable.this.fireActionSearch(BJTable.this.nivRow, BJTable.this.nivCol);
                    }
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (BJTable.this.nivRow < 0) {
                    BJTable.this.nivRow = 0;
                }
                if (BJTable.this.nivCol < 0) {
                    BJTable.this.nivCol = 0;
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                BJTable.this.doLoseFocus();
            }
        });
    }

    public void hideColumn(String colName) {
        this.hideColumn(this.getColumn(colName));
    }

    public void hideColumn(int col) {
        this.columnModel.getColumn(col).setMinWidth(0);
        this.columnModel.getColumn(col).setPreferredWidth(0);
        this.columnModel.getColumn(col).setMaxWidth(0);
        this.setColumnEditableAt(false, col);
    }

    public void doLoseFocus() {
        if (this.nivEditedRow > -1 && this.nivEditedCol > -1 && this.isCellEditable(this.nivEditedRow, this.nivEditedCol) && this.bivCellEdited) {
            this.bivCellEdited = false;
            if (this.isEditing()) {
                this.stopCellEditingAt(this.nivEditedRow, this.nivEditedCol);
            }
            this.fireActionValidate(this.nivEditedRow, this.nivEditedCol);
        }
    }

    public void setEditMsgToParent(boolean bEditMsgToParent) {
        this.bivEditMsgToParent = bEditMsgToParent;
    }

    public boolean getEditMsgToParent() {
        return this.bivEditMsgToParent;
    }

    protected void actionEnter() {
        Container parent = this.getTopLevelAncestor();
        if (parent instanceof BJDialog) {
            BJDialog p = (BJDialog)parent;
            p.actionEnter();
        }
    }

    protected void fireActionKeyPressed(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyChar() == '\t') {
            boolean bBackward = e.isShiftDown();
            if (bBackward) {
                if ((this.nivCol == 0 || this.nivCol == 1 && this.bivInclRowHdr) && this.nivRow == 0) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this);
                    return;
                }
            } else if (this.nivCol == this.getColumnCount() - 1 && this.nivRow == this.getRowCount() - 1) {
                FocusManager.getCurrentManager().focusNextComponent(this);
                return;
            }
            if (!this.isCellEditable(this.nivRow, this.nivCol)) {
                this.setNextEditable(!bBackward);
                this.scroll(this.nivRow, this.nivCol, !bBackward);
                e.consume();
            }
        }
    }

    protected void fireProcessKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyChar() == '\t' && !this.isCellEditable(this.nivRow, this.nivCol) && !this.setNextEditable(!e.isShiftDown())) {
            if (e.isShiftDown()) {
                FocusManager.getCurrentManager().focusPreviousComponent(this);
            } else {
                FocusManager.getCurrentManager().focusNextComponent(this);
            }
        }
    }

    private boolean setNextEditable(boolean forward) {
        if (forward) {
            for (int row = this.nivRow; row < this.getRowCount(); ++row) {
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    if (row == this.nivRow && col <= this.nivCol || !this.isCellEditable(row, col)) continue;
                    this.nivRow = row;
                    this.nivCol = col;
                    this.setCell(this.nivRow, this.nivCol);
                    this.scroll(this.nivRow, this.nivCol, true);
                    return true;
                }
            }
        } else {
            for (int row = this.nivRow; row >= 0; --row) {
                for (int col = this.getColumnCount() - 1; col >= 0; --col) {
                    if (row == this.nivRow && col >= this.nivCol || !this.isCellEditable(row, col)) continue;
                    this.nivRow = row;
                    this.nivCol = col;
                    this.setCell(this.nivRow, this.nivCol);
                    this.scroll(this.nivRow, this.nivCol, false);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean actionEdit() {
        if (!this.bivEditMsgToParent) {
            if (this.nivRow > -1 && this.nivCol > -1) {
                if (this.isCellEditable(this.nivRow, this.nivCol) && !this.getRowHdrValueAt(this.nivRow).equals(ROW_ADDED) && !this.getRowHdrValueAt(this.nivRow).equals(ROW_DELETED) && this.bivSetRowHdrFlags) {
                    this.setRowHdrValueAt(ROW_EDITED, this.nivRow);
                }
                this.bivCellEdited = true;
                this.nivEditedRow = this.nivRow;
                this.nivEditedCol = this.nivCol;
            }
            return true;
        }
        Container parent = this.getTopLevelAncestor();
        if (parent != null && parent instanceof BJDialog && !((BJDialog)parent).actionEdit()) {
            return false;
        }
        if (this.nivRow > -1 && this.nivCol > -1) {
            if (this.isCellEditable(this.nivRow, this.nivCol) && !this.getRowHdrValueAt(this.nivRow).equals(ROW_ADDED) && !this.getRowHdrValueAt(this.nivRow).equals(ROW_DELETED) && this.bivSetRowHdrFlags) {
                this.setRowHdrValueAt(ROW_EDITED, this.nivRow);
            }
            this.bivCellEdited = true;
            this.nivEditedRow = this.nivRow;
            this.nivEditedCol = this.nivCol;
        }
        return true;
    }

    protected void actionSearch(int row, int col) {
    }

    protected void actionSearch2(int row, int col) {
    }

    protected void actionShiftSearch(int row, int col) {
    }

    protected void actionValidate(int row, int col) {
    }

    protected void actionClick(int row, int col) {
    }

    protected void actionDoubleClick(int row, int col) {
    }

    protected void actionColHdrClick(int col) {
    }

    protected void actionColHdrRightClick(int col) {
    }

    protected void actionColHdrDoubleClick(int col) {
    }

    protected void actionColHdrRightDoubleClick(int col) {
    }

    private void rowClick(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            this.nivRow = lsm.getMinSelectionIndex();
            if (this.nivEditedRow > -1 && this.nivEditedCol > -1 && this.isCellEditable(this.nivEditedRow, this.nivEditedCol) && this.bivCellEdited) {
                this.bivCellEdited = false;
                if (this.isEditing()) {
                    this.stopCellEditingAt(this.nivEditedRow, this.nivEditedCol);
                }
                this.fireActionValidate(this.nivEditedRow, this.nivEditedCol);
            }
            this.triggerEdit(this.nivRow, this.nivCol);
        }
    }

    private void columnClick(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            this.nivCol = lsm.getMinSelectionIndex();
            if (this.nivEditedRow > -1 && this.nivEditedCol > -1 && this.isCellEditable(this.nivEditedRow, this.nivEditedCol) && this.bivCellEdited) {
                this.bivCellEdited = false;
                if (this.isEditing()) {
                    this.stopCellEditingAt(this.nivEditedRow, this.nivEditedCol);
                }
                this.fireActionValidate(this.nivEditedRow, this.nivEditedCol);
            }
            this.triggerEdit(this.nivRow, this.nivCol);
        }
    }

    private void triggerEdit(int row, int col) {
        if (row > -1 && col > -1) {
            if (!this.isCellEditable(row, col)) {
                return;
            }
            if (this.getColumnType(col) == 0) {
                this.editCellAt(row, col);
                ((LBJTextField)this.getColumnObject(col)).setFocus();
            }
        }
    }

    private void headerLClick(MouseEvent e) {
        TableColumnModel columnModel = this.getColumnModel();
        int column = columnModel.getColumnIndexAtX(e.getX());
        if (this.bivSortEnabled) {
            this.sortModelByColumn(this.tblModel, column, this.ascending);
            this.ascending = !this.ascending;
        }
    }

    private void columnCreate(int col, Object obj) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        this.tblModel.setColumnObject(obj, col);
    }

    public void setUp(String[] colNames, String[] colTitles, int[] colAlignments, int[] colWidths, int[] colTypes, int numOfCols, boolean alignColHdr, boolean includeRowHdr, boolean setRowHdrFlags) {
        this.bivAlignColHdr = alignColHdr;
        this.bivInclRowHdr = includeRowHdr;
        this.bivSetRowHdrFlags = setRowHdrFlags;
        for (int col = 0; col < numOfCols; ++col) {
            this.tblModel.addColumn(colNames[col], colTitles[col], colAlignments[col], colWidths[col], colTypes[col]);
        }
        this.refresh();
    }

    public void setColumnChars(int col, int chars) {
        this.tblModel.setColumnChars(chars, col);
        if (col < this.getColumnCount() && this.getColumnObject(col) instanceof LBJTextField) {
            ((LBJTextField)this.getColumnObject(col)).setMaximumCharacters(chars);
        }
    }

    public void setColumnChars(String colName, int chars) {
        this.setColumnChars(this.getColumn(colName), chars);
    }

    public int getColumnChars(int col) {
        return this.tblModel.getColumnChars(col);
    }

    public int getColumnChars(String colName) {
        return this.getColumnChars(this.getColumn(colName));
    }

    public void addColumn(String colName, String colTitle, int colAlignment, int colWidth, int colType) {
        this.tblModel.addColumn(colName, colTitle, colAlignment, colWidth, colType);
        this.tblModel.fireTableStructureChanged();
        this.refresh();
    }

    public void addNewRow() {
        Vector<Object> vTmp = new Vector<Object>();
        String sTmp = "";
        int col = 0;
        if (this.bivInclRowHdr) {
            col = 1;
        }
        while (col < this.tblModel.getAllColumnCount()) {
            sTmp = this.tblModel.getColumnType(col) == 4 ? "false" : "";
            vTmp.addElement(sTmp);
            ++col;
        }
        this.tblModel.addRowData(vTmp);
        if (!this.setRowAdded(this.tblModel.getRowCount() - 1)) {
            return;
        }
        this.tblModel.fireTableDataChanged();
        this.setRow(this.tblModel.getRowCount() - 1);
    }

    public Vector<Object> getRowData(int row) {
        return this.tblModel.getRowData(row);
    }

    public void insertNewRow(Vector<Object> vRowData, int row) {
        this.tblModel.insertRowData(vRowData, row);
        if (!this.setRowAdded(row)) {
            return;
        }
        this.tblModel.fireTableDataChanged();
        this.setRow(row);
    }

    public void deleteRow(int row) {
        if (!this.setRowDeleted(row)) {
            return;
        }
        this.tblModel.fireTableDataChanged();
    }

    public void deleteRow(int row, boolean bPermanent) {
        if (bPermanent) {
            this.tblModel.deleteRowData(row);
        } else if (!this.setRowDeleted(row)) {
            return;
        }
        this.tblModel.fireTableDataChanged();
    }

    public void setCellValueAt(String val, int row, int col) {
        if (row == -1 || col == -1) {
            return;
        }
        if (val == null || val.equals("")) {
            val = this.getColumnType(col) == 4 ? "false" : "";
        }
        int colM = col;
        if (col < this.getColumnCount()) {
            colM = this.convertColumnIndexToModel(col);
        }
        this.tblModel.setCellValueAt(val, row, colM);
        if (this.isEditing() && row == this.nivRow && col == this.nivCol) {
            this.setCellEditorValueAt(val, row, col);
        }
    }

    public void setCellValueAt(String val, int row, String colName) {
        this.setCellValueAt(val, row, this.getColumn(colName));
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        this.tblModel.setValueAt(obj, row, col);
    }

    public void setCellEditorValueAt(String val, int row, int col) {
        if (this.getColumnType(col) == 0) {
            ((LBJTextField)this.getColumnObject(col)).setVal(val);
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        return this.tblModel.getValueAt(row, col);
    }

    public String getCellValueAt(int row, int col) {
        if (row == -1 || col == -1) {
            return "";
        }
        if (this.isEditing() && row == this.nivRow && col == this.nivCol) {
            return this.getCellEditorValueAt(row, col);
        }
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        return this.tblModel.getCellValueAt(row, col);
    }

    public String getCellValueAt(int row, String colName) {
        return this.getCellValueAt(row, this.getColumn(colName));
    }

    public String getCellEditorValueAt(int row, int col) {
        return this.getCellEditor(row, col).getCellEditorValue().toString();
    }

    public String getCellEditorValueAt(int row, String colName) {
        return this.getCellEditorValueAt(row, this.getColumn(colName));
    }

    public void cancelCellEditingAt(int row, int col) {
        this.getCellEditor(row, col).cancelCellEditing();
    }

    public void cancelCellEditingAt(int row, String colName) {
        this.cancelCellEditingAt(row, this.getColumn(colName));
    }

    public void stopCellEditingAt(int row, int col) {
        this.getCellEditor(row, col).stopCellEditing();
    }

    public void stopCellEditingAt(int row, String colName) {
        this.stopCellEditingAt(row, this.getColumn(colName));
    }

    public boolean setRowEdited(int row) {
        return this.setRowFlag(row, ROW_EDITED);
    }

    public boolean setRowAdded(int row) {
        return this.setRowFlag(row, ROW_ADDED);
    }

    public boolean setRowDeleted(int row) {
        if (this.setRowFlag(row, ROW_DELETED)) {
            this.setRowEditableAt(false, row);
            return true;
        }
        return false;
    }

    private boolean setRowFlag(int row, String flag) {
        if (!this.bivEditMsgToParent) {
            if (row > -1 && this.isRowEditableAt(row)) {
                if (this.bivSetRowHdrFlags) {
                    this.setRowHdrValueAt(flag, row);
                }
                this.nivEditedRow = row;
                return true;
            }
            return false;
        }
        Container parent = this.getTopLevelAncestor();
        if (parent != null && parent instanceof BJDialog && !((BJDialog)parent).actionEdit()) {
            return false;
        }
        if (row > -1 && this.isRowEditableAt(row)) {
            if (this.bivSetRowHdrFlags) {
                this.setRowHdrValueAt(flag, row);
            }
            this.nivEditedRow = row;
            return true;
        }
        return false;
    }

    public void setRowHdrValueAt(String val, int row) {
        if (this.bivInclRowHdr) {
            this.tblModel.setRowHdrValueAt(val, row);
        }
    }

    public String getRowHdrValueAt(int row) {
        if (this.bivInclRowHdr) {
            return this.tblModel.getRowHdrValueAt(row).toString();
        }
        return "";
    }

    public boolean isRowAdded(int row) {
        return this.getRowHdrValueAt(row).equals(ROW_ADDED);
    }

    public boolean isRowEdited(int row) {
        return this.getRowHdrValueAt(row).equals(ROW_EDITED);
    }

    public boolean isRowDeleted(int row) {
        return this.getRowHdrValueAt(row).equals(ROW_DELETED);
    }

    public void setCellEditableAt(boolean cellEditable, int row, int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        this.tblModel.setCellEditableAt(cellEditable, row, col);
    }

    public void setCellEditableAt(boolean cellEditable, int row, String colName) {
        this.setCellEditableAt(cellEditable, row, this.getColumn(colName));
    }

    public void setRowEditableAt(boolean colEditable, int row) {
        int col = 0;
        if (this.bivInclRowHdr) {
            col = 1;
        }
        while (col < this.tblModel.getAllColumnCount()) {
            this.tblModel.setCellEditableAt(colEditable, row, col);
            ++col;
        }
    }

    protected void setRowEditableAt(Vector<Boolean> vFlags, int row) {
        this.tblModel.setRowEditableAt(vFlags, row);
    }

    protected Vector<Boolean> getRowEidtableAt(int row) {
        return this.tblModel.getRowEditableAt(row);
    }

    public boolean isRowEditableAt(int row) {
        int col = 0;
        if (this.bivInclRowHdr) {
            col = 1;
        }
        while (col < this.tblModel.getAllColumnCount()) {
            if (this.tblModel.isCellEditable(row, col)) {
                return true;
            }
            ++col;
        }
        return false;
    }

    public void setColumnEditableAt(boolean rowEditable, int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        for (int row = 0; row < this.tblModel.getRowCount(); ++row) {
            this.tblModel.setCellEditableAt(rowEditable, row, col);
        }
    }

    public void setColumnEditableAt(boolean rowEditable, String colName) {
        this.setColumnEditableAt(rowEditable, this.getColumn(colName));
    }

    public void setEditable(boolean tblEditable) {
        int col = 0;
        if (this.bivInclRowHdr) {
            col = 1;
        }
        while (col < this.tblModel.getAllColumnCount()) {
            this.setColumnEditableAt(tblEditable, col);
            ++col;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        if (row > -1 && col > -1) {
            return this.tblModel.isCellEditable(row, col);
        }
        return false;
    }

    public boolean isCellEditable(int row, String colName) {
        return this.isCellEditable(row, this.getColumn(colName));
    }

    @Override
    public String getColumnName(int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        if (this.tblModel != null) {
            return this.tblModel.getColName(col);
        }
        return null;
    }

    public String getColumnTitle(int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        if (this.tblModel != null) {
            return this.tblModel.getColumnName(col);
        }
        return null;
    }

    public void setColumnTitle(int col, String title) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        if (this.tblModel != null && title != null) {
            this.tblModel.setColumnName(title, col);
            this.getTableHeader().getColumnModel().getColumn(col).setHeaderValue(title);
            this.tblModel.fireTableStructureChanged();
            this.refresh();
        }
    }

    public void setColumnTitle(String colName, String title) {
        this.setColumnTitle(this.getColumn(colName), title);
    }

    public int getColumnWidths() {
        int w = 0;
        for (int col = 0; col < this.tblModel.getColumnCount(); ++col) {
            w += this.getColumnWidth(col);
        }
        return w;
    }

    public int getColumnWidth(int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        return this.tblModel.getColumnWidth(col);
    }

    public int getColumnWidth(String colName) {
        return this.getColumnWidth(this.getColumn(colName));
    }

    public Object getColumnObject(int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        if (this.tblModel != null) {
            return this.tblModel.getColumnObject(col);
        }
        return null;
    }

    public Object getColumnObject(String colName) {
        return this.getColumnObject(this.getColumn(colName));
    }

    public int getColumnType(int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        if (this.tblModel != null) {
            return this.tblModel.getColumnType(col);
        }
        return -1;
    }

    public int getColumnType(String colName) {
        return this.getColumnType(this.getColumn(colName));
    }

    public int getColumnAlignment(int col) {
        if (col < this.getColumnCount()) {
            col = this.convertColumnIndexToModel(col);
        }
        if (this.tblModel != null) {
            return this.tblModel.getColumnAlignment(col);
        }
        return 0;
    }

    @Override
    public int getRowCount() {
        if (this.tblModel != null) {
            return this.tblModel.getRowCount();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this.tblModel != null) {
            return this.tblModel.getColumnCount();
        }
        return 0;
    }

    public int getAllColumnCount() {
        if (this.tblModel != null) {
            return this.tblModel.getAllColumnCount();
        }
        return 0;
    }

    private void refresh() {
        this.setModel(this.tblModel);
        if (this.bivAlignColHdr) {
            this.setHeaderAlignment();
        }
        this.setCellAlignment();
        this.setCellWidth();
        this.setCellType();
    }

    private void setHeaderAlignment() {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            TableColumn tblCol = this.getColumnModel().getColumn(col);
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer();
            renderer.setHorizontalAlignment(this.getColumnAlignment(col));
            tblCol.setHeaderRenderer(renderer);
        }
    }

    private void setCellAlignment() {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            TableColumn tblCol = this.getColumnModel().getColumn(col);
            if (this.getColumnType(col) == 4) continue;
            if (this.bivInclRowHdr && col == 0) {
                BDefTblRowHdrRenderer renderer2 = new BDefTblRowHdrRenderer();
                renderer2.setHorizontalAlignment(this.getColumnAlignment(col));
                tblCol.setCellRenderer(renderer2);
                continue;
            }
            BDefTblCellRenderer renderer = new BDefTblCellRenderer();
            renderer.setHorizontalAlignment(this.getColumnAlignment(col));
            tblCol.setCellRenderer(renderer);
        }
    }

    private void setCellWidth() {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            TableColumn tblCol = this.getColumnModel().getColumn(col);
            if (this.getColumnWidth(col) == 0 || this.bivInclRowHdr && col == 0) {
                tblCol.setMinWidth(this.getColumnWidth(col));
                tblCol.setMaxWidth(this.getColumnWidth(col));
            }
            tblCol.setPreferredWidth(this.getColumnWidth(col));
        }
    }

    public void setCellType() {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            int colType = this.getColumnType(col);
            TableColumn tblCol = this.getColumnModel().getColumn(col);
            if (colType == 4) {
                BJCheckBox checkBox = new BJCheckBox();
                this.columnCreate(col, checkBox);
                checkBox.setHorizontalAlignment(0);
                tblCol.setCellEditor(new BDefTblCellEditor(checkBox));
                tblCol.setCellRenderer(new BDefTblCellCheckBoxRenderer());
                continue;
            }
            LBJTextField textField = new LBJTextField(this);
            this.columnCreate(col, textField);
            textField.setHorizontalAlignment(this.getColumnAlignment(col));
            textField.setMaximumCharacters(this.getColumnChars(col));
            tblCol.setCellEditor(new BDefTblCellEditor(textField));
        }
    }

    public int getCurrentRow() {
        return this.nivRow;
    }

    public int getCurrentColumn() {
        return this.nivCol;
    }

    public int getLastRow() {
        return this.tblModel.getRowCount() - 1;
    }

    public void setRow(int row) {
        this.setRowSelectionInterval(row, row);
    }

    public int getColumn(String colName) {
        if (this.tblModel != null) {
            int colM = this.tblModel.getColumn(colName);
            if (colM < this.getColumnCount()) {
                colM = this.convertColumnIndexToView(colM);
            }
            return colM;
        }
        return -1;
    }

    public void setColumn(int col) {
        this.setColumnSelectionInterval(col, col);
    }

    public void setColumn(String colName) {
        this.setColumn(this.getColumn(colName));
    }

    public void setCell(int row, int col) {
        this.setRow(row);
        this.setColumn(col);
    }

    public void setCell(int row, String colName) {
        this.setCell(row, this.getColumn(colName));
    }

    public void setCellFocus(int row, int col) {
        new FocusRequester(this, row, col);
    }

    public int findRow(int column, String value, int rowFrom, boolean bForward) {
        if (bForward) {
            for (int row = rowFrom; row < this.getRowCount(); ++row) {
                if (!this.getCellValueAt(row, column).equals(value)) continue;
                return row;
            }
        } else {
            for (int row = rowFrom; row > -1; ++row) {
                if (!this.getCellValueAt(row, column).equals(value)) continue;
                return row;
            }
        }
        return -1;
    }

    public int findRow(String colName, String value, int rowFrom, boolean bForward) {
        return this.findRow(this.getColumn(colName), value, rowFrom, bForward);
    }

    public int findRow(int column, String value, int rowFrom) {
        return this.findRow(column, value, rowFrom, true);
    }

    public int findRow(String colName, String value, int rowFrom) {
        return this.findRow(colName, value, rowFrom, true);
    }

    public int findRow(int column, String value) {
        return this.findRow(column, value, 0);
    }

    public int findRow(String colName, String value) {
        return this.findRow(colName, value, 0);
    }

    public boolean isEdited() {
        return this.bivCellEdited;
    }

    public void scroll(int row, boolean down) {
        int difference = 0;
        Rectangle visibleRect = this.getVisibleRect();
        if (down) {
            int rectEndY = visibleRect.y + visibleRect.height;
            int rowEndY = (row + 1) * this.getRowHeight();
            difference = rowEndY - rectEndY;
        } else {
            int rectStartY = visibleRect.y;
            int rowStartY = row * this.getRowHeight();
            difference = rowStartY - rectStartY;
        }
        if (down && difference > 0 || !down && difference < 0) {
            Rectangle newVisibleRect = new Rectangle(visibleRect.x, visibleRect.y + difference, visibleRect.width, visibleRect.height);
            this.scrollRectToVisible(newVisibleRect);
        }
    }

    public void scroll(int row, int col, boolean forward) {
        this.scroll(row, forward);
        int x = this.getVisibleRect().x;
        int y = this.getVisibleRect().y;
        int w = this.getVisibleRect().width;
        int h = this.getVisibleRect().height;
        int firstVisibleCol = this.columnAtPoint(new Point(x, y));
        int lastVisibleCol = this.columnAtPoint(new Point(x + w, y));
        if (firstVisibleCol > -1 && col < firstVisibleCol) {
            w = 0;
            for (int cnt = firstVisibleCol - 1; cnt >= col && cnt >= 1; --cnt) {
                w += this.getColumnWidth(cnt);
            }
            Rectangle rect = new Rectangle(x -= w, y, w, h);
            this.scrollRectToVisible(rect);
        }
        if (lastVisibleCol > -1 && col > lastVisibleCol) {
            w = 0;
            for (int cnt = lastVisibleCol + 1; cnt <= col && cnt <= this.getColumnCount(); ++cnt) {
                w += this.getColumnWidth(cnt);
            }
            x = x + this.getVisibleRect().width + w;
            Rectangle rect = new Rectangle(x, y, w, h);
            this.scrollRectToVisible(rect);
        }
    }

    public void setSortEnable(boolean enable) {
        this.bivSortEnabled = enable;
    }

    public boolean getSortEnable() {
        return this.bivSortEnabled;
    }

    public void sortModelByColumn(int column, boolean ascending) {
        this.sortModelByColumn((MyTableModel)this.getModel(), column, ascending);
    }

    public void sortModelByColumn(MyTableModel model, int column, boolean ascending) {
        int i;
        int[] indexes = new int[model.getRowCount()];
        for (i = 0; i < model.getRowCount(); ++i) {
            indexes[i] = i;
        }
        for (i = 0; i < model.getRowCount(); ++i) {
            for (int j = i + 1; j < model.getRowCount(); ++j) {
                int tmp;
                if (this.compare(model, indexes[i], indexes[j], column) < 0) {
                    if (ascending) continue;
                    tmp = indexes[i];
                    indexes[i] = indexes[j];
                    indexes[j] = tmp;
                    continue;
                }
                if (this.compare(model, indexes[i], indexes[j], column) <= 0 || !ascending) continue;
                tmp = indexes[i];
                indexes[i] = indexes[j];
                indexes[j] = tmp;
            }
        }
        Vector<Vector<Object>> vvData = new Vector<Vector<Object>>();
        Vector<Vector<Boolean>> vvEditable = new Vector<Vector<Boolean>>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            vvData.addElement(model.getRowData(indexes[row]));
            vvEditable.addElement(model.vvivCellEditable.get(indexes[row]));
        }
        model.deleteData();
        model.addData(vvData);
        model.vvivCellEditable = vvEditable;
    }

    private int compare(MyTableModel model, int row1, int row2, int column) {
        Object v2;
        String s2;
        Class<?> type = model.getColumnClass(column);
        Object o1 = model.getValueAt(row1, column);
        Object o2 = model.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)model.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)model.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)model.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)model.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s22;
            String s1 = (String)model.getValueAt(row1, column);
            int result = s1.compareTo(s22 = (String)model.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)model.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)model.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = model.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = model.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public synchronized void addBTblValidateListener(BTblValidateListener l) {
        if (this.BTblValidateListeners == null) {
            this.BTblValidateListeners = new Vector(2);
        }
        if (!this.BTblValidateListeners.contains(l)) {
            this.BTblValidateListeners.addElement(l);
        }
    }

    protected void fireActionValidate(int row, int col) {
        if (row <= -1 || col <= -1) {
            return;
        }
        this.nivEditedRow = -1;
        this.nivEditedCol = -1;
        if (this.BTblValidateListeners != null) {
            Vector<BTblValidateListener> listeners = this.BTblValidateListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).actionValidate(row, col);
            }
        }
    }

    public synchronized void addBTblSearchListener(BTblSearchListener l) {
        if (this.BTblSearchListeners == null) {
            this.BTblSearchListeners = new Vector(2);
        }
        if (!this.BTblSearchListeners.contains(l)) {
            this.BTblSearchListeners.addElement(l);
        }
    }

    protected void fireActionSearch(int row, int col) {
        if (this.BTblSearchListeners != null) {
            Vector<BTblSearchListener> listeners = this.BTblSearchListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).actionSearch(row, col);
            }
        }
    }

    protected void fireActionShiftSearch(int row, int col) {
        if (this.BTblSearchListeners != null) {
            Vector<BTblSearchListener> listeners = this.BTblSearchListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).actionShiftSearch(row, col);
            }
        }
    }

    class FocusRequester
    implements Runnable {
        private BJTable comp;
        private int row;
        private int col;

        public FocusRequester(BJTable comp, int row, int col) {
            this.comp = comp;
            this.row = row;
            this.col = col;
            try {
                SwingUtilities.invokeLater(this);
            }
            catch (Exception e) {
                Utils.logError(e);
            }
        }

        @Override
        public void run() {
            this.comp.requestFocus();
            this.comp.setCell(this.row, this.col);
        }
    }

    class LBJTextField
    extends BJTextField {
        BJTable parent;

        public LBJTextField(BJTable parent) {
            this.parent = parent;
        }

        @Override
        public void actionSearch() {
            if (this.parent.isCellEditable(this.parent.nivRow, this.parent.nivCol) && this.parent.actionEdit()) {
                this.parent.fireActionSearch(this.parent.nivRow, this.parent.nivCol);
            }
        }

        @Override
        public void actionShiftSearch() {
            if (this.parent.isCellEditable(this.parent.nivRow, this.parent.nivCol) && this.parent.actionEdit()) {
                this.parent.fireActionShiftSearch(this.parent.nivRow, this.parent.nivCol);
            }
        }

        @Override
        public void actionValidate() {
            if (this.parent.isCellEditable(this.parent.nivRow, this.parent.nivCol) && this.parent.bivCellEdited) {
                this.parent.bivCellEdited = false;
                this.parent.fireActionValidate(this.parent.nivRow, this.parent.nivCol);
            }
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
            this.parent.fireProcessKeyEvent(e);
            if (e.getKeyCode() == 9) {
                this.selectAll();
                this.parent.scroll(this.parent.nivRow, this.parent.nivCol, e.getModifiers() != 16);
            }
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        Vector<String> vivColNames = new Vector();
        Vector<String> vivColTitles = new Vector();
        Vector<Integer> vivColWidth = new Vector();
        Vector<Integer> vivColAlignment = new Vector();
        Vector<Integer> vivColType = new Vector();
        Vector<Object> vivColObject = new Vector();
        Vector<Integer> vivColChars = new Vector();
        Vector<Vector<Object>> vvivData = new Vector();
        Vector<Vector<Boolean>> vvivCellEditable = new Vector();

        @Override
        public int getColumnCount() {
            return this.vivColNames.size();
        }

        public int getAllColumnCount() {
            return this.vivColNames.size();
        }

        @Override
        public int getRowCount() {
            return this.vvivData.size();
        }

        public String getColName(int col) {
            return this.vivColNames.elementAt(col).toString();
        }

        @Override
        public String getColumnName(int col) {
            return this.vivColTitles.elementAt(col).toString();
        }

        public void setColumnName(String colTitle, int col) {
            this.vivColTitles.setElementAt(colTitle, col);
        }

        public int getColumnWidth(int col) {
            return this.vivColWidth.elementAt(col);
        }

        public void setColumnWidth(int width, int col) {
            this.vivColWidth.setElementAt(width, col);
        }

        public int getColumnChars(int col) {
            return TypConv.toInt(this.vivColChars.elementAt(col).toString());
        }

        public void setColumnChars(int chars, int col) {
            this.vivColChars.setElementAt(chars, col);
        }

        public int getColumnAlignment(int col) {
            return this.vivColAlignment.elementAt(col);
        }

        public void setColumnAlignment(int alignType, int col) {
            this.vivColAlignment.setElementAt(alignType, col);
        }

        public int getColumnType(int col) {
            return this.vivColType.elementAt(col);
        }

        public int getColumn(String colName) {
            return this.vivColNames.indexOf(colName);
        }

        public void setRowHdrValueAt(Object obj, int row) {
            this.setValueAt(obj, row, 0);
        }

        public Object getRowHdrValueAt(int row) {
            return this.getValueAt(row, 0);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.vvivData.elementAt(row).elementAt(col);
        }

        public String getCellValueAt(int row, int col) {
            if (this.getValueAt(row, col) == null || this.getValueAt(row, col).toString().equals("")) {
                return "";
            }
            if (this.getColumnType(col) == 4) {
                return ((Boolean)this.getValueAt(row, col)).toString();
            }
            return this.getValueAt(row, col).toString();
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        public void setCellEditableAt(boolean cellEditable, int row, int col) {
            Vector<Boolean> vTmp = this.vvivCellEditable.elementAt(row);
            vTmp.setElementAt(cellEditable, col);
            this.vvivCellEditable.setElementAt(vTmp, row);
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (row == -1 || col == -1) {
                return false;
            }
            return this.vvivCellEditable.elementAt(row).elementAt(col);
        }

        public Vector<Boolean> getRowEditableAt(int row) {
            return this.vvivCellEditable.get(row);
        }

        public void setRowEditableAt(Vector<Boolean> vFlags, int row) {
            this.vvivCellEditable.set(row, vFlags);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row >= this.getRowCount() || col >= this.getAllColumnCount()) {
                return;
            }
            Vector<Object> vTmp = new Vector();
            vTmp = this.vvivData.elementAt(row);
            vTmp.setElementAt(value, col);
            this.vvivData.setElementAt(vTmp, row);
            this.fireTableCellUpdated(row, col);
        }

        public void setCellValueAt(String val, int row, int col) {
            this.setValueAt(this.convertToObject(val, col), row, col);
        }

        public void addColumn(String colName, String colTitle, int colAlignment, int colWidth, int colType) {
            this.vivColNames.addElement(colName);
            this.vivColTitles.addElement(colTitle);
            this.vivColAlignment.addElement(colAlignment);
            this.vivColWidth.addElement(colWidth);
            this.vivColType.addElement(colType);
            this.vivColObject.addElement(null);
            this.vivColChars.addElement(250);
        }

        public void addData(Vector<Vector<Object>> vvData) {
            for (int row = 0; row < vvData.size(); ++row) {
                Vector<Object> vRowData = new Vector();
                vRowData = this.convertToObject(vvData.elementAt(row));
                this.vvivData.addElement(vRowData);
            }
        }

        public void addRowData(Vector<Object> vRowData) {
            if (BJTable.this.bivInclRowHdr) {
                vRowData.insertElementAt("", 0);
            }
            vRowData = this.convertToObject(vRowData);
            this.vvivData.addElement(vRowData);
            Vector<Boolean> vTmp = new Vector<Boolean>();
            for (int col = 0; col < this.getAllColumnCount(); ++col) {
                vTmp.addElement(Boolean.TRUE);
            }
            if (BJTable.this.bivInclRowHdr) {
                vTmp.setElementAt(Boolean.FALSE, 0);
            }
            this.vvivCellEditable.addElement(vTmp);
        }

        public void insertRowData(Vector<Object> vRowData, int nRow) {
            if (BJTable.this.bivInclRowHdr) {
                vRowData.insertElementAt("", 0);
            }
            vRowData = this.convertToObject(vRowData);
            this.vvivData.insertElementAt(vRowData, nRow);
            Vector<Boolean> vTmp = new Vector<Boolean>();
            for (int col = 0; col < this.getAllColumnCount(); ++col) {
                vTmp.addElement(Boolean.TRUE);
            }
            if (BJTable.this.bivInclRowHdr) {
                vTmp.setElementAt(Boolean.FALSE, 0);
            }
            this.vvivCellEditable.insertElementAt(vTmp, nRow);
        }

        public Vector<Object> getRowData(int nRow) {
            return this.vvivData.get(nRow);
        }

        public void deleteData() {
            this.vvivData.removeAllElements();
            this.vvivCellEditable.removeAllElements();
        }

        public void deleteRowData(int nRow) {
            this.vvivData.remove(nRow);
            this.vvivCellEditable.remove(nRow);
        }

        public void setColumnObject(Object obj, int col) {
            this.vivColObject.setElementAt(obj, col);
        }

        public Object getColumnObject(int col) {
            return this.vivColObject.elementAt(col);
        }

        public Vector<Object> convertToObject(Vector<Object> vRowData) {
            Vector<Object> vTmp = new Vector<Object>();
            for (int col = 0; col < vRowData.size(); ++col) {
                if (this.getColumnType(col) == 4) {
                    vTmp.addElement(new Boolean(vRowData.elementAt(col).toString()));
                    continue;
                }
                vTmp.addElement(vRowData.elementAt(col));
            }
            return vTmp;
        }

        public Object convertToObject(String val, int col) {
            if (this.getColumnType(col) == 4) {
                return new Boolean(val);
            }
            return val;
        }
    }
}

