/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.swing;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jpos.basscom.cache.Cacher;
import jpos.basscom.components.ToServ;
import jpos.basscom.components.searchFrame;
import jpos.basscom.swing.BJDialog;
import jpos.basscom.swing.BJTable;
import jpos.basscom.swing.event.BSearchListener;
import jpos.basscom.swing.event.BValidateListener;
import jpos.basscom.utils.Utils;
import jpos.ui.TouchTextField;

public class BJTextField
extends TouchTextField {
    static ResourceBundle res = ResourceBundle.getBundle("TransJavaCommon");
    protected boolean bivEditMsgToParent = true;
    public String strInst;
    private static int searchKey = 123;
    private boolean bSearchWithEnter = false;
    private String oldVal = "";
    private String oldDesc = "";
    private String oldidx = null;
    private long cacheidx = 0L;
    private Cacher cacher = null;
    private ToServ toserv = null;
    private String mandTable = null;
    private String fromTable = null;
    private String where = null;
    private String idxCol = null;
    private String codeCol = null;
    private boolean valid = false;
    private String[] sqlReturn = new String[]{"", "", ""};
    private String rsetInstance = null;
    private boolean multi = false;
    private boolean bSearch = false;
    private String titleExtension = "";
    private String[] hideCols;
    private int nivMaxChars = Integer.MAX_VALUE;
    private String orderByDir = "ASC";
    private boolean bShowSearchForOneResult = false;
    private String customNoDataMessage = null;
    private boolean suppressNoDataMessage = false;
    private transient Vector<BSearchListener> BSearchListeners;
    private transient Vector<BValidateListener> BValidateListeners;

    public BJTextField() {
        this(TouchTextField.FontSize.NORMAL);
    }

    public BJTextField(TouchTextField.FontSize fontSize) {
        super(fontSize);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public void setSearchKey(int pSearchKey) {
        searchKey = pSearchKey;
    }

    public void focusPop(long idx) {
    }

    public boolean isSearching() {
        return this.bSearch;
    }

    public void hideSearchCols(String[] hideCols) {
        this.hideCols = hideCols;
    }

    public String[] getHideSearchCols() {
        return this.hideCols;
    }

    public void doSearch() {
        this.doSearch(this.titleExtension);
    }

    public void doSearch(String titleExt) {
        this.doSearch(titleExt, this.getTopLevelAncestor());
    }

    public void doSearch(Container parent) {
        this.doSearch(this.titleExtension, parent);
    }

    public void doSearch(String titleExt, Container parent) {
        if (!this.bSearch) {
            this.bSearch = true;
            if (parent instanceof Window) {
                this.showSearchFrame(titleExt, (Window)parent);
            }
            this.setText(this.oldVal);
        }
    }

    public void showSearchFrame(String titleExt, Window parent) {
        new searchFrame(this, this.cacher, this.toserv, this.cacheidx, this.mandTable, this.fromTable, this.where, parent, titleExt, this.hideCols, this.multi, this.orderByDir, this.customNoDataMessage, this.suppressNoDataMessage);
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public void setCustomNoDataMessage(String customNoDataMessage) {
        this.customNoDataMessage = customNoDataMessage;
    }

    public void setSuppressNoDataMessage(boolean suppressNoDataMessage) {
        this.suppressNoDataMessage = suppressNoDataMessage;
    }

    public void clear() {
        this.setAllStr("0", "", "");
    }

    public void searchFinished() {
        this.bSearch = false;
    }

    public Cacher getCacher() {
        return this.cacher;
    }

    public long getCacheidx() {
        return this.cacheidx;
    }

    public void setTitleExt(String titleExtension) {
        this.titleExtension = titleExtension;
    }

    public ToServ getToServ() {
        return this.toserv;
    }

    public String getmandTable() {
        return this.mandTable;
    }

    public String getfromTable() {
        return this.fromTable;
    }

    public String getwhere() {
        return this.where;
    }

    public String getidxStr() {
        return this.oldidx;
    }

    public long getidx() {
        if (this.oldidx == null || this.oldidx.equals("")) {
            return -1L;
        }
        return Long.parseLong(this.oldidx);
    }

    public String getDesc() {
        return this.oldDesc;
    }

    public void setidx(long idx) {
        this.oldidx = String.valueOf(idx);
    }

    public void setidxStr(String idx) {
        this.oldidx = idx;
    }

    public void setVal(String val) {
        this.oldVal = val == null ? "" : val;
        this.setText(val);
    }

    public void setDesc(String desc) {
        this.oldDesc = desc;
    }

    public boolean getMulti() {
        return this.multi;
    }

    public void setFromSearch(String idx, String val, String desc, JDialog searchWin) {
        this.oldidx = idx == null ? "" : idx;
        this.oldVal = val == null ? "" : val;
        this.setText(this.oldVal);
        this.oldDesc = desc == null ? "" : desc;
        searchWin.setSize(0, 0);
        this.valid = true;
        this.actionValidate();
    }

    public void setAllStr(String idx, String val, String desc) {
        this.oldidx = idx == null ? "" : idx;
        this.oldVal = val == null ? "" : val;
        this.setText(this.oldVal);
        this.oldDesc = desc == null ? "" : desc;
    }

    public void setAll(long idx, String val, String desc) {
        this.setAllStr(idx + "", val, desc);
    }

    public BJTextField(String text) {
        super(text);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public void search() {
        this.actionSearch();
        this.fireActionSearch();
    }

    private void jbInit() throws Exception {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && BJTextField.this.isEditable() && BJTextField.this.isEnabled()) {
                    if ((e.getModifiers() & 1) == 1) {
                        BJTextField.this.actionShiftSearch();
                        BJTextField.this.fireActionShiftSearch();
                    } else {
                        BJTextField.this.search();
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == searchKey || BJTextField.this.bSearchWithEnter && e.getKeyCode() == 10) {
                    if ((e.getModifiers() & 1) == 1) {
                        BJTextField.this.actionShiftSearch();
                        BJTextField.this.fireActionShiftSearch();
                    } else {
                        BJTextField.this.search();
                    }
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BJTextField.this.actionInitSearch();
                BJTextField.this.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && BJTextField.this.hasValueChanged()) {
                    BJTextField.this.actionValidate();
                    BJTextField.this.fireActionValidate();
                }
            }
        });
    }

    @Override
    protected Document createDefaultModel() {
        return new TextDocument();
    }

    public void setEditMsgToParent(boolean bEditMsgToParent) {
        this.bivEditMsgToParent = bEditMsgToParent;
    }

    public boolean getEditMsgToParent() {
        return this.bivEditMsgToParent;
    }

    protected void actionClick() {
    }

    protected void actionDoubleClick() {
    }

    protected void actionDoubleClick2() {
    }

    protected void actionEdit() {
    }

    protected boolean actionEdit2() {
        if (!this.bivEditMsgToParent) {
            return true;
        }
        Container parent = this.getParent();
        if (!(parent instanceof BJTable)) {
            parent = this.getTopLevelAncestor();
        }
        return parent == null || !(parent instanceof BJDialog ? !((BJDialog)parent).actionEdit() : parent instanceof BJTable && !((BJTable)parent).actionEdit());
    }

    private void actionInitSearch() {
        this.oldVal = this.getText();
    }

    protected void actionValidate() {
        if (this.hasValueChanged()) {
            this.doValidate();
        }
    }

    public boolean hasValueChanged() {
        return !this.oldVal.equals(this.getText());
    }

    public boolean doValidate() {
        this.valid = true;
        if (!this.getText().equals("")) {
            if (this.cacheidx != 0L) {
                if (this.cacher == null) {
                    this.valid = false;
                } else {
                    if (!(this.idxCol != null && this.codeCol != null || this.loaditCache())) {
                        this.valid = false;
                    }
                    if (this.valid) {
                        this.rsetInstance = this.cacher.getQueryHandler(this.toserv, this.cacheidx, this.mandTable, "", this.where);
                        if (this.rsetInstance == null || this.rsetInstance.equals("")) {
                            this.valid = false;
                        } else {
                            this.valid = this.cacher.validate(this.rsetInstance, this.toserv, this.cacheidx, this.codeCol, this.getText(), this.sqlReturn, this.multi);
                            if (!this.valid || this.sqlReturn[0] == null || this.sqlReturn[0].equals("")) {
                                this.valid = false;
                            } else {
                                this.oldidx = this.sqlReturn[0];
                                this.setText(this.sqlReturn[1]);
                                this.oldDesc = this.sqlReturn[2];
                            }
                            this.cacher.clearQH(this.rsetInstance, this.toserv);
                        }
                    }
                }
            }
        } else {
            this.oldidx = "";
            this.oldDesc = "";
        }
        if (!this.valid) {
            this.doSearch();
            this.setText(this.oldVal);
            this.requestFocus();
            return this.valid;
        }
        this.oldVal = this.getText();
        return true;
    }

    protected void actionSearch() {
        this.doSearch();
    }

    protected void actionShiftSearch() {
    }

    public void setCache(Cacher cacher, ToServ toserv, long cacheidx, String mandTable, String fromTable, String where, boolean bMulti) {
        this.cacher = cacher;
        this.toserv = toserv;
        this.cacheidx = cacheidx;
        this.mandTable = mandTable;
        this.fromTable = fromTable;
        this.where = where;
        this.multi = bMulti;
        this.loaditCache();
    }

    public void setSearchOrderBy(String spOrderByDir) {
        this.orderByDir = spOrderByDir;
    }

    public String getSearchOrderByDir() {
        return this.orderByDir;
    }

    public void setCache(Cacher cacher, long cacheidx, String mandTable, String fromTable, String where) {
        this.setCache(cacher, null, cacheidx, mandTable, fromTable, where, false);
    }

    public void setCache(Cacher cacher, long cacheidx, String mandTable, String fromTable, String where, boolean bMulti) {
        this.setCache(cacher, null, cacheidx, mandTable, fromTable, where, bMulti);
    }

    public void setCache(Cacher cacher, ToServ toserv, long cacheidx, String mandTable, String fromTable, String where) {
        this.setCache(cacher, toserv, cacheidx, mandTable, fromTable, where, false);
    }

    public void setmandTable(String mandTable) {
        this.mandTable = mandTable;
    }

    public void setfromTable(String fromTable) {
        this.fromTable = fromTable;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public void setToServ(ToServ toserv) {
        this.toserv = toserv;
    }

    public void setMany(String mandTable, String fromTable, String where) {
        this.mandTable = mandTable;
        this.fromTable = fromTable;
        this.where = where;
    }

    public boolean populate(long idx) {
        return this.populate(idx + "");
    }

    public boolean populate(String idx) {
        this.valid = true;
        if (this.cacher == null) {
            this.valid = false;
        } else {
            if (!(this.idxCol != null && this.codeCol != null || this.loaditCache())) {
                this.valid = false;
            }
            if (this.valid) {
                this.rsetInstance = this.cacher.getQueryHandler(this.toserv, this.cacheidx, "", "", "");
                if (this.rsetInstance == null || this.rsetInstance.equals("")) {
                    this.valid = false;
                } else {
                    this.valid = this.cacher.validate(this.rsetInstance, this.toserv, this.cacheidx, this.idxCol, idx, this.sqlReturn, this.multi);
                    if (!this.valid || this.sqlReturn[0] == null || this.sqlReturn[0].equals("")) {
                        this.valid = false;
                    } else {
                        this.oldidx = this.sqlReturn[0];
                        this.setText(this.sqlReturn[1]);
                        this.oldDesc = this.sqlReturn[2];
                    }
                }
            }
        }
        return this.valid;
    }

    private boolean loaditCache() {
        this.cacher.loadCacheSql(this.toserv, this.cacheidx, this.mandTable, this.fromTable, this.where);
        this.idxCol = this.cacher.getUniqueidxName(this.toserv, this.cacheidx);
        this.codeCol = this.cacher.getColName(this.toserv, 0L, this.cacheidx);
        return this.idxCol != null;
    }

    public void setMaximumCharacters(int maxChars) {
        this.nivMaxChars = maxChars;
    }

    public int getMaximumCharacters() {
        return this.nivMaxChars;
    }

    public void setFocus() {
        this.requestFocus();
        this.selectAll();
    }

    public synchronized void addBSearchListener(BSearchListener l) {
        if (this.BSearchListeners == null) {
            this.BSearchListeners = new Vector(2);
        }
        if (!this.BSearchListeners.contains(l)) {
            this.BSearchListeners.addElement(l);
        }
    }

    protected void fireActionSearch() {
        if (this.BSearchListeners != null) {
            for (BSearchListener l : this.BSearchListeners) {
                l.actionSearch();
            }
        }
    }

    protected void fireActionShiftSearch() {
        if (this.BSearchListeners != null) {
            for (BSearchListener l : this.BSearchListeners) {
                l.actionShiftSearch();
            }
        }
    }

    public synchronized void addBValidateListener(BValidateListener l) {
        if (this.BValidateListeners == null) {
            this.BValidateListeners = new Vector(2);
        }
        if (!this.BValidateListeners.contains(l)) {
            this.BValidateListeners.addElement(l);
        }
    }

    protected void fireActionValidate() {
        if (this.BValidateListeners != null) {
            for (BValidateListener l : this.BValidateListeners) {
                l.actionValidate();
            }
        }
    }

    public void searchWithEnter(boolean pbSearchWithEnter) {
        this.bSearchWithEnter = pbSearchWithEnter;
    }

    public void setShowSearchForOneResult(boolean bShow) {
        this.bShowSearchForOneResult = bShow;
    }

    public boolean getShowSearchForOneResult() {
        return this.bShowSearchForOneResult;
    }

    protected class TextDocument
    extends PlainDocument {
        protected TextDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.getLength() < BJTextField.this.nivMaxChars && BJTextField.this.actionEdit2()) {
                super.insertString(offs, str, a);
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (BJTextField.this.actionEdit2()) {
                super.remove(offs, len);
            }
        }
    }
}

