/*
 * Decompiled with CFR 0.152.
 */
package jpos.capillary;

import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;

public class CapillaryTransaction {
    private static int MAX_REVERSAL_ATTEMPTS = 10;
    private long redemptionId = 0L;
    private String cardNumber;
    private String capillaryRedeemId;
    private double amount;
    private double points;
    private double pointsBalance;

    protected CapillaryTransaction() {
        this(0L);
    }

    private CapillaryTransaction(long redemptionId) {
        this.redemptionId = redemptionId;
        if (this.redemptionId > 0L) {
            this.loadFromDatabase();
        }
    }

    private void loadFromDatabase() {
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT CARD_NUMBER, AMOUNT, POINTS, CAPILLARY_REDEMPTION_ID, POINTS_BALANCE FROM CAPILLARY_TRANSACTION WHERE TRANSIDX = " + this.redemptionId);){
            if (query.next()) {
                this.cardNumber = query.getString("CARD_NUMBER");
                this.amount = query.getDouble("AMOUNT");
                this.capillaryRedeemId = query.getString("CAPILLARY_REDEMPTION_ID");
                this.points = query.getInt("POINTS");
                this.pointsBalance = query.getDouble("POINTS_BALANCE");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected boolean saveRedemption(String capillaryTransactionId, long memidx) {
        Timestamp redemptionDate = new Timestamp(new Date().getTime());
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO CAPILLARY_TRANSACTION (TRANSIDX, CARD_NUMBER, AMOUNT, POINTS, TILL_NAME, MEMIDX, REDEMPTION_DATE, CAPILLARY_REDEMPTION_ID, POINTS_BALANCE) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            this.redemptionId = SP.sParams.nextVal("XCAPILLARY_TRANSACTION");
            stmt.setLong(1, this.redemptionId);
            stmt.setString(2, this.cardNumber);
            stmt.setDouble(3, this.amount);
            stmt.setDouble(4, this.points);
            stmt.setString(5, SP.sParams.tillnum);
            stmt.setDouble(6, memidx);
            stmt.setTimestamp(7, redemptionDate);
            stmt.setString(8, capillaryTransactionId);
            stmt.setDouble(9, this.pointsBalance);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        this.capillaryRedeemId = capillaryTransactionId;
        return true;
    }

    protected boolean finishRedemption(long ap21TransactionId) {
        Throwable throwable;
        PreparedStatement stmt;
        if (this.redemptionId == 0L) {
            return false;
        }
        Timestamp committedDate = new Timestamp(new Date().getTime());
        try {
            stmt = SP.sParams.conn.prepareStatement("UPDATE CAPILLARY_TRANSACTION SET AP21_TRANSACTION_ID = ?, COMMITTED_DATE = ? WHERE TRANSIDX = ?");
            throwable = null;
            try {
                stmt.setLong(1, ap21TransactionId);
                stmt.setTimestamp(2, committedDate);
                stmt.setLong(3, this.redemptionId);
                stmt.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        try {
            stmt = SP.sParams.conn.prepareStatement("UPDATE RET_TRANH SET capillary_redemption_id = ?, capillary_redemption_value = ?, capillary_redemption_points = ?, capillary_points_balance = ? WHERE VHIDX = ?");
            throwable = null;
            try {
                stmt.setString(1, this.capillaryRedeemId);
                stmt.setDouble(2, this.amount);
                stmt.setDouble(3, this.points);
                stmt.setDouble(4, this.pointsBalance);
                stmt.setLong(5, ap21TransactionId);
                stmt.executeUpdate();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    protected boolean reverseRedemption() {
        if (this.redemptionId == 0L) {
            return false;
        }
        Timestamp reversalDate = new Timestamp(new Date().getTime());
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE CAPILLARY_TRANSACTION SET REVERSAL_DATE = ?, REVERSAL_ATTEMPT_COUNT = COALESCE(REVERSAL_ATTEMPT_COUNT,0) + 1 WHERE TRANSIDX = ?");){
            stmt.setTimestamp(1, reversalDate);
            stmt.setLong(2, this.redemptionId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    protected boolean logFailedReversal() {
        if (this.redemptionId == 0L) {
            return false;
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE CAPILLARY_TRANSACTION SET REVERSAL_ATTEMPT_COUNT = COALESCE(REVERSAL_ATTEMPT_COUNT,0) + 1 WHERE TRANSIDX = ?");){
            stmt.setLong(1, this.redemptionId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    protected static ArrayList<CapillaryTransaction> getAllTransactionsToReverse() {
        ArrayList<CapillaryTransaction> list = new ArrayList<CapillaryTransaction>();
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT TRANSIDX, REDEMPTION_DATE, REVERSAL_ATTEMPT_COUNT FROM CAPILLARY_TRANSACTION WHERE AP21_TRANSACTION_ID IS NULL AND REVERSAL_DATE IS NULL  AND COALESCE(REVERSAL_ATTEMPT_COUNT,0) <= " + MAX_REVERSAL_ATTEMPTS + " AND TILL_NAME = " + PosUtils.StringToSqlString(SP.sParams.tillnum));){
            while (query.next()) {
                int retryCount;
                Timestamp redemptionDate = query.getTimestamp("REDEMPTION_DATE");
                if (!CapillaryTransaction.canRetryReversal(redemptionDate, retryCount = query.getInt("REVERSAL_ATTEMPT_COUNT"))) continue;
                list.add(new CapillaryTransaction(query.getLong("TRANSIDX")));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return list;
    }

    protected void setCardNumber(String cardNo) {
        this.cardNumber = cardNo;
    }

    protected String getCardNumber() {
        return this.cardNumber;
    }

    protected String getCapillaryRedeemId() {
        return this.capillaryRedeemId;
    }

    protected double getAmount() {
        return this.amount;
    }

    protected void setAmount(double amount) {
        this.amount = amount;
    }

    protected double getPoints() {
        return this.points;
    }

    protected void setPoints(double points) {
        this.points = points;
    }

    protected double getPointsBalance() {
        return this.pointsBalance;
    }

    protected void setPointsBalance(double points) {
        this.pointsBalance = points;
    }

    protected static boolean canRetryReversal(Timestamp redemptionTime, int retryCount) {
        long retryMiliSeconds = CapillaryTransaction.calculateRetryMiliSeconds(retryCount);
        Date now = new Date();
        return redemptionTime.getTime() + retryMiliSeconds < now.getTime();
    }

    protected static long calculateRetryMiliSeconds(int retryCount) {
        if (retryCount == 0) {
            return 0L;
        }
        long minutes = 0L;
        for (int i = 0; i < retryCount; ++i) {
            minutes = (long)((double)minutes + Math.pow(2.0, i));
        }
        return minutes * 60L * 1000L;
    }
}

