/*
 * Decompiled with CFR 0.152.
 */
package jpos.crypt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StringUtils;
import jpos.ui.DialogButton;
import jpos.ui.TouchPasswordField;
import jpos.ui.TouchTextArea;
import jpos.ui.TouchTextField;

public class DlgPrompt
extends PosDialog {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private GridBagLayout gridBagLayoutButtons = new GridBagLayout();
    private JPanel panel = new JPanel();
    private JPanel panelButtons = new JPanel();
    private TouchTextArea jTextArea = new TouchTextArea();
    private DialogButton bOk = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private DialogButton bIgnore = new DialogButton("");
    private JTextField inputField;
    private String message;
    private boolean canCancel;
    private boolean canIgnore;
    private boolean userAccepted;
    private String userInput;

    public DlgPrompt(PosFrame frame, JDialog dlgParent, String title, String message, Buttons buttons, boolean hideInput) {
        super(frame, dlgParent, title, true);
        this.message = message;
        this.canCancel = buttons != Buttons.OK;
        this.canIgnore = buttons == Buttons.OK_CANCEL_IGNORE;
        this.userAccepted = false;
        this.userInput = "";
        try {
            this.jbInit(hideInput);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public DlgPrompt(PosFrame frame, String title, String message, Buttons buttons, boolean hideInput) {
        super(frame, title, true);
        this.message = message;
        this.canCancel = buttons != Buttons.OK;
        this.canIgnore = buttons == Buttons.OK_CANCEL_IGNORE;
        this.userAccepted = false;
        this.userInput = "";
        try {
            this.jbInit(hideInput);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public boolean getUserAccepted() {
        return this.userAccepted;
    }

    public String getUserInput() {
        return this.userInput;
    }

    public void addIgnoreAction(ActionListener listener) {
        this.bIgnore.addActionListener(listener);
    }

    private void jbInit(boolean hideInput) throws Exception {
        this.panel.setLayout(this.gridBagLayout);
        this.panelButtons.setLayout(this.gridBagLayoutButtons);
        this.bOk.setText(SP.getRS("OK"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPrompt.this.okDialog();
            }
        });
        this.bCancel.setText(SP.getRS("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPrompt.this.cancelDialog();
            }
        });
        this.bIgnore.setText(SP.getRS("Ignore"));
        this.bIgnore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPrompt.this.cancelDialog();
            }
        });
        this.jTextArea.setEditable(false);
        this.jTextArea.setFocusable(false);
        this.jTextArea.setBackground(UIManager.getColor("Panel.background"));
        this.jTextArea.setText(this.message);
        this.inputField = hideInput ? new TouchPasswordField() : new TouchTextField();
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.jTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 0, 10), 1, 1));
        this.panel.add((Component)this.inputField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 1, 1));
        this.panel.add((Component)this.panelButtons, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 1, 1));
        this.panelButtons.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        int buttonCount = 1;
        if (this.canCancel) {
            this.panelButtons.add((Component)this.bCancel, new GridBagConstraints(buttonCount, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
            ++buttonCount;
        }
        if (this.canIgnore) {
            this.panelButtons.add((Component)this.bIgnore, new GridBagConstraints(buttonCount, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
            ++buttonCount;
        }
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.inputField);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
        this.setResizable(false);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d.width < 300) {
            d.width = 300;
        }
        return d;
    }

    @Override
    public void cancelDialog() {
        if (this.canCancel) {
            this.dispose();
        }
    }

    @Override
    public void okDialog() {
        if (StringUtils.isNullOrEmpty(this.inputField.getText())) {
            DlgMessage.showMessage(this, SP.getRS("Input_Field_Empty"));
            return;
        }
        this.userInput = this.inputField.getText();
        this.userAccepted = true;
        this.dispose();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public static enum Buttons {
        OK,
        OK_CANCEL,
        OK_CANCEL_IGNORE;

    }
}

