/*
 * Decompiled with CFR 0.152.
 */
package jpos.crypt;

import jpos.crypt.ITransform;

public class StringTransform {
    public static final StringTransform NO_TRANSFORMATION = new StringTransform("N/A", new ITransform[0]);
    private String name;
    private ITransform[] operations;

    public String getName() {
        return this.name;
    }

    public ITransform[] getOperations() {
        return this.operations;
    }

    public StringTransform(String name, ITransform ... operations) {
        this.name = name;
        this.operations = operations != null ? operations : new ITransform[]{};
    }

    public String transform(String value) {
        for (ITransform operation : this.operations) {
            if (operation == null) continue;
            value = operation.transform(value);
        }
        return value;
    }

    public static ITransform createRegexReplaceOperation(String regex, String replacement) {
        return value -> value.replaceAll(regex, replacement);
    }

    public static ITransform createFirstXCharactersOperation(int numCharacters) {
        return value -> value.substring(0, Math.min(numCharacters, value.length()));
    }

    public static ITransform createLastXCharactersOperation(int numCharacters) {
        return value -> value.substring(Math.max(value.length() - numCharacters, 0), value.length());
    }
}

