/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.util.LinkedHashMap;
import jpos.DlgMessage;
import jpos.SP;
import jpos.Settings;
import jpos.custorder.IDespatcher;
import jpos.custorder.ManualDespatch;
import jpos.custorder.ShippIt;
import jpos.custorder.ShippingOptions;
import jpos.custorder.Temando;
import jpos.custorder.auspost.AustraliaPost;
import jpos.custorder.auspost.StarTrack;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class DespatchFactory {
    public static IDespatcher getDespatcher() {
        return DespatchFactory.getDespatcher("");
    }

    public static IDespatcher getDespatcher(String vhidx) {
        Element elm = SP.sParams.OnlineQueryProvider.getOnlineQuery("shipping_api", vhidx).getXML();
        if (elm == null) {
            return null;
        }
        String name = elm.getAttribute("name").getValue();
        String apiUrl = elm.getAttribute("apiUrl").getValue();
        String apiKey = elm.getAttribute("apiKey").getValue();
        String apiUsername = elm.getAttribute("apiUsername").getValue();
        String apiPassword = elm.getAttribute("apiPassword").getValue();
        if (name.equals("temando")) {
            return new Temando(apiUrl, apiUsername, apiPassword);
        }
        if (name.equals("shippit")) {
            LinkedHashMap<String, ShippingOptions> freightTypes = new LinkedHashMap<String, ShippingOptions>();
            for (Object child : elm.getChild("freight_options").getChildren("option")) {
                Element option = (Element)child;
                String serviceCarrier = option.getAttributeValue("carrierIdx") + "+" + option.getAttributeValue("serviceTypeIdx");
                ShippingOptions shipping = new ShippingOptions(option.getAttributeValue("name"), option.getAttributeValue("deliveryWindow"));
                freightTypes.put(serviceCarrier, shipping);
            }
            String autoManifest = elm.getAttribute("autoManifest").getValue();
            return new ShippIt(apiUrl, apiKey, freightTypes, autoManifest);
        }
        if (name.equals("manual")) {
            return new ManualDespatch();
        }
        if (name.equals("australiapost") || name.equals("startrack")) {
            if (Settings.isUsingAusPostIntegration()) {
                String carrierIdx = elm.getAttribute("carrierIdx").getValue();
                String carrierName = elm.getAttribute("carrierName").getValue();
                String freightOption = elm.getAttribute("freightOption").getValue();
                int purgeTime = 180;
                try {
                    purgeTime = elm.getAttribute("purge").getIntValue();
                }
                catch (DataConversionException e1) {
                    e1.printStackTrace();
                }
                boolean authToLeave = false;
                try {
                    authToLeave = elm.getAttribute("authToLeave").getBooleanValue();
                }
                catch (DataConversionException e) {
                    e.printStackTrace();
                }
                if (name.equals("australiapost")) {
                    return new AustraliaPost(apiUsername, apiKey, apiPassword, carrierIdx, carrierName, freightOption, authToLeave, purgeTime);
                }
                return new StarTrack(apiUsername, apiKey, apiPassword, carrierIdx, carrierName, freightOption, authToLeave, purgeTime);
            }
            DlgMessage.showMessage(null, SP.getRS("Integration_Unavailable_Error"));
            return null;
        }
        return null;
    }
}

