/*
 * Decompiled with CFR 0.152.
 */
package jpos.fitsession;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import jpos.PosDateFormatter;
import jpos.PosTable;
import jpos.SP;
import jpos.fitsession.FITSession;
import jpos.fitsession.SessionColumn;
import jpos.fitsession.SessionTableModel;
import org.jdom.Element;

public class SessionTable
extends PosTable {
    public static final int MAX_SESSION_DISPLAYED = 20;
    private static final String pickToolip = SP.getRS("Check_All");
    private static final SessionColumn[] defaultColumns = new SessionColumn[]{SessionColumn.TimeCreated, SessionColumn.custName, SessionColumn.memName};
    private SessionTableModel model = (SessionTableModel)this.getModel();

    public SessionTable(Window parentWindow) {
        super(parentWindow, new SessionTableModel());
        this.getSelectionModel().setSelectionMode(0);
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                this.configureColumn(e);
            }

            private void configureColumn(TableColumnModelEvent e) {
                int index = e.getToIndex();
                SessionColumn col = SessionTable.this.model.getColumnType(index);
                if (col != null) {
                    TableColumn tableCol = SessionTable.this.getColumnModel().getColumn(index);
                    if (col.getWidth() > 0) {
                        tableCol.setPreferredWidth(col.getWidth());
                        if (!col.isResizable()) {
                            tableCol.setMinWidth(col.getWidth());
                            tableCol.setMaxWidth(col.getWidth());
                            tableCol.setResizable(false);
                        }
                    }
                }
            }
        });
        this.createColumns();
    }

    private void createColumns() {
        for (SessionColumn col : defaultColumns) {
            this.model.addColumn(col);
        }
    }

    public void addColumn(SessionColumn column) {
        this.model.addColumn(column);
    }

    public void addSessions(List<FITSession> sessions, boolean overwrite) {
        this.model.addSessions(sessions, overwrite);
    }

    public void addSession(FITSession session) {
        this.model.addSession(session);
    }

    public FITSession getSession(int row) {
        return this.model.getSession(row);
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.getSelectionModel().addListSelectionListener(listener);
    }

    public boolean populateSessions(boolean limited) {
        long maxOrders;
        int index = 0;
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        long l = maxOrders = limited ? 20L : -1L;
        if (SP.sParams.checkIConn()) {
            Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("get_myfitsessions", Long.toString(SP.sParams.getStoreIdx())).getXML();
            if (result != null) {
                ArrayList<FITSession> sessions = new ArrayList<FITSession>();
                PosDateFormatter formatter = new PosDateFormatter(null, 3, 3, 2);
                List sessionElements = result.getChildren();
                for (Object session : sessionElements) {
                    if (maxOrders == -1L || (long)index >= maxOrders) continue;
                    sessions.add(new FITSession((Element)session, formatter));
                    ++index;
                }
                this.model.addSessions(sessions, true);
            }
            return true;
        }
        return false;
    }

    public FITSession getSelectedSession() {
        return this.model.getSession(this.getSelectedRow());
    }

    public void filter(String searchString) {
        this.model.filter(searchString);
        this.selectFirstRow();
    }

    public void removeSession(FITSession session) {
        int row = this.model.getSessionRow(session);
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.model.removeSession(session);
    }
}

