/*
 * Decompiled with CFR 0.152.
 */
package jpos.kleber;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public class KleberModels {

    public static class Log {
        private String endpointType;
        private String request;
        private String response;
        private int responseStatusCode;
        private Exception exception;
        private String requestTime;
        private String responseTime;
        private DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss.SSS");

        public Log(String endpointType) {
            this.endpointType = endpointType;
        }

        public void setRequest(String request) {
            this.request = request;
            this.requestTime = this.dtf.format(LocalDateTime.now());
        }

        public void setResponse(String response, int responseStatusCode) {
            this.response = response;
            this.responseStatusCode = responseStatusCode;
            this.responseTime = this.dtf.format(LocalDateTime.now());
        }

        public void setException(Exception exception) {
            this.exception = exception;
            this.responseTime = this.dtf.format(LocalDateTime.now());
        }

        public String toString() {
            String log = this.endpointType + "\r\n" + "Request: " + this.requestTime + " - " + this.request + "\r\n" + "Reponse: " + this.responseTime + " - ";
            log = this.exception != null ? log + "EXCEPTION: " + this.exception.getLocalizedMessage() + "\r\n" + this.getStackTrace(this.exception) : log + this.responseStatusCode + " " + this.response;
            return log;
        }

        /*
         * Exception decompiling
         */
        private String getStackTrace(Exception e) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class ErrorResponse {
        public String errorCode;
        public String errorId;
        public String message;
        public int httpStatusCode;

        public ErrorResponse(String errorCode, String errorId, String message, int httpStatusCode) {
            this.errorCode = errorCode;
            this.errorId = errorId;
            this.message = message;
            this.httpStatusCode = httpStatusCode;
        }
    }

    public static class DtResponse<T> {
        public String RequestId;
        public int ResultCount;
        public String ErrorMessage;
        public ArrayList<T> Result = new ArrayList();

        public static interface AddressResult {
            public AddressRetrieveResult toAddressRetrieveResult();
        }

        public static interface VerifyResult {
            public AddressVerifyResult toAddressVerifyResult();
        }

        public static class IntGdcVerifyResult
        implements VerifyResult {
            public String AddressReliabilityDescription;
            public String AddressAdaptationDescription;
            public String AddressLine1;
            public String AddressLine2;
            public String AddressLine3;
            public String AddressLine4;
            public String AddressLine5;
            public String AddressLine6;
            public String AddressLine7;
            public String AddressLine8;
            public String AddressLine9;
            public String AddressLine10;
            public String BuildingName;
            public String StreetNumber;
            public String StreetName;
            public String PostBox;
            public String Locality;
            public String County;
            public String District;
            public String StateProvince;
            public String Postcode;
            public String CountryCode;
            public String CountryName;
            public int AddressAdaptationCode;
            public int AddressReliabilityCode;

            @Override
            public AddressVerifyResult toAddressVerifyResult() {
                AddressVerifyResult result = new AddressVerifyResult();
                result.AddressLine1 = this.AddressLine1;
                result.City = this.Locality;
                result.Country = this.CountryCode;
                result.Postcode = this.Postcode;
                result.State = this.StateProvince;
                result.addressChanged = this.AddressAdaptationCode == 0;
                result.MatchType = this.AddressReliabilityCode == 30 ? MatchType.Ambiguous : MatchType.Correct;
                return result;
            }
        }

        public static class Address {
            public String AddressLine1;
            public String AddressLine2;
            public String City;
            public String State;
            public String Postcode;
            public String Country;
        }

        public static class NzPafVerifyResult
        implements VerifyResult {
            public String DPID;
            public String BuildingName;
            public String AddressLine1;
            public String AddressLine2;
            public String AddressLine3;
            public String Suburb;
            public String TownCityMailtown;
            public String Postcode;
            public String MatchTypeDescription;
            public String FieldChanges;
            public String ActiveStatus;
            public String FormatFlag;
            public String AlternateLocality;
            public String LevelNumber;
            public String LevelType;
            public String UnitNumber;
            public String UnitType;
            public String PostBoxLobby;
            public String PostBoxNumber;
            public String PostBoxType;
            public String RuralDeliveryType;
            public String RuralDeliveryNumber;
            public String RuralDeliverySupplement;
            public String StreetName;
            public String StreetType;
            public String StreetNumber1;
            public String StreetNumber1Alpha;
            public String StreetTypeSuffix;
            public String StreetName2;
            public String StreetType2;
            public String StreetNumber2;
            public String StreetNumber2Alpha;
            public String StreetTypeSuffix2;
            public MatchType MatchType;

            @Override
            public AddressVerifyResult toAddressVerifyResult() {
                AddressVerifyResult result = new AddressVerifyResult();
                result.AddressLine1 = this.AddressLine1;
                result.City = this.Suburb.isEmpty() ? this.TownCityMailtown : this.Suburb;
                result.Postcode = this.Postcode;
                result.MatchType = this.MatchType;
                result.addressChanged = !this.FieldChanges.isEmpty();
                return result;
            }
        }

        public static class AuPafRepairResult
        implements VerifyResult {
            public String DPID;
            public String BuildingName;
            public String AddressLine;
            public String Locality;
            public String State;
            public String Postcode;
            public String AddressBlockLine1;
            public String AddressBlockLine2;
            public String AddressBlockLine3;
            public String AddressBlockLine4;
            public String AddressBlockLine5;
            public String AddressBlockLine6;
            public String AddressBlockLine7;
            public String MatchTypeDescription;
            public String FieldChanges;
            public String AustraliaPostBarcode;
            public String AustraliaPostBarcodeSortPlan;
            public String UnitType;
            public String UnitNumber;
            public String LevelType;
            public String LevelNumber;
            public String LotNumber;
            public String StreetNumber1;
            public String StreetNumberSuffix1;
            public String StreetNumber2;
            public String StreetNumberSuffix2;
            public String PostBoxNumber;
            public String PostBoxNumberPrefix;
            public String PostBoxNumberSuffix;
            public String StreetName;
            public String StreetType;
            public String StreetSuffix;
            public String PostBoxType;
            public String AltStreetName;
            public String AltStreetType;
            public String AltStreetSuffix;
            public String AltLocality;
            public String AltPostcode;
            public MatchType MatchType;

            @Override
            public AddressVerifyResult toAddressVerifyResult() {
                AddressVerifyResult result = new AddressVerifyResult();
                result.AddressLine1 = this.AddressLine;
                result.City = this.Locality;
                result.State = this.State;
                result.Postcode = this.Postcode;
                result.MatchType = this.MatchType;
                result.addressChanged = !this.FieldChanges.isEmpty();
                return result;
            }
        }

        public static enum MatchType {
            Correct,
            PostcodeCouldntBeMatched,
            StateCouldntBeMatched,
            LocalityCouldntBeMatched,
            StreetNameCouldntBeMatched,
            Ambiguous,
            StreetNumberCouldntBeMatched,
            PostalTypeCouldntBeMatched,
            PostalNumberCouldntBeMatched,
            PhantomPrimaryPoint,
            UnitNumberCouldntBeMatched,
            BuildingTypeCouldntBeMatched,
            LevelTypeCouldntBeMatched,
            DPIDCouldntBeMatched,
            LotNumberCouldntBeMatched,
            BuildingNameCouldntBeMatched,
            InputDPIDNotFound,
            ParsingError,
            PrimaryPoint,
            ExtendedDPIDNotReturned,
            ParserWarning,
            InvalidCustomerInfo,
            InvalidFCC;

        }

        public static class AddressVerifyResult {
            public String AddressLine1 = "";
            public String AddressLine2 = "";
            public String City = "";
            public String State = "";
            public String Postcode = "";
            public String Country = "";
            public MatchType MatchType;
            public boolean addressChanged;
        }

        public static class IntPcaRetrieveResult
        implements AddressResult {
            public String DomesticId;
            public String Company;
            public String Department;
            public String BuildingName;
            public String UnitLevelNumber;
            public String StreetNumber;
            public String StreetName;
            public String SecondaryStreetName;
            public String Block;
            public String Neighbourhood;
            public String AddressLine1;
            public String AddressLine2;
            public String AddressLine3;
            public String AddressLine4;
            public String AddressLine5;
            public String District;
            public String LocalityCityTown;
            public String StateProvince;
            public String StateProvinceName;
            public String StateProvinceCode;
            public String Postcode;
            public String CountryName;
            public String CountryIso2;
            public String CountryIso3;
            public String CountryIsoNumber;
            public String AdminAreaName;
            public String AdminAreaCode;
            public String SortingNumber1;
            public String SortingNumber2;
            public String Barcode;
            public String PostBoxNumber;
            public String Language;
            public String LanguageAlternatives;
            public String Type;
            public String DataLevel;

            @Override
            public AddressRetrieveResult toAddressRetrieveResult() {
                AddressRetrieveResult result = new AddressRetrieveResult();
                result.AddressLine1 = this.AddressLine1;
                result.City = this.LocalityCityTown;
                result.Country = this.CountryIso2;
                result.Postcode = this.Postcode;
                result.State = this.StateProvinceName;
                return result;
            }
        }

        public static class UkPafRetrieveResult
        implements AddressResult {
            public String DomesticId;
            public String Company;
            public String Department;
            public String BuildingName;
            public String UnitLevelNumber;
            public String StreetNumber;
            public String StreetName;
            public String SecondaryStreetName;
            public String Block;
            public String Neighbourhood;
            public String AddressLine1;
            public String AddressLine2;
            public String AddressLine3;
            public String AddressLine4;
            public String AddressLine5;
            public String District;
            public String LocalityCityTown;
            public String StateProvince;
            public String StateProvinceName;
            public String StateProvinceCode;
            public String Postcode;
            public String CountryName;
            public String CountryIso2;
            public String CountryIso3;
            public String CountryIsoNumber;
            public String AdminAreaName;
            public String AdminAreaCode;
            public String SortingNumber1;
            public String SortingNumber2;
            public String Barcode;
            public String PostBoxNumber;
            public String Language;
            public String LanguageAlternatives;
            public String Type;
            public String DataLevel;

            @Override
            public AddressRetrieveResult toAddressRetrieveResult() {
                AddressRetrieveResult result = new AddressRetrieveResult();
                result.AddressLine1 = this.AddressLine1;
                result.City = this.LocalityCityTown;
                result.Country = "GB";
                result.Postcode = this.Postcode;
                result.State = this.StateProvinceName;
                return result;
            }
        }

        public static class CaPafRetrieveResult
        implements AddressResult {
            public String DomesticId;
            public String Company;
            public String Department;
            public String BuildingName;
            public String UnitLevelNumber;
            public String StreetNumber;
            public String StreetName;
            public String SecondaryStreetName;
            public String Block;
            public String Neighbourhood;
            public String AddressLine1;
            public String AddressLine2;
            public String AddressLine3;
            public String AddressLine4;
            public String AddressLine5;
            public String District;
            public String LocalityCityTown;
            public String StateProvince;
            public String StateProvinceName;
            public String StateProvinceCode;
            public String Postcode;
            public String CountryName;
            public String CountryIso2;
            public String CountryIso3;
            public String CountryIsoNumber;
            public String AdminAreaName;
            public String AdminAreaCode;
            public String SortingNumber1;
            public String SortingNumber2;
            public String Barcode;
            public String PostBoxNumber;
            public String Language;
            public String LanguageAlternatives;
            public String Type;
            public String DataLevel;

            @Override
            public AddressRetrieveResult toAddressRetrieveResult() {
                AddressRetrieveResult result = new AddressRetrieveResult();
                result.AddressLine1 = this.AddressLine1;
                result.City = this.LocalityCityTown;
                result.Country = "CA";
                result.Postcode = this.Postcode;
                result.State = this.StateProvinceName;
                return result;
            }
        }

        public static class NzAdRetrieveResult
        implements AddressResult {
            public String DPID;
            public String MailDelivery;
            public String AddressType;
            public String BuildingName;
            public String AddressLine1;
            public String AddressLine2;
            public String AddressLine3;
            public String AddressLine4;
            public String UnitType;
            public String UnitNumber;
            public String LevelType;
            public String LevelNumber;
            public String StreetNumber1;
            public String StreetNumberSuffix1;
            public String StreetName;
            public String StreetType;
            public String StreetSuffix;
            public String Suburb;
            public String TownCity;
            public String Mailtown;
            public String PostBoxType;
            public String PostBoxNumber;
            public String Postcode;
            public String RdNumber;

            @Override
            public AddressRetrieveResult toAddressRetrieveResult() {
                AddressRetrieveResult result = new AddressRetrieveResult();
                result.AddressLine1 = this.AddressLine1;
                result.City = this.Suburb.isEmpty() ? this.TownCity : this.Suburb;
                result.Country = "NZ";
                result.Postcode = this.Postcode;
                return result;
            }
        }

        public static class AuPafRetrieveResult
        implements AddressResult {
            public String DPID;
            public String UnitType;
            public String UnitNumber;
            public String LevelType;
            public String LevelNumber;
            public String LotNumber;
            public String StreetNumber1;
            public String StreetNumberSuffix1;
            public String StreetNumber2;
            public String StreetNumberSuffix2;
            public String PostBoxNumber;
            public String PostBoxNumberPrefix;
            public String PostBoxNumberSuffix;
            public String StreetName;
            public String StreetType;
            public String StreetSuffix;
            public String PostBoxType;
            public String BuildingName;
            public String AddressLine;
            public String Locality;
            public String State;
            public String Postcode;

            @Override
            public AddressRetrieveResult toAddressRetrieveResult() {
                AddressRetrieveResult result = new AddressRetrieveResult();
                result.AddressLine1 = this.AddressLine;
                result.City = this.Locality;
                result.Country = "AU";
                result.Postcode = this.Postcode;
                result.State = this.State;
                return result;
            }
        }

        public static class AddressRetrieveResult {
            public String AddressLine1 = "";
            public String AddressLine2 = "";
            public String City = "";
            public String State = "";
            public String Postcode = "";
            public String Country = "";
        }

        public static interface AuNzSearchResult {
            public AddressSearchResult toAddressSearchResult();
        }

        public static class NzAdSearchResult
        implements AuNzSearchResult {
            public String RecordId;
            public String DisplayLine;

            @Override
            public AddressSearchResult toAddressSearchResult() {
                AddressSearchResult result = new AddressSearchResult();
                result.RecordId = this.RecordId;
                result.AddressLine = this.DisplayLine;
                return result;
            }
        }

        public static class AuPafSearchResult
        implements AuNzSearchResult {
            public String RecordId;
            public String AddressLine;
            public String Locality;
            public String State;
            public String Postcode;

            @Override
            public AddressSearchResult toAddressSearchResult() {
                AddressSearchResult result = new AddressSearchResult();
                result.RecordId = this.RecordId;
                result.AddressLine = this.AddressLine;
                if (!this.Locality.isEmpty()) {
                    result.AddressLine = result.AddressLine + ", " + this.Locality;
                }
                if (!this.State.isEmpty()) {
                    result.AddressLine = result.AddressLine + ", " + this.State;
                }
                if (!this.Postcode.isEmpty()) {
                    result.AddressLine = result.AddressLine + ", " + this.Postcode;
                }
                return result;
            }
        }

        public static class AddressSearchResult {
            public String RecordId;
            public String AddressLine;

            public String toString() {
                return this.AddressLine;
            }
        }

        public static class PhoneResult {
            public PhoneStatusCode StatusCode;
            public String StatusDescription;
            public String Response;
            public String RidNumber;

            public static enum PhoneStatusCode {
                Connected,
                Disconnected,
                Indeterminate,
                InvalidAuthenticationInformation,
                AccountSuspended,
                RequiredFieldsInvalid,
                InternalSystemError,
                ExcessiveWebServiceCalls;

            }
        }

        public static class EmailResult {
            public EmailStatusCode StatusCode;
            public String StatusDescription;
            public String EmailAccount;
            public String EmailDomain;
            public String Connected;
            public String Disposable;
            public String RoleAddress;

            public static enum EmailStatusCode {
                Valid,
                AcceptAll,
                Invalid,
                Unknown;

            }
        }
    }

    public static class KleberResponse<T> {
        public DtResponse<T> DtResponse = new DtResponse();
        public boolean FeatureEnabled = true;

        public KleberResponse() {
        }

        public <T2> KleberResponse(KleberResponse<T2> from) {
            this.DtResponse.ErrorMessage = from.DtResponse.ErrorMessage;
            this.DtResponse.RequestId = from.DtResponse.RequestId;
            this.DtResponse.ResultCount = from.DtResponse.ResultCount;
        }
    }
}

