/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.util.function.Function;
import jpos.PosFrame;
import jpos.labelprinting.BulkLabelPrintDlg;
import jpos.labelprinting.ILabelDialog;
import jpos.labelprinting.LabelPrintingDlg;
import jpos.labelprinting.ScanLabelPrintDlg;

public enum LabelDialogType {
    NONE(null),
    SINGLE(parent -> new LabelPrintingDlg((PosFrame)parent)),
    BULK(parent -> new BulkLabelPrintDlg((PosFrame)parent)),
    SCAN(parent -> new ScanLabelPrintDlg((PosFrame)parent));

    private Function<PosFrame, ILabelDialog> newDialogFunction;

    private LabelDialogType(Function<PosFrame, ILabelDialog> newDialogFunction) {
        this.newDialogFunction = newDialogFunction;
    }

    public ILabelDialog generateDialog(PosFrame parent) {
        if (this.newDialogFunction != null) {
            return this.newDialogFunction.apply(parent);
        }
        return null;
    }
}

