/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.sql.SQLException;
import java.util.Vector;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.SystemSettings;
import jpos.labelprinting.LabelEnums;
import jpos.labelprinting.LabelFormat;

public class LabelFormats
extends Vector<LabelFormat> {
    public LabelFormats() {
        block34: {
            try {
                LabelFormat format;
                try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT NAME, NORMAL_FORMAT, MARKDOWN_FORMAT, HEADER_FORMAT, BY_STYLE, BY_CLR, BY_SKU, BY_STOCK_LEVEL, IS_DEFAULT_FORMAT FROM POS_LABEL_PRINT WHERE NORMAL_FORMAT IS NOT NULL ORDER BY SEQ");){
                    while (sql.next()) {
                        format = new LabelFormat(sql.getString("NAME"), sql.getString("NORMAL_FORMAT"), sql.getString("MARKDOWN_FORMAT"), sql.getString("HEADER_FORMAT"));
                        if (sql.getBoolean("BY_STYLE")) {
                            format.addPrintLevel(LabelEnums.PrintLevel.STYLE);
                        }
                        if (sql.getBoolean("BY_CLR")) {
                            format.addPrintLevel(LabelEnums.PrintLevel.COLOUR);
                        }
                        if (sql.getBoolean("BY_SKU")) {
                            format.addPrintLevel(LabelEnums.PrintLevel.SKU);
                        }
                        if (sql.getBoolean("BY_STOCK_LEVEL")) {
                            format.addPrintLevel(LabelEnums.PrintLevel.STOCK_UNIT);
                        }
                        if (SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.AUTO_PRINT_DISPLAY_LABELS_ON_RECEIPT) > 0L) {
                            format.setIsDefaultFormat(sql.getBoolean("IS_DEFAULT_FORMAT"));
                        }
                        this.add(format);
                    }
                }
                if (this.size() != 0) break block34;
                sql = new SqlQuery(SP.sParams.conn, "SELECT LABEL_PRINTING_TEMPLATE FROM STOREPARAMS");
                var2_3 = null;
                try {
                    if (sql.next()) {
                        format = new LabelFormat(sql.getString("LABEL_PRINTING_TEMPLATE"));
                        format.addPrintLevel(LabelEnums.PrintLevel.SKU);
                        this.add(format);
                    }
                }
                catch (Throwable throwable) {
                    var2_3 = throwable;
                    throw throwable;
                }
                finally {
                    if (sql != null) {
                        if (var2_3 != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable) {
                                var2_3.addSuppressed(throwable);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    public LabelFormat getDefaultFormat() {
        for (int i = 0; i < this.size(); ++i) {
            if (!((LabelFormat)this.get(i)).getIsDefaultFormat().booleanValue()) continue;
            return (LabelFormat)this.get(i);
        }
        return (LabelFormat)this.get(0);
    }
}

