/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import jpos.PosDateFormatter;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.labelprinting.LabelWriter;
import jpos.labelprinting.PrinterLabel;

public class ReservationLabel
extends PrinterLabel {
    private Connection conn;
    private long widx;
    private String docketNum;
    private String storeNo;
    private String storeCode;
    private String labelCode;
    private int lineNo;

    public ReservationLabel(Connection conn, String storeNo, String labelCode, long vshidx) {
        this.conn = conn;
        RetTranHDetails retTranHDetails = new RetTranHDetails(conn, vshidx);
        this.widx = retTranHDetails.getWidx();
        this.docketNum = retTranHDetails.getDocketNum();
        this.storeNo = storeNo;
        this.labelCode = labelCode;
        this.setPrintQuantity(retTranHDetails.getPrintQuantity());
        this.lineNo = 1;
        this.populate();
    }

    public ReservationLabel(Connection conn, long widx, String docketNum, String storeNo, String labelCode, double printQuantity) {
        this.conn = conn;
        this.widx = widx;
        this.docketNum = docketNum;
        this.storeNo = storeNo;
        this.labelCode = labelCode;
        this.setPrintQuantity((int)printQuantity);
        this.lineNo = 1;
        this.populate();
    }

    public ReservationLabel(Connection conn, long widx, String docketNum, String storeNo, String labelCode, double printQuantity, int lineNo) {
        this.conn = conn;
        this.widx = widx;
        this.docketNum = docketNum;
        this.storeNo = storeNo;
        this.labelCode = labelCode;
        this.setPrintQuantity((int)printQuantity);
        this.lineNo = lineNo;
        this.populate();
    }

    private void populate() {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT CODE FROM REFCODE WHERE RCIDX = ?", String.valueOf(this.widx));){
            if (sql.next()) {
                this.storeCode = sql.getString(1);
            }
        }
        catch (SQLException ex) {
            PosUtils.logError(ex);
        }
    }

    @Override
    public boolean writeLabelToFile() {
        String template = "^XA\r\n^PW448\r\n^LH60,20\r\n^FO10,0,0\r\n^LRY\r\n^FO10,0,0\r\n^LRN\r\n^FO10,98\r\n^BXN,3,200,22,22\r\n^FD{DOCKET_NUM}^FS\r\n^FO90,80\r\n^A0,18,22\r\n^FD{STORE_CODE}^FS\r\n^FO90,105\r\n^A0,18,22\r\n^FD{LABEL_CODE}^FS\r\n^FO90,160\r\n^A0,18,22\r\n^FD{DATE_PRINTED}^FS\r\n^XZ";
        LabelWriter writer = new LabelWriter(template);
        writer.setEscapeStrings(SP.sParams.getEscapeLabelPrintStrings());
        String complete_docketnum = "D" + this.storeNo + this.docketNum;
        writer.addValue("DOCKET_NUM", complete_docketnum);
        writer.addValue("STORE_CODE", this.storeCode);
        writer.addValue("LABEL_CODE", this.labelCode);
        PosDateFormatter dateFormatter = new PosDateFormatter(new Timestamp(System.currentTimeMillis()));
        dateFormatter.setFormat(3, 0);
        writer.addValue("DATE_PRINTED", dateFormatter.toString());
        return writer.sendLabelToDestination(this.getPrintQuantity(), this.lineNo);
    }

    @Override
    public boolean isCounted() {
        return true;
    }

    private class RetTranHDetails {
        private long widx;
        private String docketNum;
        private int printQuantity;

        public RetTranHDetails(Connection conn, long vshidx) {
            try (SqlQuery sql = new SqlQuery(conn, "SELECT rh.WIDX, rh.DOCKET_NUMBER, sum(rd.QTY) FROM RET_TRANH rh JOIN RET_TRAND rd ON rh.VHIDX =rd.VHIDX WHERE rh.VHIDX = ? GROUP BY rh.WIDX, rh.DOCKET_NUMBER", String.valueOf(vshidx));){
                if (sql.next()) {
                    this.widx = sql.getLong(1);
                    this.docketNum = sql.getString(2);
                    this.printQuantity = sql.getInt(3);
                }
            }
            catch (SQLException ex) {
                PosUtils.logError(ex);
            }
        }

        public long getWidx() {
            return this.widx;
        }

        public String getDocketNum() {
            return this.docketNum;
        }

        public int getPrintQuantity() {
            return this.printQuantity;
        }
    }
}

