/*
 * Decompiled with CFR 0.152.
 */
package jpos.omneo;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jpos.RestRequest;
import jpos.SP;
import jpos.omneo.OmneoLoyaltySetup;
import jpos.omneo.OmneoUtils;

class OmneoAPI {
    private String authToken;
    private String baseURL;
    private String clientId;
    private String clientSecret;
    private String apiAuthVersion;
    private String omneoRedemptionId;
    private double balance;
    private String lastError;
    private String personIdType;
    private Map<String, String> authHeader;

    protected OmneoAPI() {
        OmneoLoyaltySetup setup = new OmneoLoyaltySetup();
        this.baseURL = RestRequest.formatBaseURL(setup.getLoyaltyApiUrl());
        this.clientId = setup.getClientId();
        this.clientSecret = setup.getClientSecret();
        this.apiAuthVersion = setup.getApiAuthVersion();
        this.personIdType = setup.getPersonIdType();
    }

    private boolean authenticateV1Pos() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.clientId);
        params.put("redirect_uri", this.baseURL + "/reflect");
        params.put("response_type", "code");
        params.put("scope", "master_all");
        RestRequest restRequest = new RestRequest();
        RestRequest.Response result = null;
        try {
            result = restRequest.get(this.baseURL + "/api/v1/oauth/authorize", params, null);
        }
        catch (IOException e) {
            this.lastError = SP.getRS("omneo_failed_authentication");
            return false;
        }
        if (!result.isSuccess()) {
            this.lastError = SP.getRS("omneo_failed_authentication");
            return false;
        }
        Gson gson = new Gson();
        Auth authCode = (Auth)gson.fromJson(result.Content, Auth.class);
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("grant_type", "authorization_code");
        postData.put("client_id", this.clientId);
        postData.put("client_secret", this.clientSecret);
        postData.put("redirect_uri", this.baseURL + "/reflect");
        postData.put("scope", "master_all");
        postData.put("code", authCode.code);
        try {
            restRequest.setPostFormEncoded(postData);
            result = restRequest.post(this.baseURL + "/api/v1/oauth/access-token", null, null);
        }
        catch (IOException e) {
            this.lastError = SP.getRS("omneo_failed_authentication");
            return false;
        }
        if (!result.isSuccess()) {
            this.lastError = SP.getRS("omneo_failed_authentication");
            return false;
        }
        Auth postAuth = (Auth)gson.fromJson(result.Content, Auth.class);
        this.authToken = postAuth.access_token;
        TokenManager.setToken(this.authToken);
        return true;
    }

    private boolean authenticateV2Pos() {
        RestRequest restRequest = new RestRequest();
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("grant_type", "client_credentials");
        postData.put("client_id", this.clientId);
        postData.put("client_secret", this.clientSecret);
        postData.put("scope", "write-interactions read-rewards read-reward_redemptions write-reward_redemptions write-reward_redeem");
        RestRequest.Response result = null;
        try {
            restRequest.setPostFormEncoded(postData);
            result = restRequest.post(this.baseURL + "/oauth/token", null, null);
        }
        catch (IOException e) {
            this.lastError = SP.getRS("omneo_failed_authentication");
            return false;
        }
        if (!result.isSuccess()) {
            this.lastError = SP.getRS("omneo_failed_authentication");
            return false;
        }
        Gson gson = new Gson();
        Auth postAuth = (Auth)gson.fromJson(result.Content, Auth.class);
        TokenManager.setToken(postAuth.token_type + " " + postAuth.access_token, OmneoLoyaltySetup.ApiAuthV2);
        this.authHeader = TokenManager.getAuthHeader();
        return true;
    }

    private boolean authenticatePos() {
        if (this.apiAuthVersion.equals(OmneoLoyaltySetup.ApiAuthV1)) {
            this.authToken = TokenManager.getToken();
            if (this.authToken != null) {
                return true;
            }
            return this.authenticateV1Pos();
        }
        this.authHeader = TokenManager.getAuthHeader();
        if (this.authHeader != null) {
            return true;
        }
        return this.authenticateV2Pos();
    }

    protected boolean requestBalance(String cardNumber) {
        if (!this.authenticatePos()) {
            return false;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.personIdType.equalsIgnoreCase("id")) {
            long peridx = OmneoUtils.getPeridxFromDatabase(cardNumber);
            params.put("person_id", Long.toString(peridx));
        } else {
            params.put("person_id", cardNumber);
        }
        if (this.apiAuthVersion.equals(OmneoLoyaltySetup.ApiAuthV1)) {
            params.put("access_token", this.authToken);
        }
        RestRequest restRequest = new RestRequest();
        RestRequest.Response result = null;
        try {
            result = restRequest.get(this.baseURL + "/api/v1/rewardbalance", params, this.authHeader);
        }
        catch (IOException e) {
            this.lastError = SP.getRS("omneo_failed_GetBalance");
            return false;
        }
        Result balanceResponse = null;
        Gson gson = new Gson();
        try {
            balanceResponse = (Result)gson.fromJson(result.Content, Result.class);
        }
        catch (JsonSyntaxException e) {
            this.lastError = SP.getRS("omneo_failed_GetBalance");
            return false;
        }
        if (!result.isSuccess() || balanceResponse.error != null) {
            this.lastError = SP.getRS("omneo_failed_GetBalance");
            return false;
        }
        this.balance = balanceResponse.data.reward_balance;
        return true;
    }

    protected boolean requestRedeem(String cardNumber, long staffId, Double amount) {
        if (!this.authenticatePos()) {
            return false;
        }
        RestRequest restRequest = new RestRequest();
        HashMap<String, String> postData = new HashMap<String, String>();
        if (this.personIdType.equalsIgnoreCase(OmneoLoyaltySetup.PersonIdTypeId)) {
            long peridx = OmneoUtils.getPeridxFromDatabase(cardNumber);
            postData.put("person_id", Long.toString(peridx));
        } else {
            postData.put("person_id", cardNumber);
        }
        postData.put("amount", amount.toString());
        postData.put("currency", SP.sParams.storeCurrency.getCode());
        if (this.apiAuthVersion.equals(OmneoLoyaltySetup.ApiAuthV2)) {
            try {
                restRequest.setPostJson(postData);
            }
            catch (UnsupportedEncodingException e) {
                this.lastError = SP.getRS("omneo_failed_redeem");
                return false;
            }
        } else {
            postData.put("access_token", this.authToken);
            restRequest.setPostFormEncoded(postData);
        }
        RestRequest.Response result = null;
        try {
            result = restRequest.post(this.baseURL + "/api/v1/redeem", null, this.authHeader);
        }
        catch (IOException e) {
            this.lastError = SP.getRS("omneo_failed_redeem");
            return false;
        }
        Result resultJson = null;
        Gson gson = new Gson();
        try {
            resultJson = (Result)gson.fromJson(result.Content, Result.class);
        }
        catch (JsonSyntaxException e) {
            this.lastError = SP.getRS("omneo_failed_redeem");
            return false;
        }
        if (!result.isSuccess() || resultJson.error != null) {
            this.lastError = SP.getRS("omneo_failed_redeem");
            return false;
        }
        this.omneoRedemptionId = resultJson.data.redemption_id;
        return resultJson.data.success;
    }

    protected boolean requestReverse(String cardNumber, String transactionId) {
        JsonParser parser;
        JsonElement jsonRoot;
        if (!this.authenticatePos()) {
            return false;
        }
        RestRequest restRequest = new RestRequest();
        HashMap<String, String> postData = new HashMap<String, String>();
        if (this.personIdType.equalsIgnoreCase(OmneoLoyaltySetup.PersonIdTypeId)) {
            long peridx = OmneoUtils.getPeridxFromDatabase(cardNumber);
            postData.put("person_id", Long.toString(peridx));
        } else {
            postData.put("person_id", cardNumber);
        }
        postData.put("redemption_id", transactionId);
        if (this.apiAuthVersion.equals(OmneoLoyaltySetup.ApiAuthV1)) {
            postData.put("access_token", this.authToken);
            restRequest.setPostFormEncoded(postData);
        } else {
            try {
                restRequest.setPostJson(postData);
            }
            catch (UnsupportedEncodingException e) {
                this.lastError = SP.getRS("omneo_failed_redeem");
                return false;
            }
        }
        RestRequest.Response result = null;
        try {
            result = this.apiAuthVersion.equals(OmneoLoyaltySetup.ApiAuthV1) ? restRequest.post(this.baseURL + "/api/v1/redemptionrefund", null, this.authHeader) : restRequest.post(this.baseURL + "/api/v1/redemption-refund", null, this.authHeader);
        }
        catch (IOException e) {
            this.lastError = SP.getRS("omneo_failed_redeem");
            return false;
        }
        Result resultJson = null;
        Gson gson = new Gson();
        if (result.isSuccess()) {
            try {
                resultJson = (Result)gson.fromJson(result.Content, Result.class);
            }
            catch (JsonSyntaxException e) {
                this.lastError = SP.getRS("omneo_failed_redeem");
                return false;
            }
            if (resultJson.error != null) {
                this.lastError = resultJson.error.message;
                return false;
            }
            return resultJson.data.success;
        }
        if (result.StatusCode == 400 && (jsonRoot = (parser = new JsonParser()).parse(result.Content)).isJsonObject()) {
            JsonObject json = jsonRoot.getAsJsonObject();
            if (json.get("error") != null) {
                this.lastError = json.get("error").getAsString();
                return false;
            }
            if (json.get("errors") != null) {
                String allErrors = "";
                JsonArray errors = json.getAsJsonArray("errors");
                for (int i = 0; i < errors.size(); ++i) {
                    allErrors = allErrors + "\n" + errors.get(i).getAsString();
                }
                this.lastError = allErrors;
                return false;
            }
        }
        this.lastError = SP.getRS("omneo_failed_redeem");
        return false;
    }

    protected double getBalance() {
        return this.balance;
    }

    protected String getLastError() {
        return this.lastError;
    }

    protected String getRedemptionId() {
        return this.omneoRedemptionId;
    }

    private static class TokenManager {
        private static final long TIMEOUT_MILISECS = 3000000L;
        private static String token = null;
        static Date lastFetch = null;
        static Map<String, String> authHeader = new HashMap<String, String>();

        private TokenManager() {
        }

        private static String getToken() {
            Date now = new Date();
            if (token == null || lastFetch == null || lastFetch.getTime() + 3000000L < now.getTime()) {
                return null;
            }
            return token;
        }

        private static Map<String, String> getAuthHeader() {
            Date now = new Date();
            if (authHeader.size() == 0 || lastFetch == null || lastFetch.getTime() + 3000000L < now.getTime()) {
                return null;
            }
            return authHeader;
        }

        private static void setToken(String newToken) {
            TokenManager.setToken(newToken, OmneoLoyaltySetup.ApiAuthV1);
        }

        private static void setToken(String newToken, String version) {
            if (version.equals(OmneoLoyaltySetup.ApiAuthV2)) {
                authHeader.clear();
                authHeader.put("authorization", newToken);
            } else {
                token = newToken;
            }
            lastFetch = new Date();
        }
    }

    private class Result {
        private Data data;
        private Error error;

        private Result() {
        }

        private class Error {
            private int Code;
            private int http_code;
            private String message;

            private Error() {
            }
        }

        private class Data {
            private String person_id;
            private Double reward_balance;
            private boolean success;
            private String redemption_id;
            private Double person_new_balance;
            private Double redeem_amt_requested;
            private Double amount_redeemed;
            private Double amount_refunded;
            private String details;
            private Double amount;
            private String currency;
            private String pos_trans_reference;
            private ArrayList<Currencies> currencies;

            private Data() {
            }
        }

        private class Currencies {
            private String id;
            private String iso;
            private String name;
            private String symbol;
            private Double fx_in;
            private Double fx_out;
            private Double reward_balance;

            private Currencies() {
            }
        }
    }

    private class Auth {
        private String code;
        private String access_token;
        private String token_type;
        private String expires_in;
        private String refresh_token;

        private Auth() {
        }
    }
}

