/*
 * Decompiled with CFR 0.152.
 */
package jpos.omneo;

import java.sql.SQLException;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.SystemSettings;

public class OmneoLoyaltySetup {
    private long loyaltyProgramId = 0L;
    private String loyaltyApiUrl;
    private String loyaltyRedemptionScreenUrl;
    private String personScreenUrl;
    private String clientId;
    private String clientSecret;
    private String apiAuthVersion;
    private String transactionIdType;
    private String personIdType;
    private String transactionItemIdType;
    private String rewardDefinitionId;
    public static String ApiAuthV1 = "V1";
    public static String ApiAuthV2 = "V2";
    public static String PersonIdTypeId = "id";
    public static String PersonIdTypeCardNum = "card_number";

    public OmneoLoyaltySetup() {
        this.loadSettings();
    }

    private void loadSettings() {
        String whseRef = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.OMNEO_LOYALTY_SETUP);
        if (whseRef.length() > 0) {
            String select = "SELECT O.LOYALTYIDX, O.API_URL, O.REDEEM_SCREEN_URL, O.PERSON_SCREEN_URL, O.CLIENT_ID, O.CLIENT_SECRET, O.API_AUTH_VERSION, O.REWARD_DEFINITION_ID, O.TRANSACTION_ID_TYPE, O.PERSON_ID_TYPE, O.TRANSACTION_ITEM_ID_TYPE FROM OMNEO_LOYALTY_SETUP O, WHSE W WHERE W.WIDX = " + SP.sParams.getStoreIdx() + " AND W." + whseRef + " = O.RCIDX";
            try (SqlQuery sql = new SqlQuery(SP.sParams.conn, select);){
                if (sql.next()) {
                    this.loyaltyProgramId = sql.getLong("LOYALTYIDX");
                    this.loyaltyApiUrl = sql.getString("API_URL");
                    this.loyaltyRedemptionScreenUrl = sql.getString("REDEEM_SCREEN_URL");
                    this.personScreenUrl = sql.getString("PERSON_SCREEN_URL");
                    this.clientId = sql.getString("CLIENT_ID");
                    this.clientSecret = sql.getString("CLIENT_SECRET");
                    this.apiAuthVersion = sql.getString("API_AUTH_VERSION");
                    this.transactionIdType = sql.getString("TRANSACTION_ITEM_ID_TYPE");
                    this.personIdType = sql.getString("PERSON_ID_TYPE");
                    this.transactionItemIdType = sql.getString("API_AUTH_VERSION");
                    this.rewardDefinitionId = sql.getString("REWARD_DEFINITION_ID");
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    public long getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    public String getLoyaltyApiUrl() {
        return StringUtils.nullToEmpty(this.loyaltyApiUrl);
    }

    public String getLoyaltyRedemptionScreenUrl() {
        return StringUtils.nullToEmpty(this.loyaltyRedemptionScreenUrl);
    }

    public String getPersonScreenUrl() {
        return StringUtils.nullToEmpty(this.personScreenUrl);
    }

    public String getClientId() {
        return StringUtils.nullToEmpty(this.clientId);
    }

    public String getClientSecret() {
        return StringUtils.nullToEmpty(this.clientSecret);
    }

    public String getApiAuthVersion() {
        if (this.apiAuthVersion == null || this.apiAuthVersion.isEmpty()) {
            return ApiAuthV1;
        }
        return this.apiAuthVersion;
    }

    public boolean isUsingLoyaltyApi(long loyaltyProgramId) {
        return this.getLoyaltyApiUrl().length() > 0 && loyaltyProgramId == this.getLoyaltyProgramId();
    }

    public boolean isUsingLoyaltyRedemptionScreen(long loyaltyProgramId) {
        return this.getLoyaltyRedemptionScreenUrl().length() > 0 && loyaltyProgramId == this.getLoyaltyProgramId();
    }

    public boolean isUsingOmneoPersonScreen() {
        return this.getPersonScreenUrl().length() > 0;
    }

    public String getTransactionIdType() {
        return StringUtils.nullToEmpty(this.transactionIdType);
    }

    public String getTransactionItemIdType() {
        return StringUtils.nullToEmpty(this.transactionItemIdType);
    }

    public String getPersonIdType() {
        return StringUtils.nullToEmpty(this.personIdType);
    }

    public String getRewardDefinitionId() {
        return StringUtils.nullToEmpty(this.rewardDefinitionId);
    }
}

