/*
 * Decompiled with CFR 0.152.
 */
package jpos.omneo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jpos.PosUtils;
import jpos.SP;
import jpos.omneo.OmneoLoyaltySetup;

public class OmneoUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCardNumberFromDatabase(long peridx) {
        OmneoLoyaltySetup setup = new OmneoLoyaltySetup();
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT CARDNO FROM PERLOYALTY WHERE PERIDX = ? AND RCIDX = ? AND \"ACTIVE\" = 1 ORDER BY CARDNO");){
            stmt.setLong(1, peridx);
            stmt.setLong(2, setup.getLoyaltyProgramId());
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return null;
                String string = result.getString("CARDNO");
                return string;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getPeridxFromDatabase(String cardNumber) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT PERIDX FROM PERLOYALTY WHERE CARDNO = ? AND \"ACTIVE\" = 1");){
            stmt.setString(1, cardNumber);
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return 0L;
                long l = result.getLong("PERIDX");
                return l;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return 0L;
    }

    public static boolean redeemRewards() {
        return true;
    }
}

