/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.table.AbstractTableModel;
import jpos.DlgMessage;
import jpos.PosDouble;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayType;
import jpos.pay.PayTypes;
import jpos.pay.RetTranP;
import jpos.ui.Colours;

public class ChangeTM
extends AbstractTableModel {
    private int lastRowEdited = -1;
    private int lastColEdited = -1;
    private double requiredChangeTotal;
    private double totalDue;
    Vector<RetTranP> vRetTranPs = new Vector();
    static final int COL_TENDER = 0;
    static final int COL_AMT = 1;
    static final int COL_MIN = 2;
    static final int COL_MAX = 3;
    static final int COL_COUNT = 2;
    JDialog dlgParent;

    public ChangeTM(JDialog pDlgParent) {
        this.dlgParent = pDlgParent;
    }

    @Override
    public int getRowCount() {
        return this.vRetTranPs.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.vRetTranPs.size() | row < 0) {
            return "";
        }
        RetTranP payment = this.vRetTranPs.get(row);
        switch (col) {
            case 0: {
                return payment.getPayType().code;
            }
            case 1: {
                return payment.getTMAmount();
            }
            case 2: {
                return payment.getPayType().minPayment.isNull() ? null : new PosDouble(payment.getPayType().minPayment.doubleValue());
            }
            case 3: {
                return new PosDouble(payment.getMaxChangePayment(this.getRoundError(), this.requiredChangeTotal));
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Tender";
            }
            case 1: {
                return SP.getRS("amount");
            }
            case 2: {
                return SP.getRS("min");
            }
            case 3: {
                return SP.getRS("max");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return super.getColumnClass(column);
            }
            case 1: {
                return PosDouble.class;
            }
            case 2: {
                return PosDouble.class;
            }
            case 3: {
                return PosDouble.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 1: {
                return row < this.vRetTranPs.size() && !this.vRetTranPs.elementAt(row).isRounding();
            }
            case 3: {
                return false;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.setLastRowEdited(row);
        this.setLastColEdited(col);
        if (row >= this.vRetTranPs.size() || row < 0 || value == null) {
            return;
        }
        RetTranP payment = this.vRetTranPs.get(row);
        switch (col) {
            case 1: {
                double newAmt = ((PosDouble)value).doubleValue();
                if (!(newAmt < 0.0)) {
                    if (!(newAmt > payment.getMaxChangePayment(this.getRoundError(), this.requiredChangeTotal))) {
                        payment.setAmount(PayType.roundDec(-newAmt));
                        this.fireTableCellUpdated(row, col);
                        this.testRounding();
                    } else {
                        Object[] objs = new Object[]{payment.getPayType().code, SP.sParams.storeCurrency.formatDetailNoScale(payment.getMaxChangePayment(this.getRoundError(), this.requiredChangeTotal))};
                        DlgMessage.showMessage(this.dlgParent, MessageFormat.format(SP.getRS("max_change"), objs), SP.getRS("Stop"), 0);
                        payment.setAmount(PayType.roundDec(-payment.getMaxChangePayment(this.getRoundError(), this.requiredChangeTotal)));
                        this.fireTableCellUpdated(row, col);
                        this.testRounding();
                    }
                }
                return;
            }
        }
    }

    public void setRequiredChangeTotal(double pRequiredChangeTotal) {
        this.requiredChangeTotal = pRequiredChangeTotal;
    }

    public void setTotalDue(double pTotalDue) {
        this.totalDue = pTotalDue;
    }

    private void testRounding() {
        this.deleteRnd();
        try {
            double roundError = this.getRoundError();
            double balanceDue = PayType.roundDec(this.requiredChangeTotal + this.getTotal());
            if (roundError != 0.0 && PayType.roundDec(-balanceDue) == roundError) {
                RetTranP rounding = new RetTranP(PayTypes.getPayType(518L), roundError);
                rounding.setRounding();
                this.appendPayment(rounding);
                double d = PayType.roundDec(balanceDue -= rounding.getAmount());
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private double getRoundError() {
        double roundError = 0.0;
        PayType ptRoundRule = null;
        for (int line = 0; line < this.getRowCount(); ++line) {
            RetTranP pmt = this.getRetTranP(line);
            if (!pmt.getPayType().round) continue;
            ptRoundRule = pmt.getPayType();
            break;
        }
        if (ptRoundRule != null) {
            double rndErrPrice = PayType.roundDec(this.totalDue - ptRoundRule.roundAmt(this.totalDue));
            double paid = PayType.roundDec(this.totalDue + this.requiredChangeTotal);
            double rndErrPaid = PayType.roundDec(paid - ptRoundRule.roundAmt(paid));
            double rndChange = this.requiredChangeTotal < 0.0 ? ptRoundRule.roundAmt(this.requiredChangeTotal) : PayType.roundDec(ptRoundRule.roundAmt(-1000000.0 + this.requiredChangeTotal) + 1000000.0);
            double rndErrChange = PayType.roundDec(rndChange - this.requiredChangeTotal);
            roundError = rndErrPaid == 0.0 ? rndErrPrice : rndErrChange;
        }
        return roundError;
    }

    public void testRoundingTotalPlusPaid() {
        this.deleteRnd();
        PayType ptRoundRule = null;
        for (int line = 0; line < this.getRowCount(); ++line) {
            RetTranP pmt = this.getRetTranP(line);
            if (!pmt.getPayType().round) continue;
            ptRoundRule = pmt.getPayType();
            break;
        }
        if (ptRoundRule != null) {
            double paid = this.totalDue + this.requiredChangeTotal + this.getTotal();
            double rndErrTotal = PayType.roundDec(this.totalDue - ptRoundRule.roundAmt(this.totalDue));
            double rndErrPaid = PayType.roundDec(paid - ptRoundRule.roundAmt(paid));
            double rndError = PayType.roundDec(rndErrTotal - rndErrPaid);
            double balanceDue = PayType.roundDec(this.requiredChangeTotal + this.getTotal());
            try {
                RetTranP rounding = new RetTranP(PayTypes.getPayType(518L), rndError);
                rounding.setRounding();
                if (rounding.getAmount() != 0.0 && PayType.roundDec(-balanceDue) == rounding.getAmount()) {
                    this.appendPayment(rounding);
                    balanceDue -= rounding.getAmount();
                    balanceDue = PayType.roundDec(balanceDue);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public void testRoundingBal() {
        this.deleteRnd();
        PayType ptRoundRule = null;
        for (int line = 0; line < this.getRowCount(); ++line) {
            RetTranP pmt = this.getRetTranP(line);
            if (!pmt.getPayType().round) continue;
            ptRoundRule = pmt.getPayType();
            break;
        }
        if (ptRoundRule != null) {
            double balanceDue = PayType.roundDec(this.requiredChangeTotal + this.getTotal());
            double rndBalanceDue = balanceDue - (ptRoundRule.roundAmt(this.totalDue) - this.totalDue);
            rndBalanceDue = PayType.roundDec(rndBalanceDue);
            try {
                RetTranP rounding = new RetTranP(PayTypes.getPayType(518L), rndBalanceDue - balanceDue);
                rounding.setRounding();
                if (rounding.getAmount() != 0.0 && PayType.roundDec(-balanceDue) == rounding.getAmount()) {
                    this.appendPayment(rounding);
                    balanceDue -= rounding.getAmount();
                    balanceDue = PayType.roundDec(balanceDue);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public void deleteRnd() {
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            RetTranP pmt = this.getRetTranP(line);
            if (!pmt.isRounding()) continue;
            this.deleteRow(line);
            this.fireTableRowsDeleted(line, line);
        }
    }

    public RetTranP getRetTranP(int line) {
        return this.vRetTranPs.get(line);
    }

    public Color getDisplayForegroundAt(Object value, int row, int column) {
        return Colours.BLACK;
    }

    public void appendPayment(RetTranP pmt) {
        this.vRetTranPs.add(pmt);
        this.fireTableRowsInserted(this.vRetTranPs.size() - 1, this.vRetTranPs.size() - 1);
    }

    public void deleteRow(int row) {
        this.vRetTranPs.remove(row);
    }

    public void deleteAllRows() {
        this.vRetTranPs.removeAllElements();
    }

    public RetTranP getPayment(int line) {
        return this.vRetTranPs.get(line);
    }

    public Color getForground(int line) {
        Color c = null;
        if (this.vRetTranPs.get(line).isChange() || this.vRetTranPs.get(line).isRounding()) {
            c = Colours.RED;
        }
        return c;
    }

    public double getTotal() {
        double totalAmount = 0.0;
        for (int i = 0; i < this.vRetTranPs.size(); ++i) {
            RetTranP retTranP = this.vRetTranPs.get(i);
            totalAmount += retTranP.getAmount();
        }
        return PayType.roundDec(totalAmount);
    }

    public int getLastColEdited() {
        return this.lastColEdited;
    }

    public void setLastColEdited(int lastColEdited) {
        this.lastColEdited = lastColEdited;
    }

    public int getLastRowEdited() {
        return this.lastRowEdited;
    }

    public void setLastRowEdited(int lastRowEdited) {
        this.lastRowEdited = lastRowEdited;
    }
}

