/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosDateField;
import jpos.PosDateFormatter;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class LaybyDepositDlg
extends PayDialog {
    protected boolean isLayby = true;
    private GridBagLayout gridBagLayoutAll = new GridBagLayout();
    private boolean bAllowChangeLaybyDateSec = false;
    private boolean bReduceDepositSec = false;
    private GridBagLayout gridBagLayoutDates = new GridBagLayout();
    private JPanel panelDates = new JPanel(this.gridBagLayoutDates);
    private LabelNormal lNextPayDate = new LabelNormal();
    private PosDateField dfNextPayDate = new PosDateField(this);
    private PosDateFormatter nextPayDate = new PosDateFormatter(null, 3, 3, 0);
    private DialogButton bNextPayDate = new DialogButton("", this);
    private LabelNormal lFinalPayDate = new LabelNormal();
    private PosDateField dfFinalPayDate = new PosDateField(this);
    private PosDateFormatter finalPayDate = new PosDateFormatter(null, 3, 3, 0);
    private DialogButton bFinalPayDate = new DialogButton("", this);
    private GridBagLayout gridBagLayoutDets = new GridBagLayout();
    private JPanel panelDets = new JPanel(this.gridBagLayoutDets);
    private LabelSubHeading lLaybyTotal = new LabelSubHeading();
    private DecimalField dfLaybyTotal;
    private double laybyTotal;
    private LabelSubHeading lLaybyFee;
    private DecimalField dfLaybyFee;
    private double laybyFee;
    private double origLaybyFee;
    private boolean bAllowDelFeeSec;
    private DialogButton bDelFee;
    private LabelSubHeading lDeposit;
    private DecimalField dfDeposit;
    private double deposit;
    private GridBagLayout gridBagLayoutFooter;
    private JPanel panelFooter;
    private DialogButton bOk;
    private DialogButton bCancel;

    public LaybyDepositDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfLaybyTotal = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.lLaybyFee = new LabelSubHeading();
        this.dfLaybyFee = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.bAllowDelFeeSec = false;
        this.bDelFee = new DialogButton("", this);
        this.lDeposit = new LabelSubHeading();
        this.dfDeposit = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.lNextPayDate.setText(SP.getRS("next_payment_due"));
        this.dfNextPayDate.setEnabled(false);
        this.dfNextPayDate.setDisabledTextColor(Colours.BLACK);
        this.setDateFieldProp(this.dfNextPayDate);
        this.bNextPayDate.setText(SP.getRS("F7_change_date"));
        this.bNextPayDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LaybyDepositDlg.this.isRunning && LaybyDepositDlg.this.isVisible()) {
                    LaybyDepositDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LaybyDepositDlg.this.changeNextLaybyDate();
                            LaybyDepositDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.lFinalPayDate.setText(SP.getRS("final_payment_due"));
        this.setDateFieldProp(this.dfFinalPayDate);
        this.dfFinalPayDate.setEnabled(false);
        this.dfFinalPayDate.setDisabledTextColor(Colours.BLACK);
        this.bFinalPayDate.setText(SP.getRS("F5_change_date"));
        this.bFinalPayDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LaybyDepositDlg.this.isRunning && LaybyDepositDlg.this.isVisible()) {
                    LaybyDepositDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LaybyDepositDlg.this.changeFinalLaybyDate();
                            LaybyDepositDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.panelDates.setBorder(BorderFactory.createLineBorder(Colours.BLACK));
        this.panelDates.setBorder(BorderFactory.createEtchedBorder());
        this.panelDates.add((Component)this.lNextPayDate, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDates.add((Component)this.dfNextPayDate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(20, 10, 10, 10), 0, 0));
        this.panelDates.add((Component)this.bNextPayDate, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(20, 10, 10, 20), 0, 0));
        this.panelDates.add((Component)this.lFinalPayDate, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelDates.add((Component)this.dfFinalPayDate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelDates.add((Component)this.bFinalPayDate, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.lLaybyTotal.setText(SP.getRS("layby_total"));
        this.setAmtFieldProp(this.dfLaybyTotal);
        this.dfLaybyTotal.setEnabled(false);
        this.lLaybyFee.setText(SP.getRS("admin_fee"));
        this.setAmtFieldProp(this.dfLaybyFee);
        this.bDelFee.setText(SP.getRS("F2_delete_fee"));
        this.bDelFee.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LaybyDepositDlg.this.isRunning && LaybyDepositDlg.this.isVisible()) {
                    LaybyDepositDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LaybyDepositDlg.this.deleteFee();
                            LaybyDepositDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.dfLaybyFee.setEnabled(false);
        this.lDeposit.setText(SP.getRS("deposit"));
        this.setAmtFieldProp(this.dfDeposit);
        this.panelDets.setBorder(BorderFactory.createEtchedBorder());
        this.panelDets.add((Component)this.lLaybyTotal, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 50, 0));
        this.panelDets.add((Component)this.dfLaybyTotal, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(20, 10, 10, 20), 0, 0));
        if (!SP.sParams.bUsingExtendedTax) {
            this.panelDets.add((Component)this.lLaybyFee, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 10, 10), 0, 0));
            this.panelDets.add((Component)this.dfLaybyFee, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 20), 0, 0));
            this.panelDets.add((Component)this.bDelFee, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 20), 0, 0));
        }
        this.panelDets.add((Component)this.lDeposit, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelDets.add((Component)this.dfDeposit, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.dfNextPayDate.setValue("");
        this.dfFinalPayDate.setValue("");
        this.dfLaybyTotal.setText("");
        this.dfLaybyFee.setText("");
        this.dfDeposit.setText("");
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.panelAll.add((Component)this.panelDates, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelDets, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(this.panelAll);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfDeposit);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void changeNextLaybyDate() {
        if (this.bAllowChangeLaybyDateSec && this.frSales != null && this.frSales.isLoggedIn(false)) {
            this.dfNextPayDate.actionSearch();
        }
    }

    private void changeFinalLaybyDate() {
        if (this.bAllowChangeLaybyDateSec && this.frSales != null && this.frSales.isLoggedIn(false)) {
            this.dfFinalPayDate.actionSearch();
        }
    }

    private void deleteFee() {
        if (SP.sParams.bUsingExtendedTax) {
            return;
        }
        if (this.bAllowDelFeeSec) {
            boolean bRecalcDeposit;
            double saveDeposit = this.dfDeposit.getDouble();
            boolean bl = bRecalcDeposit = this.deposit == saveDeposit;
            if (this.laybyFee != 0.0) {
                this.laybyTotal -= this.laybyFee;
                this.laybyFee = 0.0;
                this.deposit = PayType.roundDec(this.isLayby ? SP.sParams.getMinLbDep(this.laybyTotal) : SP.sParams.getMinSpecOrdDep(this.laybyTotal));
            } else {
                this.laybyTotal += this.origLaybyFee;
                this.laybyFee = this.origLaybyFee;
                this.deposit = PayType.roundDec((this.isLayby ? SP.sParams.getMinLbDep(this.laybyTotal - this.laybyFee) : SP.sParams.getMinSpecOrdDep(this.laybyTotal - this.laybyFee)) + this.laybyFee);
            }
            this.populateFields();
            if (!bRecalcDeposit) {
                this.dfDeposit.setText(saveDeposit);
            }
            this.dfDeposit.requestFocus();
            this.dfDeposit.selectAll();
        }
    }

    @Override
    public boolean initDialog() {
        this.bAllowDelFeeSec = this.frSales.hasSecurity(11129L, 0);
        this.bAllowChangeLaybyDateSec = this.frSales.hasSecurity(11131L, 0);
        this.bReduceDepositSec = this.frSales.hasSecurity(11138L, 0);
        if (this.origLaybyFee == 0.0) {
            this.bAllowDelFeeSec = false;
        }
        this.populateFields();
        return super.initDialog();
    }

    private void populateFields() {
        if (this.nextPayDate.getTimestamp() != null) {
            this.dfNextPayDate.setValue(new Timestamp(this.nextPayDate.getTime()));
        } else {
            this.dfNextPayDate.setValue("");
        }
        if (this.finalPayDate.getTimestamp() != null) {
            this.dfFinalPayDate.setValue(new Timestamp(this.finalPayDate.getTime()));
        } else {
            this.dfFinalPayDate.setValue("");
        }
        if (this.laybyFee == 0.0) {
            this.bDelFee.setText(SP.getRS("F2_add_fee"));
        } else {
            this.bDelFee.setText(SP.getRS("F2_delete_fee"));
        }
        this.dfLaybyTotal.setText(this.laybyTotal);
        this.dfLaybyFee.setText(this.laybyFee);
        this.dfDeposit.setText(this.deposit);
        this.bDelFee.setEnabled(this.bAllowDelFeeSec);
        this.bNextPayDate.setEnabled(this.bAllowChangeLaybyDateSec);
        this.bFinalPayDate.setEnabled(this.bAllowChangeLaybyDateSec);
    }

    public double getDepositAmt() {
        return this.deposit;
    }

    public double getLaybyFee() {
        return this.laybyFee;
    }

    @Override
    public void okDialog() {
        double newLaybyFee = PayType.roundDec(this.dfLaybyFee.getDouble());
        double newDeposit = PayType.roundDec(this.dfDeposit.getDouble());
        if (newDeposit > this.laybyTotal) {
            this.dfDeposit.setText(this.laybyTotal);
            this.dfDeposit.requestFocus();
            this.dfDeposit.selectAll();
            return;
        }
        double minDeposit = PayType.roundDec((this.isLayby ? SP.sParams.getMinLbDep(this.laybyTotal - newLaybyFee) : SP.sParams.getMinSpecOrdDep(this.laybyTotal - newLaybyFee)) + newLaybyFee);
        if (!this.bReduceDepositSec && newDeposit < minDeposit) {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("no_reduce_deposit_security"), objs), StoreParams.res.getString("Insufficient_security"));
            this.dfDeposit.setText(minDeposit);
            this.dfDeposit.requestFocus();
            this.dfDeposit.selectAll();
            return;
        }
        if (newDeposit < 0.0) {
            this.dfDeposit.setText(minDeposit);
            this.dfDeposit.requestFocus();
            this.dfDeposit.selectAll();
            return;
        }
        if (this.isLayby) {
            long newFinalPayDate;
            long newNextPayDate;
            try {
                newNextPayDate = this.dfNextPayDate.getDateFormatter().getTime();
            }
            catch (Exception ex) {
                this.dfNextPayDate.requestFocus();
                this.dfNextPayDate.selectAll();
                return;
            }
            try {
                newFinalPayDate = this.dfFinalPayDate.getDateFormatter().getTime();
            }
            catch (Exception ex) {
                this.dfFinalPayDate.requestFocus();
                this.dfFinalPayDate.selectAll();
                return;
            }
            if (newNextPayDate > newFinalPayDate) {
                newNextPayDate = newFinalPayDate;
                this.dfNextPayDate.setValue(new Timestamp(newFinalPayDate));
                return;
            }
            this.nextPayDate.setTime(newNextPayDate);
            this.finalPayDate.setTime(newFinalPayDate);
        }
        this.laybyFee = newLaybyFee;
        this.deposit = newDeposit;
        this.frSales.setCompletingOrder(PayType.roundDec(this.deposit) == PayType.roundDec(this.laybyTotal));
        super.okDialog();
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        if (k.getKeyCode() == 116) {
            this.bFinalPayDate.doClick();
            return true;
        }
        if (k.getKeyCode() == 118) {
            this.bNextPayDate.doClick();
            return true;
        }
        if (k.getKeyCode() == 113) {
            this.bDelFee.doClick();
            return true;
        }
        if (k.getKeyCode() == 10) {
            this.bOk.doClick();
            return true;
        }
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public void setLaybyDets(boolean pIsLayby, double pLaybyTotal, double pLaybyFee, Date pNextPayDate, Date pFinalPayDate) {
        this.isLayby = pIsLayby;
        if (this.isLayby) {
            this.nextPayDate.setTime(pNextPayDate.getTime());
            this.finalPayDate.setTime(pFinalPayDate.getTime());
            this.lLaybyTotal.setText(SP.getRS("layby_total"));
            this.setTitle(SP.getRS("layby_deposit"));
            this.panelDates.setVisible(true);
        } else {
            this.lLaybyTotal.setText(SP.getRS("special_order_total"));
            this.setTitle(SP.getRS("special_order_deposit"));
            this.panelDates.setVisible(false);
        }
        this.laybyTotal = pLaybyTotal;
        this.laybyFee = pLaybyFee;
        this.origLaybyFee = pLaybyFee;
        this.deposit = PayType.roundDec((this.isLayby ? SP.sParams.getMinLbDep(this.laybyTotal - pLaybyFee) : SP.sParams.getMinSpecOrdDep(this.laybyTotal - pLaybyFee)) + pLaybyFee);
    }

    public Date getNextPayDate() {
        return new Date(this.nextPayDate.getTime());
    }

    public Date getFinalPayDate() {
        return new Date(this.finalPayDate.getTime());
    }
}

